<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete"></t:base>
<div id="quota_list" class="easyui-layout" fit="true">
    <div region="center">
        <t:datagrid name="ttAuditActlist"  tagConf="${clickFunctionId}" idField="id" queryMode="group" fit="true" fitColumns="true"
                    specialSearch="true"     actionUrl="/tpm/ttAuditActController/findTtAuditActPage?tempUuid=${tempUuid}&id=${vo.id}" pagination="true">
            <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
            <t:dgCol title="申请活动编号" field="actCode" query="true"></t:dgCol>
            <t:dgCol title="申请活动名称" field="actName" query="true"></t:dgCol>
            <t:dgCol title="活动申请人" field="createName"  ></t:dgCol>
            <t:dgCol title="活动申请时间" field="createDate"   formType="date" formatter="yyyy-MM-dd"></t:dgCol>
            <t:dgCol title="备注" field="remarks"></t:dgCol>

            <t:dgToolBar title="新增" icon="icon-add" width="1000" height="500" url="/tpm/ttAuditActController/goApiActMain"
                         funname="selectAct"></t:dgToolBar>
            <t:dgToolBar title="删除" funname="deleteALLSelect_"
                         url="/tpm/ttAuditActController/delAuditAct"></t:dgToolBar>
        </t:datagrid>
    </div>
</div>
<script type="text/javascript">
    var tempUuid='${tempUuid}';
    function selectAct(){
        var url = "/tpm/ttApiActController/goApiActMain";
        var width = 1000;
        var height = 500;
        id = "actSelectlist";
        var gridname = id;
        var myOptions ={
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if (rowsData == '' || rowsData == null) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }
                } else {
                    //提交数据到后台表里
                    $.ajax({
                        url : "/tpm/ttAuditActController/saveAuditAct",
                        type : 'post',
                        data : {"tempUuid":tempUuid,"acts":JSON.stringify(rowsData)},
                        cache : false,
                        success : function(data) {
                            tip(data.msg);
                            if (!data.success) {
                                tip(data.msg);
                                return false;
                            }
                            $('#ttAuditActlist').datagrid('reload');
                        }
                    });
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        };
        safeShowDialogParent(myOptions);
    }
    function deleteALLSelect_(title, url, gname, deleteCallback) {
        gridname = gname;
        var ids = [];
        var rows = $("#" + gname).datagrid('getSelections');
        if (rows.length > 0) {
            $.dialog.setting.zIndex = 3000;
            getSafeJq().dialog.confirm("你确定永久删除该数据吗?", function (r) {
                if (r) {
                    for (var i = 0; i < rows.length; i++) {
                        ids.push(rows[i].id);
                    }
                    $.ajax({
                        url: url,
                        type: 'post',
                        dataType: 'json',
                        data: {
                            ids: ids.join(',')
                        },
                        cache: false,
                        success: function (data) {
                            var msg = data.msg;
                            if (data.success) {
                                tip(msg, 'info');
                                reloadTable();
                                if (deleteCallback) {
                                    deleteCallback();
                                }
                                $("#" + gname).datagrid('unselectAll');
                                ids = '';
                            } else {
                                tip(msg, 'error');

                            }
                        },
                        error: function () {
                            tip("客户端请求错误", 'error');
                            return false;
                        }
                    });
                }
            });
        } else {
            tip("请选择需要删除的数据");
        }
    }
</script>
