<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8"%>
<%@ include file="/context/mytags.jsp"%>
<!DOCTYPE html>
<html>
<head>
    <title>费用上账</title>
    <t:base type="jquery,easyui,tools"></t:base>
</head>
<body class="easyui-layout" fit="true">
<div data-options="region:'south',split:true" style="height:250px;">
    <t:datagrid name="billAddList"  idField="id" queryMode="group" fit="true" fitColumns="true"
                actionUrl="/tpm/ttAccountController/getInvoiceMaiListPage?accountCode=${accountCode}" pagination="false">
        <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
        <t:dgCol title="上账编号" field="accountCode" ></t:dgCol>
        <t:dgCol title="发票编号" field="invoiceCode" ></t:dgCol>
        <t:dgCol title="科目编号" field="budgetSubjectsCode" ></t:dgCol>
        <t:dgCol title="科目" field="budgetSubjectsName" ></t:dgCol>
        <t:dgCol title="科目" field="budgetSubjectsName" ></t:dgCol>
        <t:dgCol title="税码" field="taxCode" ></t:dgCol>
        <t:dgCol title="税金" field="taxAmount" ></t:dgCol>
        <t:dgCol title="进项税转出金额" field="taxOutAmount" ></t:dgCol>
        <t:dgCol title="SAP成本中心" field="costCenters" ></t:dgCol>
        <t:dgCol title="摘要" field="notes" ></t:dgCol>
        <t:dgCol title="张数" field="invoiceCount" ></t:dgCol>
        <t:dgToolBar title="导出上账明细"  operationCode="dataOut" icon="icon-dataOut"
                     url="/tpm/commonExcelController/excel" ></t:dgToolBar>
        <t:dgToolBar title="导入发票" icon="icon-dataIn" detail="false"
                     onclick="importExcel({downUrl:'/tpm/ttBillExcelController/excelImportTemplate', uploadUrl:'/tpm/ttBillExcelController/doImport',title:'发票信息',sheetName:'发票信息',classPath:'com.biz.eisp.account.vo.TtAccountInvoiceVo'})"></t:dgToolBar>
        <t:dgToolBar title="凭证附件张数"  icon=""
                     onclick=""></t:dgToolBar>
    </t:datagrid>
</div>
<div data-options="region:'center' " style="padding:5px;">
    <t:datagrid name="accountAddList"   idField="id" queryMode="group" fit="true" fitColumns="true"
                actionUrl="/tpm/ttAccountController/getListForUpdatePage?id=${id}" pagination="false" checkbox="true"
                singleSelect="false" onLoadSuccess="editorALl">
        <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
        <t:dgCol title="上账编号" field="accountCode" ></t:dgCol>
        <t:dgCol title="活动名称" field="actName" ></t:dgCol>
        <t:dgCol title="活动编号" field="actCode" ></t:dgCol>
        <t:dgCol title="活动明细编号" field="actDetailCode" ></t:dgCol>
        <t:dgCol title="核销编号" field="auditCode" ></t:dgCol>
        <t:dgCol title="核销明细编号" field="auditDetailCode" ></t:dgCol>
        <t:dgCol title="活动细类" field="fineName" ></t:dgCol>
        <t:dgCol title="活动细类" field="fineCode" hidden="true"></t:dgCol>
        <t:dgCol title="客户编码" field="custCode" hidden="true"></t:dgCol>
        <t:dgCol title="客户名称" field="custName" ></t:dgCol>
        <t:dgCol title="门店" field="terminalName" ></t:dgCol>
        <t:dgCol title="门店编码" field="terminalCode" hidden="true"></t:dgCol>
        <t:dgCol title="组织" field="departName" ></t:dgCol>
        <t:dgCol title="组织编码" field="departCode" ></t:dgCol>
        <t:dgCol title="可上账金额" field="auditAmount" ></t:dgCol>
        <t:dgCol title="本次上账金额" field="accountAmount"  editor="{type:'numberbox',options:{precision:2,required:true}}"></t:dgCol>
        <t:dgCol title="支付方式" field="paymentCode" dictionary="pay_type"></t:dgCol>
        <t:dgCol title="货补产品编码" field="accountProductCode" hidden="true" ></t:dgCol>
        <t:dgCol title="货补产品" field="accountProductName" style="color:red!important;_请选择" ></t:dgCol>
        <%--<t:dgCol title="财务凭证编号" field="credentialsCode" editor="{type:'text'}"></t:dgCol>--%>
        <t:dgCol title="财务凭证编号" field="credentialsCode" ></t:dgCol>
        <t:dgCol title="核销科目编号" field="budgetSubjectsCode" ></t:dgCol>
        <t:dgCol title="核销科目" field="budgetSubjectsName" ></t:dgCol>
        <t:dgCol title="活动开始时间" field="beginDate" ></t:dgCol>
        <t:dgCol title="活动结束时间" field="endDate" ></t:dgCol>
        <t:dgToolBar detail="false" title="选择" icon="icon-add" url="/tpm/ttApiAuditController/goAuditDetailSelectMain"
                     funname="selectAuditDetail" ></t:dgToolBar>
        <t:dgToolBar detail="false" title="删除" icon="icon-remove" url=""
                     funname="deleteSelect"></t:dgToolBar>
        <t:dgToolBar detail="false" title="导入"  operationCode="import" icon="icon-dataIn"
                     onclick="importDataByXml({impName:'tmAdministrativeArea', gridName:'tbaList'})"></t:dgToolBar>
        <t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut"
                     url="/tpm/commonExcelController/excel" funname="excelCommonExport"></t:dgToolBar>
    </t:datagrid>
</div>
</body>
<script type="text/javascript">

    $(function () {
        $('#accountAddList').datagrid({
            onClickCell: function(index,field,value){
                if(field=="accountProductName"){
                    //选择产品
                    goSelectProduct(index);
                }
                if(field=="accountAmount"){
                    editorALl();
                }

            }
        });
    });


    /** 选择产品 */
    function goSelectProduct(index) {
        var load = '${load}';
        if(!isEmpty(load)&&load=='detail'){
            return;
        }
        endEditorALl();
        triggerId = "productCode";
        triggerName = "productName";
        url = "/tpm/tmApiProductInfoController/goProductInfoListMain";
        width = 500;
        height = 450;
        id = "productinfoList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            parent:'auditProduct',
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }
                } else {
                    var productInfoCodes = [];
                    var productInfoNames = [];
                    for(var i=0;i<rowsData.length;i++){
                        productInfoCodes[i]=rowsData[i].productInfoCode;
                        productInfoNames[i]=rowsData[i].productInfoName;
                    }
                    $('#accountAddList').datagrid('updateRow',{
                        index: index,
                        row: {
                            accountProductCode: productInfoCodes.join(","),
                            accountProductName: productInfoNames.join(",")
                        }
                    });
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    /**删除上账明细*/
    function deleteSelect() {
        var rowsDetailDatas = $('#accountAddList').datagrid('getSelections');
        if(rowsDetailDatas.length==0){
            tip("请选择待删除的数据");
            return ;
        }
        getSafeJq().dialog.confirm("你确定删除选择的数据吗?", function (r) {
            if (r) {
              for(var i=rowsDetailDatas.length-1;i>=0;i--){
                  var index = $('#accountAddList').datagrid('getRowIndex',rowsDetailDatas[i]);
                  $('#accountAddList').datagrid('deleteRow',index);
              }
            }
        });
    }
    //选择核销明细
    function selectAuditDetail(title, url, id, width, height, params) {
        title = "核销明细";
        url="/tpm/ttApiAuditController/goAuditDetailSelectMain";
        height="550";
        width="1100";
        var _char ="&";
        if (url.indexOf("?")==-1) {
            _char = "?";
        }

        url += _char;
        createwindowSmallOver(title, url, width, height);
    }
    //处理核销明细数据写入
    function createwindowSmallOver(title, addurl, width, height, options) {
        var offsetW = window.top.document.body.offsetWidth;
        var offsetH = window.top.document.body.offsetHeight;
        var id="auditDetaillist";
        width = (width && width != 'null') ? width : 700;
        height = (height && height != 'null') ? height : 400;
        if (width == "100%" || width > offsetW) {
            width = offsetW;
        }
        if (height == "100%" || height > (offsetH - 100)) {
            height = offsetH - 100;
        }
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: parseInt(width),
            height: parseInt(height),
            title: title,
            opacity: 0.3,
            parent:'auditDetailDialog',
            cache: false,
            /* 为true等价于function(){} */
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var rowsDatas = iframe.$('#' + id).datagrid('getSelections');
                    if(rowsDatas.length==0){
                        iframe.tip("请选择数据");
                    }else{
                        //得到可以保存收数据
                        var insertDatas = [];
                        for(var i=0;i<rowsDatas.length;i++){
                            var flagTemp = getInsertDetail(rowsDatas[i]);
                            if(flagTemp!=null){
                                insertDatas.push(flagTemp);
                            }
                        }
                        if(insertDatas.length>0){
                            //获取上账编码
                            var codes = getCodes(insertDatas.length);
                            if(codes.length==0){
                                iframe.tip("系统出了点问题，请稍后再试");
                                return false;
                            }
                            for(var i=0;i<insertDatas.length;i++){
                                insertDetail(insertDatas[i],codes[i]);
                            }
                        }
                    }
                    return true;
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.extend(myOptions, options);
        safeShowDialog(myOptions);
    }

    /*获取上账编号*/
    function getCodes(count) {
        var codes ;
        $.ajax({
            type: "POST",
            url: "/tpm/ttAccountController/getCodes",
            data: {'count':count},
            dataType:"json",
            async:false,
            success: function(data){
                if(data.success){
                    codes =  data.objList;
                }else{
                    codes = [];
                }

            }
        });
        return codes;
    }

    /**将选择的细类插入列表*/
    function getInsertDetail(rowsData) {
        var rowsDetailDatas = $('#accountAddList').datagrid('getRows');
        for(var i=0;i<rowsDetailDatas.length;i++){
           var id = rowsDetailDatas[i].id;
           if(id==rowsData.id){
               return null;
           }
        }
        return rowsData;
    }
    /** 插入数据 */
    function insertDetail(rowsData,code) {
        $('#accountAddList').datagrid('insertRow',{
            index: 0,
            row: {
                id: rowsData.id,
                auditDetailCode: rowsData.auditDetailCode,
                accountProductName:'请选择',
                auditAmount:rowsData.feeUseable,
                actDetailCode:rowsData.actDetailCode,
                custName:rowsData.customerName,
                custCode:rowsData.customerCode,
                terminalName:rowsData.terminalName,
                terminalCode:rowsData.terminalCode,
                fineName:rowsData.actSubclassName,
                fineCode:rowsData.actSubclassCode,
                paymentCode:rowsData.payType,
                departCode:rowsData.orgCode,
                accountCode:code,
                actName:rowsData.actName,
                actCode:rowsData.actCode,
                auditCode:rowsData.auditCode,
                budgetSubjectsCode:rowsData.budgetSubjectsCode,
                budgetSubjectsName:rowsData.budgetSubjectsName,
                beginDate:rowsData.beginDate,
                endDate:rowsData.endDate,
                departName:rowsData.orgName
            }
        });
        editorALl();
    }

    /*上账明细打开编辑*/
    function editorALl() {
        var load = '${load}';
        if(!isEmpty(load)&&load=='detail'){
          return;
        }
        var rowsDetailDatas = $('#accountAddList').datagrid('getRows');
        for(var i=0;i<rowsDetailDatas.length;i++){
            var index = $('#accountAddList').datagrid('getRowIndex',rowsDetailDatas[i]);
            $('#accountAddList').datagrid('beginEdit' ,index);
        }
    }
    /*上账明细结束编辑*/
    function endEditorALl() {
        var rowsDetailDatas = $('#accountAddList').datagrid('getRows');
        for(var i=0;i<rowsDetailDatas.length;i++){
            var index = $('#accountAddList').datagrid('getRowIndex',rowsDetailDatas[i]);
            $('#accountAddList').datagrid('endEdit' ,index);
        }
    }
     /* 保存组装数据*/
    function saveData(status) {
        var data={};
        endEditorALl();
        var rowsDetailDatas = $('#accountAddList').datagrid('getRows');
        for(var i=0;i<rowsDetailDatas.length;i++){
           var accountAmount = rowsDetailDatas[i].accountAmount;
            var accountCode = rowsDetailDatas[i].accountCode;
           if(isEmpty(accountAmount)||Number(accountAmount) == 0){
               tip("上账编号:"+accountCode+"本次上账金额必须大于0");
               editorALl();
               return;
           }
           var auditAmount = rowsDetailDatas[i].auditAmount;

           if(Number(accountAmount)>Number(auditAmount)){
               tip("上账编号:"+accountCode+"超过可上账金额"+auditAmount);
               editorALl();
               return;
           }
        }
        var billAddListDatas = $('#billAddList').datagrid('getRows');
        data.detailList = rowsDetailDatas;
        data.invoiceList =billAddListDatas;
        data.status= status;
        openProgressTop();
        $.ajax({
            type: "POST",
            url: "/tpm/ttAccountController/saveOrUpdateData",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(data),
            complete:function(){
                closeProgressTop();
            },
            success: function(data){
                closeProgressTop();
                var api = frameElement.api, W = api.opener;
                if (data.success) {
                    W.tip(data.msg);
                    W.feeListsearch();
                    api.close();
                }else{
                    tip(data.msg);
                    editorALl();
                }
            }
        });
    }

</script>
</html>