<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8"%>
<%@ include file="/context/mytags.jsp"%>
<!DOCTYPE html>
<html>
<head>
    <title>费用预算新增</title>
    <t:base type="jquery,easyui,tools"></t:base>
</head>
<body style="overflow-y: hidden" scroll="no">
<t:formvalid action="/tpm/ttRealSalesDataController/saveOrUpdate" layout="div"  dialog="true" formid="fiscalForm">
    <t:dgFormList expandParam="${clickFunctionId}" tagConf="${clickFunctionId}">
        <t:dgFormColumn field="id" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                        defaultVal="${vo.id }"/>
        <t:dgFormColumn field="extChar1" hidden="true" formClass="biz-col-50 mb5 form" labelName="extChar1" optionType="input" required="false"
                        defaultVal="${vo.extChar1 }"/>
        <t:dgFormColumn field="extChar2" hidden="true" formClass="biz-col-50 mb5 form" labelName="extChar2" optionType="input" required="false"
                        defaultVal="${vo.extChar2 }"/>
        <t:dgFormColumn field="extChar3" hidden="true" formClass="biz-col-50 mb5 form" labelName="extChar3" optionType="input" required="false"
                        defaultVal="${vo.extChar3 }"/>
        <t:dgFormColumn field="extChar4" hidden="true" formClass="biz-col-50 mb5 form" labelName="extChar4" optionType="input" required="false"
                        defaultVal="${vo.extChar4 }"/>
        <t:dgFormColumn field="extChar5" hidden="true" formClass="biz-col-50 mb5 form" labelName="extChar5" optionType="input" required="false"
                        defaultVal="${vo.extChar5 }"/>
        <t:dgFormColumn field="orderSn" hidden="false"  formClass="form"
                        defaultVal="${vo.orderSn}"
                        labelName="订单编号" optionType="input" required="true" />
        <t:dgFormColumn field="rsYear" hidden="false" formClass="form" labelName="年份" optionType="select" required="true"
                        defaultVal="${vo.rsYear}" typeGroupCode="financial_year"/>
        <t:dgFormColumn field="rsMonth" hidden="false"  typeGroupCode="month" formClass="form"
                        defaultVal="${vo.rsMonth}"
                        labelName="月份" optionType="select" required="true" />
        <t:dgFormColumn field="orderDate" hidden="false" formClass="form" labelName="下单日期" optionType="date" required="true"
                        defaultVal="${vo.orderDate}" style="width: 150px;" />
        <t:dgFormColumn field="customerCode" hidden="true" formClass="form" labelName="客户编码" optionType="input" required="true"
                        defaultVal="${vo.customerCode}" />
        <t:dgFormColumn field="customerName" hidden="false" formClass="form" labelName="客户" optionType="choseDialog" required="true"
                        defaultVal="${vo.customerName}" onclick="goCustomer();"/>
        <t:dgFormColumn field="productCode" hidden="true" formClass="form" labelName="产品" optionType="input" required="false"
                        defaultVal="${vo.productCode}"  />
        <t:dgFormColumn field="productName" hidden="false" formClass="form" labelName="产品" optionType="choseDialog" required="false"
                        defaultVal="${vo.productName}" onclick="goSelectProduct();" />
        <t:dgFormColumn field="terminalName" hidden="false" formClass="form" labelName="门店名称" optionType="choseDialog" required="false"
                        onclick="selectTerminal()" defaultVal="${vo.terminalName}" />
        <t:dgFormColumn field="terminalCode"  formClass="form" labelName="门店编码" optionType="input" hidden="true" required="false"
                        defaultVal="${vo.terminalCode}" />
        <t:dgFormColumn field="price" hidden="false"  formClass="form"
                        defaultVal="${vo.price}"
                        labelName="单价" optionType="input"  required="true" />
        <t:dgFormColumn field="num" hidden="false"  formClass="form"
                        defaultVal="${vo.num}"
                        labelName="数量" optionType="input"  required="true" />
        <t:dgFormColumn field="totalAmount" hidden="false"  formClass="form"
                        defaultVal="${vo.totalAmount}"
                        labelName="金额小计" optionType="input"  required="true" readOnly="true"/>
    </t:dgFormList>
</t:formvalid>
</body>
<script type="text/javascript">
    $("#num").click(function () {
        countPrice();
    })
    $("#price").click(function () {
        countPrice();
    })

    function countPrice() {
        var price = $("#price").val();
        var num = $("#num").val();
        $("#totalAmount").val(numMulti(price,num));
    }

    /**
     * 乘法运算，避免数据相乘小数点后产生多位数和计算精度损失。
     *
     * @param num1被乘数 | num2乘数
     */
    function numMulti(num1, num2) {
        var baseNum = 0;
        try {
            baseNum += num1.toString().split(".")[1].length;
        } catch (e) {
        }
        try {
            baseNum += num2.toString().split(".")[1].length;
        } catch (e) {
        }
        return Number(num1.toString().replace(".", "")) * Number(num2.toString().replace(".", "")) / Math.pow(10, baseNum);
    };

    /** 选择客户 */
    function goCustomer(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
        triggerId = "customerCode";
        triggerName = "customerName";
        url = "/tpm/tmApiCustomerController/goCustomerListMain";
        width = 1000;
        height = 450;
        id = "customerList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].customerCode);
                    $("#" + triggerName).val(myobj[0].customerName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }
    /** 选择产品 */
    function goSelectProduct() {
        triggerId = "productCode";
        triggerName = "productName";
        url = "/tpm/tmApiProductInfoController/goProductInfoListMain";
        width = 500;
        height = 450;
        id = "productinfoList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }
                } else {
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].productInfoCode);
                    $("#" + triggerName).val(myobj[0].productInfoName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function selectTerminal(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
        triggerId = "terminalCode";
        triggerName = "terminalName";
        url = "/tpm/tmApiTerminalController/goTerminalListMain";
        width = 1000;
        height = 450;
        id = "terminalList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            left: '85%',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].terminalCode);
                    $("#" + triggerName).val(myobj[0].terminalName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }
</script>

</html>