<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8"%>
<%@ include file="/context/mytags.jsp"%>
<!DOCTYPE html>
<html>
<head>
    <title>活动大类</title>
    <t:base type="jquery,easyui,tools"></t:base>
</head>
<body class="easyui-layout" fit="true">
    <div data-options="region:'west',split:true" style="width:380px;">
        <t:formvalid action="/tpm/ttCostTypeController/saveOrUpdateCategories" layout="div"  dialog="true" beforeSubmit="sumFineIds" formid="budgetSubjectsForm">
            <t:dgFormList expandParam="${clickFunctionId}" tagConf="${clickFunctionId}">
                <t:dgFormColumn field="id" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                                defaultVal="${vo.id }"/>
                <t:dgFormColumn field="extChar1" hidden="true" formClass="biz-col-50 mb5 form" labelName="extChar1" optionType="input" required="false"
                                defaultVal="${vo.extChar1 }"/>
                <t:dgFormColumn field="extChar2" hidden="true" formClass="biz-col-50 mb5 form" labelName="extChar2" optionType="input" required="false"
                                defaultVal="${vo.extChar2 }"/>
                <t:dgFormColumn field="extChar3" hidden="true" formClass="biz-col-50 mb5 form" labelName="extChar3" optionType="input" required="false"
                                defaultVal="${vo.extChar3 }"/>
                <t:dgFormColumn field="extChar4" hidden="true" formClass="biz-col-50 mb5 form" labelName="extChar4" optionType="input" required="false"
                                defaultVal="${vo.extChar4 }"/>
                <t:dgFormColumn field="extChar5" hidden="true" formClass="biz-col-50 mb5 form" labelName="extChar5" optionType="input" required="false"
                                defaultVal="${vo.extChar5 }"/>
                <t:dgFormColumn field="categoriesCode" hidden="false" formClass="form" labelName="活动大类编号" optionType="input" required="false"
                                defaultVal="${vo.categoriesCode}" readOnly="true" />
                <t:dgFormColumn field="categoriesName" hidden="false" formClass="form" labelName="活动大类名称" optionType="input" required="true"
                                defaultVal="${vo.categoriesName}" />
                <t:dgFormColumn field="financialFeeCode" hidden="false" formClass="form" labelName="财务费用归类" optionType="select" typeGroupCode="financial_fee" required="true"
                                defaultVal="${vo.financialFeeCode}"/>
                <t:dgFormColumn field="businessFeeCode" hidden="false" formClass="form" labelName="业务费用归类" optionType="select" typeGroupCode="business_fee" required="true"
                                defaultVal="${vo.businessFeeCode}"/>
                <t:dgFormColumn field="budgetSubjectsCode" hidden="false" formClass="form" labelName="预算科目编码" optionType="choseDialog" required="true"
                                defaultVal="${vo.budgetSubjectsCode}" onclick="goSbudgetSubjects();" readOnly="true" />
                <t:dgFormColumn field="budgetSubjectsName" hidden="false" formClass="form" labelName="预算科目名称" optionType="input" required="false"
                                defaultVal="${vo.budgetSubjectsName}" readOnly="true" />
                <t:dgFormColumn field="orgJson" hidden="true" formClass="form" labelName="组织json" optionType="input" required="false"
                                 />
                <t:dgFormColumn field="orgCodes_1" hidden="false"  formClass="form" labelName="可选组织" optionType="tags"  required="false"
                                formTags="${vo.orgFormTags}"  onclick="goOrg();" />
                <t:dgFormColumn field="fineIds" hidden="true"   formClass="form" labelName="活动细类选择ids" optionType="input" typeGroupCode="above_audit" required="false"
                                defaultVal="${vo.fineIds}" lineNum="4"/>
                <t:dgFormColumn field="notes" hidden="false"  formClass="form"
                                defaultVal="${vo.notes}"
                                labelName="备注" optionType="textarea" rows="5" cols="500" required="false"/>
            </t:dgFormList>
        </t:formvalid>
    </div>
    <div data-options="region:'center'" style="padding:5px;">
        <t:datagrid  name="fineList" idField="id" queryMode="group" fit="true" fitColumns="true" singleSelect="false" checkbox="true"
                     actionUrl="/tpm/ttCostTypeController/getFineListByCategories?code=${vo.categoriesCode}" pagination="false">
            <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
            <t:dgCol title="活动细类编号" field="fineCode" ></t:dgCol>
            <t:dgCol title="活动细类名称" field="fineName" ></t:dgCol>
            <t:dgCol title="最近更新人" field="updateName" treefield="updateName"></t:dgCol>
            <t:dgCol title="最近更新时间" field="updateDate" treefield="updateDate" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>
            <c:if test="${show eq '0'}">
                <t:dgToolBar title="关联活动细类" icon="icon-add" url="" funname="selfSelectFine" ></t:dgToolBar>
                <t:dgToolBar title="解除关联细类" icon="icon-remove" url="" funname="delteSelectFine" ></t:dgToolBar>
            </c:if>

        </t:datagrid>
    </div>
</body>
<script type="text/javascript">
    $(function () {
        $("#orgCodes_1").on('click', '.biz-tag-close', function () {
            $(this).parent().remove();
        });
    });

    /*** 解除活动关联 */
    function delteSelectFine() {
        var rowsData = $('#fineList').datagrid('getSelections');
        for(var i=rowsData.length-1;i>=0;i--){
            var index = $('#fineList').datagrid('getRowIndex',rowsData[i]);
            $('#fineList').datagrid('deleteRow',index);
        }
    }

    /** 汇总活动细类id,可选组织数据 */
    function sumFineIds() {
        var rowsData = $('#fineList').datagrid('getRows');
        var ids="";
        for(var i=0;i<rowsData.length;i++){
            if(i==0){
                ids+=rowsData[i].id;
            }else{
                ids+=","+rowsData[i].id;
            }
        }
        $("#fineIds").val(ids);
        var tags = getTags("orgCodes_1");
        $("#orgJson").val(JSON.stringify(tags));
    }

    /** 关联活动细类 */
    function selfSelectFine() {
        var title = "关联活动细类";
        var options = {};
        var addurl = "/tpm/ttCostTypeController/goFineSelectMain?dataType=0&categoriesCode=${vo.categoriesCode}";
        var width = 860;
        var height = 410
        var offsetW = window.top.document.body.offsetWidth;
        var offsetH = window.top.document.body.offsetHeight;
        if (width == "100%" || width > offsetW) {
            width = offsetW;
        }
        if (height == "100%" || height > (offsetH - 100)) {
            height = offsetH - 100;
        }
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: parseInt(width),
            height: parseInt(height),
            title: title,
            opacity: 0.3,
            parent:'fineParent',
            id:'fine',
            cache: false,
            /* 为true等价于function(){} */
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    //选择好的数据
                    var rowsDatas = iframe.getSelectData();
                    if(rowsDatas.length==0){
                    }else{
                        var rowsSelectData = $('#fineList').datagrid('getRows');
                           for(var j=0;j<rowsDatas.length;j++){
                               var flag = true;
                               for(var i=0;i<rowsSelectData.length;i++){
                                 if(rowsDatas[j].id==rowsSelectData[i].id){
                                     flag = false;
                                 }
                               }
                               if(flag){
                                   insertFine(rowsDatas[j]);
                               }
                           }
                    }
                    return true;
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.extend(myOptions, options);
        safeShowDialog(myOptions);
    }
    /**将选择的细类加入*/
    function insertFine(rowsData) {
        $('#fineList').datagrid('insertRow',{
            index: 1,
            row: {
                id: rowsData.id,
                fineCode: rowsData.fineCode,
                fineName: rowsData.fineName,
                updateName: rowsData.updateName,
                updateDate: rowsData.updateDate
            }
        });
    }
    /** 选择科目 */
    function goSbudgetSubjects(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
        triggerId = "budgetSubjectsCode";
        triggerName = "budgetSubjectsName";
        url = "/tpm/ttApiBudgetController/goBudgetSubjects";
        width = 1000;
        height = 450;
        id = "budgetSubjectsList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].budgetSubjectsCode);
                    $("#" + triggerName).val(myobj[0].budgetSubjectsName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }
    /** 选择组织 */
    function goOrg(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "budgetDepartCode";
        triggerName = "budgetDepartName";
        url = "/tpm/tmApiOrgController/goOrgListMain";
        width = 1000;
        height = 450;
        id = "orgList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    var myobj=eval(rowsData);
                    var tagArray = [];
                    $(myobj).each(function(index,item){
                        var tag = {};
                        tag["name"] = item.src;
                        tag["code"] = item.text;
                        tagArray.push(tag);
                    });

                    renderTag("orgCodes_1", tagArray);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

</script>
</html>