/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.advance.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.act.advance.dao.TtActAdvanceDetailDao;
import com.biz.eisp.act.advance.entity.TtActAdvanceDetailEntity;
import com.biz.eisp.act.advance.service.TtActAdvanceDetailService;
import com.biz.eisp.act.advance.vo.TtActAdvanceDetailVo;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttActAdvanceDetailService")
@Transactional
public class TtActAdvanceDetailServiceImpl
extends BaseServiceImpl<TtActAdvanceDetailEntity>
implements TtActAdvanceDetailService {
    @Autowired
    private TtActAdvanceDetailDao ttActAdvanceDetailDao;
    @Autowired
    private TtActDetailService ttActDetailService;

    @Override
    public PageInfo<TtActAdvanceDetailVo> findTtActAdvanceDetailPage(TtActAdvanceDetailVo vo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.ttActAdvanceDetailDao.findTtActAdvanceDetailList(vo), (Page)page);
    }

    @Override
    public TtActAdvanceDetailEntity getTtActAdvanceDetailEntity(String id) {
        return (TtActAdvanceDetailEntity)this.ttActAdvanceDetailDao.selectByPrimaryKey(id);
    }

    @Override
    public void saveActAdvanceDetail(String tempUuid, String acts) {
        if (StringUtils.isBlank((CharSequence)tempUuid)) {
            throw new RuntimeException("\u660e\u7ec6\u6570\u636e\u51fa\u9519\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u5173\u7cfb\uff01");
        }
        JSONArray jsonArray = JSONArray.parseArray((String)acts);
        if (jsonArray != null && jsonArray.size() > 0) {
            ArrayList<TtActAdvanceDetailEntity> list = new ArrayList<TtActAdvanceDetailEntity>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject object = jsonArray.getJSONObject(i);
                TtActDetailEntity ttActEntity = (TtActDetailEntity)this.ttActDetailService.selectByPrimaryKey(object.getString("id"));
                Example example = new Example(TtActAdvanceDetailEntity.class);
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("actCode", (Object)ttActEntity.getActCode());
                criteria.andEqualTo("actDetailCode", (Object)ttActEntity.getActDetailCode());
                criteria.andEqualTo("tempUuid", (Object)tempUuid);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)this.ttActAdvanceDetailDao.selectByExample(example))) continue;
                TtActAdvanceDetailEntity entity = new TtActAdvanceDetailEntity();
                entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
                entity.setTempUuid(tempUuid);
                entity.setActCode(ttActEntity.getActCode());
                entity.setActDetailCode(ttActEntity.getActDetailCode());
                entity.setActSubclassCode(ttActEntity.getActSubclassCode());
                entity.setActSubclassName(ttActEntity.getActSubclassName());
                entity.setTerminalCode(ttActEntity.getTerminalCode());
                entity.setTerminalName(ttActEntity.getTerminalName());
                entity.setCustomerCode(ttActEntity.getCustomerCode());
                entity.setCustomerName(ttActEntity.getCustomerName());
                entity.setPayType(ttActEntity.getPayType());
                entity.setApplyPrice(ttActEntity.getAmount());
                list.add(entity);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                this.insertList(list);
            } else {
                throw new RuntimeException("\u8be5\u6d3b\u52a8\u660e\u7ec6\u5df2\u88ab\u9009\u62e9\uff01");
            }
        }
    }
}

