/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.departuse.controller;

import com.alibaba.fastjson.JSONArray;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.act.service.TtActProductService;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.act.vo.ActivitiQuotaVo;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.act.vo.TtActVo;
import com.biz.eisp.api.common.ActivitiFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.pojo.ActivitiBusinessVo;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UUIDGenerator;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@RequestMapping(value={"ttActDepartUseController"})
@Controller
public class TtActDepartUseController {
    @Autowired
    private TtActService ttActService;
    @Autowired
    private TtActDetailService ttActDetailService;
    @Autowired
    private TtActProductService ttActProductService;
    @Autowired
    private ActivitiFeign activitiFeign;

    @RequestMapping(value={"goTtActDepartUseMain"})
    public ModelAndView goTtActQuotaMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/act/departuse/TtActDepartUseMain");
    }

    @RequestMapping(value={"findTtActDepartUsePage"})
    @ResponseBody
    public DataGrid findTtActDepartUsePage(HttpServletRequest request, TtActVo vo) {
        EuPage page = new EuPage(request);
        vo.setActType(ConstantEnum.ACTTYPE.departuse.getVal());
        PageInfo<TtActVo> info = this.ttActService.findTtActPage(vo, (Page)page);
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"goUpdateOrAdd"})
    public ModelAndView goUpdateOrAdd(HttpServletRequest request, TtActDetailVo vo, String clickFunctionId) {
        TtActEntity entity = new TtActEntity();
        String tempUuid = UUIDGenerator.generate();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = (TtActEntity)this.ttActService.selectByPrimaryKey(vo.getId());
            tempUuid = entity.getTempUuid();
        }
        request.setAttribute("vo", (Object)entity);
        request.setAttribute("tempUuid", (Object)tempUuid);
        request.setAttribute("clickFunctionId", (Object)clickFunctionId);
        return new ModelAndView("com/biz/eisp/act/departuse/TtActDepartUseForm");
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(TtActVo vo) {
        AjaxJson j = new AjaxJson();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            j.setSuccess(this.ttActService.update(vo));
        } else {
            vo.setActType(ConstantEnum.ACTTYPE.departuse.getVal());
            j.setSuccess(this.ttActService.save(vo));
        }
        return j;
    }

    @RequestMapping(value={"goUpdateOrAddDetail"})
    public ModelAndView goUpdateOrAddDetail(HttpServletRequest request, TtActDetailVo vo) {
        TtActDetailEntity entity = new TtActDetailEntity();
        String tempUuid = vo.getTempUuid();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = (TtActDetailEntity)this.ttActDetailService.selectByPrimaryKey(vo.getId());
            tempUuid = entity.getTempUuid();
        }
        request.setAttribute("budgetCode", (Object)vo.getBudgetCode());
        request.setAttribute("vo", (Object)entity);
        request.setAttribute("tempUuid", (Object)tempUuid);
        return new ModelAndView("com/biz/eisp/act/departuse/TtActDepartUseDetailForm");
    }

    @RequestMapping(value={"saveOrUpdateDetail"})
    @ResponseBody
    public AjaxJson saveOrUpdateDetail(TtActDetailVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isBlank((CharSequence)vo.getId())) {
                vo.setActType(ConstantEnum.ACTTYPE.departuse.getVal());
                j.setSuccess(this.ttActDetailService.saveDetail(vo, j));
            } else {
                vo.setActType(ConstantEnum.ACTTYPE.departuse.getVal());
                j.setSuccess(this.ttActDetailService.updateDetail(vo, j));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"delDetail"})
    @ResponseBody
    public AjaxJson delDetail(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids) && this.ttActDetailService.delByIds(ids) > 0) {
                j.setSuccess(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"delProduct"})
    @ResponseBody
    public AjaxJson delProduct(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids) && this.ttActProductService.delByIds(ids) > 0) {
                j.setSuccess(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"findTtActDepartUseDetailPage"})
    @ResponseBody
    public DataGrid findTtActDepartUseDetailPage(HttpServletRequest request, TtActDetailVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtActDetailVo> info = this.ttActService.findTtActDetailPage(vo, (Page)page);
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @ResponseBody
    @RequestMapping(value={"deleteTtAct"})
    public AjaxJson deleteTtActAdvance(HttpServletRequest request, String ids) {
        AjaxJson j = new AjaxJson();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            j = this.ttActService.delete(ids);
        } else {
            j.setErrMsg("\u8bf7\u9009\u62e9\u5f85\u5220\u9664\u6570\u636e");
        }
        return j;
    }

    @RequestMapping(value={"subActiviti"})
    @ResponseBody
    public AjaxJson subActiviti(@RequestBody ActivitiQuotaVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        ActivitiBusinessVo activitiBusinessVo = new ActivitiBusinessVo();
        BeanUtils.copyProperties((Object)vo, (Object)activitiBusinessVo);
        activitiBusinessVo.setClassName("com.biz.eisp.tpm.act.core.entity.TtActActivitiHeadEntity");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("callback_service", "tpmDepartUseActivitiFeign");
        activitiBusinessVo.setVariables(variables);
        TtActEntity entity = (TtActEntity)this.ttActService.selectByPrimaryKey(vo.getBusinessObjId());
        ArrayList<TtActEntity> list = new ArrayList<TtActEntity>();
        list.add(entity);
        String json = JSONArray.toJSONString(list);
        activitiBusinessVo.setTargetText(json);
        ajaxJson = this.activitiFeign.commit(activitiBusinessVo);
        if (!ajaxJson.isSuccess()) {
            return ajaxJson;
        }
        TtActVo ttActVo = new TtActVo();
        ttActVo.setId(entity.getId());
        ttActVo.setProcessKey(ajaxJson.getObj().toString());
        UserRedis userRedis = UserUtils.getUser();
        ttActVo.setApplyUserName(userRedis.getRealname());
        ttActVo.setApplyUserBy(userRedis.getUsername());
        ttActVo.setApplyTime(DateUtils.dateNowStrHms());
        this.ttActService.updateProcessKey(ttActVo);
        ajaxJson.setMsg("\u64cd\u4f5c\u6210\u529f\uff1a\u6d41\u7a0b\u7f16\u53f7\u4e3a\uff1a" + ajaxJson.getObj().toString());
        this.ttActService.updateTtActBpmStatus(ConstantEnum.bpmStatus.APPROVAL.getValue(), activitiBusinessVo.getBusinessObjId());
        return ajaxJson;
    }
}

