/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.audit.controller;

import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.audit.entity.TtAuditActDetailEntity;
import com.biz.eisp.audit.entity.TtAuditEntity;
import com.biz.eisp.audit.service.TtAuditActDetailService;
import com.biz.eisp.audit.service.TtAuditService;
import com.biz.eisp.audit.vo.TtAuditActDetailVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/ttAuditActDetailController"})
public class TtAuditActDetailController {
    @Autowired
    private TtAuditActDetailService ttAuditActDetailService;
    @Autowired
    private TtAuditService ttAuditService;
    @Autowired
    private TtActService ttActService;
    @Autowired
    private TtActDetailService ttActDetailService;

    @RequestMapping(value={"goTtAuditActDetailMain"})
    public ModelAndView goTtAuditActDetailMain(HttpServletRequest request, String tempUuid, String id) {
        request.setAttribute("tempUuid", (Object)tempUuid);
        TtAuditEntity entity = new TtAuditEntity();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            entity = (TtAuditEntity)this.ttAuditService.selectByPrimaryKey(id);
        }
        request.setAttribute("vo", (Object)entity);
        return new ModelAndView("com/biz/eisp/audit/TtActDetailSelectMain");
    }

    @ResponseBody
    @RequestMapping(value={"findTtAuditActDetailPage"})
    public DataGrid findTtAuditActDetailPage(HttpServletRequest request, TtAuditActDetailVo vo) {
        List<TtAuditActDetailEntity> info = this.ttAuditActDetailService.findTtAuditActDetailList(vo);
        return new DataGrid(info, null);
    }

    @ResponseBody
    @RequestMapping(value={"findAuditDetailSelectPage"})
    public DataGrid findAuditDetailSelectPage(HttpServletRequest request, TtAuditActDetailEntity entity) {
        EuPage page = new EuPage(request);
        PageInfo<TtAuditActDetailEntity> info = this.ttAuditActDetailService.findAuditDetailSelectPage(entity, (Page)page);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)info.getList())) {
            info.getList().forEach(auditActDetailEntity -> {
                BigDecimal feeUsed = auditActDetailEntity.getFeeUsed() == null ? BigDecimal.ZERO : auditActDetailEntity.getFeeUsed();
                auditActDetailEntity.setFeeUseable(auditActDetailEntity.getCurrentAmount().subtract(feeUsed));
            });
        }
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @ResponseBody
    @RequestMapping(value={"saveAuditActDetail"})
    public AjaxJson saveAuditActDetail(HttpServletRequest request, String tempUuid, String acts) {
        AjaxJson j = new AjaxJson();
        this.ttAuditActDetailService.saveAuditActDetail(tempUuid, acts);
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"updateAuditActDetail"})
    public AjaxJson updateAuditActDetail(String saveJsonData) {
        AjaxJson j = new AjaxJson();
        this.ttAuditActDetailService.updateAuditActDetail(saveJsonData);
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"delActDetail"})
    public AjaxJson delActDetail(HttpServletRequest request, String ids) {
        AjaxJson j = new AjaxJson();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.ttAuditActDetailService.delByIds(ids);
        }
        return j;
    }
}

