/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.fee.service.impl;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.fee.dao.TtFeePoolDao;
import com.biz.eisp.fee.dao.TtFeePoolDetailDao;
import com.biz.eisp.fee.entity.TtFeePoolDetailEntity;
import com.biz.eisp.fee.entity.TtFeePoolEntity;
import com.biz.eisp.fee.service.TtFeePoolService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.surplus.Service.TtCustPostService;
import com.biz.eisp.tools.CodeRuleUtil;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.klock.annotation.Klock;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TtFeePoolServiceImpl
extends BaseServiceImpl<TtFeePoolEntity>
implements TtFeePoolService {
    @Autowired
    private TtFeePoolDao ttFeePoolDao;
    @Autowired
    private TtFeePoolDetailDao ttFeePoolDetailDao;
    @Autowired
    private TtCustPostService ttCustPostService;

    @Override
    public PageInfo<TtFeePoolEntity> getMaiList(TtFeePoolEntity entity, Page page) {
        Example example = new Example(TtFeePoolEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)entity.getCustCode())) {
            criteria.andLike("custCode", "%" + entity.getCustCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getCustName())) {
            criteria.andLike("custName", "%" + entity.getCustName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getCompanyCode())) {
            criteria.andLike("companyCode", "%" + entity.getCompanyCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getCompanyName())) {
            criteria.andLike("companyName", "%" + entity.getCompanyName() + "%");
        }
        if (StringUtil.isNotEmpty((Object)entity.getFeeAmount())) {
            criteria.andEqualTo("feeAmount", (Object)entity.getFeeAmount());
        }
        if (StringUtil.isNotEmpty((Object)entity.getFeeUsableAmount())) {
            criteria.andEqualTo("feeUsableAmount", (Object)entity.getFeeUsableAmount());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar1())) {
            criteria.andLike("extChar1", "%" + entity.getExtChar1() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar2())) {
            criteria.andLike("extChar2", "%" + entity.getExtChar2() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar3())) {
            criteria.andLike("extChar3", "%" + entity.getExtChar3() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar4())) {
            criteria.andLike("extChar4", "%" + entity.getExtChar4() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar5())) {
            criteria.andLike("extChar5", "%" + entity.getExtChar5() + "%");
        }
        return PageAutoHelperUtil.generatePage(() -> this.ttFeePoolDao.selectByExample(example), (Page)page);
    }

    @Override
    @Klock(keys={"#entity.custCode"})
    public AjaxJson updateAmount(TtFeePoolEntity entity, AjaxJson ajaxJson) {
        if (StringUtil.isEmpty((String)entity.getCustCode())) {
            ajaxJson.setErrMsg("\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        if (entity.getUpdateAmount() == null) {
            ajaxJson.setErrMsg("\u8c03\u6574\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)entity.getId())) {
            TtFeePoolEntity oldEntity = this.getEntityByCustAndCompany(entity.getCustCode(), entity.getCompanyCode());
            if (oldEntity == null) {
                String poolCode = CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.fee_pool_code.name());
                entity.setPoolCode(poolCode);
                entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
                entity.setFeeUsableAmount(entity.getUpdateAmount());
                entity.setFeeAmount(entity.getUpdateAmount());
                TtFeePoolDetailEntity detailEntity = this.createDetailEntity(entity);
                this.ttFeePoolDao.insertSelective(entity);
                this.ttFeePoolDetailDao.insertSelective(detailEntity);
                if (StringUtil.isNotEmpty((CharSequence)entity.getCustCode())) {
                    this.ttCustPostService.saveCustTermPost(poolCode, entity.getCustCode(), null);
                }
            } else {
                this.sysAmount(entity, oldEntity);
                this.doAmountUpdate(entity, ajaxJson);
                if (!ajaxJson.isSuccess()) {
                    return ajaxJson;
                }
                TtFeePoolDetailEntity detailEntity = this.createDetailEntity(entity);
                this.ttFeePoolDetailDao.insertSelective(detailEntity);
                this.updateDataPool(entity);
                if (StringUtil.isNotEmpty((CharSequence)entity.getCustCode())) {
                    this.ttCustPostService.saveCustTermPost(oldEntity.getPoolCode(), entity.getCustCode(), null);
                }
            }
        } else {
            TtFeePoolEntity oldEntity = (TtFeePoolEntity)this.ttFeePoolDao.selectByPrimaryKey(entity.getId());
            this.sysAmount(entity, oldEntity);
            this.doAmountUpdate(entity, ajaxJson);
            if (!ajaxJson.isSuccess()) {
                return ajaxJson;
            }
            TtFeePoolDetailEntity detailEntity = this.createDetailEntity(entity);
            this.ttFeePoolDetailDao.insertSelective(detailEntity);
            this.updateDataPool(entity);
            if (StringUtil.isNotEmpty((CharSequence)entity.getCustCode())) {
                this.ttCustPostService.saveCustTermPost(oldEntity.getPoolCode(), entity.getCustCode(), null);
            }
        }
        return ajaxJson;
    }

    private void sysAmount(TtFeePoolEntity newEntity, TtFeePoolEntity oldEntity) {
        newEntity.setFeeAmount(oldEntity.getFeeAmount());
        newEntity.setFeeUsableAmount(oldEntity.getFeeUsableAmount());
    }

    private void updateDataPool(TtFeePoolEntity entity) {
        TtFeePoolEntity newEntity = new TtFeePoolEntity();
        newEntity.setFeeAmount(entity.getFeeAmount());
        newEntity.setFeeUsableAmount(entity.getFeeUsableAmount());
        newEntity.setCustCode(entity.getCustCode());
        newEntity.setCustName(entity.getCustName());
        newEntity.setCompanyCode(entity.getCompanyCode());
        newEntity.setCompanyName(entity.getCompanyName());
        newEntity.setMoneyUnits(entity.getMoneyUnits());
        newEntity.setNotes(entity.getNotes());
        Example example = new Example(TtFeePoolEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("id", (Object)entity.getId());
        this.ttFeePoolDao.updateByExampleSelective(newEntity, example);
    }

    private void doAmountUpdate(TtFeePoolEntity entity, AjaxJson ajaxJson) {
        BigDecimal feeAmount = entity.getFeeAmount();
        BigDecimal feeUsableAmount = entity.getFeeUsableAmount();
        BigDecimal amount = entity.getUpdateAmount();
        if ((ConstantEnum.FeePoolTypeEnum.INCOME_OUT.getValue().equals(entity.getFeePoolType()) || ConstantEnum.FeePoolTypeEnum.DELETE_FEE.getValue().equals(entity.getFeePoolType())) && feeUsableAmount.add(amount = amount.multiply(new BigDecimal("-1"))).compareTo(BigDecimal.ZERO) < 0) {
            ajaxJson.setErrMsg("\u64cd\u4f5c\u5931\u8d25\uff0c\u8d85\u8fc7\u4f59\u989d\u8d39\u7528\uff1a" + feeUsableAmount);
            return;
        }
        if (amount.compareTo(BigDecimal.ZERO) > 0) {
            feeAmount = feeAmount.add(amount);
        }
        feeUsableAmount = feeUsableAmount.add(amount);
        entity.setFeeAmount(feeAmount);
        entity.setFeeUsableAmount(feeUsableAmount);
    }

    private TtFeePoolDetailEntity createDetailEntity(TtFeePoolEntity entity) {
        BigDecimal amount = entity.getUpdateAmount();
        TtFeePoolDetailEntity detailEntity = new TtFeePoolDetailEntity();
        detailEntity.setPoolCode(entity.getPoolCode());
        detailEntity.setPoolDetailCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.fee_pool_detail_code.name()));
        detailEntity.setFeeAmount(amount);
        detailEntity.setFeeUsableAmount(amount);
        detailEntity.setMoneyUnits(entity.getMoneyUnits());
        detailEntity.setFeePoolType(entity.getFeePoolType());
        detailEntity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        detailEntity.setNotes(entity.getNotes());
        detailEntity.setCompanyCode(entity.getCompanyCode());
        detailEntity.setCompanyName(entity.getCompanyName());
        detailEntity.setCustCode(entity.getCustCode());
        detailEntity.setCustName(entity.getCustName());
        detailEntity.setFromCode(entity.getFromCode());
        detailEntity.setFromTable(entity.getFromTable());
        detailEntity.setPayType(entity.getPayType());
        return detailEntity;
    }

    @Override
    public TtFeePoolEntity getEntityByCustAndCompany(String custCode, String companyCode) {
        List list;
        if (StringUtil.isEmpty((String)custCode)) {
            return null;
        }
        Example example = new Example(TtFeePoolEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)custCode)) {
            criteria.andEqualTo("custCode", (Object)custCode);
        }
        if (StringUtil.isNotEmpty((CharSequence)companyCode)) {
            criteria.andEqualTo("companyCode", (Object)companyCode);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(list = this.ttFeePoolDao.selectByExample(example)))) {
            return (TtFeePoolEntity)list.get(0);
        }
        return null;
    }

    @Override
    public TtFeePoolEntity getEntityByIdOrPoolCode(String id, String poolCode) {
        if (StringUtil.isEmpty((String)id) && StringUtil.isEmpty((String)poolCode)) {
            return null;
        }
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            return (TtFeePoolEntity)this.ttFeePoolDao.selectByPrimaryKey(id);
        }
        Example example = new Example(TtFeePoolEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("poolCode", (Object)poolCode);
        List list = this.ttFeePoolDao.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            return (TtFeePoolEntity)list.get(0);
        }
        return null;
    }
}

