<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>价格活动</title>
    <t:base type="jquery,easyui,tools"></t:base>
    <style>
        .layout-split-north {
            border-bottom: 1px solid #0072ae00;
        }
    </style>
</head>
<body class="easyui-layout" fit="true">
<div data-options="region:'north',split:true" style="height:150px;">
    <t:formvalid action="/tpm/ttActPriceController/saveOrUpdate" layout="div"
                 dialog="true" formid="detailId">
        <t:dgFormList layoutStyle="horizontal" tagConf="${clickFunctionId}" expandParam="${clickFunctionId}">
            <t:dgFormColumn field="id" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                            defaultVal="${vo.id }"/>
            <t:dgFormColumn field="tempUuid" hidden="true" formClass="form" labelName="tempUuid" optionType="input" required="false"
                            defaultVal="${tempUuid }"/>
            <t:dgFormColumn field="actName" hidden="false" formClass="biz-col-33 mb5 form" labelName="活动名称" optionType="input"  required="true"
                            defaultVal="${vo.actName}"/>
            <t:dgFormColumn field="budgetCode" hidden="false" formClass="biz-col-33 mb5 form" labelName="预算选择" optionType="choseDialog" required="true"
                            onclick="selectbudget()" defaultVal="${vo.budgetCode}" />
            <t:dgFormColumn field="beginDate" extendField="endDate" extendFieldVal="${vo.endDate}" hidden="false" formClass="biz-col-33 mb5 form" labelName="起止时间" optionType="date_begin_end"  required="true"
                            defaultVal="${vo.beginDate}"/>

            <t:dgFormColumn field="budgetName" hidden="true" formClass="biz-col-50 mb5 form" labelName="budgetName" optionType="input" required="false"
                            defaultVal="${vo.budgetName}"/>
            <t:dgFormColumn field="remarks" hidden="false" formClass="form" labelName="备注" optionType="textarea"  required="false"
                            rows="3" cols="5" defaultVal="${vo.remarks}"  style="width: 1106px; height: 83px;"/>
        </t:dgFormList>
    </t:formvalid>
</div>
<div data-options="region:'center'" style="padding:5px;">
    <t:datagrid name="priceDetailList" checkbox="true" fitColumns="false" idField="id" fit="true"
                queryMode="group"
                actionUrl="/tpm/ttActPriceController/findTtActPriceDetailPage?tempUuid=${tempUuid}&id=${vo.id}"
                pagination="true"
    >
        <t:dgCol title="id" field="id" hidden="true"/>
        <t:dgCol title="促销类型" field="actDetailType" sortable="false" dictionary="act_detail_type"/>
        <t:dgCol title="产品" field="productName" sortable="false"/>
        <t:dgCol title="公司" field="companyCode" sortable="false" dictionary="company_code"/>
        <t:dgCol title="客户" field="customerName" sortable="false"/>
        <t:dgCol title="门店" field="terminalName" sortable="false"/>
        <%--<t:dgCol title="价格类型" field="priceType" sortable="false" dictionary="price_type"/>--%>
        <t:dgCol title="价格组" field="priceGroup" sortable="false" dictionary="price_group"/>
        <t:dgCol title="标准价" field="standPrice" sortable="false"/>
        <t:dgCol title="申请价" field="applyPrice" sortable="false"/>
        <t:dgCol title="差价" field="diffPrice" sortable="false"/>
        <t:dgCol title="本品数量" field="productNum" sortable="false"/>
        <t:dgCol title="赠品" field="giftName" sortable="false"/>
        <t:dgCol title="赠品数量" field="giftNum" sortable="false"/>
        <t:dgCol title="预计销量" field="forecastSalesNum" sortable="false"/>
        <t:dgCol title="预估销售额" field="forecastSalesAmount" sortable="false"/>
        <t:dgCol title="申请费用金额" field="amount" sortable="false"/>
        <t:dgCol title="活动细类" field="actSubclassName" sortable="false"/>
        <%--<t:dgCol title="支付方式" field="payType" sortable="false" dictionary="pay_type" />--%>
        <t:dgCol title="比例" field="scale" sortable="false"/>
        <t:dgToolBar title="新增" funname="addDetail" icon="icon-add"
                     url=""></t:dgToolBar>
        <t:dgToolBar title="编辑" funname="updateDetail" icon="icon-edit"
                     url=""></t:dgToolBar>
        <t:dgToolBar title="导入" funname="add" icon="icon-dataIn"
                     url=""></t:dgToolBar>
        <t:dgToolBar title="删除" funname="deleteALLSelect" icon="icon-remove"
                     url="/tpm/ttActPriceController/delDetail"></t:dgToolBar>
        <t:dgToolBar title="附件" funname="add" icon="icon-attach"
                     url=""></t:dgToolBar>
    </t:datagrid>
    <t:formvalid action=""  layout="div"  dialog="true" formid="productId">
        <div class="p10">
            <table id="templeteTable" style="width: 100%;" cellpadding="0" cellspacing="1"
                   class="formtable">
                <tbody>
                <tr id='trId___'>
                </tr>
                </tbody>
            </table>
            <div class="p5">
            </div>
            <table id="showTable" class="table-dynamic">
                <thead>
                </thead>
                <tbody>

                </tbody>
            </table>
        </div>
    </t:formvalid>
</div>
</body>
</html>
<script type="text/javascript">
    function addDetail(){
        var budgetCode = $("#budgetCode").val();
        if (budgetCode == "") {
            tip("请先选择预算编码");
            return false;
        }else{
            id = "priceDetailList";
            gridname = id;
            var addurl = "/tpm/ttActPriceController/goUpdateOrAddDetail?1=1&tempUuid=${tempUuid}&budgetCode="+budgetCode;
            createwindow("新增", addurl,  400, 400, {});
        }
    }
    /**获取选择的预算编码*/
    function getBugetCode() {
        var budgetCode = $("#budgetCode").val();
        return budgetCode;
    }

    function updateDetail() {
        var rowsData = $('#priceDetailList').datagrid('getSelections');
        var myobj=eval(rowsData);
        var budgetCode = $("#budgetCode").val();
        if (budgetCode == "") {
            tip("请先选择预算编码");
            return false;
        }else{
            id = "priceDetailList";
            gridname = id;
            var addurl = "/tpm/ttActPriceController/goUpdateOrAddDetail?1=1&tempUuid=${tempUuid}&budgetCode="+budgetCode+"&id="+myobj[0].id;
            createwindow("编辑", addurl,  400, 400, {});
        }
    }

    $(document.body).css({
        "overflow-x":"auto",
        "overflow-y":"auto"
    });
    var trId = 0;
    var cloneTrTemp = "";
    $(function () {
        $('#templeteTable').hide();
    });

    function selectbudget(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
        triggerId = "budgetCode";
        triggerName = "budgetName";
        url = "/tpm/ttApiBudgetController/goApiBudgetMain";
        width = 1300;
        height = 500;
        id = "ttApibudgetList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                $("#budgetCode").focus();
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].budgetCode);
                    $("#" + triggerName).val(myobj[0].budgetName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

</script>