/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.project.controller;

import com.biz.eisp.act.entity.TtActbudgetEntity;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.act.vo.ActivitiQuotaVo;
import com.biz.eisp.act.vo.TtActVo;
import com.biz.eisp.api.common.ActivitiFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.pojo.ActivitiBusinessVo;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.budget.config.entity.TtCostTypeCategoriesEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeCategoriesExtendEntity;
import com.biz.eisp.budget.config.service.CategoriesExtendService;
import com.biz.eisp.budget.config.service.TtCostTypeCategoriesService;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.project.service.ActProjectService;
import com.biz.eisp.project.service.TtActbudgetService;
import com.biz.eisp.project.vo.ActDetailSaveVo;
import com.biz.eisp.project.vo.ActProjectSaveVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/actProjectController"})
public class ActProjectController {
    @Autowired
    private TtActService ttActService;
    @Autowired
    private TtActbudgetService ttActbudgetService;
    @Autowired
    private TtCostTypeCategoriesService ttCostTypeCategoriesService;
    @Autowired
    private CategoriesExtendService categoriesExtendService;
    @Autowired
    private ActProjectService actProjectService;
    @Autowired
    private ActivitiFeign activitiFeign;

    @RequestMapping(value={"goMain"})
    public ModelAndView goMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/act/project/projectActMain");
    }

    @RequestMapping(value={"goSaveUpdate"})
    public ModelAndView goSaveUpdate(HttpServletRequest request, String id) {
        request.setAttribute("id", (Object)id);
        return new ModelAndView("com/biz/eisp/act/project/projectActForm");
    }

    @RequestMapping(value={"findActProjectListPage"})
    @ResponseBody
    public DataGrid findActProjectListPage(HttpServletRequest request, TtActVo vo) {
        EuPage page = new EuPage(request);
        vo.setActType(ConstantEnum.ACTTYPE.project.getVal());
        PageInfo<TtActVo> info = this.ttActService.findTtActPage(vo, (Page)page);
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"findActBudgetListPage"})
    @ResponseBody
    public AjaxJson<TtActbudgetEntity> findActBudgetListPage(HttpServletRequest request, TtActVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        EuPage page = new EuPage(request);
        PageInfo<TtActbudgetEntity> info = this.ttActbudgetService.findActBudgetListPage(vo, (Page)page);
        ajaxJson.setList(info.getList());
        return ajaxJson;
    }

    @RequestMapping(value={"getActProjectSaveVoByCode"})
    @ResponseBody
    public AjaxJson<ActProjectSaveVo> getActProjectSaveVoByCode(String id) {
        AjaxJson ajaxJson = new AjaxJson();
        ActProjectSaveVo actProjectSaveVo = this.actProjectService.getActProjectSaveVoByCode(null, id);
        ajaxJson.setObj((Object)actProjectSaveVo);
        return ajaxJson;
    }

    @RequestMapping(value={"chooseType"})
    public ModelAndView chooseType(HttpServletRequest request, String budgetCodes) {
        request.setAttribute("budgetCodes", (Object)budgetCodes);
        return new ModelAndView("com/biz/eisp/act/project/projectActChooseType");
    }

    @RequestMapping(value={"chooseTypeListPage"})
    @ResponseBody
    public DataGrid chooseTypeListPage(HttpServletRequest request, TtCostTypeCategoriesEntity entity, String budgetCodes) {
        EuPage page = new EuPage(request);
        String[] budgetCodesArr = budgetCodes.split(",");
        PageInfo<TtCostTypeCategoriesEntity> info = this.ttCostTypeCategoriesService.chooseTypeListPage(entity, new ArrayList<String>(Arrays.asList(budgetCodesArr)), (Page)page);
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"findCategoriesExtendByCode"})
    @ResponseBody
    public AjaxJson findCategoriesExtendByCode(@RequestBody String[] categoriesCodes) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TtCostTypeCategoriesExtendEntity> listAll = this.categoriesExtendService.findCategoriesExtendByCode(new ArrayList<String>(Arrays.asList(categoriesCodes)));
        HashMap<String, List> listMap = new HashMap<String, List>();
        listAll.stream().collect(Collectors.groupingBy(TtCostTypeCategoriesExtendEntity::getCategoriesCode, Collectors.toList())).forEach((categoriesCode, list) -> listMap.put((String)categoriesCode, (List)list));
        ArrayList vos = new ArrayList();
        List<TtCostTypeCategoriesEntity> entities = this.ttCostTypeCategoriesService.findListByCodes(new ArrayList<String>(Arrays.asList(categoriesCodes)));
        Map<String, TtCostTypeCategoriesEntity> mapCa = entities.stream().collect(Collectors.toMap(TtCostTypeCategoriesEntity::getCategoriesCode, account -> account));
        listMap.forEach((k, v) -> {
            ActDetailSaveVo vo = new ActDetailSaveVo();
            vo.setCategoriesCode((String)k);
            vo.setCategoriesName(((TtCostTypeCategoriesEntity)mapCa.get(k)).getCategoriesName());
            Collections.sort(v, Comparator.comparing(TtCostTypeCategoriesExtendEntity::getOrderNum));
            vo.setExtendEntities((List<TtCostTypeCategoriesExtendEntity>)v);
            vos.add(vo);
        });
        ajaxJson.setList(vos);
        return ajaxJson;
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(@RequestBody ActProjectSaveVo actProjectSaveVo) {
        AjaxJson ajaxJson = new AjaxJson();
        this.actProjectService.saveOrUpdate(actProjectSaveVo);
        return ajaxJson;
    }

    @RequestMapping(value={"deleteHead"})
    @ResponseBody
    public AjaxJson deleteHead(HttpServletRequest request, @RequestBody String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        int errorCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f85\u64cd\u4f5c\u6570\u636e").append(ids.length).append("\u6761");
        for (String id : ids) {
            try {
                ajaxJson = this.actProjectService.deleteHead(id);
                if (ajaxJson.isSuccess()) continue;
                ++errorCount;
            }
            catch (Exception e) {
                ++errorCount;
                e.printStackTrace();
            }
        }
        stringBuffer.append("\uff0c\u5931\u8d25").append(errorCount).append("\u6761");
        if (errorCount == 0) {
            ajaxJson.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        } else {
            ajaxJson.setSuccessMsg(stringBuffer.toString());
        }
        return ajaxJson;
    }

    @RequestMapping(value={"subActiviti"})
    @ResponseBody
    public AjaxJson subActiviti(@RequestBody ActivitiQuotaVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        ActivitiBusinessVo activitiBusinessVo = new ActivitiBusinessVo();
        BeanUtils.copyProperties((Object)vo, (Object)activitiBusinessVo);
        activitiBusinessVo.setClassName("com.biz.eisp.tpm.act.core.entity.TtActActivitiHeadEntity");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("callback_service", "tpmProjectActivitiFeign");
        activitiBusinessVo.setVariables(variables);
        String json = this.actProjectService.getTargetData(vo.getBusinessObjId());
        activitiBusinessVo.setTargetText(json);
        ajaxJson = this.activitiFeign.commit(activitiBusinessVo);
        if (!ajaxJson.isSuccess()) {
            return ajaxJson;
        }
        TtActVo ttActVo = new TtActVo();
        ttActVo.setId(vo.getBusinessObjId());
        ttActVo.setProcessKey(ajaxJson.getObj().toString());
        UserRedis userRedis = UserUtils.getUser();
        ttActVo.setApplyUserName(userRedis.getRealname());
        ttActVo.setApplyUserBy(userRedis.getUsername());
        ttActVo.setApplyTime(DateUtils.dateNowStrHms());
        this.ttActService.updateProcessKey(ttActVo);
        ajaxJson.setMsg("\u64cd\u4f5c\u6210\u529f\uff1a\u6d41\u7a0b\u7f16\u53f7\u4e3a\uff1a" + ajaxJson.getObj().toString());
        this.ttActService.updateTtActBpmStatus(ConstantEnum.bpmStatus.APPROVAL.getValue(), activitiBusinessVo.getBusinessObjId());
        return ajaxJson;
    }
}

