/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.project.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.biz.eisp.act.dao.TtActDao;
import com.biz.eisp.act.dao.TtActDetailDao;
import com.biz.eisp.act.dao.TtActProductDao;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.entity.TtActProductEntity;
import com.biz.eisp.act.entity.TtActbudgetEntity;
import com.biz.eisp.act.saledata.service.TtRealSalesDataService;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.pojo.glob.entity.BaseEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeCategoriesEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeCategoriesExtendEntity;
import com.biz.eisp.budget.config.service.CategoriesExtendService;
import com.biz.eisp.budget.config.service.TtCostTypeCategoriesService;
import com.biz.eisp.budget.fee.entity.TtFeeBudgetEntity;
import com.biz.eisp.budget.fee.service.TtFeeBudgetService;
import com.biz.eisp.project.dao.TtActbudgetDao;
import com.biz.eisp.project.service.ActProjectService;
import com.biz.eisp.project.vo.ActDetailSaveVo;
import com.biz.eisp.project.vo.ActProjectSaveVo;
import com.biz.eisp.project.vo.TtProjectTargetDataVo;
import com.biz.eisp.tools.CodeRuleUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional
@Service
public class ActProjectServiceImpl
implements ActProjectService {
    @Autowired
    private TtActDao ttActDao;
    @Autowired
    private TtActDetailDao ttActDetailDao;
    @Autowired
    private TtActProductDao ttActProductDao;
    @Autowired
    private TtActbudgetDao ttActbudgetDao;
    @Autowired
    private TtCostTypeCategoriesService ttCostTypeCategoriesService;
    @Autowired
    private CategoriesExtendService categoriesExtendService;
    @Autowired
    private TtRealSalesDataService ttRealSalesDataService;
    @Autowired
    private TtFeeBudgetService ttFeeBudgetService;

    @Override
    public ActProjectSaveVo getActProjectSaveVoByCode(String code, String id) {
        ActProjectSaveVo actProjectSaveVo = new ActProjectSaveVo();
        TtActEntity head = (TtActEntity)this.ttActDao.selectByPrimaryKey(id);
        Example exampleDetail = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = exampleDetail.createCriteria();
        criteria.andEqualTo("actCode", (Object)head.getActCode());
        List detailEntities = this.ttActDetailDao.selectByExample(exampleDetail);
        Example exampleBudget = new Example(TtActbudgetEntity.class);
        Example.Criteria criteriaBudget = exampleBudget.createCriteria();
        criteriaBudget.andEqualTo("actCode", (Object)head.getActCode());
        List ttActbudgetEntities = this.ttActbudgetDao.selectByExample(exampleBudget);
        Example exampleProduct = new Example(TtActProductEntity.class);
        Example.Criteria criteriaProduct = exampleProduct.createCriteria();
        criteriaProduct.andEqualTo("actCode", (Object)head.getActCode());
        List productEntities = this.ttActProductDao.selectByExample(exampleProduct);
        actProjectSaveVo.setHead(head);
        actProjectSaveVo.setBudgets(ttActbudgetEntities);
        HashMap detailListMap = new HashMap();
        detailEntities.stream().collect(Collectors.groupingBy(TtActDetailEntity::getCategoriesCode, Collectors.toList())).forEach((categoriesCode, list) -> detailListMap.put(categoriesCode, list));
        HashMap productListMap = new HashMap();
        productEntities.stream().collect(Collectors.groupingBy(TtActProductEntity::getCategoriesCode, Collectors.toList())).forEach((categoriesCode, list) -> productListMap.put(categoriesCode, list));
        ArrayList codeDetail = new ArrayList(detailListMap.keySet());
        ArrayList productDetail = new ArrayList(productListMap.keySet());
        codeDetail.addAll(productDetail);
        List<String> codes = codeDetail.stream().distinct().collect(Collectors.toList());
        List<TtCostTypeCategoriesEntity> costTypeCategoriesEntities = this.ttCostTypeCategoriesService.findListByCodes(codes);
        List<String> categoriesCodes = costTypeCategoriesEntities.stream().map(TtCostTypeCategoriesEntity::getCategoriesCode).collect(Collectors.toList());
        List<TtCostTypeCategoriesExtendEntity> listAll = this.categoriesExtendService.findCategoriesExtendByCode(categoriesCodes);
        HashMap<String, List> listMap = new HashMap<String, List>();
        listAll.stream().collect(Collectors.groupingBy(TtCostTypeCategoriesExtendEntity::getCategoriesCode, Collectors.toList())).forEach((categoriesCode, list) -> listMap.put((String)categoriesCode, (List)list));
        listMap.forEach((k, v) -> Collections.sort(v, Comparator.comparing(TtCostTypeCategoriesExtendEntity::getOrderNum)));
        ArrayList<ActDetailSaveVo> categories = new ArrayList<ActDetailSaveVo>();
        costTypeCategoriesEntities.forEach(item -> {
            ActDetailSaveVo vo = new ActDetailSaveVo();
            vo.setCategoriesCode(item.getCategoriesCode());
            vo.setCategoriesName(item.getCategoriesName());
            vo.setItems((List)detailListMap.get(item.getCategoriesCode()));
            vo.setProducts((List)productListMap.get(item.getCategoriesCode()));
            vo.setExtendEntities((List)listMap.get(item.getCategoriesCode()));
            categories.add(vo);
        });
        actProjectSaveVo.setCategories(categories);
        return actProjectSaveVo;
    }

    @Override
    public AjaxJson saveOrUpdate(ActProjectSaveVo actProjectSaveVo) {
        AjaxJson ajaxJson = new AjaxJson();
        TtActEntity head = this.packageHead(actProjectSaveVo);
        List<TtActDetailEntity> actDetails = this.packageDetail(actProjectSaveVo);
        List<TtActbudgetEntity> budgets = this.packageBudgetDetail(actProjectSaveVo);
        List<TtActProductEntity> produts = this.packageProductDetail(actProjectSaveVo);
        if (StringUtil.isNotEmpty((CharSequence)head.getId())) {
            this.updateHead(head);
            this.updateDetail(actDetails, head);
            this.updateBudgets(budgets, head);
            this.updateproduts(produts, head);
        } else {
            List codes = CodeRuleUtil.getCodeList((String)"act_project_detail", (Integer)actDetails.size());
            BigDecimal amount = BigDecimal.ZERO;
            for (int i = 0; i < actDetails.size(); ++i) {
                actDetails.get(i).setActDetailCode((String)codes.get(i));
                amount = amount.add(actDetails.get(i).getAmount());
            }
            head.setAmount(amount);
            this.ttActDao.insertSelective(head);
            actDetails.forEach(item -> {
                item.setActCode(head.getActCode());
                this.ttActDetailDao.insertSelective(item);
            });
            budgets.forEach(item -> {
                item.setActCode(head.getActCode());
                this.ttActbudgetDao.insertSelective(item);
            });
            produts.forEach(item -> {
                item.setActCode(head.getActCode());
                this.ttActProductDao.insertSelective(item);
            });
        }
        return ajaxJson;
    }

    private void updateproduts(List<TtActProductEntity> detailEntities, TtActEntity head) {
        Example example = new Example(TtActProductEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actCode", (Object)head.getActCode());
        List oldDetail = this.ttActProductDao.selectByExample(example);
        Map<String, TtActProductEntity> detailMap = oldDetail.stream().collect(Collectors.toMap(BaseEntity::getId, account -> account));
        ArrayList<TtActProductEntity> addList = new ArrayList<TtActProductEntity>();
        ArrayList<TtActProductEntity> updateList = new ArrayList<TtActProductEntity>();
        ArrayList deleteList = new ArrayList();
        for (TtActProductEntity item2 : detailEntities) {
            item2.setActCode(head.getActCode());
            if (StringUtil.isEmpty((String)item2.getId())) {
                addList.add(item2);
                continue;
            }
            if (!detailMap.containsKey(item2.getId())) continue;
            updateList.add(item2);
            detailMap.remove(item2.getId());
        }
        if (detailMap != null && !detailMap.isEmpty()) {
            detailMap.forEach((k, v) -> deleteList.add(v));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(addList)) {
            addList.forEach(item -> this.ttActProductDao.insertSelective(item));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(updateList)) {
            updateList.forEach(item -> this.ttActProductDao.updateByPrimaryKeySelective(item));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(deleteList)) {
            deleteList.forEach(item -> this.ttActProductDao.deleteByPrimaryKey(item.getId()));
        }
    }

    private void updateBudgets(List<TtActbudgetEntity> detailEntities, TtActEntity head) {
        Example example = new Example(TtActbudgetEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actCode", (Object)head.getActCode());
        List oldDetail = this.ttActbudgetDao.selectByExample(example);
        Map<String, TtActbudgetEntity> detailMap = oldDetail.stream().collect(Collectors.toMap(TtActbudgetEntity::getId, account -> account));
        ArrayList<TtActbudgetEntity> addList = new ArrayList<TtActbudgetEntity>();
        ArrayList<TtActbudgetEntity> updateList = new ArrayList<TtActbudgetEntity>();
        ArrayList deleteList = new ArrayList();
        for (TtActbudgetEntity item2 : detailEntities) {
            item2.setActCode(head.getActCode());
            if (StringUtil.isEmpty((String)item2.getId())) {
                addList.add(item2);
                continue;
            }
            if (!detailMap.containsKey(item2.getId())) continue;
            updateList.add(item2);
            detailMap.remove(item2.getId());
        }
        if (detailMap != null && !detailMap.isEmpty()) {
            detailMap.forEach((k, v) -> deleteList.add(v));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(addList)) {
            addList.forEach(item -> this.ttActbudgetDao.insertSelective(item));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(updateList)) {
            updateList.forEach(item -> this.ttActbudgetDao.updateByPrimaryKeySelective(item));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(deleteList)) {
            deleteList.forEach(item -> this.ttActbudgetDao.deleteByPrimaryKey(item.getId()));
        }
    }

    private void updateDetail(List<TtActDetailEntity> detailEntities, TtActEntity head) {
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actCode", (Object)head.getActCode());
        List oldDetail = this.ttActDetailDao.selectByExample(example);
        Map<String, TtActDetailEntity> detailMap = oldDetail.stream().collect(Collectors.toMap(BaseEntity::getId, account -> account));
        ArrayList<TtActDetailEntity> addList = new ArrayList<TtActDetailEntity>();
        ArrayList<TtActDetailEntity> updateList = new ArrayList<TtActDetailEntity>();
        ArrayList deleteList = new ArrayList();
        for (TtActDetailEntity item2 : detailEntities) {
            item2.setActCode(head.getActCode());
            if (StringUtil.isEmpty((String)item2.getId())) {
                addList.add(item2);
                continue;
            }
            if (!detailMap.containsKey(item2.getId())) continue;
            updateList.add(item2);
            detailMap.remove(item2.getId());
        }
        if (detailMap != null && !detailMap.isEmpty()) {
            detailMap.forEach((k, v) -> deleteList.add(v));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(addList)) {
            List codes = CodeRuleUtil.getCodeList((String)"act_project_detail", (Integer)addList.size());
            for (int i = 0; i < addList.size(); ++i) {
                ((TtActDetailEntity)addList.get(i)).setActDetailCode((String)codes.get(i));
                this.ttActDetailDao.insertSelective(addList.get(i));
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(updateList)) {
            updateList.forEach(item -> this.ttActDetailDao.updateByPrimaryKeySelective(item));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(deleteList)) {
            deleteList.forEach(item -> this.ttActDetailDao.deleteByPrimaryKey(item.getId()));
        }
    }

    private void updateHead(TtActEntity head) {
        this.ttActDao.updateByPrimaryKeySelective(head);
    }

    private TtActEntity packageHead(ActProjectSaveVo actProjectSaveVo) {
        TtActEntity entity = actProjectSaveVo.getHead();
        if (StringUtil.isEmpty((String)entity.getActCode())) {
            entity.setActCode(CodeRuleUtil.getKnlCodingRulesString((String)"act_project"));
            entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        }
        entity.setActType(ConstantEnum.ACTTYPE.project.getVal());
        return entity;
    }

    private List<TtActDetailEntity> packageDetail(ActProjectSaveVo actProjectSaveVo) {
        List<ActDetailSaveVo> categories = actProjectSaveVo.getCategories();
        ArrayList<TtActDetailEntity> detailEntities = new ArrayList<TtActDetailEntity>();
        for (ActDetailSaveVo detailSaveVo : categories) {
            List<TtActDetailEntity> items = detailSaveVo.getItems();
            if (CollectionUtil.listNotEmptyNotSizeZero(items)) {
                items.forEach(item -> {
                    item.setCategoriesCode(detailSaveVo.getCategoriesCode());
                    item.setCategoriesName(detailSaveVo.getCategoriesName());
                });
            }
            detailEntities.addAll(items);
        }
        return detailEntities;
    }

    private List<TtActbudgetEntity> packageBudgetDetail(ActProjectSaveVo actProjectSaveVo) {
        ArrayList<TtActbudgetEntity> entities = new ArrayList<TtActbudgetEntity>();
        if (CollectionUtil.listNotEmptyNotSizeZero(actProjectSaveVo.getBudgets())) {
            actProjectSaveVo.getBudgets().forEach(item -> {
                if (StringUtil.isEmpty((String)item.getId())) {
                    item.setId(null);
                }
            });
            entities.addAll(actProjectSaveVo.getBudgets());
        }
        return entities;
    }

    private List<TtActProductEntity> packageProductDetail(ActProjectSaveVo actProjectSaveVo) {
        List<ActDetailSaveVo> categories = actProjectSaveVo.getCategories();
        ArrayList<TtActProductEntity> entities = new ArrayList<TtActProductEntity>();
        for (ActDetailSaveVo actDetailSaveVo : categories) {
            List<TtActProductEntity> items = actDetailSaveVo.getProducts();
            if (!CollectionUtil.listNotEmptyNotSizeZero(items)) continue;
            items.forEach(item -> item.setCategoriesCode(actDetailSaveVo.getCategoriesCode()));
            entities.addAll(items);
        }
        return entities;
    }

    @Override
    public AjaxJson deleteHead(String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TtActEntity head = (TtActEntity)this.ttActDao.selectByPrimaryKey(id);
        if (StringUtils.equals((CharSequence)head.getBpmStatus(), (CharSequence)ConstantEnum.bpmStatus.APPROVAL.getValue()) || StringUtils.equals((CharSequence)head.getBpmStatus(), (CharSequence)ConstantEnum.bpmStatus.PASS.getValue())) {
            ajaxJson.setErrMsg("\u6d41\u7a0b\u4e2d\u4e0d\u80fd\u5220\u9664");
            return ajaxJson;
        }
        this.ttActDao.deleteByPrimaryKey(id);
        Example exampleDetail = new Example(TtActDetailEntity.class);
        Example.Criteria criteriaDetail = exampleDetail.createCriteria();
        criteriaDetail.andEqualTo("actCode", (Object)head.getActCode());
        this.ttActDetailDao.deleteByExample(exampleDetail);
        Example exampleProduct = new Example(TtActProductEntity.class);
        Example.Criteria criteriaProduct = exampleProduct.createCriteria();
        criteriaProduct.andEqualTo("actCode", (Object)head.getActCode());
        this.ttActProductDao.deleteByExample(exampleProduct);
        Example exampleBudget = new Example(TtActbudgetEntity.class);
        Example.Criteria criteriaBudget = exampleBudget.createCriteria();
        criteriaBudget.andEqualTo("actCode", (Object)head.getActCode());
        this.ttActbudgetDao.deleteByExample(exampleBudget);
        return ajaxJson;
    }

    @Override
    public String getTargetData(String id) {
        TtActEntity actEntity = (TtActEntity)this.ttActDao.selectByPrimaryKey(id);
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actCode", (Object)actEntity.getActCode());
        List detailEntities = this.ttActDetailDao.selectByExample(example);
        Example exampleBudget = new Example(TtActbudgetEntity.class);
        Example.Criteria criteriaBudget = exampleBudget.createCriteria();
        criteriaBudget.andEqualTo("actCode", (Object)actEntity.getActCode());
        List ttActbudgetEntities = this.ttActbudgetDao.selectByExample(exampleBudget);
        ArrayList<String> budgetCodes = new ArrayList<String>();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)ttActbudgetEntities)) {
            for (Object item : ttActbudgetEntities) {
                budgetCodes.add(((TtActbudgetEntity)item).getBudgetCode());
            }
        }
        BigDecimal budgetAmounts = BigDecimal.ZERO;
        for (String string : budgetCodes) {
            TtFeeBudgetEntity entity = this.ttFeeBudgetService.getEntity(null, string);
            budgetAmounts = budgetAmounts.add(entity.getAmount());
        }
        ArrayList<TtProjectTargetDataVo> ttProjectTargetDataVos = new ArrayList<TtProjectTargetDataVo>();
        for (TtActDetailEntity itemDetai : detailEntities) {
            TtProjectTargetDataVo vo = new TtProjectTargetDataVo();
            vo.setAmount(itemDetai.getAmount() == null ? BigDecimal.ZERO : itemDetai.getAmount());
            vo.setApplyPrice(itemDetai.getApplyPrice());
            vo.setCustName(itemDetai.getCustomerName());
            vo.setForecastSalesAmount(itemDetai.getForecastSalesAmount() == null ? BigDecimal.ZERO : itemDetai.getForecastSalesAmount());
            vo.setProductName(itemDetai.getProductName());
            vo.setStandPrice(itemDetai.getStandPrice());
            vo.setBudgetAmount(budgetAmounts);
            String feeRodio = vo.getForecastSalesAmount().compareTo(BigDecimal.ZERO) == 0 ? "1" : vo.getAmount().divide(vo.getForecastSalesAmount(), 4, 4).multiply(new BigDecimal(100)).toString();
            vo.setFeeRodio(feeRodio + "%");
            ttProjectTargetDataVos.add(vo);
        }
        String string = JSONArray.toJSONString(ttProjectTargetDataVos);
        return string;
    }
}

