/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.advance.controller;

import com.alibaba.fastjson.JSONArray;
import com.biz.eisp.act.advance.entity.TtActAdvanceEntity;
import com.biz.eisp.act.advance.service.TtActAdvanceDetailService;
import com.biz.eisp.act.advance.service.TtActAdvanceService;
import com.biz.eisp.act.advance.vo.TtActAdvanceVo;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.act.vo.ActivitiAdvanceVo;
import com.biz.eisp.api.common.ActivitiFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.pojo.ActivitiBusinessVo;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UUIDGenerator;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@RequestMapping(value={"ttActAdvanceController"})
@Controller
public class TtActAdvanceController {
    @Autowired
    private TtActAdvanceService ttActAdvanceService;
    @Autowired
    private TtActAdvanceDetailService ttActAdvanceDetailService;
    @Autowired
    private TtActService ttActService;
    @Autowired
    private ActivitiFeign activitiFeign;

    @RequestMapping(value={"goTtActAdvanceMain"})
    public ModelAndView goTtSalesPlansMain(HttpServletRequest request, String id) {
        return new ModelAndView("com/biz/eisp/act/advance/TtActAdvanceMain");
    }

    @RequestMapping(value={"findTtActAdvancePage"})
    @ResponseBody
    public DataGrid findTtActAdvancePage(HttpServletRequest request, TtActAdvanceVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtActAdvanceVo> ttActAdvanceVoPageInfo = this.ttActAdvanceService.findTtActAdvancePage(vo, (Page)page);
        if (ttActAdvanceVoPageInfo != null) {
            return new DataGrid(ttActAdvanceVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"goSaveOrUpdateTtActAdvance"})
    public ModelAndView goSaveOrUpdateTtActAdvance(HttpServletRequest request, TtActAdvanceVo vo, String clickFunctionId) {
        request.setAttribute("clickFunctionId", (Object)clickFunctionId);
        TtActAdvanceEntity entity = new TtActAdvanceEntity();
        String tempUuid = "";
        if (vo != null && StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = this.ttActAdvanceService.getTtActAdvanceEntity(vo.getId());
            tempUuid = entity.getTempUuid();
            String actCode = entity.getActCode();
            TtActEntity ttActEntity = this.ttActService.getTtActVoByActCode(actCode);
            request.setAttribute("ttActVo", (Object)ttActEntity);
        } else {
            tempUuid = "tempuuid" + UUIDGenerator.generate();
        }
        request.setAttribute("vo", (Object)entity);
        request.setAttribute("tempUuid", (Object)tempUuid);
        return new ModelAndView("com/biz/eisp/act/advance/TtActAdvanceForm");
    }

    @ResponseBody
    @RequestMapping(value={"saveTtActAdvance"})
    public AjaxJson saveTtActAdvance(HttpServletRequest request, TtActAdvanceVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
                j.setSuccess(this.ttActAdvanceService.updateTtActAdvance(vo));
            } else {
                j.setSuccess(this.ttActAdvanceService.saveTtActAdvance(vo));
            }
        }
        catch (RuntimeException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"deleteTtActAdvance"})
    public AjaxJson deleteTtActAdvance(HttpServletRequest request, String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids)) {
                this.ttActAdvanceService.delByIds(ids);
            }
        }
        catch (RuntimeException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            j.setSuccess(false);
            e.printStackTrace();
            j.setMsg("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return j;
    }

    @RequestMapping(value={"subActiviti"})
    @ResponseBody
    public AjaxJson subActiviti(@RequestBody ActivitiAdvanceVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        ActivitiBusinessVo activitiBusinessVo = new ActivitiBusinessVo();
        BeanUtils.copyProperties((Object)vo, (Object)activitiBusinessVo);
        activitiBusinessVo.setClassName("com.biz.eisp.tpm.act.core.entity.TtActActivitiHeadEntity");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("callback_service", "tpmActAdvanceActivitiFeign");
        activitiBusinessVo.setVariables(variables);
        TtActAdvanceEntity entity = this.ttActAdvanceService.getTtActAdvanceEntity(vo.getBusinessObjId());
        ArrayList<TtActAdvanceEntity> list = new ArrayList<TtActAdvanceEntity>();
        list.add(entity);
        String json = JSONArray.toJSONString(list);
        activitiBusinessVo.setTargetText(json);
        ajaxJson = this.activitiFeign.commit(activitiBusinessVo);
        if (!ajaxJson.isSuccess()) {
            return ajaxJson;
        }
        TtActAdvanceVo ttActAdvanceVo = new TtActAdvanceVo();
        ttActAdvanceVo.setId(entity.getId());
        ttActAdvanceVo.setProcessKey(ajaxJson.getObj().toString());
        ttActAdvanceVo.setBpmStatus(ConstantEnum.bpmStatus.APPROVAL.getValue());
        this.ttActAdvanceService.updateBpmStatus(ttActAdvanceVo);
        ajaxJson.setMsg("\u64cd\u4f5c\u6210\u529f\uff1a\u6d41\u7a0b\u7f16\u53f7\u4e3a\uff1a" + ajaxJson.getObj().toString());
        return ajaxJson;
    }
}

