/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.price.controller;

import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.entity.TtActProductEntity;
import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.act.service.TtActProductService;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.act.service.TtPriceActService;
import com.biz.eisp.act.vo.ActivitiQuotaVo;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.act.vo.TtActPriceSaveDataVo;
import com.biz.eisp.act.vo.TtActVo;
import com.biz.eisp.api.common.ActivitiFeign;
import com.biz.eisp.api.feign.MdmApiFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.pojo.ActivitiBusinessVo;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UUIDGenerator;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.price.PriceParamVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/ttActPriceController"})
public class TtActPriceController {
    @Autowired
    private TtActService ttActService;
    @Autowired
    private TtPriceActService ttPriceActService;
    @Autowired
    private TtActDetailService ttActDetailService;
    @Autowired
    private MdmApiFeign mdmApiFeign;
    @Autowired
    private ActivitiFeign activitiFeign;
    @Autowired
    private TtActProductService ttActProductService;

    @RequestMapping(value={"goTtActPriceMain"})
    public ModelAndView goTtActPriceMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/act/price/ttActPriceMain");
    }

    @RequestMapping(value={"goActProductForm"})
    public ModelAndView goActProductForm(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/act/price/actProductForm");
    }

    @RequestMapping(value={"findTtActPricePage"})
    @ResponseBody
    public DataGrid findTtActPricePage(HttpServletRequest request, TtActVo vo) {
        EuPage page = new EuPage(request);
        vo.setActType(ConstantEnum.ACTTYPE.price.getVal());
        PageInfo<TtActVo> info = this.ttActService.findTtActPage(vo, (Page)page);
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"getProductList"})
    @ResponseBody
    public AjaxJson<TtActProductEntity> getProductList(String actCode) {
        AjaxJson ajaxJson = new AjaxJson();
        ArrayList<String> codes = new ArrayList<String>();
        codes.add(actCode);
        List<TtActProductEntity> productEntities = this.ttActProductService.getProductsBycodes(codes);
        ajaxJson.setList(productEntities);
        return ajaxJson;
    }

    @RequestMapping(value={"goUpdateOrAdd"})
    public ModelAndView goUpdateOrAdd(HttpServletRequest request, TtActDetailVo vo) {
        TtActEntity entity = new TtActEntity();
        String tempUuid = UUIDGenerator.generate();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = (TtActEntity)this.ttActService.selectByPrimaryKey(vo.getId());
        }
        request.setAttribute("vo", (Object)entity);
        return new ModelAndView("com/biz/eisp/act/price/ttActPriceForm");
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(@RequestBody TtActPriceSaveDataVo vo) {
        AjaxJson j = new AjaxJson();
        j = this.ttPriceActService.saveOrUpdate(vo);
        return j;
    }

    @RequestMapping(value={"goUpdateOrAddDetail"})
    public ModelAndView goUpdateOrAddDetail(HttpServletRequest request, TtActDetailVo vo) {
        TtActDetailEntity entity = new TtActDetailEntity();
        String tempUuid = vo.getTempUuid();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = (TtActDetailEntity)this.ttActDetailService.selectByPrimaryKey(vo.getId());
            tempUuid = entity.getTempUuid();
        }
        request.setAttribute("budgetCode", (Object)vo.getBudgetCode());
        request.setAttribute("vo", (Object)entity);
        request.setAttribute("tempUuid", (Object)tempUuid);
        return new ModelAndView("com/biz/eisp/act/price/ttActPriceDetailForm");
    }

    @RequestMapping(value={"goAddActDetailAll"})
    public ModelAndView goAddActDetailAll(HttpServletRequest request, String budgetCode, String edit) {
        request.setAttribute("budgetCode", (Object)budgetCode);
        edit = StringUtils.isBlank((CharSequence)edit) ? "1" : edit;
        request.setAttribute("edit", (Object)edit);
        return new ModelAndView("com/biz/eisp/act/price/ttActPriceMainForm");
    }

    @RequestMapping(value={"goAddActDetailForOne"})
    public ModelAndView goAddActDetailForOne(HttpServletRequest request, String page, String budgetCode, String edit) {
        edit = StringUtils.isBlank((CharSequence)edit) ? "1" : edit;
        request.setAttribute("edit", (Object)edit);
        request.setAttribute("budgetCode", (Object)budgetCode);
        return new ModelAndView("com/biz/eisp/act/price/" + page);
    }

    @RequestMapping(value={"saveOrUpdateDetail"})
    @ResponseBody
    public AjaxJson saveOrUpdateDetail(TtActDetailVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isBlank((CharSequence)vo.getId())) {
                vo.setActType(ConstantEnum.ACTTYPE.price.getVal());
                j.setSuccess(this.ttActDetailService.saveDetail(vo, j));
            } else {
                vo.setActType(ConstantEnum.ACTTYPE.price.getVal());
                j.setSuccess(this.ttActDetailService.updateDetail(vo, j));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"delDetail"})
    @ResponseBody
    public AjaxJson delDetail(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids) && this.ttActDetailService.delByIds(ids) > 0) {
                j.setSuccess(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"findTtActPriceDetailPage"})
    @ResponseBody
    public DataGrid findTtActPriceDetailPage(HttpServletRequest request, TtActDetailEntity entity) {
        EuPage page = new EuPage(request);
        PageInfo<TtActDetailEntity> info = this.ttPriceActService.getActDetailPage(entity, (Page)page);
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"getProductPrice"})
    @ResponseBody
    public AjaxJson getProductPrice(HttpServletRequest request, PriceParamVo priceParamVo) {
        priceParamVo.setPriceType("type1");
        AjaxJson ajaxJson = this.mdmApiFeign.getPriceCommon(priceParamVo);
        return ajaxJson;
    }

    @RequestMapping(value={"subActiviti"})
    @ResponseBody
    public AjaxJson subActiviti(@RequestBody ActivitiQuotaVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        ActivitiBusinessVo activitiBusinessVo = new ActivitiBusinessVo();
        BeanUtils.copyProperties((Object)vo, (Object)activitiBusinessVo);
        activitiBusinessVo.setClassName("com.biz.eisp.tpm.act.core.entity.TtActActivitiHeadEntity");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("callback_service", "tpmActPriceActivitiFeign");
        activitiBusinessVo.setVariables(variables);
        String json = this.ttActService.getTargetDataForPrice(vo.getBusinessObjId());
        activitiBusinessVo.setTargetText(json);
        ajaxJson = this.activitiFeign.commit(activitiBusinessVo);
        if (!ajaxJson.isSuccess()) {
            return ajaxJson;
        }
        TtActVo ttActVo = new TtActVo();
        ttActVo.setId(vo.getBusinessObjId());
        ttActVo.setProcessKey(ajaxJson.getObj().toString());
        this.ttActService.updateProcessKey(ttActVo);
        ajaxJson.setMsg("\u64cd\u4f5c\u6210\u529f\uff1a\u6d41\u7a0b\u7f16\u53f7\u4e3a\uff1a" + ajaxJson.getObj().toString());
        this.ttActService.updateTtActBpmStatus(ConstantEnum.bpmStatus.APPROVAL.getValue(), activitiBusinessVo.getBusinessObjId());
        return ajaxJson;
    }

    @ResponseBody
    @RequestMapping(value={"deleteTtAct"})
    public AjaxJson deleteTtAct(HttpServletRequest request, String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids)) {
                j = this.ttActService.delete(ids);
            }
        }
        catch (RuntimeException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            j.setSuccess(false);
            e.printStackTrace();
            j.setMsg("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return j;
    }
}

