/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.audit.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.saledata.entity.TtRealSalesDataEntity;
import com.biz.eisp.act.saledata.service.TtRealSalesDataService;
import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.activiti.vo.ActivitiCallBackVo;
import com.biz.eisp.audit.dao.TtAuditActDao;
import com.biz.eisp.audit.dao.TtAuditActDetailDao;
import com.biz.eisp.audit.dao.TtAuditDao;
import com.biz.eisp.audit.entity.TtAuditActDetailEntity;
import com.biz.eisp.audit.entity.TtAuditActEntity;
import com.biz.eisp.audit.entity.TtAuditEntity;
import com.biz.eisp.audit.service.TtAuditActDetailService;
import com.biz.eisp.audit.service.TtAuditService;
import com.biz.eisp.audit.vo.TtAuditActDetailVo;
import com.biz.eisp.audit.vo.TtAuditTargetVo;
import com.biz.eisp.audit.vo.TtAuditVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional
@Service
public class TtAuditServiceImpl
extends BaseServiceImpl<TtAuditEntity>
implements TtAuditService {
    @Autowired
    private TtAuditDao ttAuditDao;
    @Autowired
    private TtAuditActDao ttAuditActDao;
    @Autowired
    private TtAuditActDetailDao ttAuditActDetailDao;
    @Autowired
    private TtAuditActDetailService ttAuditActDetailService;
    @Autowired
    private TtActDetailService ttActDetailService;
    @Autowired
    private TtActService ttActService;
    @Autowired
    private TtRealSalesDataService ttRealSalesDataService;

    @Override
    public PageInfo<TtAuditVo> findTtAuditPage(TtAuditVo vo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.ttAuditDao.findTtAuditList(vo), (Page)page);
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtAuditServiceImpl.class)
    public void saveAudit(TtAuditVo vo) {
        TtAuditEntity entity = new TtAuditEntity();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = (TtAuditEntity)this.selectByPrimaryKey(vo.getId());
            if (!ConstantEnum.bpmStatus.COMMIT.getValue().equals(entity.getBpmStatus())) {
                throw new BusinessException("\u6d41\u7a0b\u4e2d\u4e0d\u80fd\u4fee\u6539\uff01");
            }
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            }
            catch (Exception e) {
                throw new BusinessException("\u6570\u636e\u5f02\u5e38");
            }
            this.updateByPrimaryKeySelective(entity);
        } else {
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            }
            catch (Exception e) {
                throw new BusinessException("\u6570\u636e\u5f02\u5e38");
            }
            entity.setBpmStatus(ConstantEnum.bpmStatus.COMMIT.getValue());
            entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            entity.setAuditCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.audit_head.name()));
            this.insertSelective(entity);
        }
        Example example = new Example(TtAuditActEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("tempUuid", (Object)entity.getTempUuid());
        List actlist = this.ttAuditActDao.selectByExample(example);
        if (CollectionUtil.listEmpty((List)actlist)) {
            throw new RuntimeException("\u672a\u63d0\u4ea4\u7533\u62a5\u6838\u9500\u6d3b\u52a8!");
        }
        String auditCode = entity.getAuditCode();
        actlist.stream().filter(act -> StringUtils.isBlank((CharSequence)act.getAuditCode())).forEach(item -> {
            item.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            item.setAuditCode(auditCode);
        });
        this.ttAuditActDao.updateBatchByPrimaryKeySelective(actlist);
        this.updateAuditActDetail(vo.getUpdatedJsonData());
        Example exampleDetail = new Example(TtAuditActDetailEntity.class);
        Example.Criteria criteriaDetail = exampleDetail.createCriteria();
        criteriaDetail.andEqualTo("tempUuid", (Object)entity.getTempUuid());
        List actDetaillist = this.ttAuditActDetailDao.selectByExample(exampleDetail);
        if (CollectionUtil.listEmpty((List)actlist)) {
            throw new RuntimeException("\u672a\u63d0\u4ea4\u7533\u62a5\u6838\u9500\u6d3b\u52a8\u660e\u7ec6!");
        }
        actDetaillist.stream().filter(ad -> StringUtils.isBlank((CharSequence)ad.getAuditDetailCode())).forEach(item -> {
            item.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            item.setAuditCode(auditCode);
            item.setAuditDetailCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.audit_detail.name()));
        });
        this.ttAuditActDetailDao.updateBatchByPrimaryKeySelective(actDetaillist);
    }

    @Override
    public void doAuditCallBackEnd(ActivitiCallBackVo activitiCallBackVo) {
        String id = activitiCallBackVo.getBusinessObjId();
        this.updateAuditBpmStatus(activitiCallBackVo.getBpmStatus(), id);
        if (!StringUtils.equals((CharSequence)activitiCallBackVo.getBpmStatus(), (CharSequence)ConstantEnum.bpmStatus.PASS.getValue())) {
            this.backSubAuditAndUpdateAct(id);
        }
    }

    @Override
    public void updateAuditBpmStatus(String status, String id) {
        TtAuditEntity entity = new TtAuditEntity();
        entity.setId(id);
        entity.setBpmStatus(status);
        this.ttAuditDao.updateByPrimaryKeySelective(entity);
    }

    public void updateAuditActDetail(String saveDatas) {
        JSONArray jsonArray;
        if (StringUtils.isNotBlank((CharSequence)saveDatas) && (jsonArray = JSON.parseArray((String)saveDatas)) != null && jsonArray.size() > 0) {
            ArrayList<TtAuditActDetailEntity> list = new ArrayList<TtAuditActDetailEntity>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                TtAuditActDetailVo vo = (TtAuditActDetailVo)JSONObject.toJavaObject((JSON)jsonArray.getJSONObject(i), TtAuditActDetailVo.class);
                TtAuditActDetailEntity entity = new TtAuditActDetailEntity();
                try {
                    MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
                }
                catch (Exception e) {
                    throw new BusinessException("\u6570\u636e\u5f02\u5e38");
                }
                list.add(entity);
            }
            this.ttAuditActDetailDao.updateBatchByPrimaryKeySelective(list);
        }
    }

    @Override
    public AjaxJson checkSubAuditAndUpdateAct(String id) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TtAuditActDetailEntity> entityList = this.ttAuditActDetailService.getDetailsByCodeAndId(null, id);
        entityList.forEach(item -> this.ttActDetailService.saveAuditAmountForAct(item.getActDetailCode(), item.getCurrentAmount(), item.getAuditStatus(), "1"));
        List<String> detailCodes = entityList.stream().map(TtAuditActDetailEntity::getActDetailCode).distinct().collect(Collectors.toList());
        this.ttActService.updateAuditStatus(detailCodes);
        return ajaxJson;
    }

    @Override
    public void backSubAuditAndUpdateAct(String id) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TtAuditActDetailEntity> entityList = this.ttAuditActDetailService.getDetailsByCodeAndId(null, id);
        entityList.forEach(item -> this.ttActDetailService.saveAuditAmountForAct(item.getActDetailCode(), item.getCurrentAmount(), item.getAuditStatus(), "0"));
        List<String> detailCodes = entityList.stream().map(TtAuditActDetailEntity::getActDetailCode).distinct().collect(Collectors.toList());
        this.ttActService.updateAuditStatus(detailCodes);
    }

    @Override
    public TtAuditEntity getEntity(String id, String auditCode) {
        if (StringUtils.isBlank((CharSequence)id) && StringUtils.isBlank((CharSequence)auditCode)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            return (TtAuditEntity)this.ttAuditDao.selectByPrimaryKey(id);
        }
        if (StringUtils.isNotBlank((CharSequence)auditCode)) {
            Example example = new Example(TtAuditEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("auditCode", (Object)auditCode);
            List list = this.ttAuditDao.selectByExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                return (TtAuditEntity)list.get(0);
            }
            return null;
        }
        return null;
    }

    @Override
    public String getTargetData(String id) {
        String json = "";
        TtAuditEntity head = this.getEntity(id, null);
        Example example = new Example(TtAuditActEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("auditCode", (Object)head.getAuditCode());
        List auditActEntities = this.ttAuditActDao.selectByExample(example);
        List<String> actCodes = auditActEntities.stream().map(TtAuditActEntity::getActCode).collect(Collectors.toList());
        List<TtActEntity> entities = this.ttActService.getActEntitys(actCodes);
        List<TtActDetailEntity> actDetailEntities = this.ttActDetailService.findDetailByActCodes(actCodes);
        HashMap actDetailMap = new HashMap();
        actDetailEntities.stream().collect(Collectors.groupingBy(TtActDetailEntity::getActCode, Collectors.toList())).forEach((actCode_, list) -> actDetailMap.put(actCode_, list));
        TtAuditActDetailEntity entityParam = new TtAuditActDetailEntity();
        entityParam.setAuditCode(head.getAuditCode());
        List<TtAuditActDetailEntity> auditActDetailEntities = this.ttAuditActDetailDao.getAllAuditDetail(entityParam);
        HashMap auditActDetailMap = new HashMap();
        auditActDetailEntities.stream().collect(Collectors.groupingBy(TtAuditActDetailEntity::getActCode, Collectors.toList())).forEach((actCode_, list) -> auditActDetailMap.put(actCode_, list));
        HashMap<String, BigDecimal> saleMap = new HashMap<String, BigDecimal>();
        for (TtActEntity entity : entities) {
            List<TtRealSalesDataEntity> salesDataEntities;
            BigDecimal saleAmount = BigDecimal.ZERO;
            String beginDate = entity.getBeginDate();
            String endDate = entity.getEndDate();
            List detailEntities = (List)actDetailMap.get(entity.getActCode());
            ArrayList<String> custCodes = new ArrayList<String>();
            ArrayList<String> terCodes = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)detailEntities)) {
                detailEntities.forEach(item -> {
                    if (StringUtils.isNotBlank((CharSequence)item.getCustomerCode())) {
                        custCodes.add(item.getCustomerCode());
                    }
                    if (StringUtils.isNotBlank((CharSequence)item.getTerminalCode())) {
                        terCodes.add(item.getTerminalCode());
                    }
                });
            }
            if ((CollectionUtil.listNotEmptyNotSizeZero(custCodes) || CollectionUtil.listNotEmptyNotSizeZero(terCodes)) && CollectionUtil.listNotEmptyNotSizeZero(salesDataEntities = this.ttRealSalesDataService.getSalesDataListByDateOrCustOrTer(beginDate, endDate, custCodes, terCodes))) {
                for (TtRealSalesDataEntity item2 : salesDataEntities) {
                    BigDecimal totalAmount = item2.getTotalAmount() == null ? BigDecimal.ZERO : item2.getTotalAmount();
                    saleAmount = saleAmount.add(totalAmount);
                }
            }
            saleMap.put(entity.getActCode(), saleAmount);
        }
        ArrayList<TtAuditTargetVo> ttAuditTargetVos = new ArrayList<TtAuditTargetVo>();
        for (TtActEntity actEntity : entities) {
            TtAuditTargetVo vo = new TtAuditTargetVo();
            vo.setActCode(actEntity.getActCode());
            vo.setActName(actEntity.getActName());
            vo.setAuditCode(head.getAuditCode());
            vo.setAuditName(head.getAuditName());
            vo.setCreateName(head.getCreateName());
            List list2 = (List)auditActDetailMap.get(actEntity.getActCode());
            BigDecimal bigDecimal = BigDecimal.ZERO;
            for (TtAuditActDetailEntity item3 : list2) {
                bigDecimal = bigDecimal.add(item3.getCurrentAmount());
            }
            vo.setFeeAmount(bigDecimal);
            vo.setSaleAmount((BigDecimal)saleMap.get(actEntity.getActCode()));
            BigDecimal feeRadio = vo.getSaleAmount() == null || vo.getSaleAmount().compareTo(BigDecimal.ZERO) == 0 ? new BigDecimal(1) : vo.getFeeAmount().divide(vo.getSaleAmount(), 4, 4).multiply(new BigDecimal(100));
            vo.setFeeRadio(feeRadio.toString() + "%");
            ttAuditTargetVos.add(vo);
        }
        json = JSONArray.toJSONString(ttAuditTargetVos);
        return json;
    }
}

