<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete"></t:base>
<head>
</head>
<body class="easyui-layout">
<div data-options="region:'center'">
    <div class="form-group">
        <div class="tab-tables mt20">
            <div class="custom-tabs">
                <div id="tabsContent" class="tabs-content"></div>
            </div>
        </div>
    </div>
</div>

<script>
    let tabsData = [];
    let canSubmit = true;

    $(function () {
        //tab分摊添加行
        $("#tabsContent").on('click', '.tab-share-add-btn', function () {
            addShareTableRow();
        });

        //tabs下表格删除行
        $("#tabsContent").on('click', '.delete-row', function () {
            console.log(generateShareData())
            $(this).parents("tr").remove();
        });
        //modal弹窗选择
        $("#tabsContent").on('click', 'table.shareTable .searchIcon', function () {
            let field = $(this).attr("field");
            let this_ = this;
            if (field === "productCode" || field === "productName") {
                modalSelect("/tpm/tmApiProductInfoController/goProductInfoListMain", "选择产品", "productinfoList", function (obj) {
                    $(this_).parents("tr").find("input[field=productCode]").val(obj.productInfoCode);
                    $(this_).parents("tr").find("input[field=productName]").val(obj.productInfoName);
                });
            }
        });
        renderShare({});
    });

    //编辑、查看加载数据
    function loadData() {
        let id = '${id}';
        let detail = '${load}'==="detail";
        if (id) {
            $.ajax({
                url: "/tpm/actProjectController/getActProjectSaveVoByCode?id=" + id,
                type: "post",
                dataType: "json",
                success: function (res) {
                    if (res.success) {
                        $("#actId").val(res.obj.head.id);
                        $("#actCode").val(res.obj.head.actCode);
                        $("#actName").val(res.obj.head.actName);
                        $("#beginDate").val(res.obj.head.beginDate);
                        $("#endDate").val(res.obj.head.endDate);
                        $("#remarks").val(res.obj.head.remarks);
                        renderSelectTable(res.obj.budgets, "edit");
                        tabsData = res.obj.categories;
                        renderTabs();
                        if(detail){
                            setTimeout(function () {
                                $("input").attr("disabled", "disabled");
                                $("select").attr("disabled", "disabled");
                                $("textarea").attr("disabled", "disabled");
                                $(".add-classify").css({
                                    display:"none"
                                });
                                $("span.searchIcon").css({
                                    display:"none"
                                });
                                $("a.tab-add-btn").css({
                                    display:"none"
                                });
                                $("a.tab-share-add-btn").css({
                                    display:"none"
                                });
                                $(".search-budge").css({
                                    display:"none"
                                });
                                $(".delete-row").css({
                                    display:"none"
                                });
                            }, 20)
                        }
                    } else {
                        tip(res.msg);
                    }
                }
            })
        }


    }

    //大类里面弹窗选择
    function modalSelect(url, title, tableId, cb) {
        var myOptions = {
            content: 'url:' + url,
            lock: true,
            width: 800,
            height: 400,
            title: title,
            opacity: 0.3,
            zIndex: 3005,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + tableId).datagrid('getSelections');
                if (rowsData.length === 0) {
                    tip('请选择一条数据');
                    return;
                }
                cb(rowsData[0]);
                return true;
            },
            cancelVal: '关闭',
            cancel: true,
            okVal: "确定"
        };
        $.dialog(myOptions);
    }


    //分摊信息内容
    function renderShare(item) {
        let shareHtml = "";
        shareHtml += '<div class="flex flex-align-items-center mv10">';
        shareHtml += '<span class="mr20">分摊信息</span>';
        shareHtml += '<a href="javascript:void(0)" class="easyui-linkbutton l-btn l-btn-plain mr10 tab-share-add-btn" >';
        shareHtml += '<span class="l-btn-left">';
        shareHtml += '<span class="l-btn-text icon-add l-btn-icon-left">新增</span>';
        shareHtml += '</span>';
        shareHtml += '</a>';
        shareHtml += '</div>';
        shareHtml += '<div class="form-table">';
        shareHtml += renderShareTable(item);
        shareHtml += '</div>';
        $("#tabsContent").append(shareHtml);
    }

    //渲染分摊内容table
    function renderShareTable(item) {
        let table = "";
        table += "<table class='shareTable'>";
        table += "<thead>";
        table += "<tr>";
        table += "<th>产品编码";
        table += "</th>";
        table += "<th>产品名称";
        table += "</th>";
        table += "<th>比例";
        table += "</th>";
        table += "<th>备注";
        table += "</th>";
        table += "<th>操作";
        table += "</th>";
        table += "</tr>";
        table += "</thead>";
        table += "<tbody>";
        if (item.products && item.products.length > 0) {
            item.products.forEach(function (product, bIndex) {
                table += "<tr rowId='" + product.id + "' detailCode='" + product.actDetailCode + "'>";
                table += "<td field='productCode'>";
                table += "<input type='text' class='table-input' field='productCode' value='" + product.productCode + "'>";
                table += "<span field='productCode' class='fa fa-search searchIcon'></span>";
                table += "</td>";
                table += "<td field='productName'>";
                table += "<input type='text' class='table-input' field='productName' value='" + product.productName + "'>";
                table += "<span field='productName' class='fa fa-search searchIcon'></span>";
                table += "</td>";
                table += "<td field='scale'>";
                table += "<input type='text' class='table-input' field='scale' value='" + product.scale + "'>";
                table += "</td>";
                table += "<td field='remarks'>";
                table += "<input nocheck='true' type='text' class='table-input' field='remarks' value='" + product.remarks + "'>";
                table += "</td>";
                table += "<td><a href='javascript:void(0)' class='delete-row'>删除</a>";
                table += "</td>";
                table += "</tr>"
            });
        }
        table += "</tbody>";
        return table;
    }

    function renderShareTableData(item) {
        let table = "";
        if (item && item.length > 0) {
            item.forEach(function (product, bIndex) {
                table += "<tr rowId='" + product.id + "' detailCode='" + product.actDetailCode + "'>";
                table += "<td field='productCode'>";
                table += "<input type='text' class='table-input' field='productCode' value='" + product.productCode + "'>";
                table += "<span field='productCode' class='fa fa-search searchIcon'></span>";
                table += "</td>";
                table += "<td field='productName'>";
                table += "<input type='text' class='table-input' field='productName' value='" + product.productName + "'>";
                table += "<span field='productName' class='fa fa-search searchIcon'></span>";
                table += "</td>";
                table += "<td field='scale'>";
                table += "<input type='text' class='table-input' field='scale' value='" + product.scale + "'>";
                table += "</td>";
                table += "<td field='remarks'>";
                table += "<input nocheck='true' type='text' class='table-input' field='remarks' value='" + product.remarks + "'>";
                table += "</td>";
                table += "<td><a href='javascript:void(0)' class='delete-row'>删除</a>";
                table += "</td>";
                table += "</tr>"
            });
        }
        $("#tabsContent table tbody").append(table);
    }

    //分摊信息表格新增行
    function addShareTableRow() {
        let html = "";
        html += "<tr>";
        html += "<td>";
        html += "<input type='text' class='table-input' field='productCode' value=''>";
        html += "<span field='productCode' class='fa fa-search searchIcon'></span>";
        html += "</td>";
        html += "<td>";
        html += "<input type='text' class='table-input' field='productName' value=''>";
        html += "<span field='productName' class='fa fa-search searchIcon'></span>";
        html += "</td>";
        html += "<td>";
        html += "<input type='text' class='table-input' field='scale' value=''>";
        html += "</td>";
        html += "<td>";
        html += "<input nocheck='true' type='text' class='table-input' field='remarks' value=''>";
        html += "</td>";
        html += "<td>";
        html += "<a href='javascript:void(0)' class='delete-row'>删除</a>";
        html += "</td>";
        html += "</tr>";
        $("#tabsContent").find("table.shareTable tbody").append(html);
    }

    //校验分摊信息table
    function generateShareData() {
        var tableData = [];
        $("#tabsContent").find("table.shareTable tbody tr").each(function () {
            if (canSubmit) {
                var obj = {};
                $(this).find("td").each(function (index) {
                    if (canSubmit) {
                        $(this).find("input[field]").each(function () {
                            var inputName = $(this).attr("field");
                            obj[inputName] = $(this).val();
                            if (!$(this).val() && $(this).attr("type") !== "hidden" && $(this).attr("nocheck") !== "true") {
                                canSubmit = false;
                                $(this).focus();
                                var name = $("#tabsContent").find("table.shareTable thead tr th").eq(index).text();
                                tip(name + "不能为空");
                                return false;
                            }
                        })
                    } else {
                        return false;
                    }

                });
                tableData.push(obj);
            } else {
                return false;
            }

        });
        return tableData;
    }

</script>
</body>
