<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>价格活动</title>
    <t:base type="jquery,easyui,tools"></t:base>
    <style>
        .layout-split-north {
            border-bottom: 1px solid #0072ae00;
        }
        .layout-split-south {
            border-top: 1px solid #ffffff;
        }
    </style>
    <style>
        .form-group {
            padding: 10px;
            box-sizing: border-box;
        }

        .form-input label {
            display: inline-block;
            width: 130px;
            text-align: right;
            line-height: 24px;
        }

        .form-input input {
            height: 24px;
            border: 1px solid #ddd;
            -moz-border-radius: 2px;
            -webkit-border-radius: 2px;
            border-radius: 2px;
            outline: none;
            padding: 3px 2px;
            width: 150px;
            box-sizing: border-box;
        }

        .form-input textarea {
            width: 100%;
            border: 1px solid #ddd;
            -moz-border-radius: 2px;
            -webkit-border-radius: 2px;
            border-radius: 2px;
            outline: none;
            padding: 3px 2px;
            box-sizing: border-box;
        }

        .form-table table {
            width: 100%;
            border-collapse: collapse;
        }

        .form-table table td, .form-table table th {
            height: 30px;
            border: 1px solid #eeeeee;
            position: relative;
        }

        .form-table table th {
            background: #f6f6f6;
        }

        .form-table table td input {
            width: 100%;
            height: 30px;
            padding-right: 30px;
            border: none;
        }

        .form-table table td span.searchIcon {
            position: absolute;
            right: 5px;
            top: 7px;
            font-size: 16px;
            color: #dfdfdf;
            cursor: pointer;
        }

        .form-table {
            width: 100%;
            overflow-x: auto;
        }

        table.classify {
            table-layout: fixed;
        }

        .budgeTable {
            table-layout: fixed;
        }

        /*tabs*/
        .tabs-menu {
            width: 100%;
            height: 35px;
            box-sizing: border-box;
        }

        .tab-menu {
            position: relative;
            display: inline-block;
            -webkit-box-sizing: border-box;
            box-sizing: border-box;
            height: 100%;
            padding: 12px 16px;
            text-decoration: none;
            cursor: pointer;
            -webkit-transition: color .3s cubic-bezier(.645, .045, .355, 1);
            transition: color .3s cubic-bezier(.645, .045, .355, 1);
            border-bottom: 1px solid transparent;
        }

        .tab-menu.active {
            color: #0F467C;
            border-color: #0F467C;
        }

        .hide-tab-content {
            display: none;
        }

        .delete-row {
            color: #0F467C;
            text-underline: none;
            cursor: pointer;
        }

        .tab-tables {
            position: relative;
        }

        .tab-tables .tabs-menu {
            padding-left: 120px;
        }

        .tab-tables .add-classify {
            position: absolute;
            top: 7px;
            left: 10px;
        }
    </style>
</head>
<body class="easyui-layout" fit="true" id="globallayout">
<div data-options="region:'north',split:true" style="height:150px;">
    <t:formvalid action="/tpm/ttActPriceController/saveOrUpdate" layout="div"
                 dialog="true" formid="detailId">
        <t:dgFormList layoutStyle="horizontal" tagConf="${clickFunctionId}" expandParam="${clickFunctionId}">
            <t:dgFormColumn field="id" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                            defaultVal="${vo.id }"/>
            <t:dgFormColumn field="needShare" hidden="true" formClass="form" labelName="needShare" optionType="input" required="false"
                            defaultVal="${vo.needShare }"/>
            <t:dgFormColumn field="actCode" hidden="true" formClass="form" labelName="actCode" optionType="input" required="false"
                            defaultVal="${vo.actCode }"/>
            <t:dgFormColumn field="extChar1" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar1" optionType="input" required="false"
                            defaultVal="${vo.extChar1 }"/>
            <t:dgFormColumn field="extChar2" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar2" optionType="input" required="false"
                            defaultVal="${vo.extChar2 }"/>
            <t:dgFormColumn field="extChar3" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar3" optionType="input" required="false"
                            defaultVal="${vo.extChar3 }"/>
            <t:dgFormColumn field="extChar4" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar4" optionType="input" required="false"
                            defaultVal="${vo.extChar4 }"/>
            <t:dgFormColumn field="extChar5" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar5" optionType="input" required="false"
                            defaultVal="${vo.extChar5 }"/>
            <t:dgFormColumn field="extChar6" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar6" optionType="input" required="false"
                            defaultVal="${vo.extChar6 }"/>
            <t:dgFormColumn field="extChar7" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar7" optionType="input" required="false"
                            defaultVal="${vo.extChar7 }"/>
            <t:dgFormColumn field="extChar8" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar8" optionType="input" required="false"
                            defaultVal="${vo.extChar8 }"/>
            <t:dgFormColumn field="actName" hidden="false" formClass="biz-col-33 mb5 form" labelName="活动名称" optionType="input"  required="true"
                            defaultVal="${vo.actName}"/>
            <t:dgFormColumn field="budgetCode" hidden="false" formClass="biz-col-33 mb5 form" labelName="预算选择" optionType="choseDialog" required="true"
                            onclick="selectbudget()" defaultVal="${vo.budgetCode}" />
            <t:dgFormColumn field="beginDate" extendField="endDate" extendFieldVal="${vo.endDate}" hidden="false" formClass="biz-col-33 mb5 form" labelName="起止时间" optionType="date_begin_end"  required="true"
                            defaultVal="${vo.beginDate}"/>

            <t:dgFormColumn field="budgetName" hidden="true" formClass="biz-col-50 mb5 form" labelName="budgetName" optionType="input" required="false"
                            defaultVal="${vo.budgetName}"/>
            <t:dgFormColumn field="remarks" hidden="false" formClass="form" labelName="备注" optionType="textarea"  required="false"
                            rows="3" cols="5" defaultVal="${vo.remarks}"  style="width: 1106px; height: 53px;"/>
        </t:dgFormList>
    </t:formvalid>
</div>
<div data-options="region:'center'" style="padding:5px;">
    <t:datagrid name="priceDetailList" checkbox="true" fitColumns="false" idField="id" fit="true"
                queryMode="group"
                actionUrl="/tpm/ttActPriceController/findTtActPriceDetailPage?actCode=${vo.actCode}"
                pagination="false"
    >
        <t:dgCol title="id" field="id" hidden="true"/>
        <t:dgCol title="促销类型" field="actDetailType" sortable="false" dictionary="act_detail_type" width="100"/>
        <t:dgCol title="活动细类" field="actSubclassName" sortable="false" width="100"/>
        <t:dgCol title="活动细类编码" field="actSubclassCode" sortable="false" hidden="true" width="100"/>
        <t:dgCol title="产品" field="productName" sortable="false" width="200"/>
        <t:dgCol title="产品" field="productCode" sortable="false" hidden="true" width="100"/>
        <t:dgCol title="客户" field="customerName" sortable="false" width="200"/>
        <t:dgCol title="客户" field="customerCode" hidden="true" sortable="false" width="200"/>
        <t:dgCol title="门店" field="terminalName" sortable="false" width="150"/>
        <t:dgCol title="门店" field="terminalCode" hidden="true" sortable="false" width="150"/>
        <t:dgCol title="价格组" field="priceGroup" sortable="false" dictionary="price_group" width="80"/>
        <t:dgCol title="标准价" field="standPrice" sortable="false" width="50"/>
        <t:dgCol title="申请价" field="applyPrice" sortable="false" width="50"/>
        <t:dgCol title="预计销量" field="forecastSalesNum" sortable="false" width="80"/>
        <t:dgCol title="预估销售额" field="forecastSalesAmount" sortable="false" width="80"/>
        <t:dgCol title="申请费用金额" field="amount" sortable="false" width="80"/>
        <t:dgCol title="差价" field="diffPrice" sortable="false" width="50"/>
        <t:dgCol title="本品数量" field="productNum" sortable="false" width="80"/>
        <t:dgCol title="赠品" field="giftName" sortable="false" width="150"/>
        <t:dgCol title="赠品JSON" field="giftJson" sortable="false" hidden="true" width="150"/>
        <t:dgCol title="成本价" field="giftCostPrice" sortable="true" width="150"/>
        <t:dgCol title="折扣比例" field="discountScale" sortable="true" width="150"/>
        <t:dgCol title="赠品数量" field="giftNum" sortable="false" width="80"/>
        <%--<t:dgCol title="支付方式" field="payType" sortable="false" dictionary="pay_type" />--%>
        <t:dgCol title="比例" field="scale" sortable="false" width="100"/>
        <t:dgToolBar title="新增" detail="false" funname="addDetail" icon="icon-add"
                     url=""></t:dgToolBar>
        <t:dgToolBar title="编辑" detail="false" funname="updateDetail" icon="icon-edit"
                     url=""></t:dgToolBar>
        <%--<t:dgToolBar title="导入" detail="false" funname="add" icon="icon-dataIn"--%>
                     <%--url=""></t:dgToolBar>--%>
        <t:dgToolBar title="删除" detail="false" funname="deleteALLSelect" icon="icon-remove"
                     url="/tpm/ttActPriceController/delDetail"></t:dgToolBar>
        <%--<t:dgToolBar title="附件" funname="add" icon="icon-attach"--%>
                     <%--url=""></t:dgToolBar>--%>
    </t:datagrid>
</div>
</body>
</html>

<script type="text/javascript">

    $(function () {
        var needShare = "${vo.needShare }";
        if(needShare=="Y"){
            addProductLayout();
            $.post("/tpm/ttActPriceController/getProductList", { "actCode": $("#actCode").val() },
                function(data){
                 if(data.success){
                     setTimeout(function () {
                         renderShareTableData(data.objList);
                         let detail = '${load}'==="detail";
                         if(detail){
                             $("input").attr("disabled", "disabled");
                             $("select").attr("disabled", "disabled");
                             $("textarea").attr("disabled", "disabled");
                             $(".add-classify").css({
                                 display:"none"
                             });
                             $("span.searchIcon").css({
                                 display:"none"
                             });
                             $("a.tab-add-btn").css({
                                 display:"none"
                             });
                             $("a.tab-share-add-btn").css({
                                 display:"none"
                             });
                             $(".search-budge").css({
                                 display:"none"
                             });
                             $(".delete-row").css({
                                 display:"none"
                             });
                         }
                     },600)
                 }
                }, "json");
        }
    });
    
    function addProductLayout() {
        $('#globallayout').layout('add',{
            region: 'south',
            height: 250,
            split: true,
            collapsible:false
        });
        $('#globallayout').layout("panel","south").panel({href:"/tpm/ttActPriceController/goActProductForm"});
    }

    function collapseProductLayout(){
        $("#needShare").val("N");
        $('#globallayout').layout('remove','south');
    }
    /*编辑活动明细*/
    function updateDetail(){
        var rows = $('#priceDetailList').datagrid('getSelections');
        if(rows.length!=1){
            tip("请选择一条数据操作");
            return ;
        }
        var budgetCode = $("#budgetCode").val();
        if (budgetCode == "") {
            tip("请先选择预算");
            return;
        }
        var addurl = "/tpm/ttActPriceController/goAddActDetailAll?1=1&budgetCode="+budgetCode+"&edit=0";
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: 1300,
            height: 500,
            title: '编辑',
            opacity: 0.3,
            zIndex:2500,
            parent:'addDetailDialog',
            id:'addDetailDialogId',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var data = iframe.saveData();
                    insertDetailData(data);
                    return true;
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }

    /**新增活动明细*/
    function addDetail() {
        var budgetCode = $("#budgetCode").val();
        if (budgetCode == "") {
            tip("请先选择预算");
            return;
        }
        var addurl = "/tpm/ttActPriceController/goAddActDetailAll?1=1&budgetCode="+budgetCode;
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: 1300,
            height: 500,
            title: '新增',
            opacity: 0.3,
            zIndex:2500,
            parent:'addDetailDialog',
            id:'addDetailDialogId',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var data = iframe.saveData();
                    insertDetailData(data);
                    return true;
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }
    /*插入明细数据*/
    function insertDetailData(data) {
        var productDetailRows = data.productDetailRows;
        if(productDetailRows.length==0){
            return;
        }
        var priceDetailListOldRows= $('#priceDetailList').datagrid('getRows');
        var priceDetailListOldObj = [];
        for(var i = 0;i<priceDetailListOldRows.length;i++){
            priceDetailListOldObj.push(priceDetailListOldRows[i].id);
        }
        var head = data.head;
        //构建赠品名称
        var giftName = createGiftName(head);
        var giftJson = createGiftJson(head);
        //收集活动细类编码

        for(var i=0;i<productDetailRows.length;i++){
            if(priceDetailListOldObj.includes(productDetailRows[i].id)){
                $('#priceDetailList').datagrid('updateRow',{
                    index: getIndex(productDetailRows[i].id),
                    row: {
                        giftName:giftName,
                        giftJson:giftJson,
                        actDetailType:head.actDetailType,
                        customerName:head.customerName,
                        customerCode:head.customerCode,
                        terminalName:head.terminalName,
                        terminalCode:head.terminalCode,
                        priceGroup:head.priceGroup,
                        productNum:head.productNum,
                        giftNum:head.giftNum,
                        actSubclassName:head.actSubclassName,
                        actSubclassCode:head.actSubclassCode,
                        discountScale:productDetailRows[i].discountScale,
                        diffPrice:productDetailRows[i].diffPrice,
                        applyPrice:productDetailRows[i].applyPrice,
                        productName: productDetailRows[i].productInfoName,
                        productCode:productDetailRows[i].productInfoCode,
                        standPrice:productDetailRows[i].standPrice,
                        forecastSalesNum:productDetailRows[i].forecastSalesNum,
                        forecastSalesAmount:productDetailRows[i].forecastSalesAmount,
                        amount:productDetailRows[i].amount,
                        scale:productDetailRows[i].scale
                    }
                });
            }else{
                $('#priceDetailList').datagrid('insertRow',{
                    index: 0,
                    row: {
                        giftName:giftName,
                        giftJson:giftJson,
                        id: productDetailRows[i].id,
                        actDetailType:head.actDetailType,
                        customerName:head.customerName,
                        customerCode:head.customerCode,
                        terminalName:head.terminalName,
                        terminalCode:head.terminalCode,
                        priceGroup:head.priceGroup,
                        productNum:head.productNum,
                        giftNum:head.giftNum,
                        actSubclassName:head.actSubclassName,
                        actSubclassCode:head.actSubclassCode,
                        giftCostPrice:head.giftCostPrice,
                        discountScale:productDetailRows[i].discountScale,
                        diffPrice:productDetailRows[i].diffPrice,
                        applyPrice:productDetailRows[i].applyPrice,
                        productName:productDetailRows[i].productInfoName,
                        productCode:productDetailRows[i].productInfoCode,
                        standPrice:productDetailRows[i].standPrice,
                        forecastSalesNum:productDetailRows[i].forecastSalesNum,
                        forecastSalesAmount:productDetailRows[i].forecastSalesAmount,
                        amount:productDetailRows[i].amount,
                        scale:productDetailRows[i].scale
                    }
                });
            }
        }
        checkDataForProduct();

    }

    function checkDataForProduct() {
        var actSubclassCodeArr = [];
        var priceDetailListRows = $('#priceDetailList').datagrid('getRows');
        if(priceDetailListRows.length==0){
            if($("#tabsContent").length>0){
                collapseProductLayout();
            }
        }else{
            for(var i=0;i<priceDetailListRows.length;i++){
                if(!isEmpty(priceDetailListRows[i].actSubclassCode)){
                    actSubclassCodeArr.push(priceDetailListRows[i].actSubclassCode);
                }
            }
            if(actSubclassCodeArr.length==0){

                if($("#tabsContent").length>0){
                    collapseProductLayout();
                }
            }else{
                //请求服务器检查
                $.ajax({
                    url: "/tpm/ttCostTypeController/checkProductByFineCode",
                    type: "post",
                    dataType: "json",
                    data: JSON.stringify(actSubclassCodeArr),
                    contentType: "application/json",
                    success: function (res) {
                        if(res.type=="1"){
                            $("#needShare").val("Y");
                            if(!($("#tabsContent").length>0)){
                                addProductLayout();
                            }
                        }else{
                            if(($("#tabsContent").length>0)){
                                collapseProductLayout();
                            }
                        }

                    }
                });
            }

        }
    }

    
    function getSelectsRows() {
        var rows= $('#priceDetailList').datagrid('getSelections');
        return rows;
    }
    
    /*构建赠品名字*/
    function createGiftName(head) {
        var giftName = '';
        if(head.giftJson){
            var giftJson = head.giftJson;
            for (var i=0;i<giftJson.length;i++){
                if(i==0){
                    giftName += giftJson[i].name;
                }else{
                    giftName += ","+giftJson[i].name;
                }
            }
        }
        return giftName;
    }

    function createGiftJson(head) {
        var giftJson = '[]';
        if(head.giftJson){
            giftJson = JSON.stringify(head.giftJson)
        }
        return giftJson;
    }


    function getIndex(id){
        var tempRows= $('#priceDetailList').datagrid('getRows');
        var index = 0;
        for(var i = 0;i<tempRows.length;i++){
            if(tempRows[i].id==id){
                index = $("#priceDetailList").datagrid("getRowIndex",tempRows[i]);
                break;
            }
        }
        return index;
    }

    /* 提交数据构建 */
    function saveData() {
       var data = {};
       var head = {};
        head.id= $("#id").val();
        head.actName= $("#actName").val();
        head.needShare = $("#needShare").val();
        head.budgetCode= $("#budgetCode").val();
        head.beginDate= $("#beginDate").val();
        head.endDate= $("#endDate").val();
        head.remarks= $("#remarks").val();
        head.extChar1= $("#extChar1").val();
        head.extChar2= $("#extChar2").val();
        head.extChar3= $("#extChar3").val();
        head.extChar4= $("#extChar4").val();
        head.extChar5= $("#extChar5").val();
        head.extChar6= $("#extChar6").val();
        head.extChar7= $("#extChar7").val();
        head.extChar8= $("#extChar8").val();
        data.head = head;
       var budgetsArr = [];
       var budgets = {}
        budgets.budgetCode = $("#budgetCode").val();
        budgets.actCode = $("#actCode").val();
        budgetsArr.push(budgets);
        data.budgets = budgetsArr;
        var priceProductListRows =[];
        if(document.getElementById("tabsContent")){
            priceProductListRows= generateShareData();
        }
        data.products = priceProductListRows;
        var priceDetailListRows = $('#priceDetailList').datagrid('getRows');
        data.details =priceDetailListRows;
        for(var i=-0;i<data.details.length;i++){
            var giftJson = data.details[i].giftJson;
            if(!isEmpty(giftJson)){
               var gifts = JSON.parse(giftJson);
                data.details[i].gifts = gifts
            }
        }
        openProgressTop();
        $.ajax({
            type: "POST",
            url: "/tpm/ttActPriceController/saveOrUpdate",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(data),
            complete:function(){
                closeProgressTop();
            },
            success: function(data){
                closeProgressTop();
                var api = frameElement.api, W = api.opener;
                if (data.success) {
                    W.tip(data.msg);
                    W.pricelistsearch();
                    api.close();
                }else{
                    tip(data.msg);
                }
            }
        });
    }




    function selectbudget(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
        triggerId = "budgetCode";
        triggerName = "budgetName";
        url = "/tpm/ttApiBudgetController/goApiBudgetMain";
        width = 1300;
        height = 500;
        id = "ttApibudgetList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                $("#budgetCode").focus();
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].budgetCode);
                    $("#" + triggerName).val(myobj[0].budgetName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }
</script>

