<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete"></t:base>
<head>
    <style>
        .form-group {
            padding: 10px;
            box-sizing: border-box;
        }

        .form-input label {
            display: inline-block;
            width: 130px;
            text-align: right;
            line-height: 24px;
        }

        .form-input input {
            height: 24px;
            border: 1px solid #ddd;
            -moz-border-radius: 2px;
            -webkit-border-radius: 2px;
            border-radius: 2px;
            outline: none;
            padding: 3px 2px;
            width: 150px;
            box-sizing: border-box;
        }

        .form-input textarea {
            width: 100%;
            border: 1px solid #ddd;
            -moz-border-radius: 2px;
            -webkit-border-radius: 2px;
            border-radius: 2px;
            outline: none;
            padding: 3px 2px;
            box-sizing: border-box;
        }

        .form-table table {
            width: 100%;
            border-collapse: collapse;
        }

        .form-table table td, .form-table table th {
            height: 30px;
            border: 1px solid #eeeeee;
            position: relative;
        }

        .form-table table th {
            background: #f6f6f6;
        }

        .form-table table td input {
            width: 100%;
            height: 30px;
            padding-right: 30px;
            border: none;
        }

        .form-table table td span.searchIcon {
            position: absolute;
            right: 5px;
            top: 7px;
            font-size: 16px;
            color: #dfdfdf;
            cursor: pointer;
        }

        .form-table {
            width: 100%;
            overflow-x: auto;
        }

        table.classify {
            table-layout: fixed;
        }

        .budgeTable {
            table-layout: fixed;
        }

        /*tabs*/
        .tabs-menu {
            width: 100%;
            height: 35px;
            box-sizing: border-box;
        }

        .tab-menu {
            position: relative;
            display: inline-block;
            -webkit-box-sizing: border-box;
            box-sizing: border-box;
            height: 100%;
            padding: 12px 16px;
            text-decoration: none;
            cursor: pointer;
            -webkit-transition: color .3s cubic-bezier(.645, .045, .355, 1);
            transition: color .3s cubic-bezier(.645, .045, .355, 1);
            border-bottom: 1px solid transparent;
        }

        .tab-menu.active {
            color: #0F467C;
            border-color: #0F467C;
        }

        .hide-tab-content {
            display: none;
        }

        .delete-row {
            color: #0F467C;
            text-underline: none;
            cursor: pointer;
        }

        .tab-tables {
            position: relative;
        }

        .tab-tables .tabs-menu {
            padding-left: 120px;
        }

        .tab-tables .add-classify {
            position: absolute;
            top: 7px;
            left: 10px;
        }
    </style>
</head>
<body class="easyui-layout">
<div data-options="region:'center'">
    <div class="form-group">
        <div class="flex flex-align-items-center mb10">
            <input type="hidden" id="actId">
            <input type="hidden" id="actCode">
            <div class="form-input flex-1">
                <label>活动名称：</label>
                <input type="text" id="actName">
            </div>
            <div class="form-input flex-1">
                <label>起止时间：</label>
                <input type="text" id="beginDate" readonly class='Wdate' onfocus="WdatePicker({dateFmt:'yyyy-MM-dd'})">~
                <input type="text" id="endDate" readonly class='Wdate' onfocus="WdatePicker({dateFmt:'yyyy-MM-dd'})">
            </div>
        </div>
        <div class="form-input flex flex-align-items-center mb10">
            <label class="flex-none">备注：</label>
            <textarea id="remarks" class="flex-auto" rows="3"></textarea>
        </div>
        <div class="form-input flex flex-align-items-start">
            <label class="flex-none">选择预算：</label>
            <div class="form-table flex-auto flex flex-align-items-start">
                <div class="flex-auto">
                    <table class="budgeTable flex-auto" id="selectTable">
                        <thead>
                        <tr>
                            <th>预算编码</th>
                            <th>预算科目</th>
                            <th>年</th>
                            <th>月</th>
                            <th>余额</th>
                            <th>使用上限</th>
                            <th>操作</th>
                        </tr>
                        </thead>
                        <tbody>

                        </tbody>
                        <tfoot>

                        </tfoot>
                    </table>
                </div>
                <div class="search-budge p5 flex-none">
                    <span onclick="selectBudge()" class="fa fa-search"
                          style="display: block;font-size: 16px;"></span>
                </div>
            </div>
        </div>
        <div class="tab-tables mt20">
            <a href="javascript:void(0)" class="add-classify easyui-linkbutton l-btn l-btn-plain mr10"
               onclick="selectClassify()">
                         <span class="l-btn-left">
                             <span class="l-btn-text icon-add l-btn-icon-left">增加大类</span>
                         </span>
            </a>
            <div class="custom-tabs">
                <div id="tabsMenu" class="tabs-menu flex flex-align-items-center">

                </div>
                <div id="tabsContent" class="tabs-content"></div>
            </div>
        </div>
    </div>
</div>

<script>
    let tabsData = [];
    let canSubmit = true;

    $(function () {
        loadData();

        //tab切换事件
        $("#tabsMenu").on('click', '.tab-menu', function () {
            let code = $(this).attr("code");
            $("#tabsMenu .tab-menu").removeClass("active");
            $(this).addClass("active");
            $(".tab-content").addClass("hide-tab-content");
            $("#" + code).removeClass("hide-tab-content")
        });

        // 预算使用金额输入
        $("#selectTable tbody").on("keyup", "input.shareAmount", function () {
            let reg1 = /^(-?[0-9]\d*)?$/;
            let reg2 = /^(-?\d*\.\d{1,2})?$/;
            let value = $(this).val();
            let maxValue = $(this).attr("maxValue");
            if (value.length != 0 && (reg1.test(value) || reg2.test(value))) {
                if (parseFloat(value) > parseFloat(maxValue)) {
                    tip("使用上限不能大于余额");
                    $(this).val("");
                }
            } else {
                $(this).val("");
            }
            $("#selectTable tfoot .totalShareAmount").text(calcUseTotal());
        });

        //预算删除行
        $("#selectTable").on('click', '.delete-row', function () {
            $(this).parents("tr").remove();
            renderTotal();
        });

        //tab添加按钮
        $("#tabsContent").on('click', '.tab-add-btn', function () {
            let code = $(this).attr("code");
            renderEmptyRow(code, 1);
        });

        //tab分摊添加行
        $("#tabsContent").on('click', '.tab-share-add-btn', function () {
            let code = $(this).attr("code");
            addShareTableRow(code);
        });

        //tabs下表格删除行
        $("#tabsContent").on('click', '.delete-row', function () {
            $(this).parents("tr").remove();
        });

        //modal弹窗选择
        $("#tabsContent").on('click', 'table.classify .searchIcon', function () {
            let field = $(this).attr("field");
            let this_ = this;
            if (field === "terminalCode" || field === "terminalName") {
                modalSelect("/tpm/tmApiTerminalController/goTerminalListMain", "选择终端", "terminalList", function (obj) {
                    $(this_).parents("tr").find("input[field=terminalCode]").val(obj.terminalCode);
                    $(this_).parents("tr").find("input[field=terminalName]").val(obj.terminalName);
                });
            }
            if (field === "customerCode" || field === "customerName") {
                modalSelect("/tpm/tmApiCustomerController/goCustomerListMain", "选择客户", "customerList", function (obj) {
                    $(this_).parents("tr").find("input[field=customerCode]").val(obj.customerCode);
                    $(this_).parents("tr").find("input[field=customerName]").val(obj.customerName);
                });
            }
            if (field === "productCode" || field === "productName") {
                modalSelect("/tpm/tmApiProductInfoController/goProductInfoListMain", "选择产品", "customerList", function (obj) {
                    $(this_).parents("tr").find("input[field=productCode]").val(obj.productInfoCode);
                    $(this_).parents("tr").find("input[field=productName]").val(obj.productInfoName);
                });
            }
            if (field === "actSubclassCode" || field === "actSubclassName") {
                let code = $(this_).parents("div.tab-content").attr("id");
                let url = "/tpm/ttApiFineController/goApiActFinesByCategMain?categoriesCode=" + code;
                modalSelect(url, "选择活动细类", "actSubclassList", function (obj) {
                    $(this_).parents("tr").find("input[field=actSubclassCode]").val(obj.fineCode);
                    $(this_).parents("tr").find("input[field=actSubclassName]").val(obj.fineName);
                    $.ajax({
                        url: "/tpm/ttCostTypeController/checkProductByFineCode",
                        type: "post",
                        dataType: "json",
                        data: JSON.stringify([obj.fineCode]),
                        contentType: "application/json",
                        success: function (res) {
                            if (res.success && res.type == 1) {
                                let item = {
                                    categoriesCode: code,
                                    products: []
                                }
                                renderShare(item);
                            }
                        }
                    })

                });
            }


        });

        //modal弹窗选择
        $("#tabsContent").on('click', 'table.shareTable .searchIcon', function () {
            let field = $(this).attr("field");
            let this_ = this;
            if (field === "productCode" || field === "productName") {
                modalSelect("/tpm/tmApiProductInfoController/goProductInfoListMain", "选择产品", "productinfoList", function (obj) {
                    $(this_).parents("tr").find("input[field=productCode]").val(obj.productInfoCode);
                    $(this_).parents("tr").find("input[field=productName]").val(obj.productInfoName);
                });
            }
        });
    });

    //编辑、查看加载数据
    function loadData() {
        let id = '${id}';
        let detail = '${load}'==="detail";
        if (id) {
            $.ajax({
                url: "/tpm/actProjectController/getActProjectSaveVoByCode?id=" + id,
                type: "post",
                dataType: "json",
                success: function (res) {
                    if (res.success) {
                        $("#actId").val(res.obj.head.id);
                        $("#actCode").val(res.obj.head.actCode);
                        $("#actName").val(res.obj.head.actName);
                        $("#beginDate").val(res.obj.head.beginDate);
                        $("#endDate").val(res.obj.head.endDate);
                        $("#remarks").val(res.obj.head.remarks);
                        renderSelectTable(res.obj.budgets, "edit");
                        tabsData = res.obj.categories;
                        renderTabs();
                        if(detail){
                            setTimeout(function () {
                                $("input").attr("disabled", "disabled");
                                $("select").attr("disabled", "disabled");
                                $("textarea").attr("disabled", "disabled");
                                $(".add-classify").css({
                                    display:"none"
                                });
                                $("span.searchIcon").css({
                                    display:"none"
                                });
                                $("a.tab-add-btn").css({
                                    display:"none"
                                });
                                $("a.tab-share-add-btn").css({
                                    display:"none"
                                });
                                $(".search-budge").css({
                                    display:"none"
                                });
                                $(".delete-row").css({
                                    display:"none"
                                });
                            }, 20)
                        }
                    } else {
                        tip(res.msg);
                    }
                }
            })
        }


    }

    //选择预算
    function selectBudge() {
        var myOptions = {
            content: 'url:/tpm/ttApiBudgetController/goApiBudgetMain?checkBox=false',
            lock: true,
            width: 800,
            height: 600,
            title: "选择预算",
            opacity: 0.3,
            zIndex: 3000,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#ttApibudgetList').datagrid('getSelections');
                if (rowsData.length === 0) {
                    tip('请选择一条数据');
                    return;
                }
                renderSelectTable(rowsData, "add");
                return true;
            },
            cancelVal: '关闭',
            cancel: true,
            okVal: "确定"
        };
        $.dialog(myOptions);
    }

    //渲染选择预算表格
    function renderSelectTable(array, type) {
        if (array.length > 0) {
            array.forEach(function (item, index) {
                let html = '';
                let id = type === "add" ? "" : item.id;
                let actCode = item.actCode || "";
                let code = item.budgetCode;
                if ($("#selectTable tbody tr[code='" + code + "']").length === 0) {
                    html += "<tr newId='" + id + "' actCode='" + actCode + "' code='" + code + "'>";
                    html += "<td field='budgetCode'>" + item.budgetCode;
                    html += "</td>";
                    html += "<td field='budgetSubjectsName'>" + item.budgetSubjectsName;
                    html += "</td>";
                    html += "<td field='budgetYear'>" + item.budgetYear;
                    html += "</td>";
                    html += "<td field='budgetMonth'>" + item.budgetMonth;
                    html += "</td>";
                    html += "<td field='amount'>" + item.amount;
                    html += "</td>";
                    html += "<td field='shareAmount'><input class='table-input shareAmount' maxValue='" + item.amount + "' type='text' value='" + item.amount + "'>";
                    html += "</td>";
                    html += "<td><a href='javascript:void(0)' class='delete-row'>删除</a>";
                    html += "</td>";
                    html += "</tr>";
                    $("#selectTable tbody").append(html);
                }
            });
            renderTotal();
        }

    }

    //渲染预算合计
    function renderTotal() {
        let totalHtml = "";
        totalHtml += "<tr class='total'>";
        totalHtml += "<td colspan='5'>可用余额合计：<span class='totalMoney'>" + calcTotal() + "</span>";
        totalHtml += "</td>";
        totalHtml += "<td colspan='2'>使用金额合计：<span class='totalShareAmount'>" + calcUseTotal() + "</span>";
        totalHtml += "</td>";
        totalHtml += "</tr>";
        $("#selectTable tfoot").html(totalHtml);
    }

    //计算预算合计
    function calcTotal() {
        let total = 0;
        let doms = $("#selectTable tbody").find("tr");
        $.each(doms, function () {
            if ($(this).find("td[field=amount]").length > 0) {
                let amount = $(this).find("td[field=amount]").text() || 0;
                total = ((parseFloat(total) * 1000 + parseFloat(amount) * 1000) / 1000).toFixed(2);
            }
        });
        return total;
    }

    //计算预算使用合计
    function calcUseTotal() {
        let total = 0;
        let doms = $("#selectTable tbody").find("tr");
        $.each(doms, function () {
            if ($(this).find("input.shareAmount").length > 0) {
                let amount = $(this).find("input.shareAmount").val() || 0;
                total = ((parseFloat(total) * 1000 + parseFloat(amount) * 1000) / 1000).toFixed(2);
            }
        });
        return total;
    }


    //选择大类
    function selectClassify() {
        let budgeCodes = [];
        $("#selectTable tbody tr").each(function () {
            let budgeCode = $(this).find("td[field=budgetCode]").text();
            budgeCodes.push(budgeCode)
        });
        if(budgeCodes.length===0){
            tip("请先选择预算");
            return;
        }
        var myOptions = {
            content: 'url:/tpm/actProjectController/chooseType?budgetCodes='+budgeCodes.join(","),
            lock: true,
            width: 600,
            height: 400,
            title: "选择大类",
            opacity: 0.3,
            zIndex: 3001,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#projectActCostlist').datagrid('getSelections');
                if (rowsData.length === 0) {
                    tip('请选择一条数据');
                    return;
                }
                let codes = [];
                rowsData.forEach(function (item) {
                    codes.push(item.categoriesCode);
                });
                requestClassify(codes);
                return true;
            },
            cancelVal: '关闭',
            cancel: true,
            okVal: "确定"
        };
        $.dialog(myOptions);
    }

    //渲染大类tabs
    function renderTabs() {
        tabsData.forEach(function (item) {
            renderTabMenu(item);
            renderTabContent(item);
        })
    }

    //渲染tab-menu
    function renderTabMenu(item) {
        let tabsHtml = "";
        let code = item.categoriesCode;
        console.log(code)
        if ($("div.tab-menu[code='" + code + "']").length === 0) {
            if ($("#tabsMenu").find(".tab-menu").length === 0) {
                tabsHtml += "<div code='" + item.categoriesCode + "' class='tab-menu active'>" + item.categoriesName;
            } else {
                tabsHtml += "<div code='" + item.categoriesCode + "' class='tab-menu'>" + item.categoriesName;
            }
            tabsHtml += "</div>";
            $("#tabsMenu").append(tabsHtml);
        }
    }

    //渲染tab-content
    function renderTabContent(item) {
        let contentHtml = "";
        let code = item.categoriesCode;
        if ($("#" + code).length === 0) {
            if ($("#tabsContent").find(".tab-content").length === 0) {
                contentHtml += '<div id="' + item.categoriesCode + '" class="tab-content">';
            } else {
                contentHtml += '<div id="' + item.categoriesCode + '"  class="tab-content hide-tab-content">';
            }
            contentHtml += '<div class="flex mv10">';
            contentHtml += '<a href="javascript:void(0)" class="easyui-linkbutton l-btn l-btn-plain mr10 tab-add-btn" code="' + item.categoriesCode + '">';
            contentHtml += '<span class="l-btn-left">';
            contentHtml += '<span class="l-btn-text icon-add l-btn-icon-left">新增</span>';
            contentHtml += '</span>';
            contentHtml += '</a>';
            contentHtml += '<a href="javascript:void(0)" class="easyui-linkbutton l-btn l-btn-plain mr10" code="' + item.categoriesCode + '">';
            contentHtml += '<span class="l-btn-left">';
            contentHtml += '<span class="l-btn-text icon-dataIn l-btn-icon-left">导入</span>';
            contentHtml += '</span>';
            contentHtml += '</a>';
            contentHtml += '</div>';
            contentHtml += '<div class="form-table">';
            contentHtml += renderTabContenTable(item);
            contentHtml += '</div>';
            contentHtml += '</div>';
            $("#tabsContent").append(contentHtml);
            renderEmptyRow(item.categoriesCode, 5);
            if (item.products && item.products.length > 0) {
                renderShare(item);
            }
        }
    }

    //渲染内容table
    function renderTabContenTable(item) {
        let table = "";
        table += "<table class='classify'>";
        table += "<thead>";
        table += "<tr>";
        item.extendEntities.forEach(function (head, hIndex) {
            table += "<th width='" + head.wideNum + "px'>" + head.name;
            table += "</th>"
        });
        table += "<th width='100px'>操作";
        table += "</th>";
        table += "</tr>";
        table += "</thead>";
        table += "<tbody>";
        if (item.items && item.items.length > 0) {
            item.items.forEach(function (body, bIndex) {
                table += "<tr rowId='" + body.id + "' detailCode='" + body.actDetailCode + "'>";
                item.extendEntities.forEach(function (column, cIndex) {
                    table += "<td field='" + column.field + "' notEmpty='" + column.required + "'>";
                    if (column.opType === "select") {
                        table += "<select class='table-input' field='" + column.field + "' value='" + body[column.field] + "'>";
                        table += "<option value=''>---请选择---</option>";
                        column.selectVos.forEach(function (option) {
                            if (body[column.field] == option.value) {
                                table += "<option selected value='" + option.value + "'>" + option.desc
                            } else {
                                table += "<option value='" + option.value + "'>" + option.desc
                            }
                            table += "</option>";
                        });
                        table += "</select>";
                    }
                    if (column.opType === "choose") {
                        table += "<input type='text' class='table-input' field='" + column.field + "' value='" + body[column.field] + "'>";
                        table += "<span field='" + column.field + "' class='fa fa-search searchIcon'></span>";
                    }
                    if (column.opType === "text") {
                        table += "<input type='text' class='table-input' field='" + column.field + "' value='" + body[column.field] + "'>";
                    }
                    table += "</td>"
                });
                table += "<td><a href='javascript:void(0)' class='delete-row'>删除</a>";
                table += "</td>";
                table += "</tr>"
            });
        }
        table += "</tbody>";
        return table;
    }

    //请求大类
    function requestClassify(codes) {
        $.ajax({
            url: "/tpm/actProjectController/findCategoriesExtendByCode",
            type: "post",
            dataType: "json",
            contentType: "application/json",
            data: JSON.stringify(codes),
            success: function (res) {
                if (res.success) {
                    if (res.objList && res.objList.length > 0) {
                        res.objList.forEach(function (item) {
                            let code = item.categoriesCode;
                            if ($("div.tab-menu[code='" + code + "']").length === 0) {
                                tabsData.push(item);
                            }
                        })
                    }
                    renderTabs();
                } else {
                    tip(res.msg);
                }
            }
        });
    }

    //生成空白表格行
    function renderEmptyRow(code, times) {
        if (!times) times = 1;
        for (let i = 0; i < times; i++) {
            let columns = [];
            tabsData.forEach(function (item) {
                if (item.categoriesCode == code) {
                    columns = item.extendEntities;
                }
            });
            let trHtml = "";
            trHtml += "<tr rowId='' detailCode=''>";
            columns.forEach(function (column) {
                trHtml += "<td field='" + column.field + "' notEmpty='" + column.required + "'>";
                if (column.opType === "select") {
                    trHtml += "<select class='table-input' field='" + column.field + "' value=''>";
                    trHtml += "<option value=''>---请选择---</option>";
                    column.selectVos.forEach(function (option) {
                        trHtml += "<option value='" + option.value + "'>" + option.desc
                        trHtml += "</option>";
                    });
                    trHtml += "</select>";
                }
                if (column.opType === "choose") {
                    trHtml += "<input type='text' class='table-input' field='" + column.field + "' value=''>";
                    trHtml += "<span field='" + column.field + "' class='fa fa-search searchIcon'></span>";
                }
                if (column.opType === "text") {
                    trHtml += "<input type='text' class='table-input' field='" + column.field + "' value=''>";
                }
                trHtml += "</td>"
            });
            trHtml += "<td><a href='javascript:void(0)' class='delete-row'>删除</a>";
            trHtml += "</td>";
            trHtml += "</tr>";
            $("#" + code).find("table.classify tbody").append(trHtml);
        }
    }

    //构造选择预算的数据
    function generateBudgeData() {
        let params = [];
        let trs = $("#selectTable tbody tr");
        $.each(trs, function () {
            let obj = {};
            obj["id"] = $(this).attr("newId");
            obj["actCode"] = $(this).attr("actCode");
            let tds = $(this).find("td[field]");
            $.each(tds, function (dIndex, td) {
                let key = $(this).attr("field");
                if ($(this).find("input").length > 0) {
                    obj[key] = $(this).find("input").val();
                } else {
                    obj[key] = $(this).text();
                }
            });
            params.push(obj);
        });
        return params;
    }

    //构造大类数据
    function generateClassifyData() {
        let params = [];
        let tabs = $("#tabsMenu").find(".tab-menu");
        $.each(tabs, function (index, item) {
            let tabObj = {};
            let categoriesCode = $(this).attr("code");
            let categoriesName = $(this).text();
            tabObj["categoriesCode"] = categoriesCode;
            tabObj["categoriesName"] = categoriesName;
            let items = [];
            let trs = $("#" + categoriesCode).find("table.classify tbody tr");
            $.each(trs, function () {
                let rowObj = {};
                rowObj["id"] = $(this).attr("rowId");
                rowObj["actDetailCode"] = $(this).attr("detailCode");
                let tds = $(this).find("td[field]");
                let canPushRow = false;
                $.each(tds, function (dIndex, td) {
                    let key = $(this).attr("field");
                    let notEmpty = $(this).attr("notEmpty");
                    let value = "";
                    if ($(this).find("input").length > 0) {
                        value = $(this).find("input").val();
                    }
                    if ($(this).find("select").length > 0) {
                        value = $(this).find("select").val();
                    }
                    if (notEmpty === "Y") {
                        if (value) {
                            rowObj[key] = value;
                            canPushRow = true;
                        } else {
                            canPushRow = false;
                        }
                    } else {
                        rowObj[key] = value;
                    }
                });
                canPushRow ? items.push(rowObj) : "";
            });
            tabObj["items"] = items;
            let products = [];
            products = generateShareData(categoriesCode);
            tabObj["products"] = products;
            params.push(tabObj);
        });
        return params;
    }

    //大类里面弹窗选择
    function modalSelect(url, title, tableId, cb) {
        var myOptions = {
            content: 'url:' + url,
            lock: true,
            width: 800,
            height: 400,
            title: title,
            opacity: 0.3,
            zIndex: 3005,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + tableId).datagrid('getSelections');
                if (rowsData.length === 0) {
                    tip('请选择一条数据');
                    return;
                }
                cb(rowsData[0]);
                return true;
            },
            cancelVal: '关闭',
            cancel: true,
            okVal: "确定"
        };
        $.dialog(myOptions);
    }


    //分摊信息内容
    function renderShare(item) {
        let shareHtml = "";
        let code = item.categoriesCode;
        if ($("#" + code).find("table.shareTable").length === 0) {
            shareHtml += '<div class="flex flex-align-items-center mv10">';
            shareHtml += '<span class="mr20">分摊信息</span>';
            shareHtml += '<a href="javascript:void(0)" class="easyui-linkbutton l-btn l-btn-plain mr10 tab-share-add-btn" code="' + item.categoriesCode + '">';
            shareHtml += '<span class="l-btn-left">';
            shareHtml += '<span class="l-btn-text icon-add l-btn-icon-left">新增</span>';
            shareHtml += '</span>';
            shareHtml += '</a>';
            shareHtml += '</div>';
            shareHtml += '<div class="form-table">';
            shareHtml += renderShareTable(item);
            shareHtml += '</div>';
            $("#" + code).append(shareHtml);
        }
    }

    //渲染分摊内容table
    function renderShareTable(item) {
        let table = "";
        table += "<table class='shareTable'>";
        table += "<thead>";
        table += "<tr>";
        table += "<th>产品编码";
        table += "</th>";
        table += "<th>产品名称";
        table += "</th>";
        table += "<th>比例";
        table += "</th>";
        table += "<th>备注";
        table += "</th>";
        table += "<th>操作";
        table += "</th>";
        table += "</tr>";
        table += "</thead>";
        table += "<tbody>";
        if (item.products && item.products.length > 0) {
            item.products.forEach(function (product, bIndex) {
                table += "<tr rowId='" + product.id + "' detailCode='" + product.actDetailCode + "'>";
                table += "<td field='productCode'>";
                table += "<input type='text' class='table-input' field='productCode' value='" + product.productCode + "'>";
                table += "<span field='productCode' class='fa fa-search searchIcon'></span>";
                table += "</td>";
                table += "<td field='productName'>";
                table += "<input type='text' class='table-input' field='productName' value='" + product.productName + "'>";
                table += "<span field='productName' class='fa fa-search searchIcon'></span>";
                table += "</td>";
                table += "<td field='scale'>";
                table += "<input type='text' class='table-input' field='scale' value='" + product.scale + "'>";
                table += "</td>";
                table += "<td field='remarks'>";
                table += "<input nocheck='true' type='text' class='table-input' field='remarks' value='" + product.remarks + "'>";
                table += "</td>";
                table += "<td><a href='javascript:void(0)' class='delete-row'>删除</a>";
                table += "</td>";
                table += "</tr>"
            });
        }
        table += "</tbody>";
        return table;
    }

    //分摊信息表格新增行
    function addShareTableRow(code) {
        let html = "";
        html += "<tr>";
        html += "<td>";
        html += "<input type='text' class='table-input' field='productCode' value=''>";
        html += "<span field='productCode' class='fa fa-search searchIcon'></span>";
        html += "</td>";
        html += "<td>";
        html += "<input type='text' class='table-input' field='productName' value=''>";
        html += "<span field='productName' class='fa fa-search searchIcon'></span>";
        html += "</td>";
        html += "<td>";
        html += "<input type='text' class='table-input' field='scale' value=''>";
        html += "</td>";
        html += "<td>";
        html += "<input nocheck='true' type='text' class='table-input' field='remarks' value=''>";
        html += "</td>";
        html += "<td>";
        html += "<a href='javascript:void(0)' class='delete-row'>删除</a>";
        html += "</td>";
        html += "</tr>";
        $("#" + code).find("table.shareTable tbody").append(html);
    }

    //校验分摊信息table
    function generateShareData(code) {
        var tableData = [];
        $("#" + code).find("table.shareTable tbody tr").each(function () {
            if (canSubmit) {
                var obj = {};
                $(this).find("td").each(function (index) {
                    if (canSubmit) {
                        $(this).find("input[field]").each(function () {
                            var inputName = $(this).attr("field");
                            obj[inputName] = $(this).val();
                            if (!$(this).val() && $(this).attr("type") !== "hidden" && $(this).attr("nocheck") !== "true") {
                                canSubmit = false;
                                $(this).focus();
                                var name = $("#" + code).find("table.shareTable thead tr th").eq(index).text();
                                tip(name + "不能为空");
                                return false;
                            }
                        })
                    } else {
                        return false;
                    }

                });
                tableData.push(obj);
            } else {
                return false;
            }

        });
        return tableData;
    }

    //提交数据
    function saveData() {
        canSubmit = true;
        let id = $("#actId").val();
        let actCode = $("#actCode").val();
        let actName = $("#actName").val();
        let beginDate = $("#beginDate").val();
        let endDate = $("#endDate").val();
        let remarks = $("#remarks").val();
        let head = {
            id: id,
            actCode: actCode,
            actName: actName,
            beginDate: beginDate,
            endDate: endDate,
            remarks: remarks,
        };
        let budgets = generateBudgeData();
        let categories = generateClassifyData();
        if (canSubmit) {
            let postParams = {
                head: head,
                budgets: budgets,
                categories: categories,
            };
            $.ajax({
                url: "/tpm/actProjectController/saveOrUpdate",
                type: "post",
                dataType: "json",
                data: JSON.stringify(postParams),
                contentType: "application/json",
                success: function (res) {
                    if (res.success) {
                        var api = frameElement.api, W = api.opener;
                        W.tip(res.msg);
                        W.projectlistsearch();
                        api.close();
                    } else {
                        tip(res.msg);
                    }
                }
            })
        }
    }
</script>
</body>
