/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.uploadz.service.impl;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UUIDGenerator;
import com.biz.eisp.uploadz.service.UploadService;
import com.biz.eisp.uploadz.utils.FileUtils;
import com.biz.eisp.uploadz.utils.UploadFile;
import com.biz.eisp.uploadz.vo.ResultFileVo;
import com.biz.eisp.uploadz.vo.TsPictureVo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="uploadService")
public class UploadServiceImpl
implements UploadService {
    private static String FILE_SEPARATOR = File.separator;
    private static final String pointFolderField = "pointFolder";
    @Value(value="${upload.win-path}")
    private String WIN_UPLOAD_ROOT;
    @Value(value="${upload.linux-path}")
    private String LINUX_UPLOAD_ROOT;
    @Value(value="${upload.base-path}")
    private String UPLOAD_BASE_PATH;
    @Value(value="${upload.url-path}")
    private String UPLOAD_URL_PATH;

    @Override
    public List<ResultFileVo> saveMoreFile(HttpServletRequest request) {
        ArrayList<ResultFileVo> savePaths = new ArrayList<ResultFileVo>();
        String pointFolderFieldTemp = this.getThePointFolderField(request);
        try {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            multipartRequest.setCharacterEncoding("UTF-8");
            Map fileMap = multipartRequest.getFileMap();
            String basePath = this.createAndReturnBasePath(pointFolderFieldTemp);
            for (Map.Entry entity : fileMap.entrySet()) {
                MultipartFile mf = (MultipartFile)entity.getValue();
                ResultFileVo fileVo = new ResultFileVo();
                String fileName = mf.getOriginalFilename();
                fileVo.setFileName(fileName);
                String extend = FileUtils.getExtend(fileName);
                fileVo.setExtend(extend);
                String newFileName = this.getNewFileName(extend);
                String savePath = this.getRealPath(basePath, newFileName);
                System.out.println(savePath);
                this.saveFile(mf, savePath, extend);
                fileVo.setRealPath(savePath);
                fileVo.setVurlPath(this.getRealPath_(basePath, newFileName));
                fileVo.setUrlPath(this.getUrlPath(basePath, newFileName));
                savePaths.add(fileVo);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return savePaths;
    }

    @Override
    public List<TsPictureVo> saveAppFile(HttpServletRequest request) {
        ArrayList<TsPictureVo> savePaths = new ArrayList<TsPictureVo>();
        try {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            multipartRequest.setCharacterEncoding("UTF-8");
            List files = ((MultipartHttpServletRequest)request).getFiles("files");
            if (CollectionUtil.listNotEmptyNotSizeZero((List)files)) {
                files.forEach(mf -> {
                    String[] dateArr;
                    TsPictureVo fileVo = new TsPictureVo();
                    String fileName = mf.getOriginalFilename();
                    if (StringUtils.isNotBlank((String)fileName) && (dateArr = fileName.split("_")).length > 1) {
                        String dateStr = DateUtils.format((Date)DateUtils.getDate((long)Long.parseLong(dateArr[1])), (String)"yyyy-MM-dd");
                        String basePath = this.createAndReturnBasePathForNew(dateStr);
                        fileVo.setFileName(fileName);
                        String extend = FileUtils.getExtend(fileName);
                        fileVo.setExtend(extend);
                        String savePath = this.getRealPath(basePath, fileName);
                        this.saveFile((MultipartFile)mf, savePath, extend);
                        fileVo.setImgPath(this.getRealPath_(basePath, fileName));
                        fileVo.setImgUrl(this.getUrlPath(basePath, fileName));
                        savePaths.add(fileVo);
                    }
                });
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return savePaths;
    }

    private String getThePointFolderField(HttpServletRequest request) {
        String obj = request.getParameter(pointFolderField);
        if (StringUtil.isNotEmpty((Object)obj)) {
            return obj;
        }
        return "";
    }

    @Override
    public String saveFile(MultipartFile mf, String savePath, String extend) {
        if ("txt".equals(extend)) {
            this.copyToDisk(mf, savePath);
        } else {
            File savefile = new File(savePath);
            try {
                FileCopyUtils.copy((byte[])mf.getBytes(), (File)savefile);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25\uff01");
            }
        }
        return "";
    }

    private void copyToDisk(MultipartFile mf, String savePath) {
        try {
            byte[] allbytes = mf.getBytes();
            String head1 = this.toHexString(allbytes[0]);
            String head2 = this.toHexString(allbytes[1]);
            if ("ef".equals(head1) && "bb".equals(head2)) {
                String contents = new String(mf.getBytes(), "UTF-8");
                if (StringUtil.isNotBlank((CharSequence)contents)) {
                    FileOutputStream out = new FileOutputStream(savePath);
                    ((OutputStream)out).write(contents.getBytes());
                    ((OutputStream)out).close();
                }
            } else {
                String contents = new String(mf.getBytes(), "GBK");
                FileOutputStream out = new FileOutputStream(savePath);
                ((OutputStream)out).write(contents.getBytes());
                ((OutputStream)out).close();
            }
        }
        catch (Exception e) {
            try {
                String contents = new String(mf.getBytes(), "UTF-8");
                if (StringUtil.isNotBlank((CharSequence)contents)) {
                    FileOutputStream out = new FileOutputStream(savePath);
                    ((OutputStream)out).write(contents.getBytes());
                    ((OutputStream)out).close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    private String toHexString(int index) {
        String hexString = Integer.toHexString(index);
        hexString = hexString.substring(hexString.length() - 2);
        return hexString;
    }

    private String getNewFileName(String extend) {
        return DateUtils.getDataString((SimpleDateFormat)DateUtils.yyyymmddhhmmss) + UUIDGenerator.generate() + "." + extend;
    }

    private String createAndReturnBasePath(String pointFolder) {
        String basePath = this.getBasePath(pointFolder);
        File file = new File(this.getRealPath(basePath, ""));
        if (!file.exists()) {
            file.mkdirs();
        }
        return basePath;
    }

    private String createAndReturnBasePathForNew(String dateStr) {
        String basePath = this.UPLOAD_BASE_PATH + FILE_SEPARATOR + dateStr;
        File file = new File(this.getRealPath(basePath, ""));
        if (!file.exists()) {
            file.mkdirs();
        }
        return basePath;
    }

    private String getRootPath() {
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            return this.WIN_UPLOAD_ROOT;
        }
        return this.LINUX_UPLOAD_ROOT;
    }

    @Override
    public String getCouldDownloadPath() {
        return this.getRootPath() + this.UPLOAD_BASE_PATH;
    }

    private String getBasePath(String pointFolder) {
        return this.UPLOAD_BASE_PATH + FILE_SEPARATOR + this.checkAndRturnPointFolder(pointFolder) + DateUtils.getDataString((SimpleDateFormat)DateUtils.date_sdf);
    }

    private String checkAndRturnPointFolder(String pointFolder) {
        if (StringUtil.isNotEmpty((CharSequence)pointFolder)) {
            return pointFolder.replace("/", FILE_SEPARATOR) + FILE_SEPARATOR;
        }
        return "";
    }

    private String getRealPath(String basePath, String fileName) {
        return this.getRootPath() + basePath + FILE_SEPARATOR + fileName;
    }

    private String getUrlPath(String basePath, String fileName) {
        return this.UPLOAD_URL_PATH + basePath + FILE_SEPARATOR + fileName;
    }

    private String getRealPath_(String basePath, String fileName) {
        return basePath + FILE_SEPARATOR + fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServletResponse viewOrDownloadFile(UploadFile uploadFile) {
        uploadFile.getResponse().setContentType("UTF-8");
        uploadFile.getResponse().setCharacterEncoding("UTF-8");
        InputStream bis = null;
        BufferedOutputStream bos = null;
        HttpServletResponse response = uploadFile.getResponse();
        HttpServletRequest request = uploadFile.getRequest();
        String ctxPath = "D:\\tomcat\\tomcat7.0.70WDL\\template";
        String downLoadPath = "";
        long fileLength = 0L;
        if (uploadFile.getRealPath() != null && uploadFile.getContent() == null) {
            downLoadPath = uploadFile.getRealPath();
            fileLength = new File(downLoadPath).length();
            try {
                bis = new BufferedInputStream(new FileInputStream(downLoadPath));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            if (uploadFile.getContent() != null) {
                bis = new ByteArrayInputStream(uploadFile.getContent());
            }
            fileLength = uploadFile.getContent().length;
        }
        try {
            int bytesRead;
            if (!uploadFile.isView() && uploadFile.getExtend() != null) {
                if (uploadFile.getExtend().equals("text")) {
                    response.setContentType("text/plain;");
                } else if (uploadFile.getExtend().equals("doc") || uploadFile.getExtend().equals("docx")) {
                    response.setContentType("application/msword;");
                } else if (uploadFile.getExtend().equals("xls")) {
                    response.setContentType("application/ms-excel;");
                } else if (uploadFile.getExtend().equals("pdf")) {
                    response.setContentType("application/pdf;");
                } else if (uploadFile.getExtend().equals("jpg") || uploadFile.getExtend().equals("jpeg")) {
                    response.setContentType("image/jpeg;");
                } else {
                    response.setContentType("application/x-msdownload;");
                }
                response.setHeader("Content-disposition", "attachment; filename=" + new String((uploadFile.getTitleField() + "." + uploadFile.getExtend()).getBytes("GBK"), "ISO8859-1"));
                response.setHeader("Content-Length", String.valueOf(fileLength));
            }
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return response;
    }
}

