/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.uploadz.controller;

import com.biz.eisp.attachment.entity.KnlDownAttachmentEntity;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.uploadz.service.DownloadService;
import com.biz.eisp.uploadz.service.UploadService;
import com.biz.eisp.uploadz.utils.FileUtils;
import com.biz.eisp.uploadz.vo.ResultFileVo;
import com.biz.eisp.uploadz.vo.ZipFileVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.aspectj.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/downLoadController"})
@Api(tags={"\u6587\u4ef6\u4e0b\u8f7d"}, description="\u6587\u4ef6\u4e0b\u8f7d")
public class DownLoadController {
    private static final Logger log = LoggerFactory.getLogger(DownLoadController.class);
    @Autowired
    private UploadService uploadService;
    @Autowired
    private DownloadService downloadService;

    @RequestMapping(value={"/downloadFile"})
    @ApiOperation(value="\u901a\u8fc7\u6587\u4ef6\u8def\u5f84\u4e0b\u8f7d\u6587\u4ef6\u5e76\u6307\u5b9a\u6587\u4ef6\u540d", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="realPath", value="\u6587\u4ef6\u8def\u5f84", paramType="query"), @ApiImplicitParam(name="fileName", value="\u6587\u4ef6\u540d\u79f0", paramType="query")})
    public void downloadFile(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="realPath") String realPath, @RequestParam(value="fileName") String fileName) {
        this.commonDownloadFile(request, response, realPath, fileName);
    }

    @RequestMapping(value={"/commonDownloadFile"})
    @ApiOperation(value="\u901a\u8fc7\u6587\u4ef6ID\u6765\u4e0b\u8f7d\u6587\u4ef6", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u9644\u4ef6ID", paramType="query")})
    public void commonDownloadFile(HttpServletRequest request, HttpServletResponse response, String id) {
        KnlDownAttachmentEntity downAttachmentEntity = this.downloadService.getDownAttachInfo(id);
        if (!StringUtil.isNotEmpty((Object)downAttachmentEntity)) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u6587\u4ef6\u4e0b\u8f7d\u4fe1\u606f");
        }
        this.commonDownloadFile(request, response, downAttachmentEntity.getRealPath(), downAttachmentEntity.getAttachmentTitle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u6253\u5305\u4e0b\u8f7d\u6587\u4ef6", httpMethod="GET")
    @RequestMapping(value={"downloadZip"}, consumes={"application/json;charset=UTF-8"}, produces={"application/zip"})
    public void downloadZip(HttpServletResponse response, @RequestBody ZipFileVo zipfile) {
        File zipTempFile = new File("zipTemp" + DateUtils.getDate((String)"yyyyMMddHHmmss") + ".zip");
        ZipOutputStream zipStream = null;
        FileInputStream zipSource = null;
        BufferedInputStream bufferStream = null;
        try {
            zipStream = new ZipOutputStream(new FileOutputStream(zipTempFile));
            for (ResultFileVo fileVo : zipfile.getFiles()) {
                File file;
                if (!fileVo.getRealPath().startsWith(this.uploadService.getCouldDownloadPath()) || !(file = new File(fileVo.getRealPath())).exists()) continue;
                zipSource = new FileInputStream(file);
                ZipEntry zipEntry = new ZipEntry(fileVo.getFileName());
                zipStream.putNextEntry(zipEntry);
                bufferStream = new BufferedInputStream(zipSource, 10240);
                int read = 0;
                byte[] buf = new byte[10240];
                while ((read = bufferStream.read(buf, 0, 10240)) != -1) {
                    zipStream.write(buf, 0, read);
                }
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            try {
                if (null != bufferStream) {
                    bufferStream.close();
                }
                if (null != zipStream) {
                    zipStream.flush();
                    zipStream.close();
                }
                if (null != zipSource) {
                    zipSource.close();
                }
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
        try {
            response.setContentType("application/zip");
            String fileName = StringUtil.isEmpty((String)zipfile.getFileName()) ? "\u538b\u7f29\u6587\u4ef6" : zipfile.getFileName();
            response.setHeader("content-disposition", "attachment;filename=" + fileName + ".zip");
            response.addHeader("content-length", "" + zipTempFile.length());
            byte[] buffer = FileUtil.readAsByteArray((File)zipTempFile);
            ServletOutputStream out = response.getOutputStream();
            out.write(buffer);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            zipTempFile.deleteOnExit();
        }
    }

    @ApiOperation(value="\u5220\u9664\u9644\u4ef6\u4e0b\u8f7d\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u9644\u4ef6ID", paramType="query")})
    @PostMapping(value={"removeDownAttach"})
    public Boolean removeDownAttach(@RequestParam(value="id") String id) {
        return this.downloadService.removeDownAttach(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commonDownloadFile(HttpServletRequest request, HttpServletResponse response, String realPath, String fileName) {
        if (realPath.startsWith(this.uploadService.getCouldDownloadPath())) {
            File file = new File(realPath);
            FileInputStream in = null;
            OutputStream out = null;
            if (file.exists()) {
                try {
                    in = new FileInputStream(file);
                    byte[] buffer = new byte[((InputStream)in).available()];
                    ((InputStream)in).read(buffer);
                    String userAgent = request.getHeader("user-agent").toLowerCase();
                    fileName = userAgent.contains("msie") || userAgent.contains("like gecko") ? URLEncoder.encode(fileName, "UTF-8") : new String(fileName.getBytes("UTF-8"), "iso-8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + fileName);
                    response.addHeader("content-length", "" + file.length());
                    String extend = FileUtils.getExtend(file.getName());
                    if (StringUtils.isNotBlank((String)extend)) {
                        switch (extend) {
                            case "text": {
                                response.setContentType("text/plain");
                                break;
                            }
                            case "doc": {
                                response.setContentType("application/msword");
                                break;
                            }
                            case "docx": {
                                response.setContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
                                break;
                            }
                            case "xls": {
                                response.setContentType("application/vnd.ms-excel");
                                break;
                            }
                            case "xlsx": {
                                response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                                break;
                            }
                            case "jpg": {
                                response.setContentType("image/jpeg");
                                break;
                            }
                            case "jpeg": {
                                response.setContentType("image/jpeg");
                                break;
                            }
                            case "pdf": {
                                response.setContentType("application/pdf");
                                break;
                            }
                            default: {
                                response.setContentType("application/octet-stream");
                            }
                        }
                    }
                    out = new BufferedOutputStream((OutputStream)response.getOutputStream());
                    out.write(buffer);
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
                finally {
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e) {
                            log.error("", (Throwable)e);
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            log.error("", (Throwable)e);
                        }
                    }
                }
            }
        } else {
            throw new BusinessException("\u65e0\u6cd5\u4e0b\u8f7d\u5176\u4ed6\u76ee\u5f55\u7684\u6587\u4ef6");
        }
    }
}

