/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.commom.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.utils.JsonPropertyUtil;
import com.biz.eisp.commom.service.CommonWebserviceService;
import com.biz.eisp.commom.service.DoBusiness;
import com.biz.eisp.config.SpringApplicationContextUtil;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.thread.ThreadLocalUtil;
import com.biz.eisp.webservce.WebserveCallHead;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jws.WebService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
@WebService
public class CommonWebserviceServiceImpl
implements CommonWebserviceService {
    private static final Logger log = LoggerFactory.getLogger(CommonWebserviceServiceImpl.class);
    @Autowired
    private RedisService redisService;
    private static Map<String, DoBusiness> businessMap = new HashMap<String, DoBusiness>();
    @Value(value="${webservices.token:123456}")
    private String webserviceToken;
    @Value(value="${webservices.username:admin}")
    private String username;

    private WebserveCallHead check(WebserveCallHead webserveCallHead, String token, String method, String uuid) {
        String status = "E";
        if (StringUtil.isBlank((CharSequence)token) || StringUtil.isBlank((CharSequence)method) || StringUtil.isBlank((CharSequence)uuid)) {
            webserveCallHead.setStatus(status);
            webserveCallHead.setMsg("\u53c2\u6570\u4f20\u5165\u4e0d\u5168");
            return webserveCallHead;
        }
        if (!this.webserviceToken.equals(token)) {
            webserveCallHead.setStatus(status);
            webserveCallHead.setMsg("\u6ca1\u6709\u8ba4\u8bc1\u6743\u9650");
            return webserveCallHead;
        }
        if (!businessMap.containsKey(method)) {
            ApplicationContext applicationContext = SpringApplicationContextUtil.getApplicationContext();
            if (!applicationContext.containsBean(method)) {
                webserveCallHead.setStatus(status);
                webserveCallHead.setMsg(method + "\u65b9\u6cd5\u4e0d\u5b58\u5728\u6216\u8005\u672a\u542f\u7528");
                return webserveCallHead;
            }
            Object object = applicationContext.getBean(method);
            if (object == null) {
                webserveCallHead.setStatus(status);
                webserveCallHead.setMsg(method + "\u65b9\u6cd5\u4e0d\u5b58\u5728\u6216\u8005\u672a\u542f\u7528");
                return webserveCallHead;
            }
            DoBusiness doBusiness = (DoBusiness)object;
            businessMap.put(method, doBusiness);
        }
        return webserveCallHead;
    }

    @Override
    public String crmWebservice(String json) {
        log.info("webservice\u4f20\u5165\u503c:" + json);
        WebserveCallHead webserveCallHead = new WebserveCallHead();
        if (StringUtil.isBlank((CharSequence)json)) {
            webserveCallHead.setStatus("E");
            webserveCallHead.setMsg("\u53c2\u6570\u9519\u8bef");
            return JSONObject.toJSONString((Object)webserveCallHead);
        }
        webserveCallHead.setStatus("S");
        try {
            String token = "";
            String method = "";
            String uuid = "";
            WebserveCallHead vo = (WebserveCallHead)JsonPropertyUtil.toObject((String)json, WebserveCallHead.class);
            if (StringUtil.isBlank((CharSequence)vo.getToken())) {
                JSONObject object = JSONObject.parseObject((String)json);
                token = object.get((Object)"TOKEN") == null ? "" : object.get((Object)"TOKEN").toString();
                method = object.get((Object)"METHOD") == null ? "" : object.get((Object)"METHOD").toString();
                uuid = object.get((Object)"UUID") == null ? "" : object.get((Object)"UUID").toString();
            } else {
                token = vo.getToken();
                method = vo.getMethod();
                uuid = vo.getUuid();
            }
            this.check(webserveCallHead, token, method, uuid);
            if ("S".equals(webserveCallHead.getStatus())) {
                ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
                map.put("loginUserToken", token);
                ThreadLocalUtil.stObj(map);
                UserRedis userRedis = new UserRedis();
                userRedis.setUsername(this.username);
                this.redisService.set("LOGIN_SUCCESS_" + token, (Object)JSONObject.toJSONString((Object)userRedis));
                webserveCallHead = businessMap.get(method).execute(webserveCallHead);
                webserveCallHead.setText("");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            webserveCallHead.setStatus("E");
            webserveCallHead.setMsg("\u7cfb\u7edf\u5f02\u5e38");
        }
        String jsonRetrun = JSONObject.toJSONString((Object)webserveCallHead);
        log.info("webservice\u8fd4\u56de\u503c:" + jsonRetrun);
        return jsonRetrun;
    }
}

