/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.service.impl;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessDefinitionDao;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaRRoleProcDefEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessDefinitionService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessDefinitionVo;
import com.biz.eisp.activiti.entity.activiti.ActHiProcinstEntity;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import java.util.List;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taProcessDefinitionService")
@Transactional
public class TaProcessDefinitionServiceImpl
extends BaseServiceImpl
implements TaProcessDefinitionService {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private TaProcessDefinitionDao taProcessDefinitionDao;

    @Override
    public List<TaProcessDefinitionVo> findProcessDefinitionList(TaProcessDefinitionVo taProcessDefinitionVo, Page page) {
        if (StringUtils.isBlank((CharSequence)taProcessDefinitionVo.getProcessDefinitionKey())) {
            throw new BusinessException("\u6ca1\u6709\u4f20\u9012\u6d41\u7a0b\u5b9a\u4e49key");
        }
        List<TaProcessDefinitionVo> voList = this.taProcessDefinitionDao.findProcessDefinitionList(taProcessDefinitionVo, page);
        return voList;
    }

    @Override
    public void deleteProcessDefinition(TaProcessDefinitionVo taProcessDefinitionVo) {
        String deploymentId = taProcessDefinitionVo.getDeploymentId();
        String processDefinitionKey = taProcessDefinitionVo.getProcessDefinitionKey();
        TaProcessEntity taProcessEntity = this.findUniqueByProperty(TaProcessEntity.class, "processKey", processDefinitionKey);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId).processDefinitionKey(processDefinitionKey).singleResult();
        List<ActHiProcinstEntity> actHiProcinsts = this.findByProperty(ActHiProcinstEntity.class, "procDefId", processDefinition.getId());
        if (actHiProcinsts.size() > 0) {
            throw new BusinessException("\u6d41\u7a0b\u8ddf\u4e1a\u52a1\u5df2\u5173\u8054\u65e0\u6cd5\u5220\u9664");
        }
        this.repositoryService.deleteDeployment(deploymentId, true);
        this.deleteTaRRoleDef(deploymentId);
        taProcessEntity.setProcessState(WorkFlowGlobals.PROCESS_DEPLOY_NO);
        this.updateEntity(taProcessEntity);
    }

    private void deleteTaRRoleDef(String deploymentId) {
        List<TaRRoleProcDefEntity> list = this.findByProperty(TaRRoleProcDefEntity.class, "deploymentId", deploymentId);
        this.deleteAllEntity(list);
    }
}

