/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.core.interceptors;

import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.mdm.authobj.util.AuthObjHandler;
import java.io.Serializable;
import java.util.Date;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;
import org.springframework.stereotype.Component;

@Component
public class HibernateEntityInterceptor
extends EmptyInterceptor {
    private static final long serialVersionUID = 1L;

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        int i = 0;
        while (i < propertyNames.length) {
            if ("createDate".equals(propertyNames[i])) {
                if (this.isEmpty(state[i])) {
                    state[i] = new Date();
                }
            } else if ("createName".equals(propertyNames[i])) {
                if (this.isEmpty(state[i])) {
                    state[i] = ResourceUtil.getCreateName();
                }
            } else if ("updateDate".equals(propertyNames[i])) {
                if (this.isEmpty(state[i])) {
                    state[i] = new Date();
                }
            } else if ("updateName".equals(propertyNames[i])) {
                if (this.isEmpty(state[i])) {
                    state[i] = ResourceUtil.getCreateName();
                }
            } else if ("createPosId".equals(propertyNames[i]) && this.isEmpty(state[i])) {
                state[i] = ResourceUtil.getCurrPosition().getId();
            }
            ++i;
        }
        return true;
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        int i = 0;
        while (i < propertyNames.length) {
            if ("updateDate".equals(propertyNames[i])) {
                currentState[i] = new Date();
            } else if ("updateName".equals(propertyNames[i])) {
                currentState[i] = ResourceUtil.getCreateName();
            } else if ("updatePosId".equals(propertyNames[i])) {
                currentState[i] = ResourceUtil.getCurrPosition().getId();
            }
            ++i;
        }
        return true;
    }

    public boolean isEmpty(Object object) {
        return object == null || object.equals("") || object.equals("null");
    }

    public String onPrepareStatement(String sql) {
        return AuthObjHandler.executeAuthHandle(sql);
    }
}

