/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.exporter;

import com.biz.eisp.base.exporter.annotation.Excel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public final class ExcelUtil {
    private ExcelUtil() {
    }

    public static void createExcel(String excel_name, String[] headList, String[] fieldList, List<Map<String, Object>> dataList) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet();
        HSSFRow row = sheet.createRow(0);
        int i = 0;
        while (i < headList.length) {
            HSSFCell cell = row.createCell(i);
            cell.setCellType(1);
            cell.setCellValue(headList[i]);
            ++i;
        }
        int n = 0;
        while (n < dataList.size()) {
            HSSFRow row_value = sheet.createRow(n + 1);
            Map<String, Object> dataMap = dataList.get(n);
            int i2 = 0;
            while (i2 < fieldList.length) {
                HSSFCell cell = row_value.createCell(i2);
                cell.setCellType(1);
                cell.setCellValue(ExcelUtil.objToString(dataMap.get(fieldList[i2])));
                ++i2;
            }
            ++n;
        }
        FileOutputStream fOut = new FileOutputStream(excel_name);
        workbook.write((OutputStream)fOut);
        fOut.flush();
        fOut.close();
    }

    public static void createExcel(String excel_name, List<String> headList, List<String> fieldList, List<Map<String, Object>> dataList) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet();
        HSSFRow row = sheet.createRow(0);
        int i = 0;
        while (i < headList.size()) {
            HSSFCell cell = row.createCell(i);
            cell.setCellType(1);
            cell.setCellValue(headList.get(i));
            ++i;
        }
        int n = 0;
        while (n < dataList.size()) {
            HSSFRow row_value = sheet.createRow(n + 1);
            Map<String, Object> dataMap = dataList.get(n);
            int i2 = 0;
            while (i2 < fieldList.size()) {
                HSSFCell cell = row_value.createCell(i2);
                cell.setCellType(1);
                cell.setCellValue(ExcelUtil.objToString(dataMap.get(fieldList.get(i2))));
                ++i2;
            }
            ++n;
        }
        FileOutputStream fOut = new FileOutputStream(excel_name);
        workbook.write((OutputStream)fOut);
        fOut.flush();
        fOut.close();
    }

    public static HSSFWorkbook createExcel(List<String> headList, List<String> fieldList, List<Map<String, Object>> dataList) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet();
        HSSFRow row = sheet.createRow(0);
        int i = 0;
        while (i < headList.size()) {
            HSSFCell cell = row.createCell(i);
            cell.setCellType(1);
            cell.setCellValue(headList.get(i));
            ++i;
        }
        int n = 0;
        while (n < dataList.size()) {
            HSSFRow row_value = sheet.createRow(n + 1);
            Map<String, Object> dataMap = dataList.get(n);
            int i2 = 0;
            while (i2 < fieldList.size()) {
                HSSFCell cell = row_value.createCell(i2);
                cell.setCellType(1);
                cell.setCellValue(ExcelUtil.objToString(dataMap.get(fieldList.get(i2))));
                ++i2;
            }
            ++n;
        }
        return workbook;
    }

    private static String objToString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Date) {
            return null;
        }
        return obj.toString();
    }

    public static void bulidExcel(String excel_name, String[] headList, List<String[]> valueList) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet();
        HSSFRow row = sheet.createRow(0);
        int i = 0;
        while (i < headList.length) {
            HSSFCell cell = row.createCell(i);
            cell.setCellType(1);
            cell.setCellValue(headList[i]);
            ++i;
        }
        int n = 0;
        while (n < valueList.size()) {
            HSSFRow row_value = sheet.createRow(n + 1);
            String[] valueArray = valueList.get(n);
            int i2 = 0;
            while (i2 < valueArray.length) {
                HSSFCell cell = row_value.createCell(i2);
                cell.setCellType(1);
                cell.setCellValue(valueArray[i2]);
                ++i2;
            }
            ++n;
        }
        FileOutputStream fOut = new FileOutputStream(excel_name);
        workbook.write((OutputStream)fOut);
        fOut.flush();
        fOut.close();
    }

    public static List<String[]> readExcel(String excel_name) throws Exception {
        ArrayList<String[]> list = new ArrayList<String[]>();
        HSSFWorkbook hssfworkbook = new HSSFWorkbook((InputStream)new FileInputStream(excel_name));
        HSSFSheet hssfsheet = hssfworkbook.getSheetAt(0);
        int j = 0;
        while (j < hssfsheet.getPhysicalNumberOfRows()) {
            HSSFRow hssfrow = hssfsheet.getRow(j);
            if (hssfrow != null) {
                int col = hssfrow.getPhysicalNumberOfCells();
                String[] arrayString = new String[col];
                int i = 0;
                while (i < col) {
                    HSSFCell cell = hssfrow.getCell(i);
                    if (cell == null) {
                        arrayString[i] = "";
                    } else if (cell.getCellType() == 0) {
                        if (cell.getCellType() == 0) {
                            if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                                Date d = cell.getDateCellValue();
                                SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                arrayString[i] = formater.format(d);
                            } else {
                                arrayString[i] = String.valueOf(new BigDecimal(cell.getNumericCellValue()).longValue());
                            }
                        }
                    } else {
                        arrayString[i] = cell.getStringCellValue().trim();
                    }
                    ++i;
                }
                list.add(arrayString);
            }
            ++j;
        }
        return list;
    }

    public static List<List<Object>> readExcelByList(String excel_name) throws Exception {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        HSSFWorkbook hssfworkbook = new HSSFWorkbook((InputStream)new FileInputStream(excel_name));
        HSSFSheet hssfsheet = hssfworkbook.getSheetAt(0);
        int j = 0;
        while (j < hssfsheet.getPhysicalNumberOfRows()) {
            HSSFRow hssfrow = hssfsheet.getRow(j);
            if (hssfrow != null) {
                int col = hssfrow.getPhysicalNumberOfCells();
                ArrayList<String> arrayString = new ArrayList<String>();
                int i = 0;
                while (i < col) {
                    HSSFCell cell = hssfrow.getCell(i);
                    if (cell == null) {
                        arrayString.add("");
                    } else if (cell.getCellType() == 0) {
                        arrayString.add(new Double(cell.getNumericCellValue()).toString());
                    } else {
                        arrayString.add(cell.getStringCellValue().trim());
                    }
                    ++i;
                }
                list.add(arrayString);
            }
            ++j;
        }
        return list;
    }

    public static List<List<Object>> readExcelByInputStream(InputStream inputstream) throws Exception {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        HSSFWorkbook hssfworkbook = new HSSFWorkbook(inputstream);
        HSSFSheet hssfsheet = hssfworkbook.getSheetAt(0);
        int j = 0;
        while (j < hssfsheet.getPhysicalNumberOfRows()) {
            HSSFRow hssfrow = hssfsheet.getRow(j);
            if (hssfrow != null) {
                int col = hssfrow.getPhysicalNumberOfCells();
                ArrayList<String> arrayString = new ArrayList<String>();
                int i = 0;
                while (i < col) {
                    HSSFCell cell = hssfrow.getCell(i);
                    if (cell == null) {
                        arrayString.add("");
                    } else if (cell.getCellType() == 0) {
                        arrayString.add(new Double(cell.getNumericCellValue()).toString());
                    } else {
                        arrayString.add(cell.getStringCellValue().trim());
                    }
                    ++i;
                }
                list.add(arrayString);
            }
            ++j;
        }
        return list;
    }

    @Deprecated
    public static Collection importExcel(File file, Class pojoClass) {
        try {
            FileInputStream in = new FileInputStream(file);
            return ExcelUtil.importExcelByIs(in, pojoClass);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static Collection importExcelByIs(InputStream inputstream, Class pojoClass) {
        ArrayList dist = new ArrayList();
        try {
            Field[] filed = pojoClass.getDeclaredFields();
            HashMap<String, Method> fieldSetMap = new HashMap<String, Method>();
            HashMap<String, Method> fieldSetConvertMap = new HashMap<String, Method>();
            int i = 0;
            while (i < filed.length) {
                Field f = filed[i];
                Excel excel = f.getAnnotation(Excel.class);
                if (excel != null) {
                    String fieldname = f.getName();
                    String setMethodName = "set" + fieldname.substring(0, 1).toUpperCase() + fieldname.substring(1);
                    Method setMethod = pojoClass.getMethod(setMethodName, f.getType());
                    fieldSetMap.put(excel.exportName(), setMethod);
                    if (excel.importConvertSign() == 1) {
                        StringBuffer setConvertMethodName = new StringBuffer("convertSet");
                        setConvertMethodName.append(fieldname.substring(0, 1).toUpperCase());
                        setConvertMethodName.append(fieldname.substring(1));
                        Method getConvertMethod = pojoClass.getMethod(setConvertMethodName.toString(), String.class);
                        fieldSetConvertMap.put(excel.exportName(), getConvertMethod);
                    }
                }
                ++i;
            }
            HSSFWorkbook book = new HSSFWorkbook(inputstream);
            HSSFSheet sheet = book.getSheetAt(0);
            Iterator row = sheet.rowIterator();
            Row title = (Row)row.next();
            Iterator cellTitle = title.cellIterator();
            HashMap<Integer, String> titlemap = new HashMap<Integer, String>();
            int i2 = 0;
            while (cellTitle.hasNext()) {
                Cell cell = (Cell)cellTitle.next();
                String value = cell.getStringCellValue();
                titlemap.put(i2, value);
                ++i2;
            }
            while (row.hasNext()) {
                Row rown = (Row)row.next();
                Iterator cellbody = rown.cellIterator();
                Object tObject = pojoClass.newInstance();
                int k = 0;
                while (cellbody.hasNext()) {
                    Cell cell = (Cell)cellbody.next();
                    String titleString = (String)titlemap.get(k);
                    if (fieldSetMap.containsKey(titleString)) {
                        Method setMethod = (Method)fieldSetMap.get(titleString);
                        Type[] ts = setMethod.getGenericParameterTypes();
                        String xclass = ts[0].toString();
                        if (1 == cell.getCellType() && fieldSetConvertMap.containsKey(titleString)) {
                            ((Method)fieldSetConvertMap.get(titleString)).invoke(tObject, cell.getStringCellValue());
                        } else if (xclass.equals("class java.lang.String")) {
                            cell.setCellType(1);
                            setMethod.invoke(tObject, cell.getStringCellValue());
                        } else if (xclass.equals("class java.util.Date")) {
                            Date cellDate = null;
                            cellDate = cell.getCellType() == 0 ? cell.getDateCellValue() : ExcelUtil.stringToDate(cell.getStringCellValue());
                            setMethod.invoke(tObject, cellDate);
                        } else if (xclass.equals("class java.lang.Boolean")) {
                            boolean valBool = 4 == cell.getCellType() ? cell.getBooleanCellValue() : cell.getStringCellValue().equalsIgnoreCase("true") || !cell.getStringCellValue().equals("0");
                            setMethod.invoke(tObject, valBool);
                        } else if (xclass.equals("class java.lang.Integer")) {
                            Integer valInt = cell.getCellType() == 0 ? Integer.valueOf(new Double(cell.getNumericCellValue()).intValue()) : new Integer(cell.getStringCellValue());
                            setMethod.invoke(tObject, valInt);
                        } else if (xclass.equals("class java.lang.Long")) {
                            Long valLong = cell.getCellType() == 0 ? Long.valueOf(new Double(cell.getNumericCellValue()).longValue()) : new Long(cell.getStringCellValue());
                            setMethod.invoke(tObject, valLong);
                        } else if (xclass.equals("class java.math.BigDecimal")) {
                            BigDecimal valDecimal = cell.getCellType() == 0 ? new BigDecimal(cell.getNumericCellValue()) : new BigDecimal(cell.getStringCellValue());
                            setMethod.invoke(tObject, valDecimal);
                        }
                    }
                    ++k;
                }
                dist.add(tObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return dist;
    }

    private static Date stringToDate(String cellValue) {
        if (cellValue.length() > 19) {
            cellValue = cellValue.substring(0, 19);
        }
        Calendar calendar = Calendar.getInstance();
        String[] dateStr = cellValue.split(" ");
        String[] dateInfo = dateStr[0].split("-");
        if (dateInfo.length != 3) {
            dateInfo = dateStr[0].split("/");
        }
        if (dateInfo.length != 3) {
            return null;
        }
        int year = Integer.parseInt(dateInfo[0]);
        int month = Integer.parseInt(dateInfo[1]) - 1;
        int day = Integer.parseInt(dateInfo[2]);
        calendar.set(year, month, day);
        if (dateStr.length > 1) {
            String[] timeStr = dateStr[1].split(":");
            if (timeStr.length == 3) {
                int hour = Integer.parseInt(timeStr[0]);
                int minute = Integer.parseInt(timeStr[1]);
                int second = Integer.parseInt(timeStr[2]);
                calendar.set(11, hour);
                calendar.set(12, minute);
                calendar.set(13, second);
            } else {
                return null;
            }
        }
        return calendar.getTime();
    }
}

