/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.importer;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.dao.HibernatePersister;
import com.biz.eisp.base.importer.AbstractHibernateImporter;
import com.biz.eisp.base.importer.DataField;
import com.biz.eisp.base.importer.ImpConfigurator;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.importer.validator.ValidatorFactory;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import java.util.List;
import java.util.Map;

public abstract class ImpEventHandler<T> {
    private AbstractHibernateImporter importer;
    private ImpConfigurator conf;
    private HibernatePersister persister;
    private Map<String, Object> params;
    private int index;
    private int rowNumber;
    protected String tableName = null;

    public final void init(ImpConfigurator conf, HibernatePersister persister, Map<String, Object> params, String tableName) {
        this.conf = conf;
        this.persister = persister;
        this.params = params;
        this.tableName = tableName;
    }

    protected void persisterBean(Object bean, boolean isSkip) {
        if (this.importer.errNum == 0 && !isSkip && bean != null) {
            ++this.importer.succNum;
            this.importer.save(bean);
        }
    }

    public final void setImporter(AbstractHibernateImporter imp) {
        this.importer = imp;
    }

    public final void addMessage(String message, String onError) {
        this.importer.addMessage(message, onError);
    }

    public final void addMessage(String message, String onError, Map<String, String> row, DataField field) {
        this.importer.addMessage(message, onError, row, field);
    }

    public final void addError(String error) throws ValidateException {
        this.importer.addError(error);
    }

    public final void addError(String error, Map<String, String> row, DataField field) throws ValidateException {
        this.importer.addError(error, row, field);
    }

    public void start() {
    }

    public void startRow(Map<String, String> row) throws ValidateException {
    }

    public void validate(Map<String, String> row) throws ValidateException {
        if (StringUtil.isNotEmpty((String)this.tableName)) {
            this.validateDynamicImp(row);
        }
    }

    public void validateDynamicImp(Map<String, String> row) throws ValidateException {
        List<TmMdmTableConfigEntity> list = DynamicConfigUtil.allTableConfigImpColumn.get(this.tableName.toUpperCase());
        for (TmMdmTableConfigEntity tableConfig : list) {
            String fieldValue;
            String errorMsg = ValidatorFactory.validateDynamicImplData(tableConfig, fieldValue = row.get(tableConfig.getField()));
            if (!StringUtil.isNotEmpty((String)errorMsg)) continue;
            this.addError("\u7b2c" + this.getRowNumber() + "\u884c:" + errorMsg);
        }
    }

    public void endRow(Map<String, String> row, T bean) throws ValidateException {
    }

    public void error(DataField field, Map<String, String> row, Exception e) {
    }

    public void fatalError(Exception e) {
    }

    public void end() {
    }

    public final ImpConfigurator getConf() {
        return this.conf;
    }

    public final Map<String, Object> getParams() {
        return this.params;
    }

    public final HibernatePersister getPersister() {
        return this.persister;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int index) {
        this.index = index;
    }

    public final int getRowNumber() {
        return this.rowNumber;
    }

    public final void setRowNumber(int rowNumber) {
        this.rowNumber = rowNumber;
    }

    public int getErrNum() {
        return this.importer.errNum;
    }

    public void setSuccNum(int succNum) {
        this.importer.succNum = succNum;
    }

    public int getSuccNum() {
        return this.importer.succNum;
    }

    public String getBatchCode() {
        return this.importer.getBatchCode();
    }
}

