/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.utils;

import java.beans.PropertyEditorSupport;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.springframework.util.StringUtils;

public class DateUtils
extends PropertyEditorSupport {
    public static final SimpleDateFormat date_sdf_yyyy_m = new SimpleDateFormat("yyyy-M");
    public static final SimpleDateFormat date_sdf = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat date_sdf_2 = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyyMMdd");
    public static final SimpleDateFormat yyyyM = new SimpleDateFormat("yyyyM");
    public static final SimpleDateFormat yyyyMM = new SimpleDateFormat("yyyyMM");
    public static final SimpleDateFormat yyyy_MM = new SimpleDateFormat("yyyy-MM");
    public static final SimpleDateFormat date_sdf_wz = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
    public static final SimpleDateFormat time_sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static final SimpleDateFormat yyyymmddhhmmss = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final SimpleDateFormat short_time_sdf = new SimpleDateFormat("HH:mm:ss");
    public static final SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final long DAY_IN_MILLIS = 86400000L;
    private static final long HOUR_IN_MILLIS = 3600000L;
    private static final long MINUTE_IN_MILLIS = 60000L;
    private static final long SECOND_IN_MILLIS = 1000L;
    public static final int MINIMAL_DAYS_IN_FIRSTWEEK = 4;
    public static final int FIRST_DAY_OF_WEEK = 2;

    public static String getYYYYM(Date date) {
        return yyyyM.format(date);
    }

    public static String getYYYYMMDD() {
        return date_sdf.format(new Date());
    }

    public static String getYYYYMMDD(Date date) {
        return date_sdf.format(date);
    }

    public static Date getDateYYYYMMDD(String date) {
        try {
            return date_sdf.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getDateYYYYMD(String date) throws ParseException {
        return date_sdf_2.parse(date);
    }

    private static SimpleDateFormat getSDFormat(String pattern) {
        return new SimpleDateFormat(pattern);
    }

    public static Calendar getCalendar() {
        return Calendar.getInstance();
    }

    public static Calendar getCalendar(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(millis));
        return cal;
    }

    public static Date getDate() {
        return new Date();
    }

    public static Date getDate(long millis) {
        return new Date(millis);
    }

    public static String timestamptoStr(Timestamp time) {
        Date date = null;
        if (time != null) {
            date = new Date(time.getTime());
        }
        return DateUtils.date2Str(date_sdf);
    }

    public static Timestamp str2Timestamp(String str) {
        Date date = DateUtils.str2Date(str, date_sdf);
        return new Timestamp(date.getTime());
    }

    public static Date str2Date(String str, SimpleDateFormat sdf) {
        if (str == null || "".equals(str)) {
            return null;
        }
        Date date = null;
        try {
            date = sdf.parse(str);
            return date;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getMonthSpace(String date1, String date2, String format) throws ParseException {
        int result = 0;
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(sdf.parse(date1));
        c2.setTime(sdf.parse(date2));
        result = (c1.get(1) - c2.get(1)) * 12 + c1.get(2) - c2.get(2);
        return result == 0 ? 1 : Math.abs(result);
    }

    public static String date2Str(SimpleDateFormat date_sdf) {
        Date date = DateUtils.getDate();
        if (date == null) {
            return null;
        }
        return date_sdf.format(date);
    }

    public static String dateNow2Str() {
        return DateUtils.date2Str(date_sdf);
    }

    public static String dateformat(String date, String format) {
        SimpleDateFormat sformat = new SimpleDateFormat(format);
        Date _date = null;
        try {
            _date = sformat.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return sformat.format(_date);
    }

    public static String date2Str(Date date, SimpleDateFormat date_sdf) {
        if (date == null) {
            return null;
        }
        return date_sdf.format(date);
    }

    public static String getDate(String format) {
        Date date = new Date();
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static Date getDate(SimpleDateFormat format) {
        Date date = new Date();
        String nowDate = format.format(date);
        try {
            return format.parse(nowDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Timestamp getTimestamp(long millis) {
        return new Timestamp(millis);
    }

    public static Timestamp getTimestamp(String time) {
        return new Timestamp(Long.parseLong(time));
    }

    public static Timestamp getTimestamp() {
        return new Timestamp(new Date().getTime());
    }

    public static Timestamp getTimestamp(Date date) {
        return new Timestamp(date.getTime());
    }

    public static Timestamp getCalendarTimestamp(Calendar cal) {
        return new Timestamp(cal.getTime().getTime());
    }

    public static Timestamp gettimestamp() {
        Date dt = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String nowTime = df.format(dt);
        Timestamp buydate = Timestamp.valueOf(nowTime);
        return buydate;
    }

    public static Timestamp getDateTimestamp() {
        Date dt = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String nowTime = df.format(dt);
        return DateUtils.str2Timestamp(nowTime);
    }

    public static long getMillis() {
        return new Date().getTime();
    }

    public static long getMillis(Calendar cal) {
        return cal.getTime().getTime();
    }

    public static long getMillis(Date date) {
        return date.getTime();
    }

    public static long getMillis(Timestamp ts) {
        return ts.getTime();
    }

    public static String formatDate() {
        return date_sdf.format(DateUtils.getCalendar().getTime());
    }

    public static String getDataString(SimpleDateFormat formatstr) {
        return formatstr.format(DateUtils.getCalendar().getTime());
    }

    public static String formatDate(Calendar cal) {
        return date_sdf.format(cal.getTime());
    }

    public static String formatDate(Date date) {
        return date_sdf.format(date);
    }

    public static String formatDate(long millis) {
        return date_sdf.format(new Date(millis));
    }

    public static String formatDate(String pattern) {
        return DateUtils.getSDFormat(pattern).format(DateUtils.getCalendar().getTime());
    }

    public static String formatDate(Calendar cal, String pattern) {
        return DateUtils.getSDFormat(pattern).format(cal.getTime());
    }

    public static String formatDate(Date date, String pattern) {
        return DateUtils.getSDFormat(pattern).format(date);
    }

    public static String formatTime() {
        return time_sdf.format(DateUtils.getCalendar().getTime());
    }

    public static String formatTime(long millis) {
        return time_sdf.format(new Date(millis));
    }

    public static String formatTime(Calendar cal) {
        return time_sdf.format(cal.getTime());
    }

    public static String formatTime(Date date) {
        return time_sdf.format(date);
    }

    public static String formatShortTime() {
        return short_time_sdf.format(DateUtils.getCalendar().getTime());
    }

    public static String formatShortTime(long millis) {
        return short_time_sdf.format(new Date(millis));
    }

    public static String formatShortTime(Calendar cal) {
        return short_time_sdf.format(cal.getTime());
    }

    public static String formatShortTime(Date date) {
        return short_time_sdf.format(date);
    }

    public static Date parseDate(String src, String pattern) throws ParseException {
        return DateUtils.getSDFormat(pattern).parse(src);
    }

    public static Calendar parseCalendar(String src, String pattern) throws ParseException {
        Date date = DateUtils.parseDate(src, pattern);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static String formatAddDate(String src, String pattern, int amount) throws ParseException {
        Calendar cal = DateUtils.parseCalendar(src, pattern);
        cal.add(5, amount);
        return DateUtils.formatDate(cal);
    }

    public static String formatAddMonth(String src, String pattern, int month) throws ParseException {
        Calendar cal = DateUtils.parseCalendar(src, pattern);
        cal.add(2, month);
        return DateUtils.formatDate(cal);
    }

    public static Date formatAddMonth(Date src, int month) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(src);
        calendar.add(2, month);
        return calendar.getTime();
    }

    public static Timestamp parseTimestamp(String src, String pattern) throws ParseException {
        Date date = DateUtils.parseDate(src, pattern);
        return new Timestamp(date.getTime());
    }

    public static int dateDiff(char flag, Calendar calSrc, Calendar calDes) {
        long millisDiff = DateUtils.getMillis(calSrc) - DateUtils.getMillis(calDes);
        if (flag == 'y') {
            return calSrc.get(1) - calDes.get(1);
        }
        if (flag == 'd') {
            return (int)(millisDiff / 86400000L);
        }
        if (flag == 'h') {
            return (int)(millisDiff / 3600000L);
        }
        if (flag == 'm') {
            return (int)(millisDiff / 60000L);
        }
        if (flag == 's') {
            return (int)(millisDiff / 1000L);
        }
        return 0;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.hasText((String)text)) {
            try {
                if (text.indexOf(":") == -1 && text.length() == 10) {
                    this.setValue(date_sdf.parse(text));
                }
                if (text.indexOf(":") > 0 && text.length() == 19) {
                    this.setValue(datetimeFormat.parse(text));
                }
                throw new IllegalArgumentException("Could not parse date, date format is error ");
            }
            catch (ParseException ex) {
                IllegalArgumentException iae = new IllegalArgumentException("Could not parse date: " + ex.getMessage());
                iae.initCause(ex);
                throw iae;
            }
        } else {
            this.setValue(null);
        }
    }

    public static int getYear() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(DateUtils.getDate());
        return calendar.get(1);
    }

    public static long subtractDay(Date endDate, Date startDate) {
        return (endDate.getTime() - startDate.getTime()) / 86400000L;
    }

    public static Date ReturnTheDay(Date date, int i) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, i);
        return calendar.getTime();
    }

    public static String format(Date date, String pattern) {
        if (date != null) {
            try {
                return new SimpleDateFormat(pattern).format(date);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return "";
    }

    public static String format(Object value, String pattern) {
        if (value != null) {
            try {
                Date date = null;
                return new SimpleDateFormat(pattern).format(date);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return "";
    }

    public static Date getDateTime(String dateTime) {
        Date date = new Date();
        String datePart = DateUtils.format(date, "yyyy-MM-dd");
        String dateTimePart = String.valueOf(datePart) + " " + dateTime;
        Date newDate = DateUtils.parse(dateTimePart, "yyyy-MM-dd HH:mm");
        return newDate;
    }

    public static Date parse(String date, String pattern) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            sdf.setLenient(false);
            return sdf.parse(date);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Date getYesterdayByDate(String date, String pattern) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            sdf.setLenient(false);
            Date temp = sdf.parse(date);
            Calendar cal = Calendar.getInstance();
            cal.setTime(temp);
            cal.add(5, -1);
            return cal.getTime();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int getDaysOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, 1);
        return cal.getActualMaximum(5);
    }

    public static int getDaysOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.getActualMaximum(5);
    }

    public static int getDaysOfQuarter(int year, int quarter) {
        int firstMonth;
        Calendar cal = Calendar.getInstance();
        int days = 0;
        int i = firstMonth = (quarter - 1) * 3;
        while (i < firstMonth + 3) {
            cal.set(year, i, 1);
            days += cal.getActualMaximum(5);
            ++i;
        }
        return days;
    }

    public static int getDaysOfYear(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, 0, 1);
        return cal.getActualMaximum(6);
    }

    public static int getDaysOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.getActualMaximum(6);
    }

    public static Date getFirstDayOfWeek(int year, int week) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setMinimalDaysInFirstWeek(4);
        cal.set(year, 0, 1);
        int addDays = week * 7;
        if (cal.get(3) == 1) {
            addDays = (week - 1) * 7;
        }
        cal.add(5, addDays);
        cal.set(7, cal.getFirstDayOfWeek());
        return cal.getTime();
    }

    public static Date getFirstDayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setMinimalDaysInFirstWeek(4);
        cal.setTime(date);
        int dayOfWeek = cal.get(7);
        if (dayOfWeek == 1) {
            dayOfWeek = 8;
        }
        cal.setTimeInMillis(cal.getTimeInMillis() + (long)(2 - dayOfWeek) * 86400000L);
        return cal.getTime();
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.getActualMaximum(5));
        return cal.getTime();
    }

    public static Date getFirstDayOfLastMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(cal.getTimeInMillis() - (long)cal.get(5) * 86400000L);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getLastDayOfLastMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(cal.getTimeInMillis() - (long)cal.get(5) * 86400000L);
        return cal.getTime();
    }

    public static Date getFirstDayOfNextMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        cal.setTimeInMillis(cal.getTimeInMillis() + (long)cal.getActualMaximum(5) * 86400000L);
        return cal.getTime();
    }

    public static Date getLastDayOfNextMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(cal.getTimeInMillis() + (long)cal.getActualMaximum(5) * 86400000L);
        cal.set(5, 1);
        cal.setTimeInMillis(cal.getTimeInMillis() + (long)(cal.getActualMaximum(5) - 1) * 86400000L);
        return cal.getTime();
    }

    public static int getWeekOfDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setMinimalDaysInFirstWeek(4);
        cal.set(year, month - 1, day, 0, 0, 0);
        return cal.get(3);
    }

    public static int getDayOfDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day, 0, 0, 0);
        return cal.get(6);
    }

    public static Date getDate2() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date yesterday() {
        return new Date(System.currentTimeMillis() - 86400000L);
    }

    public static Date getEndDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2099);
        cal.set(2, 11);
        cal.set(5, 31);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date parseToDate(Object value) {
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof java.sql.Date) {
            return (Date)value;
        }
        return (Date)value;
    }

    public static Date getAppointDate(int calendarConstant, int appointNum) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(calendarConstant, appointNum);
        return calendar.getTime();
    }

    public static String calSpendTimes(String startTime, String endTime) {
        Date startTimeDateType = DateUtils.parse(startTime, "yyyy-MM-dd HH:mm:ss");
        Date endTimeDateType = null;
        if (endTime != null) {
            endTimeDateType = DateUtils.parse(endTime, "yyyy-MM-dd HH:mm:ss");
        }
        long totalTimes = endTime == null ? Calendar.getInstance().getTimeInMillis() - startTimeDateType.getTime() : endTimeDateType.getTime() - startTimeDateType.getTime();
        long dayCount = totalTimes / 86400000L;
        long restTimes = totalTimes % 86400000L;
        long hourCount = restTimes / 3600000L;
        long minuteCount = (restTimes %= 3600000L) / 60000L;
        String spendTimes = String.valueOf(dayCount) + "\u5929" + hourCount + "\u5c0f\u65f6" + minuteCount + "\u5206";
        return spendTimes;
    }
}

