/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.utils;

import com.biz.eisp.base.utils.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.FileWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class FreemarkerParseUtils {
    private static final Configuration _tplConfig = new Configuration();

    public FreemarkerParseUtils() {
        _tplConfig.setClassForTemplateLoading(this.getClass(), "/");
        _tplConfig.setNumberFormat("#");
    }

    public String parseTemplate(String tplName, String encoding, Map<String, Object> paras) {
        try {
            StringWriter swriter = new StringWriter();
            Template mytpl = _tplConfig.getTemplate(tplName, encoding);
            mytpl.process(paras, (Writer)swriter);
            return swriter.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.toString();
        }
    }

    public boolean isExistTemplate(String tplName) {
        try {
            Template mytpl = _tplConfig.getTemplate(tplName, "UTF-8");
            return mytpl != null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void parseTemplate(String tplName, String encoding, Map<String, Object> paras, FileWriter swriter) {
        try {
            Template mytpl = _tplConfig.getTemplate(tplName);
            mytpl.process(paras, (Writer)swriter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String parseTemplate(String tplName, Map<String, Object> paras) {
        return this.parseTemplate(tplName, "utf-8", paras);
    }

    public String parseTemplateContent(String tplContent, Map<String, Object> paras, String encoding) {
        Configuration cfg = new Configuration();
        StringWriter writer = new StringWriter();
        cfg.setTemplateLoader((TemplateLoader)new StringTemplateLoader(tplContent));
        encoding = encoding == null ? "UTF-8" : encoding;
        cfg.setDefaultEncoding(encoding);
        try {
            Template template = cfg.getTemplate("");
            template.process(paras, (Writer)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    public String parseTemplateContent(String tplContent, Map<String, Object> paras) {
        Configuration cfg = new Configuration();
        cfg = _tplConfig;
        StringWriter writer = new StringWriter();
        cfg.setTemplateLoader((TemplateLoader)new StringTemplateLoader(tplContent));
        cfg.setDefaultEncoding("UTF-8");
        try {
            Template template = cfg.getTemplate("");
            template.process(paras, (Writer)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    public String parseTemplateContentStringMap(String tplContent, Map<String, String> paras) {
        Configuration cfg = new Configuration();
        cfg = _tplConfig;
        StringWriter writer = new StringWriter();
        cfg.setTemplateLoader((TemplateLoader)new StringTemplateLoader(tplContent));
        cfg.setDefaultEncoding("UTF-8");
        try {
            Template template = cfg.getTemplate("");
            template.process(paras, (Writer)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return writer.toString();
    }
}

