/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.config.service.impl;

import com.biz.eisp.base.common.tag.bean.DataGridColumn;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.service.DynamicDataGridColumnService;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DefaultDynamicDataGridColumnServiceImpl
implements DynamicDataGridColumnService {
    @Override
    public List<DataGridColumn> findDataGridColumnList(List<TmMdmTableConfigEntity> tmMdmTableConfigList, boolean treegrid) {
        ArrayList<DataGridColumn> dataGridColumnList = new ArrayList<DataGridColumn>();
        if (CollectionUtil.listNotEmptyNotSizeZero(tmMdmTableConfigList)) {
            for (TmMdmTableConfigEntity entity : tmMdmTableConfigList) {
                List<DataGridColumn> dataGridColumn = this.buildDataGridColumn(entity, treegrid);
                if (!CollectionUtil.listNotEmptyNotSizeZero(dataGridColumn)) continue;
                dataGridColumnList.addAll(dataGridColumn);
            }
        }
        this.doOrderOpt(dataGridColumnList);
        return dataGridColumnList;
    }

    private List<DataGridColumn> buildDataGridColumn(TmMdmTableConfigEntity entity, boolean treegrid) {
        if (StringUtils.isBlank((CharSequence)entity.getFieldProperty())) {
            return null;
        }
        ArrayList<DataGridColumn> dataGridColumnList = new ArrayList<DataGridColumn>();
        String[] filedArr = entity.getFieldProperty().split(",");
        String[] fieldNameArr = StringUtils.isBlank((CharSequence)entity.getFieldName()) ? entity.getColumnDesc().split(",") : entity.getFieldName().split(",");
        String[] isHiddenArr = StringUtils.isBlank((CharSequence)entity.getIsHidden()) ? new String[fieldNameArr.length] : entity.getIsHidden().split(",");
        String[] formatArr = StringUtils.isBlank((CharSequence)entity.getFormat()) ? new String[fieldNameArr.length] : entity.getFormat().split(",");
        String[] formatUrlArr = StringUtils.isBlank((CharSequence)entity.getFormUrl()) ? new String[fieldNameArr.length] : entity.getFormUrl().split(",");
        String[] columnOrderArr = StringUtils.isBlank((CharSequence)entity.getColumnOrder()) ? new String[fieldNameArr.length] : entity.getColumnOrder().split(",");
        String[] queryStatusArr = StringUtils.isBlank((CharSequence)entity.getQueryStatus()) ? new String[fieldNameArr.length] : entity.getQueryStatus().split(",");
        String[] queryModeArr = StringUtils.isBlank((CharSequence)entity.getQueryMode()) ? new String[fieldNameArr.length] : entity.getQueryMode().split(",");
        String[] formTypeArr = StringUtils.isBlank((CharSequence)entity.getFormType()) ? new String[fieldNameArr.length] : entity.getFormType().split(",");
        String[] dictType = StringUtils.isBlank((CharSequence)entity.getDictType()) ? new String[fieldNameArr.length] : entity.getDictType().split(",");
        DataGridColumn dataGridColumn = null;
        int i = 0;
        while (i < fieldNameArr.length) {
            dataGridColumn = new DataGridColumn();
            Boolean hidden = false;
            if (isHiddenArr[i] != null && isHiddenArr[i].equals("1")) {
                hidden = true;
            }
            dataGridColumn.setHidden(hidden);
            if (treegrid) {
                dataGridColumn.setTreefield(filedArr[i]);
            }
            dataGridColumn.setField(filedArr[i]);
            Boolean queryStatus = false;
            if (queryStatusArr[i] != null && queryStatusArr[i].equals("1")) {
                queryStatus = true;
            }
            dataGridColumn.setQuery(queryStatus);
            dataGridColumn.setQueryMode(queryModeArr[i]);
            dataGridColumn.setFormatter(formatArr[i]);
            dataGridColumn.setTitle(fieldNameArr[i]);
            dataGridColumn.setDictionary(dictType[i]);
            dataGridColumn.setColumnOrder(Integer.parseInt(columnOrderArr[i]));
            dataGridColumn.setFormType(formTypeArr[i]);
            dataGridColumn.setFormUrl(formatUrlArr[i]);
            dataGridColumnList.add(dataGridColumn);
            ++i;
        }
        return dataGridColumnList;
    }

    private void doOrderOpt(List<DataGridColumn> dataGridColumnList) {
        Collections.sort(dataGridColumnList, (Comparator)new Comparator<DataGridColumn>(){

            @Override
            public int compare(DataGridColumn o1, DataGridColumn o2) {
                if (o1.getColumnOrder() > o2.getColumnOrder()) {
                    return 1;
                }
                return 0;
            }
        });
    }
}

