/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.dict.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.dict.entity.TmDictDataEntity;
import com.biz.eisp.mdm.dict.service.TmDictDataService;
import com.biz.eisp.mdm.dict.vo.DictTreeGrid;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tmDictDataController"})
public class TmDictDataController
extends BaseController {
    @Autowired
    private TmDictDataService tmDictDataService;

    @RequestMapping(params={"dictGrid"})
    @ResponseBody
    public List<DictTreeGrid> dictGrid(HttpServletRequest request, DictTreeGrid dictTreegrid) {
        return this.tmDictDataService.getDictsList(request, dictTreegrid);
    }

    @RequestMapping(params={"delete"})
    @ResponseBody
    public AjaxJson deleteDictData(HttpServletRequest request, String id) {
        String realId = id.split("_")[0];
        String type = id.split("_")[1];
        AjaxJson ajaxJson = new AjaxJson();
        if (type.equals("1")) {
            ajaxJson.setMsg("\u8bf7\u9009\u62e9\u6570\u636e\u5b57\u5178\u503c\u5220\u9664\uff01");
            return ajaxJson;
        }
        this.tmDictDataService.delete(realId);
        return ajaxJson;
    }

    @RequestMapping(params={"goSaveDictData"}, method={RequestMethod.GET})
    public ModelAndView goSaveDictData(HttpServletRequest req, HttpServletResponse response) {
        String id = req.getParameter("id");
        String dictTypeCode = req.getParameter("dictTypeCode");
        String realId = id.split("_")[0];
        String type = id.split("_")[1];
        DictTreeGrid dictgrid = new DictTreeGrid();
        if (type.equals("2")) {
            dictgrid.setParentId(realId);
        }
        dictgrid.setDictTypeCode(dictTypeCode);
        req.setAttribute("dictTreegrid", (Object)dictgrid);
        return new ModelAndView("com/biz/eisp/mdm/dict/dictDataForm");
    }

    @RequestMapping(params={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdateDictData(DictTreeGrid dictTreegrid, HttpServletRequest req, HttpServletResponse response) {
        this.tmDictDataService.saveAndUpdate(dictTreegrid);
        return new AjaxJson();
    }

    @RequestMapping(params={"goUpdateData"}, method={RequestMethod.GET})
    public ModelAndView goUpdateData(DictTreeGrid dictTreegrid, HttpServletRequest req, HttpServletResponse response) {
        TmDictDataEntity t = this.tmDictDataService.get(dictTreegrid.getId().split("_")[0]);
        DictTreeGrid dictgrid = new DictTreeGrid(t);
        req.setAttribute("dictTreegrid", (Object)dictgrid);
        return new ModelAndView("com/biz/eisp/mdm/dict/dictDataForm");
    }

    @RequestMapping(params={"validateDataCode"})
    @ResponseBody
    public ValidForm validateDataCode(DictTreeGrid dictTreegrid, HttpServletRequest request) {
        String param = OConvertUtils.getString(request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        SimpleExpression cr1 = Restrictions.eq((String)"tmDictType.dictTypeCode", (Object)dictTreegrid.getDictTypeCode());
        SimpleExpression cr2 = Restrictions.eq((String)"dictCode", (Object)param);
        if (StringUtil.isNotEmpty((String)dictTreegrid.getId())) {
            SimpleExpression cr3 = Restrictions.ne((String)"id", (Object)dictTreegrid.getId().split("_")[0]);
            List<TmDictDataEntity> dicts = this.tmDictDataService.findByCriteria(TmDictDataEntity.class, new Criterion[]{cr1, cr2, cr3});
            if (!CollectionUtils.isEmpty(dicts)) {
                validForm.setStatus("n");
                validForm.setInfo("\u6570\u636e\u5b57\u5178\u503c\u7f16\u7801\u5df2\u5b58\u5728");
            }
        } else {
            List<TmDictDataEntity> dicts = this.tmDictDataService.findByCriteria(TmDictDataEntity.class, new Criterion[]{cr1, cr2});
            if (!CollectionUtils.isEmpty(dicts)) {
                validForm.setStatus("n");
                validForm.setInfo("\u6570\u636e\u5b57\u5178\u503c\u7f16\u7801\u5df2\u5b58\u5728");
            }
        }
        return validForm;
    }
}

