/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.position.service.impl;

import com.biz.eisp.activiti.entity.activiti.ActIdUserEntity;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.actrole.entity.TmActRoleEntity;
import com.biz.eisp.mdm.actrole.entity.TmRPositionActRoleEntity;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
import com.biz.eisp.mdm.position.dao.TmPositionDao;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.entity.TmRPositionRoleEntity;
import com.biz.eisp.mdm.position.service.TmPositionExtendService;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.position.transformer.TmPositionEntityToTmPositionVo;
import com.biz.eisp.mdm.position.transformer.TmPositionVoToTmPositionEntity;
import com.biz.eisp.mdm.position.vo.QueryTmpositionVo;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.entity.TmUserPositionEntity;
import com.biz.eisp.mdm.web.pojo.ClientManager;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tmPositionService")
@Transactional
public class TmPositionServiceImpl
extends BaseServiceImpl
implements TmPositionService {
    @Autowired
    private TmPositionDao tmPositionDao;
    @Autowired(required=false)
    private TmPositionExtendService tmPositionExtendService;

    @Override
    public List<TmPositionVo> findTmPositionList(TmPositionVo tmPositionVo, Page page) {
        String sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_POSITION, tmPositionVo);
        List<TmPositionVo> voList = this.tmPositionDao.findTmPositionList(tmPositionVo, page, sql = this.appendPositionCondition(sql, tmPositionVo));
        if (!CollectionUtils.isEmpty(voList)) {
            for (TmPositionVo tmPositionVo2 : voList) {
                this.HandleRoleName(tmPositionVo2);
            }
        }
        return voList;
    }

    public String appendPositionCondition(String sql, Object paramObj) {
        TmPositionVo tmPositionVo = new TmPositionVo();
        if (paramObj != null) {
            tmPositionVo = (TmPositionVo)paramObj;
        }
        String isRoleSerchSql = "";
        if (StringUtil.isNotBlank((String)tmPositionVo.getRoleIds())) {
            isRoleSerchSql = ",trpr.role_id";
        }
        String joinSql = "select p.id newId,o.org_name,o.id org_id, tmo.org_name AS parentOrgName,pp.position_code AS parentCode " + isRoleSerchSql;
        if (StringUtil.isNotEmpty((String)tmPositionVo.getFullName()) || StringUtil.isNotEmpty((String)tmPositionVo.getFullName()) || StringUtil.isNotEmpty((String)tmPositionVo.getParentUserName()) || StringUtil.isNotEmpty((String)tmPositionVo.getUserId()) || StringUtil.isNotBlank((String)tmPositionVo.getRoleIds())) {
            joinSql = String.valueOf(joinSql) + " ,trup.is_main AS isMain,trup.user_id,tu.username AS userName,tu.fullname AS fullName, ptu.fullname AS parentUserName,trup.id AS tmRPositionUserId ";
        }
        joinSql = String.valueOf(joinSql) + " FROM tm_position p LEFT JOIN tm_org o ON o.id = p.org_id LEFT JOIN tm_r_user_position trup ON trup.position_id=p.id LEFT JOIN tm_user tu ON tu.id = trup.user_id LEFT JOIN tm_position pp ON pp.id = p.parent_id LEFT JOIN tm_org tmo ON pp.org_id = tmo.id LEFT JOIN tm_r_user_position ptup ON pp.id=ptup.position_id LEFT JOIN tm_user ptu ON ptu.id=ptup.user_id";
        String onSql = "t1.newId=t.id";
        String sqlWhere = "";
        if (StringUtil.isNotEmpty((String)tmPositionVo.getId())) {
            sql = String.valueOf(sql) + " and t.id='" + tmPositionVo.getId() + "'";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getCurentOrg()) && StringUtil.isEmpty(tmPositionVo.getId())) {
            ClientManager manager = ClientManager.getInstance();
            String posId = manager.getCurrentPosId();
            sql = String.valueOf(sql) + " and t.id <>'" + posId + "'";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getFlag())) {
            String excludeId = StringUtil.isNotEmpty((String)tmPositionVo.getExcludeId()) ? tmPositionVo.getExcludeId() : "'-1'";
            sqlWhere = String.valueOf(sqlWhere) + " AND t.id not in (select position_id from tm_r_user_position WHERE user_id is not null AND position_id<>" + excludeId + ")";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getNotInId())) {
            sqlWhere = String.valueOf(sqlWhere) + " AND t.id not in (" + tmPositionVo.getNotInId() + ")";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getRoleIds())) {
            joinSql = String.valueOf(joinSql) + " LEFT JOIN tm_r_position_role trpr ON p.id=trpr.position_id";
            sqlWhere = String.valueOf(sqlWhere) + " AND t1.role_id ='" + tmPositionVo.getRoleIds() + "'";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getParentUserName())) {
            sqlWhere = String.valueOf(sqlWhere) + " AND t1.parentUserName like '%" + tmPositionVo.getParentUserName() + "%'";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getFullName())) {
            sqlWhere = String.valueOf(sqlWhere) + "AND t1.fullname like '%" + tmPositionVo.getFullName() + "%'";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getUserId())) {
            sqlWhere = String.valueOf(sqlWhere) + " AND t1.user_id ='" + tmPositionVo.getUserId() + "'";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getCurentOrg())) {
            sqlWhere = String.valueOf(sqlWhere) + " AND t.orgId in (select id from tm_org start with id='${tmPositionVo.curentOrg}' connect by prior parent_id=id)";
            if (StringUtil.isNotBlank((String)tmPositionVo.getCurentId())) {
                sqlWhere = String.valueOf(sqlWhere) + " AND t.id <>'" + tmPositionVo.getCurentId() + "'";
            }
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getOrgId())) {
            sqlWhere = String.valueOf(sqlWhere) + " AND t.orgId ='" + tmPositionVo.getOrgId() + "'";
        }
        String orderSql = " order by t.positionCode asc";
        return DynamicConfigUtil.getInstance().appendCustomCondition(sql, joinSql, onSql, sqlWhere, orderSql);
    }

    private void HandleRoleName(TmPositionVo positionVo) {
        List<TmRoleEntity> roles = this.tmPositionDao.findTmRoleByPosition(positionVo);
        StringBuffer bufferNames = new StringBuffer();
        StringBuffer bufferIds = new StringBuffer();
        if (!CollectionUtils.isEmpty(roles)) {
            for (TmRoleEntity tmRoleEntity : roles) {
                if (bufferNames.length() > 0) {
                    bufferNames.append(",");
                    bufferIds.append(",");
                }
                bufferNames.append(tmRoleEntity.getRoleName());
                bufferIds.append(tmRoleEntity.getId());
            }
            positionVo.setRoleNames(bufferNames.toString());
            positionVo.setRoleIds(bufferIds.toString());
        }
        StringBuffer actRoleBufferNames = new StringBuffer();
        StringBuffer actRoleBufferIds = new StringBuffer();
        List<TmActRoleEntity> actRoles = this.tmPositionDao.findTmActRoleByPosition(positionVo);
        if (!CollectionUtils.isEmpty(actRoles)) {
            for (TmActRoleEntity actRole : actRoles) {
                if (actRoleBufferNames.length() > 0) {
                    actRoleBufferNames.append(",");
                    actRoleBufferIds.append(",");
                }
                actRoleBufferNames.append(actRole.getRoleName());
                actRoleBufferIds.append(actRole.getId());
            }
            positionVo.setWorkflowRoleNames(actRoleBufferNames.toString());
            positionVo.setWorkflowRoleIds(actRoleBufferIds.toString());
        }
    }

    @Override
    public void saveTmPosition(TmPositionVo tmPositionVo, Page page) {
        TmPositionEntity tmPositionEntity = null;
        String positionId = "";
        if (this.tmPositionExtendService != null) {
            try {
                this.tmPositionExtendService.validate(tmPositionVo, page);
            }
            catch (BusinessException e) {
                throw new BusinessException("\u6570\u636e\u9a8c\u8bc1\u4e0d\u901a\u8fc7" + e.getMessage());
            }
            tmPositionEntity = this.tmPositionExtendService.saveBefore(tmPositionVo, page);
        }
        if (tmPositionEntity == null) {
            tmPositionEntity = new TmPositionVoToTmPositionEntity(this).apply(tmPositionVo);
            positionId = tmPositionEntity.getId();
        }
        if (this.tmPositionExtendService != null) {
            tmPositionEntity = this.tmPositionExtendService.saveBefore(tmPositionEntity, tmPositionVo, page);
        }
        this.saveOrUpdate(tmPositionEntity);
        if (this.tmPositionExtendService != null) {
            tmPositionEntity = this.tmPositionExtendService.savePost(tmPositionEntity, tmPositionVo, page);
            this.tmPositionExtendService.saveActIdUserBefore(tmPositionEntity, tmPositionVo, page);
        }
        ActIdUserEntity actIdUserEntity = this.saveActIdUser(tmPositionEntity);
        if (this.tmPositionExtendService != null) {
            this.tmPositionExtendService.saveActIdUserPost(actIdUserEntity, tmPositionEntity, tmPositionVo, page);
        }
        String hql = "FROM TmRPositionRoleEntity where tmPosition.id is null";
        List list = this.findByHql(hql, new Object[0]);
        for (TmRPositionRoleEntity prole : list) {
            String proleId = prole.getId();
            super.addLogAndRemoveInvalidInfo(proleId, prole, positionId, null);
        }
        this.executeSql("DELETE FROM TM_R_POSITION_ROLE WHERE POSITION_ID IS NULL", new Object[0]);
        String hql1 = "FROM TmRPositionActRoleEntity where tmPosition.id is null";
        List list1 = this.findByHql(hql1, new Object[0]);
        for (TmRPositionActRoleEntity prole : list1) {
            String proleId = prole.getId();
            super.addLogAndRemoveInvalidInfo(proleId, prole, positionId, null);
        }
        this.executeSql("DELETE FROM TM_R_POSITION_ACT_ROLE WHERE POSITION_ID IS NULL", new Object[0]);
    }

    private ActIdUserEntity saveActIdUser(TmPositionEntity tmPositionEntity) {
        ActIdUserEntity actIdUserEntity = this.get(ActIdUserEntity.class, (Serializable)((Object)tmPositionEntity.getPositionCode()));
        if (!StringUtil.isNotEmpty(actIdUserEntity)) {
            actIdUserEntity = new ActIdUserEntity();
            actIdUserEntity.setId(tmPositionEntity.getPositionCode());
            actIdUserEntity.setRev(Globals.REV);
            actIdUserEntity.setLast(tmPositionEntity.getPositionName());
            this.save(actIdUserEntity);
        } else {
            actIdUserEntity.setId(tmPositionEntity.getPositionCode());
            actIdUserEntity.setRev(Globals.REV);
            actIdUserEntity.setLast(tmPositionEntity.getPositionName());
            this.updateEntity(actIdUserEntity);
        }
        return actIdUserEntity;
    }

    @Override
    public void deleteTmPosition(String ids, Page page) {
        if (StringUtil.isNotEmpty((String)ids)) {
            String[] positionIds;
            String[] stringArray = positionIds = ids.split(",");
            int n = positionIds.length;
            int n2 = 0;
            while (n2 < n) {
                String positionId = stringArray[n2];
                TmPositionEntity tmPositionEntity = this.get(TmPositionEntity.class, (Serializable)((Object)positionId));
                if (tmPositionEntity != null && StringUtil.isNotEmpty((String)tmPositionEntity.getId())) {
                    if (CollectionUtil.listNotEmptyNotSizeZero(tmPositionEntity.getTmPositionList())) {
                        throw new BusinessException("\u5305\u542b\u4e0b\u7ea7\u804c\u4f4d,\u65e0\u6cd5\u5220\u9664");
                    }
                    List<TmUserPositionEntity> list = this.findByProperty(TmUserPositionEntity.class, "tmPosition.id", tmPositionEntity.getId());
                    for (TmUserPositionEntity userPosition : list) {
                        userPosition.setTmUser(this.get(TmUserEntity.class, (Serializable)((Object)userPosition.getTmUser().getId())));
                    }
                    this.deleteAllEntity(list);
                    this.delete(tmPositionEntity);
                }
                ++n2;
            }
        }
    }

    @Override
    public AjaxJson startOrStopPosition(TmPositionVo tmPositionVo) {
        AjaxJson j = new AjaxJson();
        TmPositionEntity positionEntity = this.get(TmPositionEntity.class, (Serializable)((Object)tmPositionVo.getId()));
        if (StringUtil.isNotEmpty(positionEntity)) {
            if (positionEntity.getEnableStatus().equals(tmPositionVo.getEnableStatus())) {
                j.setSuccess(false);
                String fg = Globals.ZERO == tmPositionVo.getEnableStatus() ? "\u542f\u7528" : "\u505c\u7528";
                j.setMsg("\u8be5\u6570\u636e\u72b6\u6001\u5df2\u7ecf\u4e3a" + fg + "\uff0c\u65e0\u9700\u518d\u6b21\u64cd\u4f5c");
            } else {
                positionEntity.setEnableStatus(tmPositionVo.getEnableStatus());
                this.updateEntity(positionEntity);
            }
        } else {
            throw new BusinessException("\u672a\u627e\u5230\u8be5\u7eaa\u5f55");
        }
        return j;
    }

    @Override
    public ValidForm validateTmposition(TmPositionVo tmPositionVo, String param) {
        ValidForm validForm = new ValidForm();
        String hql = "";
        if (StringUtil.isNotEmpty((String)tmPositionVo.getId())) {
            if (StringUtil.isNotEmpty((String)tmPositionVo.getType())) {
                List list;
                if (StringUtil.equals("0", tmPositionVo.getType())) {
                    hql = "from TmPositionEntity where positionCode=? and id<>? and enableStatus=?";
                    list = this.findByHql(hql, param, tmPositionVo.getId(), Globals.ZERO);
                    if (!CollectionUtils.isEmpty(list)) {
                        validForm.setInfo("\u804c\u4f4d\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
                        validForm.setStatus("n");
                    }
                }
                if (StringUtil.equals("1", tmPositionVo.getType())) {
                    hql = "from TmPositionEntity where positionName=? and id<>? and enableStatus=?";
                    list = this.findByHql(hql, param, tmPositionVo.getId(), Globals.ZERO);
                    if (!CollectionUtils.isEmpty(list)) {
                        validForm.setInfo("\u804c\u4f4d\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
                        validForm.setStatus("n");
                    }
                }
            }
        } else if (StringUtil.isNotEmpty((String)tmPositionVo.getType())) {
            if (StringUtil.equals("0", tmPositionVo.getType())) {
                hql = "from TmPositionEntity where positionCode=? and enableStatus=?";
                List list = this.findByHql(hql, param, Globals.ZERO);
                if (!CollectionUtils.isEmpty(list)) {
                    validForm.setInfo("\u804c\u4f4d\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
                    validForm.setStatus("n");
                }
            }
            if (StringUtil.equals("1", tmPositionVo.getType())) {
                hql = "from TmPositionEntity where positionName=? and enableStatus=?";
                List nameList = this.findByHql(hql, param, Globals.ZERO);
                if (!CollectionUtils.isEmpty(nameList)) {
                    validForm.setInfo("\u804c\u4f4d\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
                    validForm.setStatus("n");
                }
            }
        }
        return validForm;
    }

    @Override
    public List<ComboTree> getPositionForComboTree(HttpServletRequest request, ComboTree comboTree) {
        String selfId = request.getParameter("selfId");
        List<Object> positionList = new ArrayList();
        if (StringUtil.isNotEmpty((String)selfId)) {
            positionList = this.findByProperty(TmPositionEntity.class, "id", selfId);
        } else if (StringUtil.isNotEmpty((String)comboTree.getId())) {
            positionList = this.findByProperty(TmPositionEntity.class, "tmPosition.id", comboTree.getId());
        } else {
            Criterion cr = Restrictions.isNull((String)"tmPosition.id");
            positionList = this.findByCriteria(TmPositionEntity.class, cr);
        }
        ArrayList<ComboTree> comboTrees = new ArrayList();
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "positionName", "positions");
        comboTrees = this.comboTree(positionList, comboTreeModel, null, false);
        return comboTrees;
    }

    @Override
    public AjaxJson changePositionForOrg(TmOrgVo tmOrgVo) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((String)tmOrgVo.getPositionIds())) {
            String[] posIds;
            TmPositionEntity tmPositionEntity = null;
            TmOrgEntity tmOrgEntity = new TmOrgEntity();
            String[] stringArray = posIds = tmOrgVo.getPositionIds().split(",");
            int n = posIds.length;
            int n2 = 0;
            while (n2 < n) {
                String posId = stringArray[n2];
                tmPositionEntity = this.get(TmPositionEntity.class, (Serializable)((Object)posId));
                if (StringUtil.isNotEmpty(tmPositionEntity)) {
                    tmOrgEntity.setId(tmOrgVo.getOrgId());
                    tmPositionEntity.setTmOrg(tmOrgEntity);
                    tmPositionEntity.setTmPosition(null);
                    this.saveOrUpdate(tmPositionEntity);
                }
                ++n2;
            }
            j.setMsg("\u8c03\u6574\u5173\u7cfb\u6210\u529f");
        } else {
            j.setSuccess(false);
            j.setMsg("\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
        }
        return j;
    }

    @Override
    public void changeTmPosition(TmPositionVo tmPositionVo) {
        String slq1 = " update tm_r_user_position set is_main=? where user_id=? ";
        this.executeSql(slq1, Globals.ONE, tmPositionVo.getUserId());
        String slq2 = " update tm_r_user_position set is_main=? where position_id=? ";
        this.executeSql(slq2, Globals.ZERO, tmPositionVo.getId());
        ClientManager manager = ClientManager.getInstance();
        manager.addUserPositionMap(tmPositionVo.getUserId(), tmPositionVo.getId());
    }

    @Override
    public List<TmPositionVo> findPositionListByOrgId(String orgId) {
        String hql = "from TmPositionEntity pe where tmOrg.id = ?";
        List entityList = this.findByHql(hql, orgId);
        List list = Lists.transform(entityList, (Function)new TmPositionEntityToTmPositionVo());
        return list;
    }

    @Override
    public List<TmPositionVo> findOtherTmUserInfo() {
        String userId = ResourceUtil.getSessionTmUserVo().getId();
        TmPositionVo tmPositionVo = new TmPositionVo();
        tmPositionVo.setUserId(userId);
        return this.tmPositionDao.findOtherTmUserInfo(tmPositionVo);
    }

    @Override
    public List<TmPositionVo> findPositionByConditions(TmPositionVo query, Page page) {
        List<TmPositionVo> list = this.tmPositionDao.findTmPositionByCondition(query, page);
        return list;
    }

    @Override
    public List<TmPositionVo> findTmPositionByAllPossible(QueryTmpositionVo queryTmpositionVo, Page page) {
        return this.tmPositionDao.findTmPositionByAllPossible(queryTmpositionVo, page);
    }

    @Override
    public List<TmLogVo> findPositionLogList(TmLogVo tmLogVo, Page page) {
        return this.tmPositionDao.findPositionLogList(tmLogVo, page);
    }
}

