/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.product.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TreeGridUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.product.dao.TmProductDao;
import com.biz.eisp.mdm.product.entity.TmProductEntity;
import com.biz.eisp.mdm.product.service.TmProductExtendService;
import com.biz.eisp.mdm.product.service.TmProductService;
import com.biz.eisp.mdm.product.transformer.TmProductEntityToTmProductVo;
import com.biz.eisp.mdm.product.transformer.TmProductVoToTmProductEntity;
import com.biz.eisp.mdm.product.vo.ProductExcelVo;
import com.biz.eisp.mdm.product.vo.TmProductVo;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tmProductService")
@Transactional
public class TmProductServiceImpl
extends BaseServiceImpl
implements TmProductService {
    @Autowired
    private TmProductDao tmProductDao;
    @Autowired(required=false)
    private TmProductExtendService tmProductExtendService;

    @Override
    public List<TmProductEntity> findProductSelectGrid(HttpServletRequest request, ProductExcelVo pro) {
        Criterion cr1 = null;
        if (StringUtil.isNotEmpty((String)pro.getProductName())) {
            cr1 = Restrictions.like((String)"productName", (Object)("%" + pro.getProductName() + "%"));
        }
        if (StringUtil.isEmpty(pro.getId())) {
            cr1 = Restrictions.isNull((String)"product");
        }
        SimpleExpression cr2 = Restrictions.eq((String)"status", (Object)Globals.ZERO);
        List<TmProductEntity> proList = this.findByCriteria(TmProductEntity.class, new Criterion[]{cr1, cr2});
        return proList;
    }

    @Override
    public List<ComboTree> getParentProduct(ComboTree comboTree, ProductExcelVo pro) {
        ArrayList<TmProductEntity> proList = new ArrayList<TmProductEntity>();
        if (StringUtil.isNotEmpty((String)pro.getId())) {
            List<TmProductEntity> list = this.findByProperty(TmProductEntity.class, "product.id", pro.getId());
            proList.addAll(list);
        } else if (StringUtil.isNotEmpty((String)comboTree.getId())) {
            proList.addAll(this.findByProperty(TmProductEntity.class, "product.id", comboTree.getId()));
        } else {
            Criterion cr1 = Restrictions.isNull((String)"product.id");
            proList.addAll(this.findByCriteria(TmProductEntity.class, cr1));
        }
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "productName", "products");
        List<ComboTree> comboTrees = this.comboTree(proList, comboTreeModel, null, false);
        return comboTrees;
    }

    @Override
    public void saveOrUpdateProduct(TmProductVo pro, Page page) {
        TmProductEntity productEntity = null;
        if (StringUtil.isNotEmpty(this.tmProductExtendService)) {
            try {
                this.tmProductExtendService.validate(pro, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25:" + e.getMessage());
            }
            productEntity = this.tmProductExtendService.saveBefore(pro, page);
        }
        if (StringUtil.isEmpty(productEntity)) {
            TmProductVoToTmProductEntity formPo = new TmProductVoToTmProductEntity(this);
            productEntity = formPo.apply(pro);
        }
        if (StringUtil.isNotEmpty(productEntity) && this.tmProductExtendService != null) {
            productEntity = this.tmProductExtendService.saveBefore(productEntity, pro, page);
        }
        this.saveOrUpdate(productEntity);
        if (StringUtil.isNotEmpty(productEntity) && this.tmProductExtendService != null) {
            productEntity = this.tmProductExtendService.savePost(productEntity, pro, page);
        }
    }

    @Override
    public AjaxJson delProduct(String ids) {
        String[] proIds;
        AjaxJson j = new AjaxJson();
        String[] stringArray = proIds = ids.split(",");
        int n = proIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            TmProductEntity proEntity = this.get(TmProductEntity.class, (Serializable)((Object)id));
            if (!StringUtil.isNotEmpty(proEntity)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25\uff01");
                return j;
            }
            if (StringUtil.isNotEmpty(proEntity.getTmProductList()) && proEntity.getTmProductList().size() > 0) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25\uff01\u3010" + proEntity.getProductName() + "\u3011\u4e0b\u9762\u6709\u5176\u4ed6\u4ea7\u54c1\uff01");
                return j;
            }
            this.delete(proEntity);
            ++n2;
        }
        j.setMsg("\u5220\u9664\u6210\u529f!");
        return j;
    }

    @Override
    public List<ProductExcelVo> findExcelList(HttpServletRequest request, ProductExcelVo pro) {
        return this.tmProductDao.findTmExcelProduct(pro);
    }

    @Override
    public List<ComboTree> getParentProducts(ComboTree comboTree, ProductExcelVo pro, HttpServletRequest request) {
        String selfId = request.getParameter("selfId");
        List<Object> proList = new ArrayList();
        if (StringUtil.isNotEmpty((String)comboTree.getId())) {
            SimpleExpression cr1 = Restrictions.eq((String)"product.id", (Object)comboTree.getId());
            proList = this.findByCriteria(TmProductEntity.class, new Criterion[]{cr1});
        } else {
            Criterion cr2 = Restrictions.isNull((String)"product.id");
            proList = this.findByCriteria(TmProductEntity.class, cr2);
        }
        ArrayList<TmProductEntity> proList2 = new ArrayList<TmProductEntity>();
        if (StringUtil.isNotEmpty((String)selfId)) {
            for (TmProductEntity tmProductEntity : proList) {
                if (tmProductEntity.getId().equals(selfId)) continue;
                proList2.add(tmProductEntity);
            }
            ComboTreeModel comboTreeModel = new ComboTreeModel("id", "productName", "products");
            List<ComboTree> comboTrees = this.comboTree(proList2, comboTreeModel, null, false);
            return comboTrees;
        }
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "productName", "products");
        List<ComboTree> comboTrees = this.comboTree(proList, comboTreeModel, null, false);
        return comboTrees;
    }

    @Override
    public List<ProductExcelVo> findTmProductAllPossible(ProductExcelVo productVo, Page page) {
        return this.tmProductDao.findTmProductAllPossible(productVo, page);
    }

    @Override
    public boolean validate(String id, String param, String fieldName) {
        SimpleExpression cr1 = Restrictions.eq((String)fieldName, (Object)param);
        List<Object> tmprds = new ArrayList();
        if (StringUtil.isNotEmpty((String)id)) {
            SimpleExpression cr2 = Restrictions.ne((String)"id", (Object)id);
            tmprds = this.findByCriteria(TmProductEntity.class, new Criterion[]{cr1, cr2});
        } else {
            tmprds = this.findByCriteria(TmProductEntity.class, new Criterion[]{cr1});
        }
        return !CollectionUtils.isEmpty(tmprds);
    }

    @Override
    public List<TmProductVo> findTmProductList(TmProductVo productVo) {
        String sql = DynamicConfigUtil.getInstance().buildTreeGridQuerySql(Globals.TABLE_PRODUCT, productVo);
        List<TmProductVo> voList = this.findBySql(TmProductVo.class, sql, new Object[0]);
        if (DynamicConfigUtil.getInstance().isHaveQuery(Globals.TABLE_PRODUCT, productVo)) {
            voList = this.findQueryProductList(productVo, voList);
        }
        return voList;
    }

    @Override
    public List<TmProductVo> findTmProductComboTree(TmProductVo productVo, String selfId) {
        List voList = null;
        if (StringUtils.isNotBlank((CharSequence)selfId)) {
            List<TmProductEntity> entityList = this.findByProperty(TmProductEntity.class, "id", selfId);
            voList = Lists.transform(entityList, (Function)new TmProductEntityToTmProductVo(this));
        } else {
            voList = this.findTmProductList(productVo);
        }
        return voList;
    }

    private List<TmProductVo> findQueryProductList(TmProductVo productVo, List<TmProductVo> voList) {
        if (productVo.getExportExcel().equals("true")) {
            return voList;
        }
        List allQueryVoList = TreeGridUtil.buildTreeGrid(voList);
        return allQueryVoList;
    }

    @Override
    public TmProductVo getTmProductVo(String id) {
        TmProductEntity entity = this.get(TmProductEntity.class, (Serializable)((Object)id));
        TmProductEntityToTmProductVo transForm = new TmProductEntityToTmProductVo(this);
        TmProductVo vo = transForm.apply(entity);
        return vo;
    }

    @Override
    public List<TmProductVo> findTmProductSearchList(TmProductVo productVo, Page page) {
        String sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_PRODUCT, productVo);
        List<TmProductVo> voList = this.findBySql(TmProductVo.class, sql, new Object[0]);
        return voList;
    }
}

