/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.user.service;

import com.alibaba.fastjson.JSONArray;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.importer.ImpEventHandler;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.importer.validator.ValidatorFactory;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TmUserEventHandler
extends ImpEventHandler<TmUserVo> {
    private TmUserService tmUserService = (TmUserService)ApplicationContextUtils.getContext().getBean("tmUserService");

    @Override
    public void validate(Map<String, String> row) throws ValidateException {
        List<TmMdmTableConfigEntity> list = DynamicConfigUtil.allTableConfigImpColumn.get(this.tableName.toUpperCase());
        for (TmMdmTableConfigEntity tableConfig : list) {
            String hql;
            List result;
            String fieldValue;
            String errorMsg = ValidatorFactory.validateDynamicImplData(tableConfig, fieldValue = row.get(tableConfig.getField()));
            if (StringUtil.isNotEmpty((String)errorMsg)) {
                this.addError("\u7b2c" + this.getRowNumber() + "\u884c:" + errorMsg);
            }
            if (!StringUtil.equals("userName", tableConfig.getField()) || (result = this.tmUserService.findByHql(hql = " from TmUserEntity where userType=0 and userName=?", fieldValue)) == null || result.size() <= 0) continue;
            this.addError("\u7b2c" + this.getRowNumber() + "\u884c,\u767b\u5f55\u8d26\u53f7" + fieldValue + "\u5df2\u5b58\u5728\u6216\u51fa\u73b0\u91cd\u590d");
        }
        String positionId = row.get("positionId");
        if (StringUtil.isNotEmpty((String)positionId)) {
            String sql = "SELECT COUNT(1) FROM TM_POSITION WHERE POSITION_CODE=? AND ENABLE_STATUS=?";
            long count = this.tmUserService.getCountForJdbcParam(sql, positionId, Globals.ZERO);
            if (count == 0L) {
                this.addError("\u7b2c" + this.getRowNumber() + "\u884c,\u4e3b\u804c\u4f4d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
            } else {
                String userSql = "SELECT COUNT(1) FROM TM_R_USER_POSITION WHERE POSITION_ID=?";
                TmPositionEntity entity = this.tmUserService.findUniqueByProperty(TmPositionEntity.class, "positionCode", positionId);
                count = this.tmUserService.getCountForJdbcParam(userSql, entity.getId());
                if (count > 0L) {
                    this.addError("\u7b2c" + this.getRowNumber() + "\u884c,\u4e3b\u804c\u4f4d\u5df2\u7ecf\u88ab\u4f7f\u7528");
                } else {
                    row.put("positionId", entity.getId());
                }
            }
        }
    }

    @Override
    public void endRow(Map<String, String> row, TmUserVo bean) throws ValidateException {
        try {
            bean.setPassword("123456");
            bean.setUserType(Globals.ENTERPRISE_USER);
            String mainPositionId = bean.getPositionId();
            ArrayList<TmPositionVo> tmUserPositionList = new ArrayList<TmPositionVo>();
            TmPositionVo tmPositionVo = new TmPositionVo();
            tmPositionVo.setId(mainPositionId);
            tmPositionVo.setIsMain("0");
            tmUserPositionList.add(tmPositionVo);
            bean.setPositionJson(JSONArray.toJSONString(tmUserPositionList));
            this.tmUserService.saveTmUser(bean, null);
        }
        catch (Exception e) {
            this.addError("\u7b2c" + this.getRowNumber() + "\u884c\u9047\u5230\u9519\u8bef:" + e.getMessage());
            e.printStackTrace();
        }
        this.setSuccNum(this.getSuccNum() + 1);
    }
}

