/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.web;

import com.biz.eisp.activiti.runtime.entity.TaAttachmentEntity;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.service.TbAttachmentExtendsService;
import com.biz.eisp.base.common.service.TbAttachmentService;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.ReflectHelper;
import com.biz.eisp.base.common.vo.TbAttachmentVo;
import com.biz.eisp.base.core.entity.TbAttachmentQueryEntity;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.base.utils.MyClassLoader;
import com.biz.eisp.base.utils.UploadFile;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tbAttachmentController"})
public class TbAttachmentController
extends BaseController {
    @Autowired
    private TbAttachmentService tbAttachmentService;
    private TbAttachmentExtendsService tbAttachmentExtendsService;

    @RequestMapping(params={"goTbAttachmentMain"})
    public ModelAndView goTbAttachmentMain(String id, String extendService, HttpServletRequest request) {
        if (StringUtils.isNotBlank((CharSequence)extendService)) {
            this.tbAttachmentExtendsService = (TbAttachmentExtendsService)ApplicationContextUtils.getContext().getBean(extendService, TbAttachmentExtendsService.class);
            boolean isReadOnly = this.tbAttachmentExtendsService.isReadOnly(id);
            request.setAttribute("isReadOnly", (Object)isReadOnly);
        }
        List<TbAttachmentVo> voList = this.tbAttachmentService.findTbAttachmentByBusinessKey(id);
        request.setAttribute("voList", voList);
        request.setAttribute("businessKey", (Object)id);
        return new ModelAndView("com/biz/eisp/base/tbAttachmentMain");
    }

    @RequestMapping(params={"saveFiles"})
    @ResponseBody
    public AjaxJson saveFiles(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        try {
            String businessKey = request.getParameter("businessKey");
            TbAttachmentQueryEntity entity = new TbAttachmentQueryEntity();
            entity.setBusinessKey(businessKey);
            UploadFile uploadFile = new UploadFile(request, entity);
            entity.setSubclassName(TaAttachmentEntity.class.getName());
            uploadFile.setCusPath("resources/upload");
            uploadFile.setExtend("extend");
            uploadFile.setTitleField("attachmentTitle");
            uploadFile.setRealPath("realPath");
            uploadFile.setObject(entity);
            uploadFile.setRename(true);
            this.tbAttachmentService.uploadFile(uploadFile);
            List<TbAttachmentVo> myAttachmentList = this.tbAttachmentService.findTbAttachmentByBusinessKey(businessKey);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("url", entity.getRealPath());
            attributes.put("fileKey", entity.getId());
            attributes.put("name", entity.getAttachmentTitle());
            attributes.put("delurl", "tbAttachmentController.do?delObjFile&fileKey=" + entity.getId());
            attributes.put("myAttachmentList", myAttachmentList);
            j.setAttributes(attributes);
            j.setMsg("\u6587\u4ef6\u6dfb\u52a0\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"delObjFile"})
    @ResponseBody
    public AjaxJson delObjFile(HttpServletRequest request) {
        String message = null;
        AjaxJson j = new AjaxJson();
        try {
            String fileKey = OConvertUtils.getString(request.getParameter("fileKey"));
            TbAttachmentQueryEntity attachment = this.tbAttachmentService.get(TbAttachmentQueryEntity.class, (Serializable)((Object)fileKey));
            message = attachment.getAttachmentTitle() + "\u5220\u9664\u6210\u529f";
            this.tbAttachmentService.delete(attachment);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"viewFile"})
    public void viewFile(HttpServletRequest request, HttpServletResponse response) {
        String fileid = OConvertUtils.getString(request.getParameter("fileid"));
        String subclassname = OConvertUtils.getString(request.getParameter("subclassName"), "com.biz.eisp.base.core.entity.TbAttachmentQueryEntity");
        Class fileClass = MyClassLoader.getClassByScn(subclassname);
        Object fileobj = this.tbAttachmentService.get(fileClass, (Serializable)((Object)fileid));
        ReflectHelper reflectHelper = new ReflectHelper(fileobj);
        UploadFile uploadFile = new UploadFile(request, response);
        String contentfield = OConvertUtils.getString(request.getParameter("contentfield"), uploadFile.getByteField());
        byte[] content = (byte[])reflectHelper.getMethodValue(contentfield);
        String path = OConvertUtils.getString(reflectHelper.getMethodValue("realPath"));
        String extend = OConvertUtils.getString(reflectHelper.getMethodValue("extend"));
        String attachmenttitle = OConvertUtils.getString(reflectHelper.getMethodValue("attachmentTitle"));
        uploadFile.setExtend(extend);
        uploadFile.setTitleField(attachmenttitle);
        uploadFile.setRealPath(path);
        uploadFile.setContent(content);
        this.tbAttachmentService.viewOrDownloadFile(uploadFile);
    }
}

