/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.importer.iterator;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.importer.DataField;
import com.biz.eisp.base.importer.iterator.DataIterator;
import com.biz.eisp.base.utils.DateUtils;
import com.biz.eisp.mdm.dict.util.DictUtil;
import java.io.InputStream;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;

public class ExcelDataIterator
implements DataIterator {
    private Sheet sheet;
    private int rows = -1;
    private int index;
    private List<DataField> dataFieldList;

    public ExcelDataIterator(InputStream is, int sheetIndex, List<DataField> dataFieldList) throws Exception {
        this.sheet = Workbook.getWorkbook((InputStream)is).getSheet(sheetIndex);
        this.rows = this.sheet.getRows();
        this.verifySheetRowsNum();
        this.index = 0;
        this.dataFieldList = dataFieldList;
    }

    private void verifySheetRowsNum() {
        int i = 0;
        while (i < this.sheet.getRows()) {
            int isEmptyCount = 0;
            Cell[] cellArray = this.sheet.getRow(i);
            int n = cellArray.length;
            int n2 = 0;
            while (n2 < n) {
                Cell cc = cellArray[n2];
                if (cc.getContents() == "") {
                    ++isEmptyCount;
                }
                ++n2;
            }
            if (isEmptyCount == this.sheet.getRow(i).length) {
                --this.rows;
            }
            ++i;
        }
    }

    public ExcelDataIterator(InputStream is) throws Exception {
        this(is, 0, null);
    }

    @Override
    public boolean hasNext() {
        return this.index < this.rows;
    }

    @Override
    public Map<String, String> next() {
        Cell[] cells = this.sheet.getRow(this.index++);
        HashMap<String, String> rowMap = new HashMap<String, String>();
        int m = 0;
        while (m < cells.length) {
            String value = cells[m].getContents().trim();
            if (this.dataFieldList.size() > m) {
                String dictCode;
                String valueStr;
                DataField dataField = this.dataFieldList.get(m);
                String code = dataField.getCode();
                if (StringUtil.isNotEmpty((String)value) && dataField != null && StringUtil.isNotEmpty((String)dataField.getDictCode()) && StringUtil.isNotEmpty((String)(valueStr = DictUtil.getDictCodeByValue(dictCode = dataField.getDictCode(), value)))) {
                    value = valueStr;
                }
                if (StringUtil.isNotEmpty((String)dataField.getFormat())) {
                    try {
                        rowMap.put(dataField.getCode(), (String)((Object)DateUtils.getSDFormat(dataField.getFormat()).parse(value)));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                } else {
                    rowMap.put(dataField.getCode(), value);
                }
            }
            ++m;
        }
        return rowMap;
    }

    @Override
    public void remove() {
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getRowNumber() {
        return this.index;
    }

    @Override
    public int getSize() {
        return this.rows;
    }
}

