/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.businessarea.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TreeGridUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.businessarea.dao.TmBusinessAreaDao;
import com.biz.eisp.mdm.businessarea.entity.TmBusinessAreaEntity;
import com.biz.eisp.mdm.businessarea.service.TmBusinessAreaExtendService;
import com.biz.eisp.mdm.businessarea.service.TmBusinessAreaService;
import com.biz.eisp.mdm.businessarea.transformer.TmBusinessAreaEntityToTmBusinessAreaVo;
import com.biz.eisp.mdm.businessarea.transformer.TmBusinessAreaVoToTmBusinessAreaEntity;
import com.biz.eisp.mdm.businessarea.vo.TmBusinessAreaExcelVo;
import com.biz.eisp.mdm.businessarea.vo.TmBusinessAreaVo;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tmBusinessAreaService")
@Transactional
public class TmBusinessAreaServiceImpl
extends BaseServiceImpl
implements TmBusinessAreaService {
    @Autowired
    private TmBusinessAreaDao tmBusinessAreaDao;
    @Autowired(required=false)
    private TmBusinessAreaExtendService tmBusinessAreaExtendService;

    @Override
    public void saveTmBusinessArea(TmBusinessAreaVo tmBusinessAreaVo, Page page) {
        TmBusinessAreaEntity tmBusinessAreaEntity = null;
        if (StringUtil.isNotEmpty(this.tmBusinessAreaExtendService)) {
            try {
                this.tmBusinessAreaExtendService.validate(tmBusinessAreaVo, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25:" + e.getMessage());
            }
            tmBusinessAreaEntity = this.tmBusinessAreaExtendService.saveBefore(tmBusinessAreaVo, page);
        }
        if (StringUtil.isEmpty(tmBusinessAreaEntity)) {
            tmBusinessAreaEntity = new TmBusinessAreaVoToTmBusinessAreaEntity(this).apply(tmBusinessAreaVo);
        }
        if (StringUtil.isNotEmpty(this.tmBusinessAreaExtendService)) {
            tmBusinessAreaEntity = this.tmBusinessAreaExtendService.saveBefore(tmBusinessAreaEntity, tmBusinessAreaVo, page);
        }
        this.saveOrUpdate(tmBusinessAreaEntity);
        if (StringUtil.isNotEmpty(this.tmBusinessAreaExtendService)) {
            tmBusinessAreaEntity = this.tmBusinessAreaExtendService.savePost(tmBusinessAreaEntity, tmBusinessAreaVo, page);
        }
    }

    @Override
    public void deleteTmBusinessArea(String id) {
        TmBusinessAreaEntity tbaEntity = this.get(TmBusinessAreaEntity.class, (Serializable)((Object)id));
        if (tbaEntity.getIsLeaf() == 0) {
            throw new BusinessException("\u5b58\u5728\u5b50\u8282\u70b9\u4e0d\u80fd\u5220\u9664");
        }
        this.delete(tbaEntity);
    }

    @Override
    public void updateBusinessAreaEnableStatus(TmBusinessAreaVo tmBusinessAreaVo) {
        TmBusinessAreaEntity entity = this.get(TmBusinessAreaEntity.class, (Serializable)((Object)tmBusinessAreaVo.getId()));
        entity.setEnableStatus(tmBusinessAreaVo.getEnableStatus());
        this.updateEntity(entity);
    }

    @Override
    public List<ComboBox> findBusinessAreaCombobox(TmBusinessAreaExcelVo tba) {
        String sql = "select distinct  t.name text,t.name value  from tm_business_area t left join  tm_business_area t1 on t1.id=t.PARENT_ID where 1=1";
        List<ComboBox> comList = null;
        if (StringUtil.isNotEmpty(tba.getAreaLevel())) {
            sql = String.valueOf(sql) + " and t.AREA_LEVEL=?";
            comList = this.findBySql(ComboBox.class, sql, tba.getAreaLevel());
        }
        if (StringUtil.isNotEmpty((String)tba.getBusinessAreaName())) {
            sql = String.valueOf(sql) + " and t1.name=?";
            comList = this.findBySql(ComboBox.class, sql, tba.getBusinessAreaName());
        }
        return comList;
    }

    @Override
    public boolean validate(String id, String param, String fieldName) {
        SimpleExpression cr1 = Restrictions.eq((String)fieldName, (Object)param);
        List<Object> tmtbas = new ArrayList();
        if (StringUtil.isNotEmpty((String)id)) {
            SimpleExpression cr2 = Restrictions.ne((String)"id", (Object)id);
            tmtbas = this.findByCriteria(TmBusinessAreaEntity.class, new Criterion[]{cr1, cr2});
        } else {
            tmtbas = this.findByCriteria(TmBusinessAreaEntity.class, new Criterion[]{cr1});
        }
        return !CollectionUtils.isEmpty(tmtbas);
    }

    @Override
    public List<TmBusinessAreaVo> findBusinessAreaList(TmBusinessAreaVo tmBusinessAreaVo) {
        String sql = DynamicConfigUtil.getInstance().buildTreeGridQuerySql(Globals.TABLE_BUSINESS_AREA, tmBusinessAreaVo);
        List<TmBusinessAreaVo> voList = this.findBySql(TmBusinessAreaVo.class, sql, new Object[0]);
        if (DynamicConfigUtil.getInstance().isHaveQuery(Globals.TABLE_BUSINESS_AREA, tmBusinessAreaVo)) {
            voList = this.findQueryBusinessAreaList(tmBusinessAreaVo, voList);
        }
        return voList;
    }

    @Override
    public List<TmBusinessAreaVo> findTmBusinessAreaComboTree(TmBusinessAreaVo tmBusinessAreaVo, String selfId) {
        List voList = null;
        if (StringUtils.isNotBlank((CharSequence)selfId)) {
            List<TmBusinessAreaEntity> entityList = this.findByProperty(TmBusinessAreaEntity.class, "id", selfId);
            voList = Lists.transform(entityList, (Function)new TmBusinessAreaEntityToTmBusinessAreaVo());
        } else {
            voList = this.findBusinessAreaList(tmBusinessAreaVo);
        }
        return voList;
    }

    private List<TmBusinessAreaVo> findQueryBusinessAreaList(TmBusinessAreaVo tmBusinessAreaVo, List<TmBusinessAreaVo> voList) {
        if (tmBusinessAreaVo.getExportExcel().equals("true")) {
            return voList;
        }
        List allQueryVoList = TreeGridUtil.buildTreeGrid(voList);
        return allQueryVoList;
    }

    @Override
    public void updateTmBusinessAreaIsLeaf() {
        this.tmBusinessAreaDao.updateLeafNode();
        this.tmBusinessAreaDao.updateNotLeafNode();
    }

    @Override
    public TmBusinessAreaVo getTmBusinessAreaVo(String id) {
        TmBusinessAreaEntity entity = this.get(TmBusinessAreaEntity.class, (Serializable)((Object)id));
        TmBusinessAreaVo vo = new TmBusinessAreaEntityToTmBusinessAreaVo().apply(entity);
        return vo;
    }
}

