/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.config.controller;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.service.TmTableConfigService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tmTableConfigController"})
public class TmTableConfigController
extends BaseController {
    @Autowired
    private TmTableConfigService tmTableConfigService;

    @RequestMapping(params={"goTableConfigMain"})
    public ModelAndView goTableConfigMain(HttpServletRequest request) {
        this.tmTableConfigService.importTable(Globals.TABLE_USER);
        List<ComboBox> comboxList = this.tmTableConfigService.comboBoxByDict("table_name");
        request.setAttribute("tableList", comboxList);
        return new ModelAndView("com/biz/eisp/mdm/tableConfig/tableConfigMain");
    }

    @RequestMapping(params={"goTpmTableConfigMain"})
    public ModelAndView goTpmTableConfigMain(HttpServletRequest request) {
        List<ComboBox> comboxList = this.tmTableConfigService.comboBoxByDict("tpm_table_name");
        request.setAttribute("tableList", comboxList);
        return new ModelAndView("com/biz/eisp/mdm/tableConfig/tableConfigMain");
    }

    @RequestMapping(params={"goTableConfigIframe"})
    public ModelAndView goTableConfigIframe(String tableName, HttpServletRequest request) {
        request.setAttribute("tableName", (Object)tableName);
        return new ModelAndView("com/biz/eisp/mdm/tableConfig/tableConfigIframe");
    }

    @RequestMapping(params={"tableConfigGrid"})
    public void tableConfigGrid(String tableName, HttpServletRequest request, HttpServletResponse response) {
        List<TmMdmTableConfigEntity> result = this.tmTableConfigService.getColumnsByTableName(tableName, "columnOrder");
        super.datagridReturn(response, result);
    }

    @RequestMapping(params={"saveTableConfig"})
    public void saveTableConfig1(String saveJsonData, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.tmTableConfigService.saveTableConfig(saveJsonData);
        }
        catch (Exception e) {
            this.message = "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff01";
            e.printStackTrace();
        }
        this.sendResponse(response);
    }

    @RequestMapping(params={"dictCombox"})
    public void dictCombox(String dictCode, HttpServletRequest request, HttpServletResponse response) {
        List<ComboBox> dictDataList = this.tmTableConfigService.comboBoxByDict(dictCode);
        this.sendResponseObj(response, dictDataList);
    }

    @RequestMapping(params={"queryModeCombox"})
    public void queryModeCombox(HttpServletRequest request, HttpServletResponse response) {
        List<ComboBox> dictDataList = this.tmTableConfigService.comboBoxByDict("searchmode");
        this.sendResponseObj(response, dictDataList);
    }

    @RequestMapping(params={"joinTypeCombox"})
    public void joinTypeCombox(HttpServletRequest request, HttpServletResponse response) {
        List<ComboBox> dictDataList = this.tmTableConfigService.comboBoxByDict("join_type");
        this.sendResponseObj(response, dictDataList);
    }

    @RequestMapping(params={"queryFormTypeCombox"})
    public void queryFormTypeCombox(HttpServletRequest request, HttpServletResponse response) {
        List<ComboBox> dictDataList = this.tmTableConfigService.comboBoxByDict("form_type");
        this.sendResponseObj(response, dictDataList);
    }
}

