/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.function.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.TreeGrid;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.tag.bean.TreeGridModel;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.authobj.entity.TmFunAuthEntity;
import com.biz.eisp.mdm.authobj.service.TmFunAuthService;
import com.biz.eisp.mdm.authobj.transform.TmFuncAuthTransForm;
import com.biz.eisp.mdm.authobj.vo.TmFunctionAuthVo;
import com.biz.eisp.mdm.function.dao.TmFuncionDao;
import com.biz.eisp.mdm.function.entity.TmFunctionEntity;
import com.biz.eisp.mdm.function.service.TmFunctionService;
import com.biz.eisp.mdm.function.transformer.TmFunctionVoToTmFunctionEntity;
import com.biz.eisp.mdm.function.vo.TmFunctionVo;
import com.biz.eisp.mdm.icon.entity.TmIconEntity;
import com.biz.eisp.mdm.operation.entity.TmOperationEntity;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.biz.eisp.mdm.role.entity.TmRoleFunctionEntity;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tmFunctionService")
@Transactional
public class TmFunctionServiceImpl
extends BaseServiceImpl
implements TmFunctionService {
    @Autowired
    private TmFunAuthService tmFunAuthService;
    @Autowired
    private TmFuncionDao tmFuncionDao;

    @Override
    public List<TreeGrid> getFunctionsList(HttpServletRequest request, TreeGrid treeGrid) {
        String selfId = request.getParameter("selfId");
        List<Object> functionList = new ArrayList();
        if (StringUtil.isNotEmpty((String)selfId)) {
            functionList = this.findByPropertyisOrder(TmFunctionEntity.class, "id", selfId, true, "functionOrder");
        }
        if (StringUtil.isNotEmpty((String)treeGrid.getId())) {
            functionList = this.findByPropertyisOrder(TmFunctionEntity.class, "tmFunction.id", treeGrid.getId(), true, "functionOrder");
        } else {
            Criterion cr = Restrictions.isNull((String)"tmFunction.id");
            functionList = this.findByCriteria(TmFunctionEntity.class, cr);
        }
        return this.treeGridModel(functionList);
    }

    private List<TreeGrid> treeGridModel(List<TmFunctionEntity> functionList) {
        ArrayList<TreeGrid> treeGrids = new ArrayList();
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setTextField("functionName");
        treeGridModel.setParentText("tmFunction_functionName");
        treeGridModel.setParentId("tmFunction_id");
        treeGridModel.setSrc("functionUrl");
        treeGridModel.setIdField("id");
        treeGridModel.setChildList("tmFunctionList");
        treeGridModel.setIcon("tmIcon_iconPath");
        treeGridModel.setOrder("functionOrder");
        treeGrids = this.treegrid(functionList, treeGridModel);
        return treeGrids;
    }

    @Override
    public List<ComboTree> getFunctionForComboTree(HttpServletRequest request, ComboTree comboTree) {
        String selfId = request.getParameter("selfId");
        List<Object> functionList = new ArrayList();
        if (StringUtil.isNotEmpty((String)selfId)) {
            functionList = this.findByProperty(TmFunctionEntity.class, "id", selfId);
        }
        if (StringUtil.isNotEmpty((String)comboTree.getId())) {
            functionList = this.findByProperty(TmFunctionEntity.class, "tmFunction.id", comboTree.getId());
        } else {
            Criterion cr = Restrictions.isNull((String)"tmFunction.id");
            functionList = this.findByCriteria(TmFunctionEntity.class, cr);
        }
        ArrayList<ComboTree> comboTrees = new ArrayList();
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "functionName", "tmFunctionList");
        comboTrees = this.comboTree(functionList, comboTreeModel, null, false);
        return comboTrees;
    }

    @Override
    public void deleteFunction(String functionId) throws Exception {
        try {
            TmFunctionEntity function = this.get(TmFunctionEntity.class, (Serializable)((Object)functionId));
            List<TmFunAuthEntity> funAuthList = this.findByProperty(TmFunAuthEntity.class, "tmFunction.id", functionId);
            this.deleteAllEntity(funAuthList);
            List<TmRoleFunctionEntity> roleFunList = this.findByProperty(TmRoleFunctionEntity.class, "tmFunction.id", functionId);
            this.deleteAllEntity(roleFunList);
            this.delete(function);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void saveFunction(TmFunctionVo tmFunctionVo) {
        TmFunctionEntity tmFunction = new TmFunctionVoToTmFunctionEntity(this).apply(tmFunctionVo);
        if (StringUtil.isNotEmpty((String)tmFunctionVo.getIconId())) {
            TmIconEntity iconEntity = this.get(TmIconEntity.class, (Serializable)((Object)tmFunctionVo.getIconId()));
            tmFunction.setTmIcon(iconEntity);
        }
        this.saveOrUpdate(tmFunction);
    }

    @Override
    public List<ComboTree> getAllFuncAndHandleCheck(HttpServletRequest request, ComboTree comboTree, String roleId) {
        String selfId = request.getParameter("selfId");
        List<Object> functionList = new ArrayList();
        ArrayList<TmFunctionEntity> inFunctionList = new ArrayList<TmFunctionEntity>();
        if (StringUtil.isNotEmpty((String)selfId)) {
            functionList = this.findByProperty(TmFunctionEntity.class, "id", selfId);
        }
        if (StringUtil.isNotEmpty((String)comboTree.getId())) {
            functionList = this.findByProperty(TmFunctionEntity.class, "tmFunction.id", comboTree.getId());
        } else {
            Criterion cr = Restrictions.isNull((String)"tmFunction.id");
            functionList = this.findByCriteria(TmFunctionEntity.class, cr);
        }
        List<TmRoleFunctionEntity> list = super.findByProperty(TmRoleFunctionEntity.class, "tmRole.id", roleId);
        if (list != null && list.size() > 0) {
            for (TmRoleFunctionEntity tmRoleFunctionEntity : list) {
                inFunctionList.add(tmRoleFunctionEntity.getTmFunction());
            }
        }
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "functionName", "tmFunctionList");
        List<ComboTree> comboTrees = super.comboTree(functionList, comboTreeModel, inFunctionList, true);
        return comboTrees;
    }

    @Override
    public List<TmOperationEntity> getOptByRoleFunc(String roleId, String funcId) {
        SimpleExpression roleCrt;
        List<TmOperationEntity> allOptByFuncs = this.findByProperty(TmOperationEntity.class, "tmFunction.id", funcId);
        SimpleExpression funcCrt = Restrictions.eq((String)"tmFunction.id", (Object)funcId);
        List<TmRoleFunctionEntity> tmRoleFunctions = this.findByCriteria(TmRoleFunctionEntity.class, new Criterion[]{funcCrt, roleCrt = Restrictions.eq((String)"tmRole.id", (Object)roleId)});
        if (tmRoleFunctions != null && tmRoleFunctions.size() > 0) {
            String operations = tmRoleFunctions.get(0).getOperation();
            if (allOptByFuncs.size() > 0) {
                for (TmOperationEntity tmOperationEntity : allOptByFuncs) {
                    if (StringUtil.isNotEmpty((String)operations) && operations.contains(tmOperationEntity.getId())) {
                        tmOperationEntity.setStatus(String.valueOf(Globals.User_Normal));
                        continue;
                    }
                    tmOperationEntity.setStatus(String.valueOf(Globals.User_Forbidden));
                }
            }
        }
        return allOptByFuncs;
    }

    @Override
    public void delExistFuncRole(String roleId, String funcIds) {
        SimpleExpression cr1 = Restrictions.eq((String)"tmRole.id", (Object)roleId);
        Criterion cr2 = Restrictions.not((Criterion)Restrictions.in((String)"tmFunction.id", (Object[])funcIds.split(",")));
        List<TmRoleFunctionEntity> functions = this.findByCriteria(TmRoleFunctionEntity.class, new Criterion[]{cr1, cr2});
        if (CollectionUtil.listNotEmptyNotSizeZero(functions)) {
            this.deleteAllEntity(functions);
        }
    }

    @Override
    public void setFuncRole(String roleId, String funcIds) {
        Criterion cr2;
        String alredyExistsFuncId = "";
        SimpleExpression cr1 = Restrictions.eq((String)"tmRole.id", (Object)roleId);
        List<TmRoleFunctionEntity> functions = this.findByCriteria(TmRoleFunctionEntity.class, new Criterion[]{cr1, cr2 = Restrictions.in((String)"tmFunction.id", (Object[])funcIds.split(","))});
        if (CollectionUtil.listNotEmptyNotSizeZero(functions)) {
            for (TmRoleFunctionEntity tmRoleFunctionEntity : functions) {
                if (StringUtil.isNotEmpty((String)alredyExistsFuncId)) {
                    alredyExistsFuncId = String.valueOf(alredyExistsFuncId) + ",";
                }
                alredyExistsFuncId = String.valueOf(alredyExistsFuncId) + tmRoleFunctionEntity.getTmFunction().getId();
            }
        }
        if (StringUtil.isNotEmpty((String)funcIds)) {
            String[] stringArray = funcIds.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String funcId = stringArray[n2];
                if (!StringUtil.isNotEmpty((String)alredyExistsFuncId) || !alredyExistsFuncId.contains(funcId)) {
                    TmRoleFunctionEntity roleFunctionEntity = new TmRoleFunctionEntity();
                    TmFunctionEntity tmFunction = new TmFunctionEntity();
                    tmFunction.setId(funcId);
                    roleFunctionEntity.setTmFunction(tmFunction);
                    TmRoleEntity roleEntity = new TmRoleEntity();
                    roleEntity.setId(roleId);
                    roleFunctionEntity.setTmRole(roleEntity);
                    this.save(roleFunctionEntity);
                }
                ++n2;
            }
        }
    }

    @Override
    public void setOperateByFuncRole(String opretionIds, String roleId, String funcId) {
        SimpleExpression funcCrt;
        SimpleExpression roleCrt = Restrictions.eq((String)"tmRole.id", (Object)roleId);
        List<TmRoleFunctionEntity> roleFuncs = this.findByCriteria(TmRoleFunctionEntity.class, new Criterion[]{roleCrt, funcCrt = Restrictions.eq((String)"tmFunction.id", (Object)funcId)});
        if (roleFuncs.size() == 0) {
            TmRoleFunctionEntity tmRoleFunctionEntity = new TmRoleFunctionEntity();
            TmFunctionEntity tmFunctionEntity = new TmFunctionEntity();
            tmFunctionEntity.setId(funcId);
            tmRoleFunctionEntity.setTmFunction(tmFunctionEntity);
            TmRoleEntity tmRoleEntity = new TmRoleEntity();
            tmRoleEntity.setId(roleId);
            tmRoleFunctionEntity.setTmRole(tmRoleEntity);
            tmRoleFunctionEntity.setOperation(opretionIds);
            this.save(tmRoleFunctionEntity);
        } else if (StringUtil.isNotEmpty(roleFuncs) && roleFuncs.size() > 0) {
            TmRoleFunctionEntity roleFunctionEntity = roleFuncs.get(0);
            roleFunctionEntity.setOperation(opretionIds);
            this.updateEntity(roleFunctionEntity);
        }
    }

    @Override
    public List<TmFunctionAuthVo> getAuthObjByFunc(String roleId, String funcId) {
        List<TmFunAuthEntity> allAuthByFunc = this.tmFunAuthService.getTmFunAuthList(funcId);
        List<TmFunAuthEntity> partAuthByFunc = this.tmFunAuthService.getTmFunAuthListByRoleFunc(roleId, funcId);
        List allAuthByFuncVos = Lists.transform(allAuthByFunc, (Function)new TmFuncAuthTransForm(partAuthByFunc));
        return allAuthByFuncVos;
    }

    @Override
    public void updateFuntionLevel() {
        String sql = "MERGE INTO TM_FUNCTION T1 USING ( SELECT  T.ID, LEVEL-1 AS LV FROM TM_FUNCTION T WHERE 1=1 AND T.FUNCTION_LEVEL<>LEVEL-1 START WITH T.PARENT_ID IS NULL CONNECT BY PRIOR T.ID = T.PARENT_ID) T2 ON (T1.ID=T2.ID) WHEN MATCHED THEN UPDATE SET T1.FUNCTION_LEVEL = T2.LV";
        this.executeSql(sql, new Object[0]);
    }
}

