/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.role.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.role.dao.TmRoleDao;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.biz.eisp.mdm.role.service.TmRoleExtendService;
import com.biz.eisp.mdm.role.service.TmRoleService;
import com.biz.eisp.mdm.role.transform.TmRoleEntityToTmRoleVo;
import com.biz.eisp.mdm.role.transform.TmRoleVoToTmRoleEntity;
import com.biz.eisp.mdm.role.vo.TmRoleVo;
import com.biz.eisp.mdm.web.pojo.ClientManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="roleService")
@Transactional
public class TmRoleServiceImpl
extends BaseServiceImpl
implements TmRoleService {
    @Autowired
    private TmRoleDao tmRoleDao;
    @Autowired(required=false)
    private TmRoleExtendService tmRoleExtendService;
    private static final int VALIDATE_ROLECODE = 0;
    private static final int VALIDATE_ROLENAME = 1;

    @Override
    public List<TmRoleEntity> getRoleListByCurrentPosId(TmRoleVo tmRole, Page page) throws BusinessException {
        return this.tmRoleDao.getRoleListByCurrentPosId(tmRole, page);
    }

    @Override
    public List<TmRoleEntity> findPage(Page page, TmRoleEntity tmRole) {
        StringBuffer hql = new StringBuffer("from TmRoleEntity t");
        List<TmRoleEntity> list = null;
        if (tmRole == null) {
            list = this.findByHql(hql.toString(), page, new Object[0]);
        } else {
            hql.append(" where t.roleCode like ? and t.roleName like ?");
            String code = tmRole.getRoleCode();
            String name = tmRole.getRoleName();
            Object[] obj = new Object[]{code != null && !code.equals("undefind") ? "%" + tmRole.getRoleCode().trim() + "%" : "%%", name != null && !name.equals("undefind") ? "%" + tmRole.getRoleName().trim() + "%" : "%%"};
            list = this.findByHql(hql.toString(), page, obj);
        }
        return list;
    }

    @Override
    public void createTmRole(TmRoleVo tmRoleVo, Page page) {
        TmRoleEntity tmRoleEntity = null;
        if (StringUtil.isNotEmpty(this.tmRoleExtendService)) {
            try {
                this.tmRoleExtendService.validate(tmRoleVo, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25:" + e.getMessage());
            }
            tmRoleEntity = this.tmRoleExtendService.saveBefore(tmRoleVo, page);
        }
        if (StringUtil.isEmpty(tmRoleEntity)) {
            tmRoleEntity = new TmRoleVoToTmRoleEntity(this).apply(tmRoleVo);
        }
        if (StringUtil.isNotEmpty(this.tmRoleExtendService)) {
            tmRoleEntity = this.tmRoleExtendService.saveBefore(tmRoleEntity, tmRoleVo, page);
        }
        this.saveOrUpdate(tmRoleEntity);
        if (StringUtil.isNotEmpty(this.tmRoleExtendService)) {
            tmRoleEntity = this.tmRoleExtendService.savePost(tmRoleEntity, tmRoleVo, page);
        }
    }

    @Override
    public boolean deleteTmRole(String id) {
        TmRoleEntity roleEntity = this.get(TmRoleEntity.class, (Serializable)((Object)id));
        if (StringUtil.isNotEmpty(roleEntity)) {
            if (Globals.Admin_Name.equalsIgnoreCase(roleEntity.getRoleName())) {
                return false;
            }
        } else {
            return false;
        }
        super.deleteEntityById(TmRoleEntity.class, (Serializable)((Object)id));
        return true;
    }

    @Override
    public Map<String, String> updateTmRole(TmRoleEntity tmRole) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<TmRoleEntity> li1 = this.validate(0, tmRole.getRoleCode());
        if (li1.size() == 0 || li1.get(0).getId().equals(tmRole.getId())) {
            li1 = this.validate(1, tmRole.getRoleName());
            if (li1.size() == 0 || li1.get(0).getId().equals(tmRole.getId())) {
                TmRoleEntity role = super.get(TmRoleEntity.class, (Serializable)((Object)tmRole.getId()));
                role.setRoleCode(tmRole.getRoleCode());
                role.setRoleName(tmRole.getRoleName());
                role.setUpdateDate(new Date());
                ClientManager client = ClientManager.getInstance();
                String name = client.getClient().getUser().getUserName();
                role.setUpdateName(name);
                super.updateEntity(role);
                map.put("success", "true");
            } else {
                map.put("success", "false");
                map.put("msg", "\u89d2\u8272\u540d\u79f0\u91cd\u590d");
            }
        } else {
            map.put("success", "false");
            map.put("msg", "\u89d2\u8272\u7f16\u7801\u91cd\u590d");
        }
        return map;
    }

    public List<TmRoleEntity> validate(int flag, String str) {
        String hql = null;
        Object[] obj = new Object[]{str};
        if (flag == 1) {
            hql = "from TmRoleEntity t where t.roleName = ?";
        } else if (flag == 0) {
            hql = "from TmRoleEntity t where t.roleCode = ?";
        }
        return super.findByHql(hql, obj);
    }

    @Override
    public ValidForm validateTmRoleForm(TmRoleEntity tmRole) {
        ValidForm validForm = new ValidForm();
        String hql = null;
        if (StringUtil.isEmpty(tmRole.getId())) {
            if (StringUtil.isNotEmpty((String)tmRole.getRoleCode())) {
                hql = "from TmRoleEntity t where t.roleCode = ?";
                if (!CollectionUtils.isEmpty(super.findByHql(hql, tmRole.getRoleCode()))) {
                    validForm.setInfo("\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728");
                    validForm.setStatus("n");
                }
            }
            if (StringUtil.isNotEmpty((String)tmRole.getRoleName())) {
                hql = "from TmRoleEntity t where t.roleName = ?";
                if (!CollectionUtils.isEmpty(super.findByHql(hql, tmRole.getRoleName()))) {
                    validForm.setInfo("\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728");
                    validForm.setStatus("n");
                }
            }
        } else {
            if (StringUtil.isNotEmpty((String)tmRole.getRoleCode())) {
                hql = "from TmRoleEntity t where t.roleCode = ? and id <> ?";
                if (!CollectionUtils.isEmpty(super.findByHql(hql, tmRole.getRoleCode(), tmRole.getId()))) {
                    validForm.setInfo("\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728");
                    validForm.setStatus("n");
                }
            }
            if (StringUtil.isNotEmpty((String)tmRole.getRoleName())) {
                hql = "from TmRoleEntity t where t.roleName = ? and id <> ?";
                if (!CollectionUtils.isEmpty(super.findByHql(hql, tmRole.getRoleName(), tmRole.getId()))) {
                    validForm.setInfo("\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728");
                    validForm.setStatus("n");
                }
            }
        }
        return validForm;
    }

    @Override
    public List<TmRoleVo> findTmRoleByPostionId(String positionId) {
        String sql = "select t1.* from tm_role t1 where t1.id in (select t2.role_id from tm_r_position_role t2 where t2.position_id = ?)";
        List<TmRoleEntity> roles = this.findBySql(TmRoleEntity.class, sql, positionId);
        ArrayList<TmRoleVo> result = new ArrayList<TmRoleVo>();
        for (TmRoleEntity e : roles) {
            TmRoleVo v = new TmRoleEntityToTmRoleVo().apply(e);
            result.add(v);
        }
        return result;
    }
}

