/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.entity.TaRejectReadEntity;
import com.biz.eisp.activiti.runtime.dao.TaTaskDao;
import com.biz.eisp.activiti.runtime.entity.TaAttachmentEntity;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjEntity;
import com.biz.eisp.activiti.runtime.entity.TaRuntimeStatusEntity;
import com.biz.eisp.activiti.runtime.service.TaAttachmentService;
import com.biz.eisp.activiti.runtime.service.TaBaseBusinessObjService;
import com.biz.eisp.activiti.runtime.service.TaRejectRecordService;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.transformer.HistoricTaskInstanceToHistoryTaskVo;
import com.biz.eisp.activiti.runtime.vo.BusinessFormVo;
import com.biz.eisp.activiti.runtime.vo.CommentVo;
import com.biz.eisp.activiti.runtime.vo.HistoryTaskVo;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.activiti.runtime.vo.OperationVo;
import com.biz.eisp.activiti.runtime.vo.TaAttachmentVo;
import com.biz.eisp.activiti.util.CommentUtil;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.utils.DateUtils;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taTaskService")
@Transactional
public class TaTaskServiceImpl
extends BaseServiceImpl
implements TaTaskService {
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private HistoryService historyService;
    @Autowired(required=false)
    private RepositoryService repositoryService;
    @Autowired
    private TaProcessNodeService taProcessNodeService;
    @Autowired
    private TaBaseBusinessObjService taBaseBusinessObjService;
    @Autowired
    private TaTaskDao taTaskDao;
    @Autowired
    private TaRejectRecordService taRejectRecordService;
    @Autowired
    private TaAttachmentService taAttachmentService;

    @Override
    public List<MyTaskVo> findMyTaskList(MyTaskVo myTaskVo, Page page) {
        List<MyTaskVo> myTaskVoList = this.taTaskDao.findMyTaskList(myTaskVo, page);
        return myTaskVoList;
    }

    @Override
    public String getBusinessObjIdByTask(Task task) {
        String businessKey = "";
        HistoricProcessInstance hiproins = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(this.getProcessInstanceId(task.getId())).singleResult();
        if (hiproins != null) {
            if (hiproins.getSuperProcessInstanceId() != null && hiproins.getBusinessKey() == null) {
                hiproins = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(hiproins.getSuperProcessInstanceId()).singleResult();
                businessKey = hiproins.getBusinessKey();
            } else {
                businessKey = hiproins.getBusinessKey();
            }
        }
        return businessKey;
    }

    public String getBusinessObjIdByTaskId(String taskId) {
        String businessKey = "";
        HistoricProcessInstance hiproins = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(this.getProcessInstanceId(taskId)).singleResult();
        if (hiproins != null) {
            if (hiproins.getSuperProcessInstanceId() != null && hiproins.getBusinessKey() == null) {
                hiproins = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(hiproins.getSuperProcessInstanceId()).singleResult();
                businessKey = hiproins.getBusinessKey();
            } else {
                businessKey = hiproins.getBusinessKey();
            }
        }
        return businessKey;
    }

    public ProcessDefinition getProcessDefinition(String processDefinitionId) {
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
    }

    @Override
    public Task getTask(String taskId) {
        return (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
    }

    public String getBusinessObjIdByTask(String taskId) {
        Task task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        return this.getBusinessObjIdByTask(task);
    }

    public List<String> highLight(String processInstanceId) {
        ArrayList<String> highLihth = new ArrayList<String>();
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).list();
        for (Execution execution : executions) {
            ExecutionEntity entity = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(execution.getId()).singleResult();
            highLihth.add(entity.getActivityId());
        }
        return highLihth;
    }

    @Override
    public void saveClaim(MyTaskVo myTaskVo) {
        this.taskService.claim(myTaskVo.getTaskId(), ResourceUtil.getSessionUserName().getUserName());
    }

    @Override
    public void saveComplete(MyTaskVo myTaskVo) {
        this.taskService.complete(myTaskVo.getTaskId());
    }

    @Override
    public void saveCompelte(OperationVo operationVo) {
        Task task = this.getTask(operationVo.getTaskId());
        String detailComment = CommentUtil.buildPassComment(task.getName(), ResourceUtil.getCreateName(), operationVo.getComment());
        this.taskService.addComment(operationVo.getTaskId(), operationVo.getProcessInstanceId(), detailComment);
        this.taskService.setVariableLocal(operationVo.getTaskId(), "approveOpt", (Object)"pass");
        this.runtimeService.setVariableLocal(task.getExecutionId(), "approveOpt", (Object)"pass");
        this.taskService.setOwner(operationVo.getTaskId(), ResourceUtil.getCurrPosition().getPositionCode());
        this.taskService.complete(operationVo.getTaskId());
        if (this.isLastTask(operationVo.getProcessInstanceId())) {
            this.taBaseBusinessObjService.updateBaseBusinessObjRuntimeStatusByProcessInstanceId(operationVo.getProcessInstanceId(), WorkFlowGlobals.RUNTIME_STATUS_COMPLETED);
        }
    }

    @Override
    public boolean isLastTask(String processInstanceId) {
        List list = this.historyService.createHistoricProcessInstanceQuery().finished().processInstanceId(processInstanceId).list();
        return list != null && list.size() == 1;
    }

    @Override
    public boolean hasRejectNodes(String taskId, String processInstanceId) {
        List backTaskIdlist = (List)this.taskService.getVariable(taskId, "backTaskIds");
        return backTaskIdlist != null && backTaskIdlist.size() != 0;
    }

    @Override
    public void saveReject(OperationVo operationVo) {
        List backTaskIdlist = (List)this.taskService.getVariable(operationVo.getTaskId(), "backTaskIds");
        Task task = this.getTask(operationVo.getTaskId());
        if (backTaskIdlist == null || backTaskIdlist.size() == 0) {
            throw new BusinessException("\u524d\u9762\u4efb\u52a1\u8282\u70b9\uff0c\u90fd\u6ca1\u6709\u914d\u7f6e\u9a73\u56de\uff0c\u4e0d\u80fd\u8fdb\u884c\u9a73\u56de\u4e0a\u4e00\u7ea7\u64cd\u4f5c");
        }
        String detailComment = CommentUtil.buildRejectPreComment(task.getName(), ResourceUtil.getCreateName(), operationVo.getComment());
        this.taskService.addComment(operationVo.getTaskId(), operationVo.getProcessInstanceId(), detailComment);
        this.taskService.setOwner(operationVo.getTaskId(), ResourceUtil.getCurrPosition().getPositionCode());
        String targetTaskKey = (String)((Map)backTaskIdlist.get(backTaskIdlist.size() - 1)).get("id");
        backTaskIdlist.remove(backTaskIdlist.size() - 1);
        this.taskService.setVariable(operationVo.getTaskId(), "backTaskIds", (Object)backTaskIdlist);
        this.goProcessTaskNode(operationVo.getTaskId(), targetTaskKey, null);
    }

    @Override
    public void saveRejectToApply(OperationVo operationVo) {
        Task task = this.getTask(operationVo.getTaskId());
        String detailComment = CommentUtil.buildRejectApplyComment(task.getName(), ResourceUtil.getCreateName(), operationVo.getComment());
        this.taskService.addComment(operationVo.getTaskId(), operationVo.getProcessInstanceId(), detailComment);
        this.taskService.setOwner(operationVo.getTaskId(), ResourceUtil.getCurrPosition().getPositionCode());
        this.taRejectRecordService.saveTaRejectRecord(operationVo.getProcessInstanceId());
        String USER_SELECT_TASK_NODE = "end";
        this.goProcessTaskNode(operationVo.getTaskId(), USER_SELECT_TASK_NODE, null);
        this.taBaseBusinessObjService.updateBaseBusinessObjRuntimeStatusByProcessInstanceId(operationVo.getProcessInstanceId(), WorkFlowGlobals.RUNTIME_STATUS_REJECT);
    }

    @Override
    public void saveRead(OperationVo operationVo) {
        TaRejectReadEntity entity = new TaRejectReadEntity();
        entity.setProcessInstanceId(operationVo.getProcessInstanceId());
        this.save(entity);
    }

    @Override
    public List<HistoryTaskVo> findMyHistoryTaskList(HistoryTaskVo historyTaskVo, Page page) {
        List<HistoryTaskVo> historyTaskVoList = this.taTaskDao.findMyHistoryTaskList(historyTaskVo, page);
        this.calSpendTimes(historyTaskVoList);
        return historyTaskVoList;
    }

    private void calSpendTimes(List<HistoryTaskVo> historyTaskVoList) {
        if (historyTaskVoList != null) {
            for (HistoryTaskVo vo : historyTaskVoList) {
                vo.setSpendTimes(DateUtils.calSpendTimes(vo.getStartTime(), vo.getEndTime()));
            }
        }
    }

    @Override
    public String getProcessInstanceId(String taskId) {
        Task task = this.getTask(taskId);
        if (task == null) {
            List hiTaskList = this.historyService.createHistoricTaskInstanceQuery().taskId(taskId).list();
            if (hiTaskList != null && hiTaskList.size() > 0) {
                return ((HistoricTaskInstance)hiTaskList.get(0)).getProcessInstanceId();
            }
            throw new BusinessException("\u4efb\u52a1ID\uff08taskId\uff09:" + taskId + "\u4e0d\u5b58\u5728");
        }
        return task.getProcessInstanceId();
    }

    @Override
    public List<HistoryTaskVo> findProcessInstanceTaskHistoryList(HistoryTaskVo historyTaskVo, Page page) {
        String processInstanceId = historyTaskVo.getProcessInstanceId();
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            throw new BusinessException("\u6d41\u7a0b\u5b9e\u4f8bID\uff08processInstanceId\uff09\u4e3a\u7a7a");
        }
        List historicTaskInstanceList = this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId).list();
        List voList = Lists.transform((List)historicTaskInstanceList, (Function)new HistoricTaskInstanceToHistoryTaskVo());
        return voList;
    }

    @Override
    public String getTaskBusinessForm(String taskId) {
        BusinessFormVo vo = this.taTaskDao.getBusinessForm(taskId);
        return String.valueOf(vo.getModelandview()) + "&businessObjId=" + vo.getBusinessObjId();
    }

    @Override
    public String getProcessInstanceBusinessForm(String processInstanceId) {
        BusinessFormVo vo = this.taTaskDao.getBusinessFormByProcessInstanceId(processInstanceId);
        return String.valueOf(vo.getModelandview()) + "&businessObjId=" + vo.getBusinessObjId();
    }

    @Override
    public List<CommentVo> findActHiCommentEntity(String processInstanceId) {
        List<CommentVo> voList = this.taTaskDao.findProcessInstanceCommentList(processInstanceId, null);
        for (CommentVo vo : voList) {
            List<TaAttachmentVo> list = this.taAttachmentService.findAttachmentList(vo.getTaskId());
            vo.setAttachmentList(list);
        }
        return voList;
    }

    @Override
    public List<CommentVo> findActHiCommentByBusinessKey(String businessKey) {
        List<CommentVo> result = this.taTaskDao.findProcessInstanceCommentByBusinessKey(businessKey);
        for (CommentVo vo : result) {
            List<TaAttachmentVo> list = this.taAttachmentService.findAttachmentList(vo.getTaskId());
            vo.setAttachmentList(list);
        }
        return result;
    }

    @Override
    public List<TaAttachmentEntity> findAttachmentList(String taskId) {
        List<TaAttachmentEntity> list = this.findByProperty(TaAttachmentEntity.class, "taskId", taskId);
        return list;
    }

    @Override
    public void reassign(MyTaskVo myTaskVo, String reassignComment, String reassignPositionCode) {
        String taskId = myTaskVo.getTaskId();
        Task task = this.getTask(taskId);
        TmPositionVo positionVo = ResourceUtil.getCurrPosition();
        this.taskService.addComment(taskId, task.getProcessInstanceId(), CommentUtil.buildReassignComment(task.getName(), ResourceUtil.getCreateName(), reassignComment));
        this.taskService.setVariableLocal(taskId, "approveOpt", (Object)"reassign");
        this.taskService.setOwner(taskId, positionVo.getPositionCode());
        this.taskService.setAssignee(taskId, reassignPositionCode);
    }

    @Override
    public void complete(String taskId, Map<String, Object> map) {
        try {
            String businessObjId = this.getBusinessObjIdByTask(taskId);
            String USER_SELECT_TASK_NODE = OConvertUtils.getString(map.get(WorkFlowGlobals.USER_SELECT_TASK_NODE));
            this.goProcessTaskNode(taskId, USER_SELECT_TASK_NODE, map);
            List list = this.historyService.createHistoricProcessInstanceQuery().finished().processInstanceBusinessKey(businessObjId).list();
            if (list != null && list.size() == 1) {
                TaRuntimeStatusEntity r = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code", "completed");
                TaBaseBusinessObjEntity obj = this.get(TaBaseBusinessObjEntity.class, (Serializable)((Object)businessObjId));
                obj.setTaRuntimeStatusEntity(r);
                this.updateEntity(obj);
            }
        }
        catch (ActivitiException e) {
            if (e.getMessage().indexOf("no processes deployed with key") != -1) {
                e.printStackTrace();
            } else {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void goProcessTaskNode(String taskId, String activityId, Map<String, Object> variables) {
        try {
            List<Task> taskList = this.findTaskListByKey(this.findProcessInstanceByTaskId(taskId).getId(), this.findTaskById(taskId).getTaskDefinitionKey());
            for (Task task : taskList) {
                this.commitProcess(task.getId(), variables, activityId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void commitProcess(String taskId, Map<String, Object> variables, String taskDefinitionKey) throws Exception {
        if (OConvertUtils.isEmpty(taskDefinitionKey)) {
            this.taskService.complete(taskId, variables);
        } else {
            this.turnTransition(taskId, taskDefinitionKey, variables);
        }
    }

    private void turnTransition(String taskId, String taskDefinitionKey, Map<String, Object> variables) throws Exception {
        ActivityImpl currActivity = this.findActivitiImpl(taskId, null);
        List<PvmTransition> oriPvmTransitionList = this.clearTransition(currActivity);
        TransitionImpl newTransition = currActivity.createOutgoingTransition();
        ActivityImpl pointActivity = this.findActivitiImpl(taskId, taskDefinitionKey);
        newTransition.setDestination(pointActivity);
        this.taskService.complete(taskId, variables);
        pointActivity.getIncomingTransitions().remove(newTransition);
        this.restoreTransition(currActivity, oriPvmTransitionList);
    }

    private List<PvmTransition> clearTransition(ActivityImpl activityImpl) {
        ArrayList<PvmTransition> oriPvmTransitionList = new ArrayList<PvmTransition>();
        List pvmTransitionList = activityImpl.getOutgoingTransitions();
        for (PvmTransition pvmTransition : pvmTransitionList) {
            oriPvmTransitionList.add(pvmTransition);
        }
        pvmTransitionList.clear();
        return oriPvmTransitionList;
    }

    private void restoreTransition(ActivityImpl activityImpl, List<PvmTransition> oriPvmTransitionList) {
        List pvmTransitionList = activityImpl.getOutgoingTransitions();
        pvmTransitionList.clear();
        for (PvmTransition pvmTransition : oriPvmTransitionList) {
            pvmTransitionList.add(pvmTransition);
        }
    }

    public ProcessDefinitionEntity findProcessDefinitionEntityByTaskId(String taskId) throws Exception {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(this.findTaskById(taskId).getProcessDefinitionId());
        if (processDefinition == null) {
            throw new Exception("\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230!");
        }
        return processDefinition;
    }

    private ActivityImpl findActivitiImpl(String taskId, String activityId) throws Exception {
        ActivityImpl activityImpl2;
        ProcessDefinitionEntity processDefinition = this.findProcessDefinitionEntityByTaskId(taskId);
        if (StringUtils.isEmpty((CharSequence)activityId)) {
            activityId = this.findTaskById(taskId).getTaskDefinitionKey();
        }
        if (activityId.toUpperCase().equals("END")) {
            for (ActivityImpl activityImpl2 : processDefinition.getActivities()) {
                List pvmTransitionList = activityImpl2.getOutgoingTransitions();
                if (!pvmTransitionList.isEmpty()) continue;
                return activityImpl2;
            }
        }
        activityImpl2 = processDefinition.findActivity(activityId);
        return activityImpl2;
    }

    private List<Task> findTaskListByKey(String processInstanceId, String key) {
        return this.taskService.createTaskQuery().processInstanceId(processInstanceId).taskDefinitionKey(key).list();
    }

    public ProcessInstance findProcessInstanceByTaskId(String taskId) throws Exception {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(this.findTaskById(taskId).getProcessInstanceId()).singleResult();
        if (processInstance == null) {
            throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u672a\u627e\u5230!");
        }
        return processInstance;
    }

    private TaskEntity findTaskById(String taskId) throws Exception {
        TaskEntity task = (TaskEntity)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        if (task == null) {
            throw new Exception("\u4efb\u52a1\u5b9e\u4f8b\u672a\u627e\u5230!");
        }
        return task;
    }

    @Override
    public List<MyTaskVo> findMyRejectTaskList(MyTaskVo myTaskVo, Page page) {
        List<MyTaskVo> voList = this.taTaskDao.findMyRejectTaskList(myTaskVo, page);
        return voList;
    }
}

