/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.controller;

import com.biz.eisp.activiti.runtime.entity.TaAttachmentEntity;
import com.biz.eisp.activiti.runtime.service.TaAttachmentService;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.activiti.runtime.vo.TaAttachmentVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.ReflectHelper;
import com.biz.eisp.base.core.entity.TbAttachmentEntity;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.base.utils.MyClassLoader;
import com.biz.eisp.base.utils.UploadFile;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/taAttachmentController"})
public class TaAttachmentController
extends BaseController {
    @Autowired
    private TaAttachmentService taAttachmentService;

    @RequestMapping(params={"saveFiles"})
    @ResponseBody
    public AjaxJson saveFiles(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        try {
            String taskId = request.getParameter("taskId");
            TaAttachmentEntity ta = new TaAttachmentEntity();
            ta.setTaskId(taskId);
            UploadFile uploadFile = new UploadFile(request, ta);
            ta.setSubclassName(TaAttachmentEntity.class.getName());
            uploadFile.setCusPath("resources/upload");
            uploadFile.setExtend("extend");
            uploadFile.setTitleField("attachmentTitle");
            uploadFile.setRealPath("realPath");
            uploadFile.setObject(ta);
            uploadFile.setRename(true);
            this.taAttachmentService.uploadFile(uploadFile, null, null);
            List<TaAttachmentVo> myAttachmentList = this.taAttachmentService.findAttachmentList(taskId);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("url", ta.getRealPath());
            attributes.put("fileKey", ta.getId());
            attributes.put("name", ta.getAttachmentTitle());
            attributes.put("delurl", "taTaskController.do?delObjFile&fileKey=" + ta.getId());
            attributes.put("myAttachmentList", myAttachmentList);
            j.setAttributes(attributes);
            j.setMsg("\u6587\u4ef6\u6dfb\u52a0\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"delObjFile"})
    @ResponseBody
    public AjaxJson delObjFile(HttpServletRequest request) {
        String message = null;
        AjaxJson j = new AjaxJson();
        try {
            String fileKey = OConvertUtils.getString(request.getParameter("fileKey"));
            TbAttachmentEntity attachment = this.taAttachmentService.get(TbAttachmentEntity.class, (Serializable)((Object)fileKey));
            String subclassname = attachment.getSubclassName();
            Object objfile = this.taAttachmentService.get(MyClassLoader.getClassByScn(subclassname), (Serializable)((Object)attachment.getId()));
            message = attachment.getAttachmentTitle() + "\u5220\u9664\u6210\u529f";
            this.taAttachmentService.delete(objfile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"viewFile"})
    public void viewFile(HttpServletRequest request, HttpServletResponse response) {
        String fileid = OConvertUtils.getString(request.getParameter("fileid"));
        String subclassname = OConvertUtils.getString(request.getParameter("subclassName"), "com.biz.eisp.base.core.entity.TbAttachmentEntity");
        Class fileClass = MyClassLoader.getClassByScn(subclassname);
        Object fileobj = this.taAttachmentService.get(fileClass, (Serializable)((Object)fileid));
        ReflectHelper reflectHelper = new ReflectHelper(fileobj);
        UploadFile uploadFile = new UploadFile(request, response);
        String contentfield = OConvertUtils.getString(request.getParameter("contentfield"), uploadFile.getByteField());
        byte[] content = (byte[])reflectHelper.getMethodValue(contentfield);
        String path = OConvertUtils.getString(reflectHelper.getMethodValue("realPath"));
        String extend = OConvertUtils.getString(reflectHelper.getMethodValue("extend"));
        String attachmenttitle = OConvertUtils.getString(reflectHelper.getMethodValue("attachmentTitle"));
        uploadFile.setExtend(extend);
        uploadFile.setTitleField(attachmenttitle);
        uploadFile.setRealPath(path);
        uploadFile.setContent(content);
        this.taAttachmentService.viewOrDownloadFile(uploadFile);
    }

    @RequestMapping(params={"findAttachmentList"})
    @ResponseBody
    public DataGrid findAttachmentList(MyTaskVo myTaskVo, HttpServletRequest request, HttpServletResponse response) {
        List<TaAttachmentVo> taskList = this.taAttachmentService.findAttachmentList(myTaskVo.getTaskId());
        return new DataGrid(taskList, null);
    }
}

