/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.exception;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.log.EispLog;
import com.biz.eisp.base.common.util.StringUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

public class GlobalExceptionResolver
implements HandlerExceptionResolver {
    @Autowired
    private EispLog eispLog;
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionResolver.class);
    private static final int WIRTE_DB_MAX_LENGTH = 1500;
    private static final short LOG_LEVEL = 6;
    private static final short LOG_OPT = 3;

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        boolean isajax = this.isAjax(request, response);
        Throwable deepestException = this.deepestException(ex);
        return this.processException(request, response, handler, deepestException, isajax);
    }

    private boolean isAjax(HttpServletRequest request, HttpServletResponse response) {
        return StringUtil.isNotEmpty((String)request.getHeader("X-Requested-With"));
    }

    private Throwable deepestException(Throwable e) {
        Throwable tmp = e;
        int breakPoint = 0;
        while (tmp.getCause() != null) {
            if (tmp.equals(tmp.getCause())) break;
            tmp = tmp.getCause();
            if (++breakPoint > 1000) break;
        }
        return tmp;
    }

    private ModelAndView processException(HttpServletRequest request, HttpServletResponse response, Object handler, Throwable ex, boolean isajax) {
        log.error("\u5168\u5c40\u5904\u7406\u5f02\u5e38\u6355\u83b7:", ex);
        this.logDb(ex);
        if (isajax) {
            return this.processAjax(request, response, handler, ex);
        }
        return this.processNotAjax(request, response, handler, ex);
    }

    private void logDb(Throwable ex) {
        String exceptionMessage = "\u9519\u8bef\u5f02\u5e38: " + ex.getClass().getSimpleName() + ",\u9519\u8bef\u63cf\u8ff0\uff1a" + ex.getMessage();
        if (StringUtil.isNotEmpty((String)exceptionMessage) && exceptionMessage.length() > 1500) {
            exceptionMessage = exceptionMessage.substring(0, 1500);
        }
        this.eispLog.addLog(exceptionMessage, (short)6, (short)3);
    }

    private ModelAndView processAjax(HttpServletRequest request, HttpServletResponse response, Object handler, Throwable deepestException) {
        ModelAndView empty = new ModelAndView();
        response.setHeader("Cache-Control", "no-store");
        JSONObject obj = new JSONObject();
        obj.put("success", (Object)true);
        obj.put("msg", (Object)deepestException.getMessage());
        try {
            PrintWriter pw = response.getWriter();
            pw.write(obj.toJSONString());
            pw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        empty.clear();
        return empty;
    }

    private ModelAndView processNotAjax(HttpServletRequest request, HttpServletResponse response, Object handler, Throwable ex) {
        String exceptionMessage = this.getThrowableMessage(ex);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("exceptionMessage", exceptionMessage);
        model.put("ex", ex);
        return new ModelAndView("common/error", model);
    }

    public String getThrowableMessage(Throwable ex) {
        return ex.getMessage();
    }
}

