/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.customer.transformer;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.generatednum.num.util.TbNumRuleProvider;
import com.biz.eisp.log.vo.OperationType;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.customer.entity.TmRCustPosBGEntity;
import com.biz.eisp.mdm.customer.service.TmCustomerService;
import com.biz.eisp.mdm.customer.util.ValidateUtil;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.google.common.base.Function;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TmCustomerVoToTmCustomerEntity
implements Function<TmCustomerVo, TmCustomerEntity> {
    private TmCustomerService tmCustomerService;

    public TmCustomerVoToTmCustomerEntity(TmCustomerService tmCustomerService) {
        this.tmCustomerService = tmCustomerService;
    }

    public TmCustomerEntity apply(TmCustomerVo input) {
        TmCustomerEntity tmCustomerEntity = null;
        if (StringUtil.isNotEmpty((String)input.getId())) {
            tmCustomerEntity = this.tmCustomerService.get(TmCustomerEntity.class, (Serializable)((Object)input.getId()));
        } else {
            if (StringUtil.isEmpty(input.getCustomerName())) {
                throw new BusinessException("\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a");
            }
            List list = this.tmCustomerService.findByHql("from TmCustomerEntity where customerName=? ", input.getCustomerName());
            if (list != null && list.size() > 0) {
                throw new BusinessException("\u5ba2\u6237\u540d\u79f0" + input.getCustomerName() + "\u5df2\u5b58\u5728");
            }
            tmCustomerEntity = new TmCustomerEntity();
            TbNumRuleProvider tbNumRuleProvider = (TbNumRuleProvider)ApplicationContextUtils.getContext().getBean("tbNumRuleProvider");
            String customerCode = tbNumRuleProvider.getMaxNum("customer");
            tmCustomerEntity.setCustomerCode(customerCode);
            input.setCustomerCode(customerCode);
            tmCustomerEntity.setEnableStatus(0);
        }
        if (ValidateUtil.validateName(input.getCustomerName(), "[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]")) {
            throw new BusinessException("\u68c0\u6d4b\u5230\u5ba2\u6237\u540d\u79f0[" + input.getCustomerName() + "]\u5305\u542b\u975e\u6cd5\u5b57\u7b26");
        }
        if (StringUtil.isNotEmpty((String)input.getErpCode()) && !ValidateUtil.validateName(input.getErpCode(), "[a-z0-9A-Z]")) {
            throw new BusinessException("\u68c0\u6d4b\u5230\u5ba2\u6237ERP\u7f16\u7801\u5305\u542b\u975e\u6cd5\u5b57\u7b26:" + input.getErpCode() + "\uff0c\u53ea\u80fd\u4e3a\u6570\u5b57\u548c\u5b57\u6bcd");
        }
        try {
            this.copyProperties(input, tmCustomerEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (StringUtil.isNotEmpty((String)input.getOrgId())) {
            TmOrgEntity tmOrg = null;
            if (StringUtil.isNotEmpty((String)input.getOrgId())) {
                tmOrg = this.tmCustomerService.get(TmOrgEntity.class, (Serializable)((Object)input.getOrgId()));
            }
            if (tmOrg == null) {
                String org = StringUtil.isNotEmpty((String)input.getOrgId()) ? input.getOrgId() : input.getOrgName();
                throw new BusinessException("\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f[" + org + "]\u4e0d\u5b58\u5728");
            }
            tmCustomerEntity.setTmOrg(tmOrg);
        }
        if (StringUtil.isNotEmpty((String)input.getCustomerOrgId())) {
            TmCustomerOrgEntity customerOrg = null;
            if (StringUtil.isNotEmpty((String)input.getCustomerOrgId())) {
                customerOrg = this.tmCustomerService.get(TmCustomerOrgEntity.class, (Serializable)((Object)input.getCustomerOrgId()));
            }
            if (customerOrg == null) {
                String custOrg = StringUtil.isNotEmpty((String)input.getCustomerOrgId()) ? input.getCustomerOrgId() : input.getCustomerOrgName();
                throw new BusinessException("\u5ba2\u6237\u7ec4\u7ec7\u4fe1\u606f[" + custOrg + "]\u4e0d\u5b58\u5728");
            }
            tmCustomerEntity.setTmCustomerOrg(customerOrg);
        }
        tmCustomerEntity.setTmRCustPosBGList(this.getTmRCustPosBGList(tmCustomerEntity, input));
        return tmCustomerEntity;
    }

    public List<TmRCustPosBGEntity> getTmRCustPosBGList(TmCustomerEntity customerEntity, TmCustomerVo input) {
        ArrayList<TmRCustPosBGEntity> custPostList = new ArrayList<TmRCustPosBGEntity>();
        String relationIndex = input.getRelationIndex();
        String positionIds = input.getPositionIds();
        String[] indexs = new String[]{};
        if (StringUtil.isNotEmpty((String)relationIndex)) {
            indexs = relationIndex.split(",");
        } else if (StringUtil.isNotEmpty((String)positionIds)) {
            indexs = positionIds.split(",");
        }
        String[] ids = new String[indexs.length];
        if (StringUtil.isNotEmpty((String)positionIds)) {
            ids = positionIds.split(",");
        }
        String custPost = input.getCustPostId();
        String[] custPostIds = new String[indexs.length];
        if (StringUtil.isNotEmpty((String)custPost)) {
            custPostIds = custPost.split(",");
        }
        int i = 0;
        while (i < indexs.length) {
            TmRCustPosBGEntity tmCustPostEntity = new TmRCustPosBGEntity();
            String positionId = "";
            if (ids.length > i) {
                positionId = ids[i];
            }
            String custPostId = "";
            if (custPostIds.length > i) {
                custPostId = custPostIds[i];
            }
            if (StringUtil.isNotEmpty((String)custPostId)) {
                tmCustPostEntity = this.tmCustomerService.get(TmRCustPosBGEntity.class, (Serializable)((Object)custPostId));
                String oldPositionId = tmCustPostEntity.getTmPosition().getId();
                if (StringUtil.isNotEmpty((String)positionId)) {
                    TmPositionEntity positionEntity = null;
                    if (StringUtil.isNotEmpty((String)positionId)) {
                        positionEntity = this.tmCustomerService.get(TmPositionEntity.class, (Serializable)((Object)positionId));
                        if (positionEntity == null) {
                            positionEntity = this.tmCustomerService.findUniqueByProperty(TmPositionEntity.class, "positionCode", positionId);
                        }
                        if (positionEntity == null) {
                            throw new BusinessException("\u804c\u4f4d\u4fe1\u606f[" + positionId + "]\u4e0d\u5b58\u5728");
                        }
                        tmCustPostEntity.setTmPosition(positionEntity);
                        tmCustPostEntity.setBusinessGroup(positionEntity.getBusinessGroup());
                    }
                    if (!StringUtil.equals(positionId, oldPositionId)) {
                        TmPositionEntity oldPostEntity = this.tmCustomerService.get(TmPositionEntity.class, (Serializable)((Object)oldPositionId));
                        String logContent = "\u5ba2\u6237[" + customerEntity.getCustomerCode() + "-" + customerEntity.getCustomerName() + "]" + ",\u5173\u8054\u804c\u4f4d[" + oldPostEntity.getPositionCode() + "-" + oldPostEntity.getPositionName() + "],\u4fee\u6539\u4e3a";
                        logContent = String.valueOf(logContent) + "[" + positionEntity.getPositionCode() + "-" + positionEntity.getPositionName() + "]";
                        this.tmCustomerService.addLog(OperationType.UPDATE, "\u5ba2\u6237\u4e0e\u804c\u4f4d\u5bf9\u5e94\u5173\u7cfb", customerEntity.getId(), logContent);
                    }
                    custPostList.add(tmCustPostEntity);
                } else {
                    TmPositionEntity oldPostEntity = this.tmCustomerService.get(TmPositionEntity.class, (Serializable)((Object)oldPositionId));
                    String logContent = "\u5ba2\u6237[" + customerEntity.getCustomerCode() + "-" + customerEntity.getCustomerName() + "]" + ",\u53d6\u6d88\u5173\u8054\u804c\u4f4d[" + oldPostEntity.getPositionCode() + "-" + oldPostEntity.getPositionName() + "]";
                    this.tmCustomerService.addLogAndRemoveInvalidInfo(tmCustPostEntity.getId(), tmCustPostEntity, customerEntity.getId(), logContent);
                }
            } else {
                TmPositionEntity positionEntity = null;
                if (StringUtil.isNotEmpty((String)positionId)) {
                    positionEntity = this.tmCustomerService.get(TmPositionEntity.class, (Serializable)((Object)positionId));
                    if (positionEntity == null) {
                        for (TmRCustPosBGEntity custPostEntity : custPostList) {
                            if (!custPostEntity.getTmPosition().getPositionCode().equals(positionId)) continue;
                            throw new BusinessException("\u5bf9\u5e94\u804c\u4f4d\u4fe1\u606f[" + positionId + "]\u5b58\u5728\u76f8\u540c\u7684\u591a\u4e2a\u7f16\u7801");
                        }
                        positionEntity = this.tmCustomerService.findUniqueByProperty(TmPositionEntity.class, "positionCode", positionId);
                    }
                    if (positionEntity == null) {
                        throw new BusinessException("\u804c\u4f4d\u4fe1\u606f[" + positionId + "]\u4e0d\u5b58\u5728");
                    }
                    if (positionEntity.getEnableStatus() == 1) {
                        throw new BusinessException("\u804c\u4f4d\u4fe1\u606f[" + positionId + "]\u5df2\u505c\u7528");
                    }
                    tmCustPostEntity.setTmPosition(positionEntity);
                    tmCustPostEntity.setBusinessGroup(positionEntity.getBusinessGroup());
                }
                tmCustPostEntity.setTmCustomer(customerEntity);
                custPostList.add(tmCustPostEntity);
            }
            ++i;
        }
        return custPostList;
    }

    private void copyProperties(TmCustomerVo vo, TmCustomerEntity entity) {
        entity.setAddress(vo.getAddress());
        entity.setArea(vo.getArea());
        entity.setChannelType(vo.getChannelType());
        entity.setCity(vo.getCity());
        entity.setCooperative(vo.getCooperative());
        entity.setCustomerCode(vo.getCustomerCode());
        entity.setCustomerName(vo.getCustomerName());
        entity.setCustomerType(vo.getCustomerType());
        if (StringUtils.isNotBlank((CharSequence)vo.getEnableStatus())) {
            entity.setEnableStatus(Integer.parseInt(vo.getEnableStatus()));
        }
        entity.setErpCode(vo.getErpCode());
        entity.setExtChar1(vo.getExtChar1());
        entity.setExtChar2(vo.getExtChar2());
        entity.setExtChar3(vo.getExtChar3());
        entity.setExtChar4(vo.getExtChar4());
        entity.setExtChar5(vo.getExtChar5());
        entity.setExtChar6(vo.getExtChar6());
        entity.setExtChar7(vo.getExtChar7());
        entity.setExtChar8(vo.getExtChar8());
        entity.setExtChar9(vo.getExtChar9());
        entity.setExtChar10(vo.getExtChar10());
        entity.setExtChar11(vo.getExtChar11());
        entity.setExtChar12(vo.getExtChar12());
        entity.setExtChar13(vo.getExtChar13());
        entity.setExtChar14(vo.getExtChar14());
        entity.setExtChar15(vo.getExtChar15());
        entity.setExtChar16(vo.getExtChar16());
        entity.setExtChar17(vo.getExtChar17());
        entity.setExtChar18(vo.getExtChar18());
        entity.setExtChar19(vo.getExtChar19());
        entity.setExtChar20(vo.getExtChar20());
        entity.setExtChar21(vo.getExtChar21());
        entity.setExtChar22(vo.getExtChar22());
        entity.setExtChar23(vo.getExtChar23());
        entity.setExtChar24(vo.getExtChar24());
        entity.setExtChar25(vo.getExtChar25());
        entity.setExtNumber1(vo.getExtNumber1());
        entity.setExtNumber2(vo.getExtNumber2());
        entity.setExtNumber3(vo.getExtNumber3());
        entity.setExtNumber4(vo.getExtNumber4());
        entity.setExtNumber5(vo.getExtNumber5());
        entity.setLinkman(vo.getLinkman());
        entity.setLinkmanPhone(vo.getLinkmanPhone());
        entity.setProvince(vo.getProvince());
    }
}

