/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.custuser.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.custuser.dao.TmCustUserDao;
import com.biz.eisp.mdm.custuser.entity.TmRUserCustomerEntity;
import com.biz.eisp.mdm.custuser.service.TmCustUserExtendService;
import com.biz.eisp.mdm.custuser.service.TmCustUserService;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.entity.TmUserRoleEntity;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.transformer.TmUserVoToTmUserEntity;
import com.biz.eisp.mdm.user.vo.TmCustUserVo;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tmCustUserService")
@Transactional
public class TmCustUserServiceImpl
extends BaseServiceImpl
implements TmCustUserService {
    @Autowired
    private TmCustUserDao tmCustUserDao;
    @Autowired
    private TmUserService tmUserService;
    @Autowired(required=false)
    private TmCustUserExtendService tmCustUserExtendService;

    @Override
    public List<TmCustUserVo> findTmCustUserList(TmUserVo tmUserVo, Page page) {
        List<TmCustUserVo> userVos = this.tmCustUserDao.findTmCustUserList(tmUserVo, page);
        return userVos;
    }

    @Override
    public TmCustUserVo findTmCustUserById(TmUserVo tmUserVo) {
        List<TmCustUserVo> list = this.tmCustUserDao.findTmCustUserList(tmUserVo, null);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            TmCustUserVo userVo = list.get(0);
            return userVo;
        }
        return null;
    }

    @Override
    public void saveTmUser(TmUserVo tmUserVo, Page page) {
        TmUserEntity tmUserEntity = null;
        String userId = "";
        if (StringUtil.isNotEmpty(this.tmCustUserExtendService)) {
            try {
                this.tmCustUserExtendService.validate(tmUserVo, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25:" + e.getMessage());
            }
            tmUserEntity = this.tmCustUserExtendService.saveBefore(tmUserVo, page);
        }
        if (StringUtil.isEmpty(tmUserEntity)) {
            TmUserVoToTmUserEntity tmUserVoToTmUserEntity = new TmUserVoToTmUserEntity(this.tmUserService);
            tmUserEntity = tmUserVoToTmUserEntity.apply(tmUserVo);
            userId = tmUserEntity.getId();
        }
        if (StringUtil.isNotEmpty(this.tmCustUserExtendService)) {
            tmUserEntity = this.tmCustUserExtendService.saveBefore(tmUserEntity, tmUserVo, page);
        }
        this.saveOrUpdate(tmUserEntity);
        if (StringUtil.isNotEmpty(this.tmCustUserExtendService)) {
            tmUserEntity = this.tmCustUserExtendService.savePost(tmUserEntity, tmUserVo, page);
        }
        String urhql = "FROM TmUserRoleEntity where tmUser.id is null";
        List userRolelist = this.findByHql(urhql, new Object[0]);
        for (TmUserRoleEntity userRole : userRolelist) {
            String userRoleId = userRole.getId();
            super.addLogAndRemoveInvalidInfo(userRoleId, userRole, userId, null);
        }
        this.executeSql("DELETE FROM TM_R_USER_ROLE WHERE USER_ID IS NULL", new Object[0]);
        String uchql = "FROM TmRUserCustomerEntity where tmUser.id is null";
        List list = this.findByHql(uchql, new Object[0]);
        for (TmRUserCustomerEntity userCustomer : list) {
            String userCustId = userCustomer.getId();
            super.addLogAndRemoveInvalidInfo(userCustId, userCustomer, userId, null);
        }
        this.executeSql("DELETE FROM TM_R_USER_CUSTOMER WHERE USER_ID IS NULL", new Object[0]);
    }

    @Override
    public AjaxJson startOrStopTmuser(TmUserVo tmUserVo) {
        AjaxJson j = new AjaxJson();
        TmUserEntity tmUserEntity = this.get(TmUserEntity.class, (Serializable)((Object)tmUserVo.getId()));
        if (StringUtil.isNotEmpty(tmUserEntity)) {
            if (tmUserEntity.getEnableStatus().toString().equals(tmUserVo.getEnableStatus().toString())) {
                j.setSuccess(false);
                String fg = Globals.ZERO.intValue() == tmUserVo.getEnableStatus().shortValue() ? "\u542f\u7528" : "\u505c\u7528";
                j.setMsg("\u8be5\u6570\u636e\u72b6\u6001\u5df2\u7ecf\u4e3a" + fg + "\uff0c\u65e0\u9700\u518d\u6b21\u64cd\u4f5c");
            } else {
                tmUserEntity.setEnableStatus(Short.parseShort(tmUserVo.getEnableStatus().toString()));
                tmUserEntity.setLoginErrTimes(Globals.User_Normal);
                this.updateEntity(tmUserEntity);
            }
        } else {
            throw new BusinessException("\u672a\u627e\u5230\u8be5\u7eaa\u5f55");
        }
        return j;
    }

    @Override
    public List<TmLogVo> findCustUserLogList(TmLogVo tmLogVo, Page page) {
        return this.tmCustUserDao.findCustUserLogList(tmLogVo, page);
    }
}

