/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.login.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ContextHolderUtils;
import com.biz.eisp.base.common.util.IpUtil;
import com.biz.eisp.base.common.util.Md5EncryptionAndDecryption;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.login.service.LoginService;
import com.biz.eisp.login.service.LoginrRelatedService;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.position.service.PositionService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.web.pojo.Client;
import com.biz.eisp.mdm.web.pojo.ClientManager;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="loginService")
@Transactional
public class LoginServiceImpl
extends BaseServiceImpl
implements LoginService {
    @Autowired
    private PositionService positionService;
    @Autowired(required=false)
    private LoginrRelatedService loginrRelatedService;

    @Override
    public AjaxJson validateUser(TmUserEntity tmUserEntity, String flag, HttpServletRequest request) {
        String hql = "from TmUserEntity where userName = ? ";
        if (this.loginrRelatedService != null) {
            this.loginrRelatedService.beforeLoginIn(tmUserEntity, request);
        }
        AjaxJson j = new AjaxJson();
        List list = super.findByHql(hql, tmUserEntity.getUserName());
        if (list.size() > 0) {
            TmPositionVo tmPositionVo;
            TmUserEntity userEntity = (TmUserEntity)list.get(0);
            if (Globals.User_Forbidden == userEntity.getEnableStatus() && !Globals.Admin_Name.equalsIgnoreCase(userEntity.getUserName())) {
                j.setSuccess(false);
                j.setMsg("\u7528\u6237\u88ab\u9501\u5b9a");
                return j;
            }
            String pwd = Md5EncryptionAndDecryption.encryPwd(tmUserEntity.getPassword());
            if (!pwd.equals(userEntity.getPassword())) {
                Short loginErrTimes = userEntity.getLoginErrTimes() == null ? (short)0 : userEntity.getLoginErrTimes();
                if (loginErrTimes >= 3) {
                    String sql = "update tm_user set enable_status=? where id=?";
                    this.executeSql(sql, Globals.User_Forbidden, userEntity.getId());
                } else {
                    loginErrTimes = (short)(loginErrTimes + 1);
                    String sql = "update tm_user set login_err_times=? where id=?";
                    this.executeSql(sql, loginErrTimes, userEntity.getId());
                }
                if (loginErrTimes == 3) {
                    j.setMsg("\u5bc6\u7801\u4e0d\u6b63\u786e\uff01\u7528\u6237\uff1a" + userEntity.getUserName() + "\u88ab\u9501\u5b9a\uff01");
                } else {
                    j.setMsg("\u5bc6\u7801\u4e0d\u6b63\u786e\uff01\u60a8\u8fd8\u6709" + (3 - loginErrTimes) + "\u6b21\u673a\u4f1a\u5c1d\u8bd5");
                }
                j.setSuccess(false);
                return j;
            }
            String sql = "update tm_user set login_err_times=? where id=?";
            this.executeSql(sql, Globals.User_Normal, userEntity.getId());
            List<TmPositionVo> positions = this.positionService.getPositinByUserId(userEntity, Globals.Main_Position_Type);
            if (positions.size() == 0 && userEntity.getUserType() == Globals.ENTERPRISE_USER) {
                j.setSuccess(false);
                j.setMsg("\u7528\u6237\u672a\u5206\u914d\u4e3b\u804c\u4f4d,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                return j;
            }
            if (userEntity.getUserType() == Globals.ENTERPRISE_USER && Globals.ONE.equals((tmPositionVo = positions.get(0)).getEnableStatus())) {
                j.setSuccess(false);
                j.setMsg("\u7528\u6237\u6240\u5c5e\u4e3b\u804c\u4f4d\u88ab\u505c\u7528,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                return j;
            }
            if (Globals.Y.equalsIgnoreCase(flag)) {
                TmPositionVo positionVo = new TmPositionVo();
                if (CollectionUtil.listNotEmptyNotSizeZero(positions)) {
                    positionVo = positions.get(0);
                }
                this.saveLoginInfo(userEntity, positionVo, request);
            }
            if (this.loginrRelatedService != null) {
                this.loginrRelatedService.afterLoginIn(userEntity, request);
            }
        } else {
            j.setSuccess(false);
            j.setMsg("\u6b64\u7528\u6237\u4e0d\u5b58\u5728\uff01");
            return j;
        }
        return j;
    }

    @Override
    public void saveLoginInfo(TmUserEntity tmUserEntity, TmPositionVo tmPositionVo, HttpServletRequest request) {
        HttpSession session = ContextHolderUtils.getSession();
        Client client = new Client();
        client.setIp(IpUtil.getIpAddr(request));
        client.setLogindatetime(new Date());
        client.setUser(tmUserEntity);
        client.setPosition(tmPositionVo);
        if (Globals.ENTERPRISE_USER == tmUserEntity.getUserType()) {
            if (StringUtil.isNotEmpty((String)tmPositionVo.getOrgId())) {
                TmOrgEntity orgEntity = this.get(TmOrgEntity.class, (Serializable)((Object)tmPositionVo.getOrgId()));
                client.setOrg(orgEntity);
            }
            TmCustomerOrgEntity customerOrg = this.findUniqueByProperty(TmCustomerOrgEntity.class, "positionId", tmPositionVo.getId());
            client.setCustomerOrg(customerOrg);
        }
        ClientManager clientManager = ClientManager.getInstance();
        clientManager.addClinet(session.getId(), client);
        clientManager.addUserNameSessionMap(tmUserEntity.getUserName(), session.getId());
        clientManager.addUserPositionMap(tmUserEntity.getId(), tmPositionVo.getId());
    }
}

