/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.customer.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.customer.dao.TmCustomerDao;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.customer.service.TmCustomerExtendService;
import com.biz.eisp.mdm.customer.service.TmCustomerService;
import com.biz.eisp.mdm.customer.transformer.TmCustomerVoToTmCustomerEntity;
import com.biz.eisp.mdm.customer.vo.QueryTmCustomerVo;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tmCustomerService")
@Transactional
public class TmCustomerServiceImpl
extends BaseServiceImpl
implements TmCustomerService {
    @Autowired
    private TmCustomerDao tmCustomerDao;
    @Autowired(required=false)
    private TmCustomerExtendService tmCustomerExtendService;

    @Override
    public List<TmCustomerVo> findTmCustomerList(TmCustomerVo customerVo, Page page) {
        String sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.Table_CUSTOMER, customerVo);
        sql = this.appendCustomerCondition(sql, customerVo);
        return this.tmCustomerDao.findTmCustomerList(customerVo, page, sql);
    }

    public String appendCustomerCondition(String sql, TmCustomerVo customerVo) {
        String sqlJoin = "select t1.customer_id customerId, to_char(listagg(t1.position_id,',') within GROUP (order by t1.position_id)) positionId,to_char(listagg(t2.position_name,',') within GROUP (order by t2.position_name)) position_name,to_char(listagg(t2.position_code,',') within GROUP (order by t2.position_code)) position_code,to_char(listagg(t1.business_group,',') within GROUP (order by t1.business_group)) business_group,to_char(listagg(tu.username,',') within GROUP (order by tu.username)) username,to_char(listagg(tu.fullname,',') within GROUP (order by tu.fullname)) fullname  from TM_R_CUST_POS_BG t1 left join tm_position t2 on t2.id = t1.position_id  left join tm_r_user_position up on up.position_id=t1.position_id and up.is_main='0'  left join tm_user tu on tu.id=up.user_id  group by t1.customer_id";
        String sqlOn = " to_Char(t1.customerId)=to_char(t.id) ";
        String sqlWhere = "";
        sqlWhere = StringUtil.isNotEmpty((String)customerVo.getId()) ? " and (t.id='" + customerVo.getId() + "'" : " and exists(select 1 from TM_CUSTOMER t2 left join  TM_R_CUST_POS_BG t3 on t3.customer_id=t2.id where t2.id=to_char(t1.customerId)";
        if (StringUtil.isNotEmpty((String)customerVo.getDockUserName())) {
            sqlWhere = String.valueOf(sqlWhere) + " and  (to_char(t1.username) like '%" + customerVo.getDockUserName() + "%' or to_char(t1.fullname) like '%" + customerVo.getDockUserName() + "%')";
        }
        if (StringUtil.isNotEmpty((String)customerVo.getDockPosition())) {
            sqlWhere = String.valueOf(sqlWhere) + "and (to_char(t1.position_name) like '%" + customerVo.getDockPosition() + "%' or to_char(t1.position_code) like '%" + customerVo.getDockPosition() + "%')";
        }
        if (StringUtil.isNotEmpty((String)customerVo.getBusinessGroup())) {
            sqlWhere = String.valueOf(sqlWhere) + " and to_char(t1.business_group)='" + customerVo.getBusinessGroup() + "'";
        }
        sqlWhere = String.valueOf(sqlWhere) + ")";
        if (StringUtil.isEmpty(customerVo.getId()) && StringUtil.isEmpty(customerVo.getDockUserName()) && StringUtil.isEmpty(customerVo.getDockPosition()) && StringUtil.isEmpty(customerVo.getBusinessGroup())) {
            sqlWhere = "";
        }
        String orderSql = " order by t.customerCode asc";
        return DynamicConfigUtil.getInstance().appendCustomCondition(sql, sqlJoin, sqlOn, sqlWhere, orderSql);
    }

    @Override
    public void saveTmCustomer(TmCustomerVo customerVo, Page page) {
        TmCustomerEntity tmCustomerEntity = null;
        String customerId = "";
        if (StringUtil.isNotEmpty(this.tmCustomerExtendService)) {
            try {
                this.tmCustomerExtendService.validate(customerVo, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25:" + e.getMessage());
            }
            tmCustomerEntity = this.tmCustomerExtendService.saveBefore(customerVo, page);
        }
        if (StringUtil.isEmpty(tmCustomerEntity)) {
            tmCustomerEntity = new TmCustomerVoToTmCustomerEntity(this).apply(customerVo);
            customerId = tmCustomerEntity.getId();
        }
        if (StringUtil.isNotEmpty(this.tmCustomerExtendService)) {
            tmCustomerEntity = this.tmCustomerExtendService.saveBefore(tmCustomerEntity, customerVo, page);
        }
        this.saveOrUpdate(tmCustomerEntity);
        if (tmCustomerEntity.getCooperative().equals("end")) {
            this.disableCustomerUser(tmCustomerEntity.getId());
        }
        this.executeSql("DELETE FROM TM_R_CUST_POS_BG WHERE CUSTOMER_ID IS NULL", new Object[0]);
        if (StringUtil.isNotEmpty(this.tmCustomerExtendService)) {
            tmCustomerEntity = this.tmCustomerExtendService.savePost(tmCustomerEntity, customerVo, page);
        }
    }

    private void disableCustomerUser(String customerId) {
        String sql = "UPDATE tm_user SET enable_status = 1 WHERE ID in (SELECT user_id FROM tm_r_user_customer WHERE customer_id = ?)";
        this.executeSql(sql, customerId);
    }

    @Override
    public void deleteTmCustomer(String ids) {
        if (StringUtil.isNotEmpty((String)ids)) {
            String[] customerIds;
            String[] stringArray = customerIds = ids.split(",");
            int n = customerIds.length;
            int n2 = 0;
            while (n2 < n) {
                String customerId = stringArray[n2];
                TmCustomerEntity tmCustomerEntity = this.get(TmCustomerEntity.class, (Serializable)((Object)customerId));
                if (tmCustomerEntity != null && StringUtil.isNotEmpty((String)tmCustomerEntity.getId())) {
                    this.delete(tmCustomerEntity);
                }
                ++n2;
            }
        }
    }

    @Override
    public TmCustomerVo getTmCustomerVoById(TmCustomerVo customerVo, Page page) {
        List<TmCustomerVo> list = this.findTmCustomerList(customerVo, null);
        return list.size() > 0 ? list.get(0) : new TmCustomerVo();
    }

    @Override
    public List<TmCustomerVo> findTmCustomerByPosList(TmCustomerVo customerVo, Page page) {
        return this.tmCustomerDao.findTmCustomerByPosList(customerVo, page);
    }

    @Override
    public List<TmCustomerVo> findTmCustTomerByAllPossible(QueryTmCustomerVo queryTmCustomerVo, Page page) {
        return this.tmCustomerDao.findTmCustTomerByAllPossible(queryTmCustomerVo, page);
    }

    @Override
    public List<TmCustomerVo> findTpmCustomerList(TmCustomerVo customerVo, Page page) {
        return this.tmCustomerDao.findTpmCustomerList(customerVo, page);
    }

    @Override
    public List<TmLogVo> findCustomerLogList(TmLogVo tmLogVo, Page page) {
        return this.tmCustomerDao.findCustomerLogList(tmLogVo, page);
    }

    @Override
    public List<TmCustomerVo> findTmCustTomerByOrgAndCustType(QueryTmCustomerVo queryTmCustomerVo, Page page) {
        return this.tmCustomerDao.findTmCustTomerByOrgAndCustType(queryTmCustomerVo, page);
    }

    @Override
    public List<ComboBox> findCustomerComboBoxByPosId(String positionId) {
        String sql = "SELECT TC.ID AS ID,TC.CUSTOMER_NAME AS TEXT,TC.CUSTOMER_CODE AS VALUE FROM TM_CUSTOMER TC JOIN TM_R_TERM_CUST_POS_BG TRCP ON TC.ID = TRCP.CUSTOMER_ID WHERE TRCP.POSITION_ID=?";
        return this.findBySql(ComboBox.class, sql, positionId);
    }

    @Override
    public List<TmCustomerVo> findCustomer(String settlementCode, String customerType, String contractCode) {
        return this.tmCustomerDao.findCustomer(settlementCode, customerType, contractCode);
    }
}

