/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.terminal.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.terminal.dao.TmTerminalDao;
import com.biz.eisp.mdm.terminal.entity.TmTerminalEntity;
import com.biz.eisp.mdm.terminal.service.TmTerminalExtendService;
import com.biz.eisp.mdm.terminal.service.TmTerminalService;
import com.biz.eisp.mdm.terminal.transformer.TmTerminalVoToTmTerminalEntity;
import com.biz.eisp.mdm.terminal.vo.QueryTmTerminalVo;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tmTerminalService")
@Transactional
public class TmTerminalServiceImpl
extends BaseServiceImpl
implements TmTerminalService {
    @Autowired
    private TmTerminalDao tmTerminalDao;
    @Autowired(required=false)
    private TmTerminalExtendService terminalExtendService;

    @Override
    public List<TmTerminalVo> findTmTerminalList(TmTerminalVo tmTerminalVo, Page page) {
        String sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_TERMINAL, tmTerminalVo);
        sql = this.appendTerminalCondition(sql, tmTerminalVo);
        return this.tmTerminalDao.findTerminalList(tmTerminalVo, page, sql);
    }

    public String appendTerminalCondition(String sql, TmTerminalVo terminalVo) {
        String joinSql = "select distinct t1.terminal_id terminalId,to_char(listagg(t1.customer_id,',') within GROUP (order by t1.customer_id)) customerId,to_char(listagg(tc.customer_name,',') within GROUP (order by tc.customer_name)) customerName,to_char(listagg(tc.customer_code,',') within GROUP (order by tc.customer_code)) customerCode ,to_char(listagg(t1.position_id,',') within GROUP (order by t1.position_id))  positionId,to_char(listagg(t1.business_group,',') within GROUP (order by t1.business_group)) business_group ,to_char(listagg(t2.position_name,',') within GROUP (order by t2.position_name)) position_name,to_char(listagg(t2.position_code,',') within GROUP (order by t2.position_code)) position_code,to_char(listagg(tu.username,',') within GROUP (order by tu.username)) username,to_char(listagg(tu.fullname,',') within GROUP (order by tu.fullname)) fullname from TM_R_TERM_CUST_POS_BG t1 left join tm_customer tc on tc.id=t1.customer_id  left join tm_position t2 on t2.id = t1.position_id  left join tm_r_user_position up on up.position_id=t1.position_id and up.is_main='0' left join tm_user tu on tu.id=up.user_id group by t1.terminal_id";
        String sqlOn = " t1.terminalId=t.id ";
        String sqlWhere = "";
        sqlWhere = StringUtil.isNotEmpty((String)terminalVo.getId()) ? " and (t.id='" + terminalVo.getId() + "'" : "and exists(select 1 from tm_terminal t2 left join TM_R_TERM_CUST_POS_BG t3 on t3.terminal_id=t2.id where t2.id=to_char(t1.terminalId) ";
        if (StringUtil.isNotEmpty((String)terminalVo.getDockUserName())) {
            sqlWhere = String.valueOf(sqlWhere) + " and  (to_char(t1.username) like '%" + terminalVo.getDockUserName() + "%' or to_char(t1.fullname) like '%" + terminalVo.getDockUserName() + "%')";
        }
        if (StringUtil.isNotEmpty((String)terminalVo.getDockPosition())) {
            sqlWhere = String.valueOf(sqlWhere) + "and (to_char(t1.position_name) like '%" + terminalVo.getDockPosition() + "%' or to_char(t1.position_code) like '%" + terminalVo.getDockPosition() + "%')";
        }
        if (StringUtil.isNotEmpty((String)terminalVo.getBusinessGroup())) {
            sqlWhere = String.valueOf(sqlWhere) + " and to_char(t1.business_group)='" + terminalVo.getBusinessGroup() + "'";
        }
        if (StringUtil.isNotEmpty((String)terminalVo.getCustomerId())) {
            sqlWhere = String.valueOf(sqlWhere) + "and (to_char(t1.customerName) like '%" + terminalVo.getCustomerId() + "%' or to_char(t1.customerCode) like '%" + terminalVo.getCustomerId() + "%')";
        }
        sqlWhere = String.valueOf(sqlWhere) + ")";
        if (StringUtil.isEmpty(terminalVo.getId()) && StringUtil.isEmpty(terminalVo.getDockUserName()) && StringUtil.isEmpty(terminalVo.getDockPosition()) && StringUtil.isEmpty(terminalVo.getCustomerId()) && StringUtil.isEmpty(terminalVo.getBusinessGroup())) {
            sqlWhere = "";
        }
        String orderSql = " order by t.terminalCode asc";
        return DynamicConfigUtil.getInstance().appendCustomCondition(sql, joinSql, sqlOn, sqlWhere, orderSql);
    }

    @Override
    public void saveTmTerminal(TmTerminalVo tmTerminalVo, Page page) {
        TmTerminalEntity terminalEntity = null;
        if (StringUtil.isNotEmpty(this.terminalExtendService)) {
            try {
                this.terminalExtendService.validate(tmTerminalVo, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25:" + e.getMessage());
            }
            terminalEntity = this.terminalExtendService.saveBefore(tmTerminalVo, page);
        }
        if (StringUtil.isEmpty(terminalEntity)) {
            terminalEntity = new TmTerminalVoToTmTerminalEntity(this).apply(tmTerminalVo);
        }
        if (StringUtil.isNotEmpty(this.terminalExtendService)) {
            terminalEntity = this.terminalExtendService.saveBefore(terminalEntity, tmTerminalVo, page);
        }
        this.saveOrUpdate(terminalEntity);
        this.executeSql("DELETE FROM TM_R_TERM_CUST_POS_BG WHERE TERMINAL_ID IS NULL", new Object[0]);
        if (StringUtil.isNotEmpty(this.terminalExtendService)) {
            terminalEntity = this.terminalExtendService.savePost(terminalEntity, tmTerminalVo, page);
        }
    }

    @Override
    public void deleteTmTerminal(String ids) {
        if (StringUtil.isNotEmpty((String)ids)) {
            String[] terminalIds;
            String[] stringArray = terminalIds = ids.split(",");
            int n = terminalIds.length;
            int n2 = 0;
            while (n2 < n) {
                String terminalId = stringArray[n2];
                TmTerminalEntity terminalEntity = this.get(TmTerminalEntity.class, (Serializable)((Object)terminalId));
                if (terminalEntity != null && StringUtil.isNotEmpty((String)terminalEntity.getId())) {
                    this.delete(terminalEntity);
                }
                ++n2;
            }
        }
    }

    @Override
    public TmTerminalVo getTmTerminal(TmTerminalVo tmTerminalVo, Page page) {
        List<TmTerminalVo> list = this.findTmTerminalList(tmTerminalVo, page);
        return list.size() > 0 ? list.get(0) : new TmTerminalVo();
    }

    @Override
    public List<TmTerminalVo> findTmTerminalByPosList(TmTerminalVo terminalVo, Page page) {
        return this.tmTerminalDao.findTmTerminalByPosList(terminalVo, page);
    }

    @Override
    public List<TmTerminalVo> findTmTerminalByAllPossible(QueryTmTerminalVo queryTmTerminalVo, Page page) {
        return this.tmTerminalDao.findTmTerminalByAllPossible(queryTmTerminalVo, page);
    }

    @Override
    public List<TmLogVo> findTerminalLogList(TmLogVo tmLogVo, Page page) {
        return this.tmTerminalDao.findTerminalLogList(tmLogVo, page);
    }

    @Override
    public List<QueryTmTerminalVo> findTmTerminalAndCustByterminalType(QueryTmTerminalVo queryTmTerminalVo, Page page) {
        return this.tmTerminalDao.findTmTerminalAndCustByterminalType(queryTmTerminalVo, page);
    }
}

