/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.position.controller;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.redis.cache.impl.RedisService;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
import com.biz.eisp.mdm.position.service.PositionService;
import com.biz.eisp.mdm.position.service.TmPositionFormExtendService;
import com.biz.eisp.mdm.position.service.TmPositionMainExtendService;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import com.biz.eisp.mdm.web.pojo.Client;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tmPositionController"})
public class TmPositionController
extends BaseController {
    @Autowired
    private TmPositionService tmPositionService;
    @Autowired(required=false)
    private TmPositionFormExtendService tmPositionFormExtendService;
    @Autowired(required=false)
    private TmPositionMainExtendService tmPositionMainExtendService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private RedisService redisService;

    @RequestMapping(params={"goTmPositionMain"})
    public ModelAndView goTmPositionMain(TmPositionVo tmPositionVo, HttpServletRequest request) {
        if (StringUtil.isNotEmpty((String)tmPositionVo.getOrgId())) {
            request.setAttribute("orgId", (Object)tmPositionVo.getOrgId());
        }
        request.setAttribute("extendTableName", (Object)Globals.TABLE_POSITION);
        if (this.tmPositionMainExtendService != null) {
            request.setAttribute("includeJSP", (Object)this.tmPositionMainExtendService.includeJsp());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmPosition/tmPositionMain");
    }

    @RequestMapping(params={"goTmPositionSearch"})
    public ModelAndView goTmPositionSearch(TmPositionVo tmPositionVo, String singleSelect, String searchUrl, HttpServletRequest request) {
        ModelAndView view = new ModelAndView("com/biz/eisp/mdm/tmPosition/tmPositionSearchMain");
        if (StringUtil.isNotEmpty((String)tmPositionVo.getOrgId())) {
            view.addObject("orgId", (Object)tmPositionVo.getOrgId());
        }
        if (StringUtil.isEmpty(searchUrl)) {
            searchUrl = "tmPositionController.do?findTmPositionBySearchList";
        }
        view.addObject("searchUrl", (Object)searchUrl);
        view.addObject("extendTableName", (Object)Globals.TABLE_POSITION);
        view.addObject("vo", (Object)tmPositionVo);
        view.addObject("singleSelect", (Object)singleSelect);
        return view;
    }

    @RequestMapping(params={"goTmPositionForm"})
    public ModelAndView goTmPositionForm(TmPositionVo tmPositionVo, HttpServletRequest request, HttpServletResponse response) {
        List<TmPositionVo> tmPositionVoList;
        if (StringUtil.isNotEmpty((String)tmPositionVo.getId()) && (tmPositionVoList = this.tmPositionService.findTmPositionList(tmPositionVo, null)) != null && tmPositionVoList.size() > 0) {
            TmPositionVo vo = tmPositionVoList.get(0);
            request.setAttribute("vo", (Object)vo);
        }
        String optype = request.getParameter("optype");
        request.setAttribute("optype", (Object)optype);
        request.setAttribute("extendTableName", (Object)Globals.TABLE_POSITION);
        if (this.tmPositionFormExtendService != null) {
            request.setAttribute("includeJSP", (Object)this.tmPositionFormExtendService.includeJsp());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmPosition/tmPositionForm");
    }

    @RequestMapping(params={"goSelectRole"})
    public ModelAndView goSelectRole(TmPositionVo tmPositionVo, HttpServletRequest request) {
        if (StringUtil.isNotEmpty((String)tmPositionVo.getId())) {
            request.setAttribute("posId", (Object)tmPositionVo.getId());
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getUserId())) {
            request.setAttribute("userId", (Object)tmPositionVo.getUserId());
        }
        return new ModelAndView("com/biz/eisp/mdm/role/tmRoleSelectMain");
    }

    @RequestMapping(params={"findTmPositionList"})
    @ResponseBody
    public DataGrid findTmPositionList(TmPositionVo tmPositionVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List<TmPositionVo> tmPositionVoList = this.tmPositionService.findTmPositionList(tmPositionVo, page);
        return new DataGrid(tmPositionVoList, page);
    }

    @RequestMapping(params={"findNoAnyRolePositionList"})
    @ResponseBody
    public DataGrid findNoAnyRolePositionList(TmPositionVo tmPositionVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List<TmPositionVo> tmPositionVoList = this.tmPositionService.findNoAnyRolePositionList(tmPositionVo, page);
        return new DataGrid(tmPositionVoList, page);
    }

    @RequestMapping(params={"findNoThisRolePositionList"})
    @ResponseBody
    public DataGrid findNoThisRolePositionList(TmPositionVo tmPositionVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List<TmPositionVo> tmPositionVoList = this.tmPositionService.findNoThisRolePositionList(tmPositionVo, page);
        return new DataGrid(tmPositionVoList, page);
    }

    @RequestMapping(params={"findThisRolePositionList"})
    @ResponseBody
    public DataGrid findThisRolePositionList(TmPositionVo tmPositionVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List<TmPositionVo> tmPositionVoList = this.tmPositionService.findThisRolePositionList(tmPositionVo, page);
        return new DataGrid(tmPositionVoList, page);
    }

    @RequestMapping(params={"findTmPositionBySearchList"})
    @ResponseBody
    public DataGrid findTmPositionBySearchList(TmPositionVo tmPositionVo, HttpServletRequest request) {
        List<TmPositionVo> tmPositionVoList;
        EuPage page = new EuPage(request);
        if (StringUtil.isNotEmpty((String)tmPositionVo.getSearchParam())) {
            tmPositionVo.setPositionName(tmPositionVo.getSearchParam());
        }
        try {
            tmPositionVoList = this.tmPositionService.findTmPositionList(tmPositionVo, page);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6\u804c\u4f4d\u4fe1\u606f\u5f02\u5e38," + e.getMessage());
        }
        return new DataGrid(tmPositionVoList, page);
    }

    @RequestMapping(params={"getTmPositionBySearchList"})
    @ResponseBody
    public AjaxJson getTmPositionBySearchList(TmPositionVo tmPositionVo, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        HashMap<String, Object> map = new HashMap<String, Object>();
        EuPage page = new EuPage(request);
        try {
            if (StringUtil.isNotEmpty((String)tmPositionVo.getSearchParam())) {
                tmPositionVo.setPositionName(tmPositionVo.getSearchParam());
            }
            List<TmPositionVo> tmPositionVoList = this.tmPositionService.findTmPositionList(tmPositionVo, page);
            map.put("totle", tmPositionVoList.size());
            j.setObj(tmPositionVoList);
        }
        catch (Exception e) {
            j.setSuccess(false);
            map.put("totle", 0);
            e.printStackTrace();
        }
        j.setAttributes(map);
        return j;
    }

    @RequestMapping(params={"saveTmPosition"})
    @ResponseBody
    public AjaxJson saveTmPosition(TmPositionVo tmPositionVo, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        try {
            j.setMsg("\u64cd\u4f5c\u6210\u529f");
            EuPage page = new EuPage(request);
            this.tmPositionService.saveTmPosition(tmPositionVo, page);
            this.redisService.set("NO_OPERATION_VERSION_", UUID.randomUUID().toString().replaceAll("-", ""));
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u64cd\u4f5c\u804c\u4f4d\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5");
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"deleteTmPosition"})
    @ResponseBody
    public AjaxJson deleteTmPosition(String ids, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            this.tmPositionService.deleteTmPosition(ids, this.page);
        }
        catch (Exception e) {
            e.printStackTrace();
            ajaxJson.setMsg("\u5220\u9664\u5931\u8d25," + e.getMessage());
        }
        return ajaxJson;
    }

    @RequestMapping(params={"startOrStopPosition"})
    @ResponseBody
    public AjaxJson startOrStopPosition(TmPositionVo tmPositionVo) {
        AjaxJson j = new AjaxJson();
        try {
            j = this.tmPositionService.startOrStopPosition(tmPositionVo);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u64cd\u4f5c\u5931\u8d25");
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"goTmPositionByOrgMain"})
    public ModelAndView goTmPositionByOrgMain(TmPositionVo tmPositionVo, HttpServletRequest request) {
        if (StringUtil.isNotEmpty((String)tmPositionVo.getOrgId())) {
            request.setAttribute("orgId", (Object)tmPositionVo.getOrgId());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmPosition/tmPositionByOrgMain");
    }

    @RequestMapping(params={"goParentTmpositionMain"})
    public ModelAndView goParentTmpositionMain(TmPositionVo tmPositionVo, HttpServletRequest request) {
        if (StringUtil.isNotEmpty((String)tmPositionVo.getId())) {
            request.setAttribute("id", (Object)tmPositionVo.getId());
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getOrgId())) {
            request.setAttribute("curentOrg", (Object)tmPositionVo.getOrgId());
        } else {
            TmUserVo tmUserVo = ResourceUtil.getSessionTmUserVo();
            if (StringUtil.isNotEmpty(tmUserVo)) {
                request.setAttribute("curentOrg", (Object)tmUserVo.getOrgId());
            }
        }
        return new ModelAndView("com/biz/eisp/mdm/tmPosition/tmPositionSelectMain");
    }

    @RequestMapping(params={"goTmPositionForUserMain"})
    public ModelAndView goTmPositionForUserMain(HttpServletRequest request) {
        String userId = OConvertUtils.getString(request.getParameter("userId"));
        if (StringUtil.isNotEmpty((String)userId)) {
            request.setAttribute("userId", (Object)userId);
        }
        return new ModelAndView("com/biz/eisp/mdm/tmPosition/tmPositionForUserMain");
    }

    @RequestMapping(params={"goTmPositionCheckedMain"})
    public ModelAndView goTmPositionCheckedMain(TmPositionVo tmPositionVo, HttpServletRequest request) {
        request.setAttribute("userId", (Object)(StringUtil.isNotEmpty((String)tmPositionVo.getUserId()) ? tmPositionVo.getUserId() : "-1"));
        return new ModelAndView("com/biz/eisp/mdm/tmPosition/tmPositionCheckedMain");
    }

    @RequestMapping(params={"findTmPositionForUserList"})
    @ResponseBody
    public DataGrid findTmPositionForUserList(TmPositionVo tmPositionVo, HttpServletRequest request, HttpServletResponse response) {
        tmPositionVo.setFlag("true");
        tmPositionVo.setEnableStatus(Globals.ZERO);
        EuPage page = new EuPage(request);
        List<TmPositionVo> tmPositionVoList = this.tmPositionService.findTmPositionList(tmPositionVo, page);
        return new DataGrid(tmPositionVoList, page);
    }

    @RequestMapping(params={"validateTmposition"})
    @ResponseBody
    public ValidForm validateTmposition(TmPositionVo tmPositionVo, HttpServletRequest request) {
        String param = OConvertUtils.getString(request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        try {
            validForm = this.tmPositionService.validateTmposition(tmPositionVo, param);
        }
        catch (Exception e) {
            validForm.setStatus("n");
            validForm.setInfo("\u9a8c\u8bc1\u51fa\u73b0\u5f02\u5e38");
            e.printStackTrace();
        }
        return validForm;
    }

    @RequestMapping(params={"getPositionTree"})
    @ResponseBody
    public List<ComboTree> getPositionTree(HttpServletRequest request, ComboTree comboTree) {
        return this.tmPositionService.getPositionForComboTree(request, comboTree);
    }

    @RequestMapping(params={"changePositionForOrg"})
    @ResponseBody
    public AjaxJson changePositionForOrg(HttpServletRequest request, TmOrgVo tmOrgVo) {
        AjaxJson j = new AjaxJson();
        try {
            j = this.tmPositionService.changePositionForOrg(tmOrgVo);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u8c03\u6574\u5173\u7cfb\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5");
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"goTmPositionByRoleMain"})
    public ModelAndView goTmPositionByRoleMain(TmPositionVo tmPositionVo, HttpServletRequest request) {
        if (StringUtil.isNotEmpty((String)tmPositionVo.getRoleIds())) {
            request.setAttribute("roleId", (Object)tmPositionVo.getRoleIds());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmPosition/tmPositionByRoleMain");
    }

    @RequestMapping(params={"goTmMaintainPositionByRoleMain"})
    public ModelAndView goTmMaintainPositionByRoleMain(TmPositionVo tmPositionVo, HttpServletRequest request) {
        if (StringUtil.isNotEmpty((String)tmPositionVo.getRoleIds())) {
            request.setAttribute("roleId", (Object)tmPositionVo.getRoleIds());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmPosition/tmMaintainPositionByRoleMain");
    }

    @RequestMapping(params={"goChangeTmPosition"})
    public ModelAndView goChangeTmPosition(HttpServletRequest request) {
        TmPositionVo tmPositionVo = new TmPositionVo();
        TmUserEntity userEntity = ResourceUtil.getSessionUserName();
        EuPage page = new EuPage(request);
        if (StringUtil.isNotEmpty(userEntity)) {
            tmPositionVo.setUserId(userEntity.getId());
            tmPositionVo.setEnableStatus(Globals.ZERO);
            List<TmPositionVo> list = this.tmPositionService.findTmPositionList(tmPositionVo, page);
            request.setAttribute("tmPositionVo", list);
            request.setAttribute("userId", (Object)userEntity.getId());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmPosition/changeTmPositionMain");
    }

    @RequestMapping(params={"changeTmPosition"})
    @ResponseBody
    public AjaxJson changeTmPosition(TmPositionVo tmPositionVo, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            this.tmPositionService.changeTmPosition(tmPositionVo);
            Client client = ResourceUtil.getClient();
            this.changeSession(client, tmPositionVo.getId());
        }
        catch (Exception e) {
            j.setMsg("\u5207\u6362\u804c\u4f4d\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            j.setSuccess(false);
            e.printStackTrace();
        }
        return j;
    }

    private void changeSession(Client client, String posId) {
        TmPositionVo positionVo = this.positionService.getPositinById(posId);
        client.setPosition(positionVo);
        TmOrgEntity orgEntity = this.tmPositionService.get(TmOrgEntity.class, (Serializable)((Object)positionVo.getOrgId()));
        client.setOrg(this.getTmOrgEntity(orgEntity));
        ResourceUtil.setClient(client);
    }

    private TmOrgEntity getTmOrgEntity(TmOrgEntity org) {
        TmOrgEntity result = new TmOrgEntity();
        result.setId(org.getId());
        result.setOrgName(org.getOrgName());
        result.setOrgDesc(org.getOrgDesc());
        result.setOrgCode(org.getOrgCode());
        result.setOrgType(org.getOrgType());
        result.setHeadString(org.getHeadString());
        result.setSubCode(org.getSubCode());
        result.setEnableStatus(org.getEnableStatus());
        result.setCreateDate(org.getCreateDate());
        result.setCreateName(org.getCreateName());
        result.setUpdateDate(org.getUpdateDate());
        result.setUpdateName(org.getUpdateName());
        result.setStatus(org.getStatus());
        result.setExtChar1(org.getExtChar1());
        result.setExtChar2(org.getExtChar2());
        result.setExtChar3(org.getExtChar3());
        result.setExtChar4(org.getExtChar4());
        result.setExtChar5(org.getExtChar5());
        result.setExtNumber1(org.getExtNumber1());
        result.setExtNumber2(org.getExtNumber2());
        result.setExtNumber3(org.getExtNumber3());
        result.setExtDate1(org.getExtDate1());
        result.setExtDate2(org.getExtDate2());
        result.setIsLeaf(org.getIsLeaf());
        return result;
    }

    @RequestMapping(params={"goTmLogDetailMain"})
    public ModelAndView goTmLogDetailMain(HttpServletRequest request) {
        String businessId = request.getParameter("id");
        request.setAttribute("actionUrl", (Object)("tmPositionController.do?findTmLogList&businessId=" + businessId));
        return new ModelAndView("com/biz/eisp/log/tmLogDetailMain");
    }

    @RequestMapping(params={"findTmLogList"})
    public void findTmLogList(TmLogVo tmLogVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List<TmLogVo> tmLogList = this.tmPositionService.findPositionLogList(tmLogVo, page);
        this.datagridReturn(response, tmLogList, page);
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(TmPositionVo tmPositionVo, HttpServletRequest request, HttpServletResponse response) {
        List<TmPositionVo> tmPositionVoList = this.tmPositionService.findTmPositionList(tmPositionVo, null);
        this.doExportXls(response, request, tmPositionVoList, TmPositionVo.class, "\u804c\u4f4d\u5217\u8868");
    }

    @RequestMapping(params={"goTmPositionByOrgSelectMain"})
    public ModelAndView goTmPositionByOrgSelectMain(TmPositionVo tmPositionVo, HttpServletRequest request) {
        if (StringUtil.isNotEmpty((String)tmPositionVo.getOrgId())) {
            request.setAttribute("orgId", (Object)tmPositionVo.getOrgId());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmPosition/tmPositionByOrgSelectMain");
    }

    @RequestMapping(params={"findTmPositionByOrgSelectList"})
    @ResponseBody
    public DataGrid findTmPositionByOrgSelectList(TmPositionVo tmPositionVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List<TmPositionVo> tmPositionVoList = this.tmPositionService.findTmPositionByOrgSelectList(tmPositionVo, page);
        return new DataGrid(tmPositionVoList, page);
    }

    @RequestMapping(params={"goTmPositionQuerySelectMain"})
    public ModelAndView goTmPositionSelectMain(TmPositionVo tmPositionVo, HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/tmPosition/tmPositionQuerySelectMain");
    }

    @RequestMapping(params={"findTmPositionQuerySelectList"})
    @ResponseBody
    public DataGrid findTmPositionQuerySelectList(TmPositionVo tmPositionVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List<TmPositionVo> tmPositionVoList = this.tmPositionService.findTmPositionQuerySelectList(tmPositionVo, page);
        return new DataGrid(tmPositionVoList, page);
    }

    @RequestMapping(params={"addPositionRoleRelation"})
    @ResponseBody
    public AjaxJson addPositionRoleRelation(String roleId, String positionIds, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            this.tmPositionService.addPositionRoleRelation(positionIds, roleId);
        }
        catch (Exception e) {
            j.setMsg("\u6dfb\u52a0\u804c\u4f4d\u4e0e\u89d2\u8272\u5173\u8054\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            j.setSuccess(false);
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"deletePositionRoleRelation"})
    @ResponseBody
    public AjaxJson deletePositionRoleRelation(String relationIds, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            this.tmPositionService.deletePositionRoleRelation(relationIds);
        }
        catch (Exception e) {
            j.setMsg("\u79fb\u9664\u804c\u4f4d\u4e0e\u89d2\u8272\u5173\u8054\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            j.setSuccess(false);
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"updatePositionRoleRelation"})
    @ResponseBody
    public AjaxJson updatePositionRoleRelation(String relationIds, String roleId, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            this.tmPositionService.updatePositionRoleRelation(relationIds, roleId);
        }
        catch (Exception e) {
            j.setMsg("\u66ff\u6362\u804c\u4f4d\u4e0e\u89d2\u8272\u5173\u8054\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            j.setSuccess(false);
            e.printStackTrace();
        }
        return j;
    }
}

