/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.web;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.service.TbAttachmentExtendsService;
import com.biz.eisp.base.common.service.TbAttachmentService;
import com.biz.eisp.base.common.service.TtActAndAuditBillMainExtendService;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.ReflectHelper;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.entity.TbAttachmentEntity;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.base.utils.MyClassLoader;
import com.biz.eisp.base.utils.UploadFile;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tbAttachmentController"})
public class TbAttachmentController
extends BaseController {
    @Autowired
    private TbAttachmentService tbAttachmentService;
    @Autowired(required=false)
    private TtActAndAuditBillMainExtendService ttActAndAuditBillMainExtendService;
    private TbAttachmentExtendsService tbAttachmentExtendsService;

    @RequestMapping(params={"goTbAttachmentMain"})
    public ModelAndView goTbAttachmentMain(String id, String extendService, String attachmentType, HttpServletRequest request) {
        if (StringUtils.isNotBlank((CharSequence)extendService)) {
            this.tbAttachmentExtendsService = (TbAttachmentExtendsService)ApplicationContextUtils.getContext().getBean(extendService, TbAttachmentExtendsService.class);
            boolean isReadOnly = this.tbAttachmentExtendsService.isReadOnly(id);
            request.setAttribute("isReadOnly", (Object)isReadOnly);
        }
        List voList = this.tbAttachmentService.findTbAttachmentList(id, attachmentType);
        request.setAttribute("voList", (Object)voList);
        request.setAttribute("businessKey", (Object)id);
        request.setAttribute("attachmentType", (Object)attachmentType);
        request.setAttribute("extendService", (Object)extendService);
        String extend = request.getParameter("extend");
        if (StringUtil.isEmpty((String)extend)) {
            extend = "*.*";
        }
        request.setAttribute("extend", (Object)extend);
        return new ModelAndView("com/biz/eisp/base/tbAttachmentMain");
    }

    @RequestMapping(params={"saveFiles"})
    @ResponseBody
    public AjaxJson saveFiles(String extendService, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        try {
            String businessKey = request.getParameter("businessKey");
            String attachmentType = request.getParameter("attachmentType");
            TbAttachmentEntity entity = new TbAttachmentEntity();
            entity.setBusinessKey(businessKey);
            String positionId = ResourceUtil.getCurrPosition().getId();
            TmPositionEntity positionEntity = (TmPositionEntity)this.tbAttachmentService.get(TmPositionEntity.class, (Serializable)((Object)positionId));
            entity.setTmPositionEntity(positionEntity);
            entity.setSubclassName(TbAttachmentEntity.class.getName());
            entity.setAttachmentType(attachmentType);
            UploadFile uploadFile = new UploadFile(request, (Object)entity);
            uploadFile.setExtend("extend");
            uploadFile.setTitleField("attachmentTitle");
            uploadFile.setRealPath("realPath");
            uploadFile.setObject((Object)entity);
            uploadFile.setRename(true);
            this.tbAttachmentService.uploadFile(uploadFile, extendService, businessKey);
            List myAttachmentList = this.tbAttachmentService.findTbAttachmentList(businessKey, attachmentType);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("url", entity.getRealPath());
            attributes.put("fileKey", entity.getId());
            attributes.put("name", entity.getAttachmentTitle());
            attributes.put("delurl", "tbAttachmentController.do?delObjFile&fileKey=" + entity.getId());
            attributes.put("myAttachmentList", myAttachmentList);
            attributes.put("id", entity.getId());
            j.setAttributes(attributes);
            j.setMsg("\u6587\u4ef6\u6dfb\u52a0\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"delObjFile"})
    @ResponseBody
    public AjaxJson delObjFile(HttpServletRequest request, String extendService, String fileKey) {
        String message = null;
        AjaxJson j = new AjaxJson();
        try {
            this.tbAttachmentService.deleteFile(fileKey, extendService);
            message = "\u5220\u9664\u6210\u529f";
            j.setSuccess(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setMsg("\u5220\u9664\u5931\u8d25");
            j.setSuccess(false);
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"viewFile"})
    public void viewFile(HttpServletRequest request, HttpServletResponse response) {
        String fileid = OConvertUtils.getString((String)request.getParameter("fileid"));
        String subclassname = OConvertUtils.getString((String)request.getParameter("subclassName"), (String)"com.biz.eisp.base.core.entity.TbAttachmentQueryEntity");
        Class fileClass = MyClassLoader.getClassByScn((String)subclassname);
        Object fileobj = this.tbAttachmentService.get(fileClass, (Serializable)((Object)fileid));
        ReflectHelper reflectHelper = new ReflectHelper(fileobj);
        UploadFile uploadFile = new UploadFile(request, response);
        String contentfield = OConvertUtils.getString((String)request.getParameter("contentfield"), (String)uploadFile.getByteField());
        byte[] content = (byte[])reflectHelper.getMethodValue(contentfield);
        String path = OConvertUtils.getString((Object)reflectHelper.getMethodValue("realPath"));
        String extend = OConvertUtils.getString((Object)reflectHelper.getMethodValue("extend"));
        String attachmenttitle = OConvertUtils.getString((Object)reflectHelper.getMethodValue("attachmentTitle"));
        uploadFile.setExtend(extend);
        uploadFile.setTitleField(attachmenttitle);
        uploadFile.setRealPath(path);
        uploadFile.setContent(content);
        this.tbAttachmentService.viewOrDownloadFile(uploadFile);
    }

    @RequestMapping(params={"findAttachmentList"})
    @ResponseBody
    public DataGrid findAttachmentList(String businessKey, String attachmentType, HttpServletRequest request, HttpServletResponse response) {
        List voList = this.tbAttachmentService.findTbAttachmentList(businessKey, attachmentType);
        return new DataGrid(voList, null);
    }
}

