/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.exporter;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.exporter.ExcelExportOfTemplateUtil;
import com.biz.eisp.base.exporter.ExcelPublicUtil;
import com.biz.eisp.base.exporter.annotation.Excel;
import com.biz.eisp.base.exporter.annotation.ExcelCollection;
import com.biz.eisp.base.exporter.annotation.ExcelTarget;
import com.biz.eisp.base.exporter.entity.ComparatorExcelField;
import com.biz.eisp.base.exporter.entity.ExcelExportEntity;
import com.biz.eisp.base.exporter.entity.ExcelTitle;
import com.biz.eisp.base.exporter.entity.TemplateExportParams;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.mdm.config.bean.ExportExcelConfig;
import com.biz.eisp.mdm.config.service.DynamicExportFieldService;
import com.biz.eisp.mdm.dict.util.DictUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ExcelExportTmpUtil {
    private static DynamicExportFieldService dynamicExportFieldService = (DynamicExportFieldService)ApplicationContextUtils.getContext().getBean("dynamicExportFieldService");

    public static SXSSFWorkbook exportExcel(List<Map<String, Object>> list) {
        int rowaccess = 100;
        SXSSFWorkbook workbook = new SXSSFWorkbook(rowaccess);
        for (Map<String, Object> map : list) {
            ExcelExportTmpUtil.createSheetInUserModel2File((SXSSFWorkbook)workbook, (ExcelTitle)((ExcelTitle)map.get("title")), (Class)((Class)map.get("entity")), (Collection)((Collection)map.get("data")));
        }
        return workbook;
    }

    public static SXSSFWorkbook exportExcel(ExcelTitle entity, Class<?> pojoClass, Collection<?> dataSet) {
        int rowaccess = 100;
        SXSSFWorkbook wb = new SXSSFWorkbook(rowaccess);
        ExcelExportTmpUtil.createSheetInUserModel2File((SXSSFWorkbook)wb, (ExcelTitle)entity, pojoClass, dataSet);
        return wb;
    }

    public static Workbook exportExcel(TemplateExportParams params, Class<?> pojoClass, Collection<?> dataSet, Map<String, Object> map) {
        return ExcelExportOfTemplateUtil.exportExcel((TemplateExportParams)params, pojoClass, dataSet, map);
    }

    public static Workbook exportExcel(TemplateExportParams params, Map<String, Object> map) {
        return ExcelExportOfTemplateUtil.exportExcel((TemplateExportParams)params, null, null, map);
    }

    public static void createSheetInUserModel2File(SXSSFWorkbook workbook, ExcelTitle entity, Class<?> pojoClass, Collection<?> dataSet) {
        if (dataSet != null) {
            try {
                int num = dataSet.size();
                int sheetnum = 0;
                int evnum = 0;
                int total = 0;
                Sheet sheet = null;
                sheetnum = num % 60000 == 0 ? num / 60000 : num / 60000 + 1;
                Iterator<?> itss = dataSet.iterator();
                ArrayList lst = new ArrayList();
                while (itss.hasNext()) {
                    lst.add(itss.next());
                }
                for (int is = 0; is < sheetnum; ++is) {
                    int i;
                    sheet = workbook.createSheet(entity.getSheetName() + (is > 0 ? Integer.valueOf(is) : ""));
                    Map styles = ExcelExportTmpUtil.createStyles((SXSSFWorkbook)workbook);
                    Drawing patriarch = sheet.createDrawingPatriarch();
                    ArrayList excelParams = new ArrayList();
                    Field[] fileds = ExcelPublicUtil.getClassFields(pojoClass);
                    ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
                    String targetId = null;
                    if (etarget != null) {
                        targetId = etarget.id();
                    }
                    ExcelExportTmpUtil.getAllExcelField((String)targetId, (Field[])fileds, excelParams, pojoClass, null);
                    ExcelExportTmpUtil.sortAllParams(excelParams);
                    int index = 0;
                    int feildWidth = ExcelExportTmpUtil.getFieldWidth(excelParams);
                    if (entity.getTitle() != null) {
                        i = ExcelExportTmpUtil.createHeaderRow((ExcelTitle)entity, (Sheet)sheet, (SXSSFWorkbook)workbook, (int)feildWidth);
                        sheet.createFreezePane(0, 2 + i, 0, 2 + i);
                        index += i;
                    } else {
                        sheet.createFreezePane(0, 2, 0, 2);
                    }
                    ExcelExportTmpUtil.createTitleRow((ExcelTitle)entity, (Sheet)sheet, (SXSSFWorkbook)workbook, (int)index, excelParams);
                    index += 2;
                    ExcelExportTmpUtil.setCellWith(excelParams, (Sheet)sheet);
                    total = is != sheetnum - 1 ? (is + 1) * 60000 : lst.size();
                    for (i = evnum; i < total; ++i) {
                        index += ExcelExportTmpUtil.createCells((Drawing)patriarch, (int)index, lst.get(i), excelParams, (Sheet)sheet, (SXSSFWorkbook)workbook, (Map)styles);
                        ++evnum;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void sortAllParams(List<ExcelExportEntity> excelParams) {
        Collections.sort(excelParams, new ComparatorExcelField());
        for (ExcelExportEntity entity : excelParams) {
            if (entity.getList() == null) continue;
            Collections.sort(entity.getList(), new ComparatorExcelField());
        }
    }

    private static int createCells(Drawing patriarch, int index, Object t, List<ExcelExportEntity> excelParams, Sheet sheet, SXSSFWorkbook workbook, Map<String, CellStyle> styles) throws Exception {
        ExcelExportEntity entity;
        int k;
        Row row = sheet.createRow(index);
        row.setHeight((short)350);
        int maxHeight = 1;
        int cellNum = 0;
        int paramSize = excelParams.size();
        for (k = 0; k < paramSize; ++k) {
            entity = excelParams.get(k);
            if (entity.getList() != null) {
                Collection list = (Collection)entity.getGetMethod().invoke(t, new Object[0]);
                int listC = 0;
                for (Object obj : list) {
                    ExcelExportTmpUtil.createListCells((Drawing)patriarch, (int)(index + listC), (int)cellNum, obj, (List)entity.getList(), (Sheet)sheet, (SXSSFWorkbook)workbook, styles);
                    ++listC;
                }
                cellNum += entity.getList().size();
                if (list == null || list.size() <= maxHeight) continue;
                maxHeight = list.size();
                continue;
            }
            Object value = ExcelExportTmpUtil.getCellValue((ExcelExportEntity)entity, (Object)t);
            if (entity.getType() == 1) {
                ExcelExportTmpUtil.createStringCell((Row)row, (int)cellNum++, (String)(value == null ? "" : value.toString()), (CellStyle)styles.get("one"), (ExcelExportEntity)entity);
                continue;
            }
            if (entity.getType() == 4) {
                ExcelExportTmpUtil.createNumCell((Row)row, (int)cellNum++, (String)(value == null ? "" : value.toString()), (CellStyle)styles.get("one"), (ExcelExportEntity)entity, (SXSSFWorkbook)workbook);
                continue;
            }
            ExcelExportTmpUtil.createImageCell((Drawing)patriarch, (ExcelExportEntity)entity, (Row)row, (int)cellNum++, (String)(value == null ? "" : value.toString()), (Object)t);
        }
        cellNum = 0;
        paramSize = excelParams.size();
        for (k = 0; k < paramSize; ++k) {
            entity = excelParams.get(k);
            if (entity.getList() != null) {
                cellNum += entity.getList().size();
                continue;
            }
            if (!entity.isNeedMerge()) continue;
            sheet.addMergedRegion(new CellRangeAddress(index, index + maxHeight - 1, cellNum, cellNum));
            ++cellNum;
        }
        return maxHeight;
    }

    private static Object getCellValue(ExcelExportEntity entity, Object obj) throws Exception {
        Object value;
        Object object = value = entity.getGetMethods() != null ? ExcelExportTmpUtil.getFieldBySomeMethod((List)entity.getGetMethods(), (Object)obj) : entity.getGetMethod().invoke(obj, new Object[0]);
        if (StringUtils.isNotEmpty((String)entity.getExportFormat())) {
            SimpleDateFormat format;
            Date temp = null;
            if (value instanceof String) {
                format = new SimpleDateFormat(entity.getDatabaseFormat());
                temp = format.parse(value.toString());
            } else if (value instanceof Date) {
                temp = (Date)value;
            }
            if (temp != null) {
                format = new SimpleDateFormat(entity.getExportFormat());
                value = format.format(temp);
            }
        }
        if (StringUtil.isNotEmpty((Object)value) && entity.getDictMap() != null && entity.getDictMap().size() > 0) {
            return entity.getDictMap().get(String.valueOf(value));
        }
        return value == null ? "" : value.toString();
    }

    private static void createListCells(Drawing patriarch, int index, int cellNum, Object obj, List<ExcelExportEntity> excelParams, Sheet sheet, SXSSFWorkbook workbook, Map<String, CellStyle> styles) throws Exception {
        Row row;
        if (sheet.getRow(index) == null) {
            row = sheet.createRow(index);
            row.setHeight((short)350);
        } else {
            row = sheet.getRow(index);
        }
        int paramSize = excelParams.size();
        for (int k = 0; k < paramSize; ++k) {
            ExcelExportEntity entity = excelParams.get(k);
            Object value = ExcelExportTmpUtil.getCellValue((ExcelExportEntity)entity, (Object)obj);
            if (entity.getType() == 1) {
                ExcelExportTmpUtil.createStringCell((Row)row, (int)cellNum++, (String)(value == null ? "" : value.toString()), (CellStyle)(row.getRowNum() % 2 == 0 ? ExcelExportTmpUtil.getStyles(styles, (boolean)false, (boolean)entity.isWrap()) : ExcelExportTmpUtil.getStyles(styles, (boolean)true, (boolean)entity.isWrap())), (ExcelExportEntity)entity);
                continue;
            }
            ExcelExportTmpUtil.createImageCell((Drawing)patriarch, (ExcelExportEntity)entity, (Row)row, (int)cellNum++, (String)(value == null ? "" : value.toString()), (Object)obj);
        }
    }

    private static Object getFieldBySomeMethod(List<Method> list, Object t) throws Exception {
        for (Method m : list) {
            if (t == null) {
                t = "";
                break;
            }
            t = m.invoke(t, new Object[0]);
        }
        return t;
    }

    private static void setCellWith(List<ExcelExportEntity> excelParams, Sheet sheet) {
        int index = 0;
        for (int i = 0; i < excelParams.size(); ++i) {
            if (excelParams.get(i).getList() != null) {
                List list = excelParams.get(i).getList();
                for (int j = 0; j < list.size(); ++j) {
                    sheet.setColumnWidth(index, 256 * ((ExcelExportEntity)list.get(j)).getWidth());
                    ++index;
                }
                continue;
            }
            sheet.setColumnWidth(index, 256 * excelParams.get(i).getWidth());
            ++index;
        }
    }

    private static void createTitleRow(ExcelTitle title, Sheet sheet, SXSSFWorkbook workbook, int index, List<ExcelExportEntity> excelParams) {
        Row row = sheet.createRow(index);
        Row row1 = sheet.createRow(index + 1);
        row.setHeight((short)450);
        int cellIndex = 0;
        CellStyle titleStyle = ExcelExportTmpUtil.getTitleStyle((SXSSFWorkbook)workbook, (ExcelTitle)title);
        int exportFieldTitleSize = excelParams.size();
        for (int i = 0; i < exportFieldTitleSize; ++i) {
            ExcelExportEntity entity = excelParams.get(i);
            ExcelExportTmpUtil.createStringCell((Row)row, (int)cellIndex, (String)entity.getName(), (CellStyle)titleStyle, (ExcelExportEntity)entity);
            if (entity.getList() != null) {
                List sTitel = entity.getList();
                sheet.addMergedRegion(new CellRangeAddress(index, index, cellIndex, cellIndex + sTitel.size() - 1));
                int size = sTitel.size();
                for (int j = 0; j < size; ++j) {
                    ExcelExportTmpUtil.createStringCell((Row)row1, (int)cellIndex, (String)((ExcelExportEntity)sTitel.get(j)).getName(), (CellStyle)titleStyle, (ExcelExportEntity)entity);
                    ++cellIndex;
                }
                continue;
            }
            sheet.addMergedRegion(new CellRangeAddress(index, index + 1, cellIndex, cellIndex));
            ++cellIndex;
        }
    }

    private static void createStringCell(Row row, int index, String text, CellStyle style, ExcelExportEntity entity) {
        Cell cell = row.createCell(index);
        HSSFRichTextString Rtext = new HSSFRichTextString(text);
        cell.setCellValue((RichTextString)Rtext);
        cell.setCellStyle(style);
    }

    private static void createNumCell(Row row, int index, String text, CellStyle style, ExcelExportEntity entity, SXSSFWorkbook workbook) {
        boolean isNum;
        Cell cell = row.createCell(index);
        boolean b = false;
        if (StringUtils.isNotBlank((String)text) && (isNum = text.toString().matches("^(-?\\d+)(\\.\\d+)?$"))) {
            if (entity != null && StringUtils.isNotBlank((String)entity.getExportDataFormat())) {
                DataFormat format = workbook.createDataFormat();
                style.setDataFormat(format.getFormat(entity.getExportDataFormat()));
            }
            cell.setCellValue(Double.parseDouble(text));
            b = true;
        }
        if (!b) {
            cell.setCellValue(text);
        }
        cell.setCellStyle(style);
    }

    private static void createImageCell(Drawing patriarch, ExcelExportEntity entity, Row row, int i, String string, Object obj) throws Exception {
        row.setHeight((short)(50 * entity.getHeight()));
        row.createCell(i);
        HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 0, 0, (short)i, row.getRowNum(), (short)(i + 1), row.getRowNum() + 1);
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        if (entity.getExportImageType() == 1) {
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            try {
                String path = string;
                BufferedImage bufferImg = ImageIO.read(new File(path));
                ImageIO.write((RenderedImage)bufferImg, string.substring(string.indexOf(".") + 1, string.length()), byteArrayOut);
                byte[] value = byteArrayOut.toByteArray();
                patriarch.createPicture((ClientAnchor)anchor, row.getSheet().getWorkbook().addPicture(value, ExcelExportTmpUtil.getImageType((byte[])value)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            byte[] value = (byte[])(entity.getGetMethods() != null ? ExcelExportTmpUtil.getFieldBySomeMethod((List)entity.getGetMethods(), (Object)obj) : entity.getGetMethod().invoke(obj, new Object[0]));
            if (value != null) {
                patriarch.createPicture((ClientAnchor)anchor, row.getSheet().getWorkbook().addPicture(value, ExcelExportTmpUtil.getImageType((byte[])value)));
            }
        }
    }

    private static int getImageType(byte[] value) {
        String type = ExcelPublicUtil.getFileExtendName((byte[])value);
        if (type.equalsIgnoreCase("JPG")) {
            return 5;
        }
        if (type.equalsIgnoreCase("PNG")) {
            return 6;
        }
        return 5;
    }

    private static int createHeaderRow(ExcelTitle entity, Sheet sheet, SXSSFWorkbook workbook, int feildWidth) {
        Row row = sheet.createRow(0);
        row.setHeight((short)900);
        ExcelExportTmpUtil.createStringCell((Row)row, (int)0, (String)entity.getTitle(), (CellStyle)ExcelExportTmpUtil.getHeaderStyle((SXSSFWorkbook)workbook, (ExcelTitle)entity), null);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, feildWidth));
        if (entity.getSecondTitle() != null) {
            row = sheet.createRow(1);
            CellStyle style = workbook.createCellStyle();
            style.setAlignment((short)3);
            ExcelExportTmpUtil.createStringCell((Row)row, (int)0, (String)entity.getSecondTitle(), (CellStyle)style, null);
            sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, feildWidth));
            return 2;
        }
        return 1;
    }

    private static int getFieldWidth(List<ExcelExportEntity> excelParams) {
        int length = -1;
        for (ExcelExportEntity entity : excelParams) {
            length += entity.getList() != null ? entity.getList().size() : 1;
        }
        return length;
    }

    private static void getAllExcelField(String targetId, Field[] fields, List<ExcelExportEntity> excelParams, Class<?> pojoClass, List<Method> getMethods) throws Exception {
        for (int i = 0; i < fields.length; ++i) {
            ExcelExportEntity excelEntity;
            ExcelCollection excel;
            String tableName;
            Field field = fields[i];
            if (ExcelPublicUtil.isNotUserExcelUserThis((Field)field, (String)targetId)) continue;
            ExportExcelConfig excelConfig = null;
            Excel cs = field.getAnnotation(Excel.class);
            if (StringUtil.isNotEmpty((Object)cs) && StringUtil.isNotEmpty((String)cs.tableName()) && !dynamicExportFieldService.judgeIsExport(excelConfig = dynamicExportFieldService.getExportExcelConfig(tableName = cs.tableName(), field.getName()))) continue;
            if (ExcelPublicUtil.isCollection(field.getType())) {
                excel = field.getAnnotation(ExcelCollection.class);
                ParameterizedType pt = (ParameterizedType)field.getGenericType();
                Class clz = (Class)pt.getActualTypeArguments()[0];
                ArrayList list = new ArrayList();
                ExcelExportTmpUtil.getExcelFieldList((String)targetId, (Field[])ExcelPublicUtil.getClassFields((Class)clz), (Class)clz, list, null);
                excelEntity = new ExcelExportEntity();
                String name = null;
                Integer order = null;
                if (StringUtil.isNotEmpty((Object)excelConfig)) {
                    name = excelConfig.getExportName();
                    order = Integer.parseInt(excelConfig.getExprotOrder());
                } else {
                    name = ExcelExportTmpUtil.getExcelName((String)excel.exportName(), (String)targetId);
                    order = ExcelExportTmpUtil.getCellOrder((String)excel.orderNum(), (String)targetId);
                }
                excelEntity.setName(name);
                excelEntity.setOrderNum(order.intValue());
                excelEntity.setGetMethod(ExcelPublicUtil.getMethod((String)field.getName(), pojoClass));
                excelEntity.setList(list);
                excelParams.add(excelEntity);
                continue;
            }
            if (ExcelPublicUtil.isJavaClass((Field)field)) {
                excel = field.getAnnotation(Excel.class);
                excelEntity = new ExcelExportEntity();
                excelEntity.setType(excel.exportType());
                ExcelExportTmpUtil.getExcelField((String)targetId, (Field)field, (ExcelExportEntity)excelEntity, (Excel)excel, pojoClass, (ExportExcelConfig)excelConfig);
                if (getMethods != null) {
                    ArrayList<Method> newMethods = new ArrayList<Method>();
                    newMethods.addAll(getMethods);
                    newMethods.add(excelEntity.getGetMethod());
                    excelEntity.setGetMethods(newMethods);
                }
                excelParams.add(excelEntity);
                continue;
            }
            ArrayList<Method> newMethods = new ArrayList<Method>();
            if (getMethods != null) {
                newMethods.addAll(getMethods);
            }
            newMethods.add(ExcelPublicUtil.getMethod((String)field.getName(), pojoClass));
            ExcelExportTmpUtil.getAllExcelField((String)targetId, (Field[])ExcelPublicUtil.getClassFields(field.getType()), excelParams, field.getType(), newMethods);
        }
    }

    private static String getExcelName(String exportName, String targetId) {
        String[] arr;
        if (exportName.indexOf(",") < 0) {
            return exportName;
        }
        for (String str : arr = exportName.split(",")) {
            if (str.indexOf(targetId) == -1) continue;
            return str.split("_")[0];
        }
        return null;
    }

    private static int getCellOrder(String orderNum, String targetId) {
        String[] arr;
        if (ExcelExportTmpUtil.isInteger((String)orderNum) || targetId == null) {
            return Integer.valueOf(orderNum);
        }
        for (String str : arr = orderNum.split(",")) {
            if (str.indexOf(targetId) == -1) continue;
            return Integer.valueOf(str.split("_")[0]);
        }
        return 0;
    }

    public static boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static void getExcelFieldList(String targetId, Field[] fields, Class<?> pojoClass, List<ExcelExportEntity> list, List<Method> getMethods) throws Exception {
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (ExcelPublicUtil.isNotUserExcelUserThis((Field)field, (String)targetId)) continue;
            if (ExcelPublicUtil.isJavaClass((Field)field)) {
                Excel excel = field.getAnnotation(Excel.class);
                ExcelExportEntity excelEntity = new ExcelExportEntity();
                ExcelExportTmpUtil.getExcelField((String)targetId, (Field)field, (ExcelExportEntity)excelEntity, (Excel)excel, pojoClass, null);
                excelEntity.setType(excel.exportType());
                if (getMethods != null) {
                    ArrayList<Method> newMethods = new ArrayList<Method>();
                    newMethods.addAll(getMethods);
                    newMethods.add(excelEntity.getGetMethod());
                    excelEntity.setGetMethods(newMethods);
                }
                list.add(excelEntity);
                continue;
            }
            ArrayList<Method> newMethods = new ArrayList<Method>();
            if (getMethods != null) {
                newMethods.addAll(getMethods);
            }
            newMethods.add(ExcelPublicUtil.getMethod((String)field.getName(), pojoClass));
            ExcelExportTmpUtil.getExcelFieldList((String)targetId, (Field[])ExcelPublicUtil.getClassFields(field.getType()), field.getType(), list, newMethods);
        }
    }

    public static void getExcelField(String targetId, Field field, ExcelExportEntity excelEntity, Excel excel, Class<?> pojoClass, ExportExcelConfig excelConfig) throws Exception {
        String name = null;
        Integer order = null;
        if (StringUtil.isNotEmpty((Object)excelConfig)) {
            name = excelConfig.getExportName();
            order = Integer.parseInt(excelConfig.getExprotOrder());
        } else {
            name = ExcelExportTmpUtil.getExcelName((String)excel.exportName(), (String)targetId);
            order = ExcelExportTmpUtil.getCellOrder((String)excel.orderNum(), (String)targetId);
        }
        excelEntity.setName(name);
        excelEntity.setOrderNum(order.intValue());
        excelEntity.setWidth(excel.exportFieldWidth());
        excelEntity.setHeight(excel.exportFieldHeight());
        excelEntity.setNeedMerge(excel.needMerge());
        excelEntity.setWrap(excel.isWrap());
        excelEntity.setExportImageType(excel.imageType());
        excelEntity.setExportDataFormat(excel.exportDataFormat());
        excelEntity.setExportFormat(StringUtils.isNotEmpty((String)excel.exportFormat()) ? excel.exportFormat() : excel.imExFormat());
        String fieldname = field.getName();
        excelEntity.setGetMethod(ExcelPublicUtil.getMethod((String)fieldname, pojoClass));
        if (excel.exportConvertSign() == 1 || excel.imExConvert() == 1) {
            StringBuffer getConvertMethodName = new StringBuffer("convertGet");
            getConvertMethodName.append(fieldname.substring(0, 1).toUpperCase());
            getConvertMethodName.append(fieldname.substring(1));
            Method getConvertMethod = pojoClass.getMethod(getConvertMethodName.toString(), new Class[0]);
            excelEntity.setGetMethod(getConvertMethod);
        }
        if (StringUtil.isNotEmpty((Object)excelConfig) && StringUtils.isNotEmpty((String)excelConfig.getDictCode())) {
            Map map = DictUtil.getDictMap((String)excelConfig.getDictCode());
            HashMap dictMap = new HashMap();
            if (map != null && map.size() > 0) {
                map.forEach((k, v) -> {
                    KnlDictDataEntity dictEntity = (KnlDictDataEntity)v;
                    dictMap.put(dictEntity.getDictCode(), dictEntity.getDictValue());
                });
            }
            excelEntity.setDictMap(dictMap);
        } else if (StringUtils.isNotEmpty((String)excel.dicCode())) {
            HashMap dictMap = new HashMap();
            Map map = DictUtil.getDictMap((String)excel.dicCode());
            if (map != null && map.size() > 0) {
                map.forEach((k, v) -> {
                    KnlDictDataEntity dictEntity = (KnlDictDataEntity)v;
                    dictMap.put(dictEntity.getDictCode(), dictEntity.getDictValue());
                });
            }
            excelEntity.setDictMap(dictMap);
        }
    }

    public static CellStyle getTitleStyle(SXSSFWorkbook workbook, ExcelTitle entity) {
        CellStyle titleStyle = workbook.createCellStyle();
        titleStyle.setFillForegroundColor(entity.getHeaderColor());
        titleStyle.setAlignment((short)2);
        titleStyle.setVerticalAlignment((short)1);
        titleStyle.setFillPattern((short)1);
        titleStyle.setWrapText(true);
        return titleStyle;
    }

    public static CellStyle getHeaderStyle(SXSSFWorkbook workbook, ExcelTitle entity) {
        CellStyle titleStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)24);
        titleStyle.setFont(font);
        titleStyle.setFillForegroundColor(entity.getColor());
        titleStyle.setAlignment((short)2);
        titleStyle.setVerticalAlignment((short)1);
        return titleStyle;
    }

    public static CellStyle getTwoStyle(SXSSFWorkbook workbook, boolean isWarp) {
        CellStyle style = workbook.createCellStyle();
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderBottom((short)1);
        style.setBorderTop((short)1);
        style.setFillForegroundColor((short)41);
        style.setFillPattern((short)1);
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        if (isWarp) {
            style.setWrapText(true);
        }
        return style;
    }

    public static CellStyle getOneStyle(SXSSFWorkbook workbook, boolean isWarp) {
        CellStyle style = workbook.createCellStyle();
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderBottom((short)1);
        style.setBorderTop((short)1);
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        if (isWarp) {
            style.setWrapText(true);
        }
        return style;
    }

    private static Map<String, CellStyle> createStyles(SXSSFWorkbook workbook) {
        HashMap<String, CellStyle> map = new HashMap<String, CellStyle>();
        map.put("one", ExcelExportTmpUtil.getOneStyle((SXSSFWorkbook)workbook, (boolean)false));
        return map;
    }

    private static CellStyle getStyles(Map<String, CellStyle> map, boolean needOne, boolean isWrap) {
        if (needOne && isWrap) {
            return map.get("oneWrap");
        }
        if (needOne) {
            return map.get("one");
        }
        if (!needOne && isWrap) {
            return map.get("twoWrap");
        }
        return map.get("two");
    }
}

