/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.login.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ContextHolderUtils;
import com.biz.eisp.base.common.util.IpUtil;
import com.biz.eisp.base.common.util.JsonUtil;
import com.biz.eisp.base.common.util.Md5EncryptionAndDecryption;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.vo.BaseVo;
import com.biz.eisp.base.core.redis.cache.impl.RedisService;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.utils.AppcenterUtil;
import com.biz.eisp.base.utils.CookiesUtil;
import com.biz.eisp.base.utils.DateUtils;
import com.biz.eisp.base.utils.UserRedis;
import com.biz.eisp.login.service.LoginService;
import com.biz.eisp.login.service.LoginrRelatedService;
import com.biz.eisp.login.service.PasswdService;
import com.biz.eisp.login.utils.OpenIdUtil;
import com.biz.eisp.login.utils.Snippet;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.customer.entity.TmCustomerItemEntity;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.custuser.entity.TmRUserCustomerEntity;
import com.biz.eisp.mdm.function.service.MenuPermissionService;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.position.service.PositionService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.entity.TmWxOpenIdEntity;
import com.biz.eisp.mdm.user.vo.LoginUserVo;
import com.biz.eisp.mdm.user.vo.OpenIdVo;
import com.biz.eisp.mdm.web.pojo.Client;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="loginService")
@Transactional
public class LoginServiceImpl
extends BaseServiceImpl
implements LoginService {
    @Autowired
    private PositionService positionService;
    @Autowired
    private RedisService redisService;
    @Autowired(required=false)
    private LoginrRelatedService loginrRelatedService;
    @Autowired(required=false)
    private PasswdService passwdService;
    @Autowired
    private MenuPermissionService menuPermissionService;

    public AjaxJson validateUserWx(LoginUserVo loginUserVo, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson ajaxJson = new AjaxJson();
        String configLoginErrTimes = ResourceUtil.getSysConfigProperty((String)"loginErrTimes");
        int errTime = Integer.valueOf(configLoginErrTimes);
        Object object = this.redisService.get("MDM_LOGIN_" + loginUserVo.getUsername());
        int time = 0;
        if (StringUtil.isNotEmpty((Object)object) && (time = Integer.valueOf(object.toString()).intValue()) > errTime) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u5bc6\u7801\u9519\u8bef\u8d85\u8fc75\u6b21\uff0c\u5c06\u9501\u5b9a24\u5c0f\u65f6");
            return ajaxJson;
        }
        String hql = "from TmUserEntity where userName = ? and userType in (0,1) ";
        List list = super.findByHql(hql, new Object[]{loginUserVo.getUsername()});
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            TmUserEntity userEntity = (TmUserEntity)list.get(0);
            if (Globals.ONE.equals(userEntity.getEnableStatus())) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u7528\u6237\u8d26\u53f7\u9501\u5b9a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                return ajaxJson;
            }
            String pwd = loginUserVo.getPassword();
            pwd = this.passwdService != null && this.passwdService.isExtend(userEntity) ? this.passwdService.pwd(pwd) : Md5EncryptionAndDecryption.encryPwd((String)pwd);
            if (!pwd.equals(userEntity.getPassword())) {
                ajaxJson.setSuccess(false);
                this.redisService.setDays("MDM_LOGIN_" + loginUserVo.getUsername(), (Object)(++time), 1L);
                if (time >= errTime) {
                    ajaxJson.setMsg("\u5bc6\u7801\u9519\u8bef\u8d85\u8fc7" + errTime + "\u6b21\uff0c\u5c06\u9501\u5b9a24\u5c0f\u65f6");
                } else {
                    ajaxJson.setMsg("\u5bc6\u7801\u9519\u8bef,\u60a8\u8fd8\u6709" + (errTime - time) + "\u673a\u4f1a");
                }
                return ajaxJson;
            }
            this.redisService.del(new String[]{"MDM_LOGIN_" + loginUserVo.getUsername()});
            String openid = (String)this.redisService.get("OPEN_ID_" + loginUserVo.getCode());
            if (StringUtil.isEmpty((String)openid)) {
                OpenIdVo openIdVo = OpenIdUtil.getOpenId((String)loginUserVo.getCode());
                if (StringUtil.isEmpty((Object)openIdVo) || StringUtil.isEmpty((String)openIdVo.getOpenid())) {
                    throw new BusinessException("\u65e0\u767b\u5f55\u6743\u9650");
                }
                openid = openIdVo.getOpenid();
                this.redisService.setSeconds("OPEN_ID_" + loginUserVo.getCode(), (Object)openid, 7200L);
            }
            if ("Y".equals(ResourceUtil.getSysConfigProperty((String)"wxbinding"))) {
                boolean flag = false;
                List wxOpenIdList = this.findByProperty(TmWxOpenIdEntity.class, "username", (Object)loginUserVo.getUsername());
                if (CollectionUtil.listNotEmptyNotSizeZero((List)wxOpenIdList)) {
                    if (wxOpenIdList.size() > 1) {
                        throw new BusinessException("\u8be5\u8d26\u53f7\u5df2\u7ecf\u7ed1\u5b9a\u591a\u4e2a\u5fae\u4fe1\uff0c\u6e05\u5148\u89e3\u7ed1");
                    }
                    for (TmWxOpenIdEntity item : wxOpenIdList) {
                        if (!openid.equals(item.getOpenid())) continue;
                        flag = true;
                        break;
                    }
                }
                if (!flag) {
                    TmWxOpenIdEntity newWxOpenIdEntity = new TmWxOpenIdEntity();
                    newWxOpenIdEntity.setUsername(loginUserVo.getUsername());
                    newWxOpenIdEntity.setOpenid(openid);
                    newWxOpenIdEntity.setCreateDate(new Date());
                    this.save((Object)newWxOpenIdEntity);
                }
            }
            try {
                List custItems = new ArrayList();
                TmCustomerEntity customerEntity = null;
                if (Globals.CUST_USER.equals(userEntity.getUserType())) {
                    String hqlCustomer = " from TmCustomerItemEntity where custCode = ? and status = ? ";
                    custItems = super.findByHql(hqlCustomer, new Object[]{loginUserVo.getUsername(), Globals.add});
                } else {
                    List rUserCustomerEntities = super.findByProperty(TmRUserCustomerEntity.class, "tmUser.id", (Object)userEntity.getId());
                    if (!CollectionUtil.listNotEmptyNotSizeZero((List)rUserCustomerEntities)) {
                        ajaxJson.setSuccess(false);
                        ajaxJson.setMsg("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u7528\u6237,\u4e0e\u7ecf\u9500\u5546\u7684\u5173\u7cfb");
                        return ajaxJson;
                    }
                    TmRUserCustomerEntity rUserCustomerEntity = (TmRUserCustomerEntity)rUserCustomerEntities.get(0);
                    customerEntity = (TmCustomerEntity)super.get(TmCustomerEntity.class, (Serializable)((Object)rUserCustomerEntity.getTmCustomer().getId()));
                    if (null == customerEntity) {
                        ajaxJson.setSuccess(false);
                        ajaxJson.setMsg("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u7528\u6237,\u4e0e\u7ecf\u9500\u5546\u7684\u5173\u7cfb");
                        return ajaxJson;
                    }
                    String hqlCustomer = " from TmCustomerItemEntity where custCode = ? and status = ? ";
                    custItems = super.findByHql(hqlCustomer, new Object[]{customerEntity.getCustomerCode(), Globals.add});
                }
                BaseVo baseVo = new BaseVo();
                baseVo.setUserType(userEntity.getUserType());
                if (CollectionUtil.listNotEmptyNotSizeZero(custItems)) {
                    boolean flag = true;
                    for (TmCustomerItemEntity item : custItems) {
                        if (!"1".equals(item.getCheckStatus())) continue;
                        baseVo.setId(item.getId());
                        flag = false;
                        break;
                    }
                    if (flag) {
                        TmCustomerItemEntity itemEntity = (TmCustomerItemEntity)custItems.get(0);
                        itemEntity.setCheckStatus("1");
                        this.updateEntity((Object)itemEntity);
                        baseVo.setId(itemEntity.getId());
                    }
                } else {
                    ajaxJson.setSuccess(false);
                    ajaxJson.setMsg("\u5ba2\u6237\u516c\u53f8\u4fe1\u606f\u7ef4\u62a4\u4e0d\u5b8c\u6574\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                    return ajaxJson;
                }
                ajaxJson.setVo(baseVo);
                if (!loginUserVo.getLangcode().equals(userEntity.getLangCode())) {
                    userEntity.setLangCode(loginUserVo.getLangcode());
                }
                String key = Snippet.aesEncrypt((String)CookiesUtil.getKeyFlag((String)loginUserVo.getUsername()), (String)"1oR8uIM2O5qv65l2");
                UserRedis userRedis = this.createUserRedis(userEntity, customerEntity, null, Globals.LOGIN_SOURCE_WX);
                String value = JsonUtil.bean2json((Object)userRedis);
                String redisKey = "LOGIN_SUCCESS_" + key;
                this.redisService.setDays(redisKey, (Object)value, 1825L);
                ajaxJson.setFlagId(key);
                ajaxJson.setObj((Object)userRedis);
                List tmFunctions = this.menuPermissionService.getFunctionsByUser(userEntity);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)tmFunctions)) {
                    ajaxJson.setTmFunctions(tmFunctions);
                }
            }
            catch (Exception e) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u64cd\u4f5c\u5904\u7406\u5f02\u5e38");
            }
            ajaxJson.setSuccess(true);
            ajaxJson.setMsg("\u767b\u5f55\u6210\u529f");
            return ajaxJson;
        }
        ajaxJson.setSuccess(false);
        ajaxJson.setMsg("\u7528\u6237\u4e0d\u5b58\u5728");
        return ajaxJson;
    }

    public AjaxJson validateUserApp(LoginUserVo loginUserVo, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson ajaxJson = new AjaxJson();
        String configLoginErrTimes = ResourceUtil.getSysConfigProperty((String)"loginErrTimes");
        int errTime = Integer.valueOf(configLoginErrTimes);
        Object object = this.redisService.get("MDM_LOGIN_" + loginUserVo.getUsername());
        int time = 0;
        if (StringUtil.isNotEmpty((Object)object) && (time = Integer.valueOf(object.toString()).intValue()) > errTime) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u5bc6\u7801\u9519\u8bef\u8d85\u8fc75\u6b21\uff0c\u5c06\u9501\u5b9a24\u5c0f\u65f6");
            return ajaxJson;
        }
        String hql = "from TmUserEntity where userName = ? and userType=0 ";
        List list = super.findByHql(hql, new Object[]{loginUserVo.getUsername()});
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            TmPositionVo tmPositionVo;
            TmUserEntity userEntity = (TmUserEntity)list.get(0);
            if (Globals.ONE.equals(userEntity.getEnableStatus())) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u7528\u6237\u8d26\u53f7\u9501\u5b9a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                return ajaxJson;
            }
            this.checkDate(userEntity, ajaxJson);
            if (!ajaxJson.isSuccess()) {
                return ajaxJson;
            }
            String pwd = loginUserVo.getPassword();
            pwd = this.passwdService != null && this.passwdService.isExtend(userEntity) ? this.passwdService.pwd(pwd) : Md5EncryptionAndDecryption.encryPwd((String)pwd);
            if (!pwd.equals(userEntity.getPassword())) {
                ajaxJson.setSuccess(false);
                this.redisService.setDays("MDM_LOGIN_" + loginUserVo.getUsername(), (Object)(++time), 1L);
                if (time >= errTime) {
                    ajaxJson.setMsg("\u5bc6\u7801\u9519\u8bef\u8d85\u8fc7" + errTime + "\u6b21\uff0c\u5c06\u9501\u5b9a24\u5c0f\u65f6");
                } else {
                    ajaxJson.setMsg("\u5bc6\u7801\u9519\u8bef,\u60a8\u8fd8\u6709" + (errTime - time) + "\u673a\u4f1a");
                }
                return ajaxJson;
            }
            this.redisService.del(new String[]{"MDM_LOGIN_" + loginUserVo.getUsername()});
            List positions = this.positionService.getPositinByUserId(userEntity, Globals.Main_Position_Type);
            if (positions.size() == 0 && userEntity.getUserType() == Globals.ENTERPRISE_USER) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u7528\u6237\u672a\u5206\u914d\u4e3b\u804c\u4f4d,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                return ajaxJson;
            }
            if (userEntity.getUserType() == Globals.ENTERPRISE_USER && Globals.ONE.equals((tmPositionVo = (TmPositionVo)positions.get(0)).getEnableStatus())) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u7528\u6237\u6240\u5c5e\u4e3b\u804c\u4f4d\u88ab\u505c\u7528,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                return ajaxJson;
            }
            TmPositionVo positionVo = (TmPositionVo)positions.get(0);
            try {
                if (!loginUserVo.getLangcode().equals(userEntity.getLangCode())) {
                    userEntity.setLangCode(loginUserVo.getLangcode());
                }
                String key = Snippet.aesEncrypt((String)CookiesUtil.getKeyFlag((String)loginUserVo.getUsername()), (String)"1oR8uIM2O5qv65l2");
                UserRedis userRedis = this.createUserRedis(userEntity, null, positionVo, Globals.LOGIN_SOURCE_APP);
                String value = JsonUtil.bean2json((Object)userRedis);
                String redisKey = "LOGIN_SUCCESS_" + key;
                this.redisService.setDays(redisKey, (Object)value, 1825L);
                ajaxJson.setFlagId(key);
                ajaxJson.setObj((Object)userRedis);
            }
            catch (Exception e) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u64cd\u4f5c\u5904\u7406\u5f02\u5e38");
            }
            ajaxJson.setSuccess(true);
            ajaxJson.setMsg("\u767b\u5f55\u6210\u529f");
            return ajaxJson;
        }
        ajaxJson.setSuccess(false);
        ajaxJson.setMsg("\u7528\u6237\u4e0d\u5b58\u5728");
        return ajaxJson;
    }

    public AjaxJson validateUserPc(LoginUserVo loginUserVo, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson ajaxJson = new AjaxJson();
        String configLoginErrTimes = ResourceUtil.getSysConfigProperty((String)"loginErrTimes");
        int errTime = Integer.valueOf(configLoginErrTimes);
        Object object = this.redisService.get("MDM_LOGIN_" + loginUserVo.getUsername());
        int time = 0;
        if (StringUtil.isNotEmpty((Object)object) && (time = Integer.valueOf(object.toString()).intValue()) > errTime) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u5bc6\u7801\u9519\u8bef\u8d85\u8fc75\u6b21\uff0c\u5c06\u9501\u5b9a24\u5c0f\u65f6");
            return ajaxJson;
        }
        String hql = "from TmUserEntity where userName = ? and userType=1 ";
        List list = super.findByHql(hql, new Object[]{loginUserVo.getUsername()});
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            TmCustomerItemEntity entity;
            TmUserEntity userEntity = (TmUserEntity)list.get(0);
            if (Globals.ONE.equals(userEntity.getEnableStatus())) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u7528\u6237\u8d26\u53f7\u9501\u5b9a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                return ajaxJson;
            }
            this.checkDate(userEntity, ajaxJson);
            if (!ajaxJson.isSuccess()) {
                return ajaxJson;
            }
            String pwd = loginUserVo.getPassword();
            pwd = this.passwdService != null && this.passwdService.isExtend(userEntity) ? this.passwdService.pwd(pwd) : Md5EncryptionAndDecryption.encryPwd((String)pwd);
            if (!pwd.equals(userEntity.getPassword())) {
                ajaxJson.setSuccess(false);
                this.redisService.setDays("MDM_LOGIN_" + loginUserVo.getUsername(), (Object)(++time), 1L);
                if (time >= errTime) {
                    ajaxJson.setMsg("\u5bc6\u7801\u9519\u8bef\u8d85\u8fc7" + errTime + "\u6b21\uff0c\u5c06\u9501\u5b9a24\u5c0f\u65f6");
                } else {
                    ajaxJson.setMsg("\u5bc6\u7801\u9519\u8bef,\u60a8\u8fd8\u6709" + (errTime - time) + "\u673a\u4f1a");
                }
                return ajaxJson;
            }
            TmCustomerEntity tmCustomer = null;
            this.redisService.del(new String[]{"MDM_LOGIN_" + loginUserVo.getUsername()});
            String hqlCustomer = " from TmCustomerItemEntity where custCode = ? and status = ? ";
            List custItems = super.findByHql(hqlCustomer, new Object[]{loginUserVo.getUsername(), Globals.add});
            if (CollectionUtil.listNotEmptyNotSizeZero((List)custItems)) {
                boolean flag = true;
                entity = null;
                for (TmCustomerItemEntity item : custItems) {
                    if (!"1".equals(item.getCheckStatus())) continue;
                    entity = item;
                    flag = false;
                    break;
                }
                if (flag) {
                    TmCustomerItemEntity itemEntity = (TmCustomerItemEntity)custItems.get(0);
                    itemEntity.setCheckStatus("1");
                    this.updateEntity((Object)itemEntity);
                    entity = itemEntity;
                }
                if (null == (tmCustomer = (TmCustomerEntity)this.findUniqueByProperty(TmCustomerEntity.class, "customerCode", (Object)entity.getCustCode()))) {
                    ajaxJson.setSuccess(false);
                    ajaxJson.setMsg("\u5ba2\u6237\u516c\u53f8\u4fe1\u606f\u7ef4\u62a4\u4e0d\u5b8c\u6574\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                    return ajaxJson;
                }
            } else {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u5ba2\u6237\u516c\u53f8\u4fe1\u606f\u7ef4\u62a4\u4e0d\u5b8c\u6574\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                return ajaxJson;
            }
            entity.setCustName(tmCustomer.getCustomerName());
            ajaxJson.setObj((Object)entity);
            try {
                if (!loginUserVo.getLangcode().equals(userEntity.getLangCode())) {
                    userEntity.setLangCode(loginUserVo.getLangcode());
                }
                String key = Snippet.aesEncrypt((String)CookiesUtil.getKeyFlag((String)loginUserVo.getUsername()), (String)"1oR8uIM2O5qv65l2");
                CookiesUtil.doCoke((HttpServletRequest)request, (HttpServletResponse)response, (String)key);
                UserRedis userRedis = this.createUserRedis(userEntity, tmCustomer, null, Globals.LOGIN_SOURCE_PC);
                String value = JsonUtil.bean2json((Object)userRedis);
                this.redisService.setSeconds("LOGIN_SUCCESS_" + key, (Object)value, 86400L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ajaxJson.setSuccess(true);
            ajaxJson.setMsg("\u767b\u5f55\u6210\u529f");
            return ajaxJson;
        }
        ajaxJson.setSuccess(false);
        ajaxJson.setMsg("\u7528\u6237\u4e0d\u5b58\u5728");
        return ajaxJson;
    }

    private AjaxJson checkDate(TmUserEntity userEntity, AjaxJson ajaxJson) {
        String dateNow = DateUtils.getYYYYMMDD();
        if (Globals.Admin_Name.equalsIgnoreCase(userEntity.getUserName())) {
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)userEntity.getBeginDate()) || StringUtil.isEmpty((String)userEntity.getEndDate())) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u7528\u6237\u8d26\u53f7\u5df2\u8fc7\u671f,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return ajaxJson;
        }
        if (dateNow.compareTo(userEntity.getBeginDate()) < 0 || dateNow.compareTo(userEntity.getEndDate()) > 0) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u7528\u6237\u8d26\u53f7\u5df2\u8fc7\u671f,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return ajaxJson;
        }
        return ajaxJson;
    }

    public AjaxJson validateUser(TmUserEntity tmUserEntity, String flag, String isEncryption, HttpServletRequest request, HttpServletResponse response) {
        String hql = "from TmUserEntity where userName = ? ";
        if (this.loginrRelatedService != null) {
            this.loginrRelatedService.beforeLoginIn(tmUserEntity, request);
        }
        AjaxJson j = new AjaxJson();
        List list = super.findByHql(hql, new Object[]{tmUserEntity.getUserName()});
        if (list.size() > 0) {
            TmPositionVo positionVo;
            TmPositionVo tmPositionVo;
            TmUserEntity userEntity = (TmUserEntity)list.get(0);
            if (userEntity.getUserType() != Globals.ENTERPRISE_USER) {
                j.setSuccess(false);
                j.setMsg("\u8be5\u8d26\u53f7\u4e0d\u662f\u4f01\u4e1a\u7528\u6237");
                return j;
            }
            if (Globals.ONE.equals(userEntity.getEnableStatus()) && !Globals.Admin_Name.equalsIgnoreCase(userEntity.getUserName())) {
                j.setSuccess(false);
                j.setMsg("\u7528\u6237\u8d26\u53f7\u9501\u5b9a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                return j;
            }
            String pwd = tmUserEntity.getPassword();
            if (Globals.N.equalsIgnoreCase(isEncryption)) {
                pwd = this.passwdService != null && this.passwdService.isExtend(userEntity) ? this.passwdService.pwd(pwd) : Md5EncryptionAndDecryption.encryPwd((String)pwd);
            }
            this.checkDate(userEntity, j);
            if (!j.isSuccess()) {
                return j;
            }
            if (!pwd.equals(userEntity.getPassword())) {
                String configLoginErrTimes = ResourceUtil.getSysConfigProperty((String)"loginErrTimes");
                if (StringUtil.isNotBlank((String)configLoginErrTimes)) {
                    short configLoginErrTimesShort = Short.parseShort(configLoginErrTimes);
                    Integer loginErrTimes = userEntity.getLoginErrTimes() == null ? 0 : userEntity.getLoginErrTimes();
                    if (loginErrTimes >= configLoginErrTimesShort) {
                        String sql = "update tm_user set enable_status=?,update_date=? where id=?";
                        this.executeSql(sql, new Object[]{Globals.ONE, new Date(), userEntity.getId()});
                    } else {
                        Object sql = loginErrTimes;
                        Integer n = loginErrTimes = Integer.valueOf(loginErrTimes + 1);
                        sql = "update tm_user set login_err_times=?,update_date=? where id=?";
                        this.executeSql((String)sql, new Object[]{loginErrTimes, new Date(), userEntity.getId()});
                    }
                    if (loginErrTimes == configLoginErrTimesShort) {
                        j.setMsg("\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef\uff01\u7528\u6237\uff1a" + userEntity.getUserName() + "\u88ab\u9501\u5b9a\uff01");
                    } else {
                        j.setMsg("\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef\uff01\u60a8\u8fd8\u6709" + (configLoginErrTimesShort - loginErrTimes) + "\u6b21\u673a\u4f1a\u5c1d\u8bd5");
                    }
                } else {
                    j.setMsg("\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef\uff01");
                }
                j.setSuccess(false);
                return j;
            }
            String sql = "update tm_user set login_err_times=?,update_date=? where id=?";
            this.executeSql(sql, new Object[]{Globals.User_Normal, new Date(), userEntity.getId()});
            List positions = this.positionService.getPositinByUserId(userEntity, Globals.Main_Position_Type);
            if (positions.size() == 0 && userEntity.getUserType() == Globals.ENTERPRISE_USER) {
                j.setSuccess(false);
                j.setMsg("\u7528\u6237\u672a\u5206\u914d\u4e3b\u804c\u4f4d,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                return j;
            }
            if (userEntity.getUserType() == Globals.ENTERPRISE_USER && Globals.ONE.equals((tmPositionVo = (TmPositionVo)positions.get(0)).getEnableStatus())) {
                j.setSuccess(false);
                j.setMsg("\u7528\u6237\u6240\u5c5e\u4e3b\u804c\u4f4d\u88ab\u505c\u7528,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                return j;
            }
            if (Globals.Y.equalsIgnoreCase(flag)) {
                positionVo = new TmPositionVo();
                if (CollectionUtil.listNotEmptyNotSizeZero((List)positions)) {
                    positionVo = (TmPositionVo)positions.get(0);
                }
                userEntity.setLangCode(tmUserEntity.getLangCode());
                this.saveLoginInfo(userEntity, positionVo, request, response);
            } else {
                positionVo = new TmPositionVo();
                if (CollectionUtil.listNotEmptyNotSizeZero((List)positions)) {
                    positionVo = (TmPositionVo)positions.get(0);
                }
                try {
                    String key = Snippet.aesEncrypt((String)CookiesUtil.getKeyFlag((String)userEntity.getUserName()), (String)"1oR8uIM2O5qv65l2");
                    CookiesUtil.doCoke((HttpServletRequest)request, (HttpServletResponse)response, (String)key);
                    UserRedis userRedis = this.createUserRedis(userEntity, null, positionVo, Globals.LOGIN_SOURCE_ZT);
                    String ip = IpUtil.getIpAddr((HttpServletRequest)request);
                    userRedis.setIp(ip);
                    String value = JsonUtil.bean2json((Object)userRedis);
                    this.redisService.setSeconds("LOGIN_SUCCESS_" + key, (Object)value, 86400L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.loginrRelatedService != null) {
                this.loginrRelatedService.afterLoginIn(userEntity, request);
            }
        } else {
            j.setSuccess(false);
            j.setMsg("\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef\uff01");
            return j;
        }
        return j;
    }

    public void saveLoginInfo(TmUserEntity tmUserEntity, TmPositionVo tmPositionVo, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = ContextHolderUtils.getSession();
        Client client = new Client();
        client.setIp(IpUtil.getIpAddr((HttpServletRequest)request));
        client.setLogindatetime(new Date());
        client.setUser(this.getUser(tmUserEntity));
        client.setPosition(tmPositionVo);
        client.setLangCode(StringUtil.isNotEmpty((String)tmUserEntity.getLangCode()) ? tmUserEntity.getLangCode() : "zh_cn");
        boolean b = false;
        if (this.loginrRelatedService != null && this.loginrRelatedService.isToGetOrg()) {
            b = true;
        }
        if (Globals.ENTERPRISE_USER == tmUserEntity.getUserType() || b) {
            TmCustomerOrgEntity customerOrg;
            if (StringUtil.isNotEmpty((String)tmPositionVo.getOrgId())) {
                TmOrgEntity orgEntity = (TmOrgEntity)this.get(TmOrgEntity.class, (Serializable)((Object)tmPositionVo.getOrgId()));
                client.setOrg(this.getTmOrgEntity(orgEntity));
            }
            if ((customerOrg = (TmCustomerOrgEntity)this.findUniqueByProperty(TmCustomerOrgEntity.class, "positionId", (Object)tmPositionVo.getId())) != null) {
                client.setCustomerOrg(this.getTmCustomerOrgEntity(customerOrg));
            }
        }
        ResourceUtil.setClient((Client)client);
    }

    public UserRedis createUserRedis(TmUserEntity tmUserEntity, TmCustomerEntity customerEntity, TmPositionVo tmPositionVo, String loginSource) {
        UserRedis userRedis = new UserRedis();
        userRedis.setId(tmUserEntity.getId());
        userRedis.setRealname(tmUserEntity.getFullName());
        userRedis.setUsername(tmUserEntity.getUserName());
        userRedis.setStaffcode(tmUserEntity.getExtChar1());
        userRedis.setUsertype(tmUserEntity.getUserType());
        if ((Globals.DISTRIBUTOR_AGENT.equals(tmUserEntity.getUserType()) || Globals.CUST_USER.equals(tmUserEntity.getUserType())) && customerEntity != null) {
            userRedis.setCustcode(customerEntity.getCustomerCode());
            TmCustomerOrgEntity tmCustomerOrg = customerEntity.getTmCustomerOrg();
            if (null != tmCustomerOrg) {
                userRedis.setCustomerOrgCode(tmCustomerOrg.getCustOrgCode());
            }
        }
        if (tmPositionVo != null) {
            TmOrgEntity tmOrg;
            userRedis.setPosId(tmPositionVo.getId());
            userRedis.setPosCode(tmPositionVo.getPositionCode());
            userRedis.setPosName(tmPositionVo.getPositionName());
            if (StringUtil.isNotEmpty((String)tmPositionVo.getOrgId()) && null != (tmOrg = (TmOrgEntity)super.get(TmOrgEntity.class, (Serializable)((Object)tmPositionVo.getOrgId())))) {
                userRedis.setOrgId(tmOrg.getId());
                userRedis.setOrgCode(tmOrg.getOrgCode());
            }
        }
        userRedis.setLanguage(tmUserEntity.getLangCode());
        userRedis.setLoginSource(loginSource);
        return userRedis;
    }

    private TmCustomerOrgEntity getTmCustomerOrgEntity(TmCustomerOrgEntity org) {
        TmCustomerOrgEntity result = new TmCustomerOrgEntity();
        result.setId(org.getId());
        result.setHeadString(org.getHeadString());
        result.setEnableStatus(org.getEnableStatus());
        result.setCreateDate(org.getCreateDate());
        result.setCreateName(org.getCreateName());
        result.setUpdateDate(org.getUpdateDate());
        result.setUpdateName(org.getUpdateName());
        result.setExtChar1(org.getExtChar1());
        result.setExtChar2(org.getExtChar2());
        result.setExtChar3(org.getExtChar3());
        result.setExtChar4(org.getExtChar4());
        result.setExtChar5(org.getExtChar5());
        result.setExtNumber1(org.getExtNumber1());
        result.setExtNumber2(org.getExtNumber2());
        result.setExtNumber3(org.getExtNumber3());
        result.setIsLeaf(org.getIsLeaf());
        result.setCustOrgCode(org.getCustOrgCode());
        result.setCustomerOrgName(org.getCustomerOrgName());
        result.setCustOrgDesc(org.getCustOrgDesc());
        result.setCustOrgType(org.getCustOrgType());
        result.setCustOrgLevel(org.getCustOrgLevel());
        result.setPositionId(org.getPositionId());
        return result;
    }

    private TmOrgEntity getTmOrgEntity(TmOrgEntity org) {
        TmOrgEntity result = new TmOrgEntity();
        result.setId(org.getId());
        result.setOrgName(org.getOrgName());
        result.setOrgDesc(org.getOrgDesc());
        result.setOrgCode(org.getOrgCode());
        result.setOrgType(org.getOrgType());
        result.setHeadString(org.getHeadString());
        result.setSubCode(org.getSubCode());
        result.setEnableStatus(org.getEnableStatus());
        result.setCreateDate(org.getCreateDate());
        result.setCreateName(org.getCreateName());
        result.setUpdateDate(org.getUpdateDate());
        result.setUpdateName(org.getUpdateName());
        result.setStatus(org.getStatus());
        result.setExtChar1(org.getExtChar1());
        result.setExtChar2(org.getExtChar2());
        result.setExtChar3(org.getExtChar3());
        result.setExtChar4(org.getExtChar4());
        result.setExtChar5(org.getExtChar5());
        result.setExtNumber1(org.getExtNumber1());
        result.setExtNumber2(org.getExtNumber2());
        result.setExtNumber3(org.getExtNumber3());
        result.setExtDate1(org.getExtDate1());
        result.setExtDate2(org.getExtDate2());
        result.setIsLeaf(org.getIsLeaf());
        return result;
    }

    private TmUserEntity getUser(TmUserEntity tmUserEntity) {
        TmUserEntity rt = new TmUserEntity();
        rt.setId(tmUserEntity.getId());
        rt.setUserName(tmUserEntity.getUserName());
        rt.setFullName(tmUserEntity.getFullName());
        rt.setExtChar7(tmUserEntity.getExtChar7());
        rt.setSex(tmUserEntity.getSex());
        rt.setMobilePhone(tmUserEntity.getMobilePhone());
        rt.setEmail(tmUserEntity.getEmail());
        rt.setPassword(tmUserEntity.getPassword());
        rt.setEnableStatus(tmUserEntity.getEnableStatus());
        rt.setHeadString(tmUserEntity.getHeadString());
        rt.setHasFirstTime(tmUserEntity.getHasFirstTime());
        rt.setCreateDate(tmUserEntity.getCreateDate());
        rt.setCreateName(tmUserEntity.getCreateName());
        rt.setUpdateDate(tmUserEntity.getUpdateDate());
        rt.setUpdateName(tmUserEntity.getUpdateName());
        rt.setUserType(tmUserEntity.getUserType());
        rt.setBeginDate(tmUserEntity.getBeginDate());
        rt.setEndDate(tmUserEntity.getEndDate());
        rt.setLoginErrTimes(tmUserEntity.getLoginErrTimes());
        rt.setExtChar1(tmUserEntity.getExtChar1());
        rt.setExtChar2(tmUserEntity.getExtChar2());
        rt.setExtChar3(tmUserEntity.getExtChar3());
        rt.setExtChar4(tmUserEntity.getExtChar4());
        rt.setExtChar5(tmUserEntity.getExtChar5());
        rt.setExtChar6(tmUserEntity.getExtChar6());
        rt.setExtChar7(tmUserEntity.getExtChar7());
        rt.setExtChar8(tmUserEntity.getExtChar8());
        rt.setExtChar9(tmUserEntity.getExtChar9());
        rt.setExtChar10(tmUserEntity.getExtChar10());
        rt.setExtNumber1(tmUserEntity.getExtNumber1());
        rt.setExtNumber2(tmUserEntity.getExtNumber2());
        rt.setExtNumber3(tmUserEntity.getExtNumber3());
        rt.setExtDate1(tmUserEntity.getExtDate1());
        rt.setExtDate2(tmUserEntity.getExtDate2());
        return rt;
    }

    public AjaxJson signOut() {
        AjaxJson ajaxJson = new AjaxJson();
        String key = AppcenterUtil.getUserKey();
        if (StringUtil.isNotEmpty((String)key) && this.redisService.hasKey("LOGIN_SUCCESS_" + key)) {
            this.redisService.del(new String[]{"LOGIN_SUCCESS_" + key});
        }
        return ajaxJson;
    }
}

