/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.config.service.impl;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.importer.DataField;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.service.DynamicImportDataFieldService;
import com.biz.eisp.mdm.dict.util.DictUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DefaultDynamicImportDataFieldServiceImpl
implements DynamicImportDataFieldService {
    public List<DataField> findImportDataField(String tableName, List<TmMdmTableConfigEntity> tmMdmTableConfigList) {
        ArrayList<DataField> columnList = new ArrayList<DataField>();
        for (int i = 0; i < tmMdmTableConfigList.size(); ++i) {
            TmMdmTableConfigEntity entity = tmMdmTableConfigList.get(i);
            Integer addShowMode = entity.getAddShowMode();
            if (addShowMode == null || addShowMode != 1) continue;
            Integer index = i + 1;
            DataField column = this.buildDataField(index + "", entity);
            columnList.add(column);
        }
        return columnList;
    }

    private DataField buildDataField(String index, TmMdmTableConfigEntity entity) {
        DataField column = new DataField();
        column.setName(index);
        column.setCode(entity.getField());
        column.setAvailable(false);
        column.setFormat(entity.getFormat());
        column.setTitle(StringUtils.isBlank((CharSequence)entity.getFormName()) ? entity.getColumnDesc() : entity.getFormName());
        String dataType = entity.getColumnType().toLowerCase();
        String type = "number";
        if (dataType.indexOf("varchar") != -1) {
            type = "char";
        } else if (dataType.indexOf("date") != -1) {
            type = "date";
        }
        column.setType(type);
        if (StringUtil.isNotEmpty((String)entity.getDictType())) {
            column.setDictCode(entity.getDictType());
        }
        if (StringUtil.isNotEmpty((Object)entity.getRequired()) && entity.getRequired() == 1) {
            column.setRequired(true);
        }
        if (StringUtil.isNotEmpty((String)entity.getDataType()) && entity.getDataType().length() > 1) {
            column.setMask(entity.getDataType().substring(1, entity.getDataType().length() - 1));
        }
        if (StringUtil.isNotEmpty((String)entity.getDictType())) {
            List list = DictUtil.getDictList((String)entity.getDictType());
            String[] dictArray = new String[list.size()];
            for (int v = 0; v < list.size(); ++v) {
                KnlDictDataEntity c = (KnlDictDataEntity)list.get(v);
                dictArray[v] = c.getDictValue();
            }
            column.setList(dictArray);
        }
        column.setLength(500);
        if (StringUtils.isNotBlank((CharSequence)entity.getImportField())) {
            column.setIdBySql("SELECT id FROM " + entity.getJoinTable() + " WHERE " + entity.getImportField() + " = ?");
        }
        return column;
    }
}

